# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .agent import Agent
import pydantic
from ...base.types.timestamp import Timestamp
import datetime as dt
from .encryption_details import EncryptionDetails
from .file import File
from .group import Group
from ...base.types.hostname import Hostname
from ...base.types.ip_address import IpAddress
from .user import User
from .key_value_object import KeyValueObject
from .databucket_type_id import DatabucketTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Databucket(UncheckedBaseModel):
    """
    The databucket object is a basic container that holds data, typically organized through the use of data partitions.
    """

    agent_list: typing.Optional[typing.List[Agent]] = pydantic.Field(default=None)
    """
    A list of <code>agent</code> objects associated with a device, endpoint, or resource.
    """

    cloud_partition: typing.Optional[str] = pydantic.Field(default=None)
    """
    The canonical cloud partition name to which the region is assigned (e.g. AWS Partitions: aws, aws-cn, aws-us-gov).
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the databucket was known to have been created.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the databucket was known to have been created.
    """

    criticality: typing.Optional[str] = pydantic.Field(default=None)
    """
    The criticality of the resource as defined by the event source.
    """

    data: typing.Optional[typing.Optional[typing.Any]] = pydantic.Field(default=None)
    """
    Additional data describing the resource.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the databucket.
    """

    encryption_details: typing.Optional[EncryptionDetails] = pydantic.Field(
        default=None
    )
    """
    The encryption details of the databucket. Should be populated if the databucket is encrypted.
    """

    file: typing.Optional[File] = pydantic.Field(default=None)
    """
    Details about the file/object within a databucket.
    """

    group: typing.Optional[Group] = pydantic.Field(default=None)
    """
    The name of the related resource group.
    """

    groups: typing.Optional[typing.List[Group]] = pydantic.Field(default=None)
    """
    The group names to which the databucket belongs.
    """

    hostname: typing.Optional[Hostname] = pydantic.Field(default=None)
    """
    The fully qualified name of the resource.
    """

    ip: typing.Optional[IpAddress] = pydantic.Field(default=None)
    """
    The IP address of the resource, in either IPv4 or IPv6 format.
    """

    is_encrypted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if the databucket is encrypted.
    """

    is_public: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if the databucket is publicly accessible.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of labels associated to the resource.
    """

    modified_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The most recent time when any changes, updates, or modifications were made within the databucket.
    """

    modified_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The most recent time when any changes, updates, or modifications were made within the databucket.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The databucket name.
    """

    namespace: typing.Optional[str] = pydantic.Field(default=None)
    """
    The namespace is useful when similar entities exist that you need to keep separate.
    """

    owner: typing.Optional[User] = pydantic.Field(default=None)
    """
    The identity of the service or user account that owns the resource.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    The cloud region of the resource.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size of the databucket in bytes.
    """

    tags: typing.Optional[typing.List[KeyValueObject]] = pydantic.Field(default=None)
    """
    The list of tags; <code>{key:value}</code> pairs associated to the resource.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The databucket type.
    """

    type_id: DatabucketTypeId = pydantic.Field()
    """
    The normalized identifier of the databucket type.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the databucket.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the resource. For example <code>1.2.3</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
