# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...base.types.email_address import EmailAddress
from .file import File
from .http_header import HttpHeader
from ...base.types.timestamp import Timestamp
import datetime as dt
from ...base.types.ip_address import IpAddress
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Email(UncheckedBaseModel):
    """
    The Email object describes the email metadata such as sender, recipients, and direction, and can include embedded URLs and files.
    """

    bcc: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The BCC recipients of the email. Similar to cc field but for BCC recipients.
    """

    cc: typing.Optional[typing.List[EmailAddress]] = pydantic.Field(default=None)
    """
    The machine-readable email header Cc values, as defined by RFC 5322. For example <code>example.user@usersdomain.com</code>.
    """

    cc_mailboxes: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The human-readable email header Cc Mailbox values. For example <code>'Example User &lt;example.user@usersdomain.com&gt;'</code>.
    """

    delivered_to: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The machine-readable <strong>Delivered-To</strong> email header field. For example <code>example.user@usersdomain.com</code>
    """

    delivered_to_list: typing.Optional[typing.List[EmailAddress]] = pydantic.Field(
        default=None
    )
    """
    The machine-readable <strong>Delivered-To</strong> email header values. For example <code>example.user@usersdomain.com</code>
    """

    files: typing.Optional[typing.List[File]] = pydantic.Field(default=None)
    """
    The files embedded or attached to the email.
    """

    from_: typing.Optional[EmailAddress] = pydantic.Field(alias="from", default=None)
    """
    The machine-readable email header From values, as defined by RFC 5322. For example <code>example.user@usersdomain.com</code>
    """

    from_mailbox: typing.Optional[str] = pydantic.Field(default=None)
    """
    The human-readable email header From Mailbox value. For example <code>'Example User &lt;example.user@usersdomain.com&gt;'</code>.
    """

    http_headers: typing.Optional[typing.List[HttpHeader]] = pydantic.Field(
        default=None
    )
    """
    Additional HTTP headers of an HTTP request or response.
    """

    is_externally_viewable: typing.Optional[bool] = pydantic.Field(default=None)
    """
    True if the email is viewable externally (presumably by external users).
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Labels associated with the object, such as security or sensitivity labels created by a scanning app.
    """

    message_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email header Message-ID value, as defined by RFC 5322.
    """

    raw_header: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email authentication header.
    """

    reply_to: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The machine-readable email header Reply-To values, as defined by RFC 5322. For example <code>example.user@usersdomain.com</code>
    """

    reply_to_mailboxes: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The human-readable email header Reply To Mailbox values. For example <code>'Example User &lt;example.user@usersdomain.com&gt;'</code>.
    """

    sender_mailbox_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique ID of the sender mailbox. This is distinct from the sender's email address.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size in bytes of the email, including attachments.
    """

    smtp_from: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The value of the SMTP MAIL FROM command.
    """

    smtp_to: typing.Optional[typing.List[EmailAddress]] = pydantic.Field(default=None)
    """
    The value of the SMTP envelope RCPT TO command.
    """

    subject: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email header Subject value, as defined by RFC 5322.
    """

    time_sent: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time at which the email was sent.
    """

    time_sent_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time at which the email was sent.
    """

    to: typing.Optional[typing.List[EmailAddress]] = pydantic.Field(default=None)
    """
    The machine-readable email header To values, as defined by RFC 5322. For example <code>example.user@usersdomain.com</code>
    """

    to_mailboxes: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The human-readable email header To Mailbox values. For example <code>'Example User &lt;example.user@usersdomain.com&gt;'</code>.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the email thread.
    """

    urls: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The URLs embedded in the email.
    """

    x_originating_ip: typing.Optional[typing.List[IpAddress]] = pydantic.Field(
        default=None
    )
    """
    The X-Originating-IP header identifying the emails originating IP address(es).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
