# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .agent import Agent
import pydantic
from .group import Group
from ...base.types.hostname import Hostname
from ...base.types.ip_address import IpAddress
from .user import User
from .key_value_object import KeyValueObject
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class ResourceDetails(UncheckedBaseModel):
    """
    The Resource Details object describes details about resources that were affected by the activity/event.
    """

    agent_list: typing.Optional[typing.List[Agent]] = pydantic.Field(default=None)
    """
    A list of <code>agent</code> objects associated with a device, endpoint, or resource.
    """

    cloud_partition: typing.Optional[str] = pydantic.Field(default=None)
    """
    The canonical cloud partition name to which the region is assigned (e.g. AWS Partitions: aws, aws-cn, aws-us-gov).
    """

    criticality: typing.Optional[str] = pydantic.Field(default=None)
    """
    The criticality of the resource as defined by the event source.
    """

    data: typing.Optional[typing.Optional[typing.Any]] = pydantic.Field(default=None)
    """
    Additional data describing the resource.
    """

    group: typing.Optional[Group] = pydantic.Field(default=None)
    """
    The name of the related resource group.
    """

    hostname: typing.Optional[Hostname] = pydantic.Field(default=None)
    """
    The fully qualified name of the resource.
    """

    ip: typing.Optional[IpAddress] = pydantic.Field(default=None)
    """
    The IP address of the resource, in either IPv4 or IPv6 format.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of labels associated to the resource.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the resource.
    """

    namespace: typing.Optional[str] = pydantic.Field(default=None)
    """
    The namespace is useful when similar entities exist that you need to keep separate.
    """

    owner: typing.Optional[User] = pydantic.Field(default=None)
    """
    The identity of the service or user account that owns the resource.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    The cloud region of the resource.
    """

    tags: typing.Optional[typing.List[KeyValueObject]] = pydantic.Field(default=None)
    """
    The list of tags; <code>{key:value}</code> pairs associated to the resource.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The resource type as defined by the event source.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the resource.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the resource. For example <code>1.2.3</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
