# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .timespan_type_id import TimespanTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Timespan(UncheckedBaseModel):
    """
    The Time Span object represents different time period durations. If a timespan is fractional, i.e. crosses one period, e.g. a week and 3 days, more than one may be populated since each member is of integral type. In that case <code>type_id</code> if present should be set to <code>Other</code>.
    """

    duration: typing.Optional[int] = pydantic.Field(default=None)
    """
    The duration of the time span in milliseconds.
    """

    duration_days: typing.Optional[int] = pydantic.Field(default=None)
    """
    The duration of the time span in days.
    """

    duration_hours: typing.Optional[int] = pydantic.Field(default=None)
    """
    The duration of the time span in hours.
    """

    duration_mins: typing.Optional[int] = pydantic.Field(default=None)
    """
    The duration of the time span in minutes.
    """

    duration_months: typing.Optional[int] = pydantic.Field(default=None)
    """
    The duration of the time span in months.
    """

    duration_secs: typing.Optional[int] = pydantic.Field(default=None)
    """
    The duration of the time span in seconds.
    """

    duration_weeks: typing.Optional[int] = pydantic.Field(default=None)
    """
    The duration of the time span in weeks.
    """

    duration_years: typing.Optional[int] = pydantic.Field(default=None)
    """
    The duration of the time span in years.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of time span duration the object represents.
    """

    type_id: typing.Optional[TimespanTypeId] = pydantic.Field(default=None)
    """
    The normalized identifier for the time span duration type.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
