# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .group import Group
from ...base.types.hostname import Hostname
from .user import User
from .graph import Graph
from .application_risk_level_id import ApplicationRiskLevelId
from .sbom import Sbom
from .key_value_object import KeyValueObject
from .url import Url
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Application(UncheckedBaseModel):
    """
    An Application describes the details for an inventoried application as reported by an Application Security tool or other Developer-centric tooling. Applications can be defined as Kubernetes resources, Containerized resources, or application hosting-specific cloud sources such as AWS Elastic BeanStalk, AWS Lightsail, or Azure Logic Apps.
    """

    criticality: typing.Optional[str] = pydantic.Field(default=None)
    """
    The criticality of the application as defined by the event source.
    """

    data: typing.Optional[typing.Optional[typing.Any]] = pydantic.Field(default=None)
    """
    Additional data describing the application.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    A description or commentary for an application, usually retrieved from an upstream system.
    """

    group: typing.Optional[Group] = pydantic.Field(default=None)
    """
    The name of the related application or associated resource group.
    """

    hostname: typing.Optional[Hostname] = pydantic.Field(default=None)
    """
    The fully qualified name of the application.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of labels associated to the application.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the application.
    """

    owner: typing.Optional[User] = pydantic.Field(default=None)
    """
    The identity of the service or user account that owns the application.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    The cloud region of the resource.
    """

    resource_relationship: typing.Optional[Graph] = pydantic.Field(default=None)
    """
    A graph representation showing how this application relates to and interacts with other entities in the environment. This can include parent/child relationships, dependencies, or other connections.
    """

    risk_level: typing.Optional[str] = pydantic.Field(default=None)
    """
    The risk level, normalized to the caption of the risk_level_id value.
    """

    risk_level_id: typing.Optional[ApplicationRiskLevelId] = pydantic.Field(
        default=None
    )
    """
    The normalized risk level id.
    """

    risk_score: typing.Optional[int] = pydantic.Field(default=None)
    """
    The risk score as reported by the event source.
    """

    sbom: typing.Optional[Sbom] = pydantic.Field(default=None)
    """
    The Software Bill of Materials (SBOM) associated with the application
    """

    tags: typing.Optional[typing.List[KeyValueObject]] = pydantic.Field(default=None)
    """
    The list of tags; <code>{key:value}</code> pairs associated to the application.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of application as defined by the event source, e.g., <code>GitHub</code>, <code>Azure Logic App</code>, or <code>Amazon Elastic BeanStalk</code>.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier for the application.
    """

    uid_alt: typing.Optional[str] = pydantic.Field(default=None)
    """
    An alternative or contextual identifier for the application, such as a configuration, organization, or license UID.
    """

    url: typing.Optional[Url] = pydantic.Field(default=None)
    """
    The URL of the application.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The semantic version of the application, e.g., <code>1.7.4</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
