# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .assessment import Assessment
import pydantic
from .check import Check
from .kb_article import KbArticle
from .key_value_object import KeyValueObject
from .compliance_status_id import ComplianceStatusId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Compliance(UncheckedBaseModel):
    """
    The Compliance object contains information about Industry and Regulatory Framework standards, controls and requirements or details about custom assessments utilized in a compliance evaluation. Standards define broad security frameworks, controls represent specific security requirements within those frameworks, and checks are the testable verification points used to determine if controls are properly implemented.
    """

    assessments: typing.Optional[typing.List[Assessment]] = pydantic.Field(default=None)
    """
    A list of assessments associated with the compliance requirements evaluation.
    """

    category: typing.Optional[str] = pydantic.Field(default=None)
    """
    The category a control framework pertains to, as reported by the source tool, such as <code>Asset Management</code> or <code>Risk Assessment</code>.
    """

    checks: typing.Optional[typing.List[Check]] = pydantic.Field(default=None)
    """
    A list of compliance checks associated with specific industry standards or frameworks. Each check represents an individual rule or requirement that has been evaluated against a target device. Checks typically include details such as the check name (e.g., CIS: 'Ensure mounting of cramfs filesystems is disabled' or DISA STIG descriptive titles), unique identifiers (such as CIS identifier '1.1.1.1' or DISA STIG identifier 'V-230234'), descriptions (detailed explanations of security requirements or vulnerability discussions), and version information.
    """

    compliance_references: typing.Optional[typing.List[KbArticle]] = pydantic.Field(
        default=None
    )
    """
    A list of reference KB articles that provide information to help organizations understand, interpret, and implement compliance standards. They provide guidance, best practices, and examples.
    """

    compliance_standards: typing.Optional[typing.List[KbArticle]] = pydantic.Field(
        default=None
    )
    """
    A list of established guidelines or criteria that define specific requirements an organization must follow.
    """

    control: typing.Optional[str] = pydantic.Field(default=None)
    """
    A Control is a prescriptive, actionable set of specifications that strengthens device posture. The control specifies required security measures, while the specific implementation values are defined in control_parameters. E.g., CIS AWS Foundations Benchmark 1.2.0 - Control 2.1 - Ensure CloudTrail is enabled in all regions
    """

    control_parameters: typing.Optional[typing.List[KeyValueObject]] = pydantic.Field(
        default=None
    )
    """
    The list of control parameters evaluated in a Compliance check. E.g., parameters for CloudTrail configuration might include <code>multiRegionTrailEnabled: true</code>, <code>logFileValidationEnabled: true</code>, and <code>requiredRegions: [us-east-1, us-west-2]</code>
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description or criteria of a control.
    """

    requirements: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The specific compliance requirements being evaluated. E.g., <code>PCI DSS Requirement 8.2.3 - Passwords must meet minimum complexity requirements</code> or <code>HIPAA Security Rule 164.312(a)(2)(iv) - Implement encryption and decryption mechanisms</code>
    """

    standards: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The regulatory or industry standards being evaluated for compliance.
    """

    status: typing.Optional[str] = pydantic.Field(default=None)
    """
    The resultant status of the compliance check normalized to the caption of the <code>status_id</code> value. In the case of 'Other', it is defined by the event source.
    """

    status_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    The resultant status code of the compliance check.
    """

    status_detail: typing.Optional[str] = pydantic.Field(default=None)
    """
    The contextual description of the <code>status, status_code</code> values.
    """

    status_details: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of contextual descriptions of the <code>status, status_code</code> values.
    """

    status_id: typing.Optional[ComplianceStatusId] = pydantic.Field(default=None)
    """
    The normalized status identifier of the compliance check.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
