# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from ...base.types.timestamp import Timestamp
import pydantic
import datetime as dt
from .cvss import Cvss
from .cwe import Cwe
from ...base.types.url_string import UrlString
from .epss import Epss
from .product import Product
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Cve(UncheckedBaseModel):
    """
    The Common Vulnerabilities and Exposures (CVE) object represents publicly disclosed cybersecurity vulnerabilities defined in CVE Program catalog (<a target='_blank' href='https://cve.mitre.org/'>CVE</a>). There is one CVE Record for each vulnerability in the catalog.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The Record Creation Date identifies when the CVE ID was issued to a CVE Numbering Authority (CNA) or the CVE Record was published on the CVE List. Note that the Record Creation Date does not necessarily indicate when this vulnerability was discovered, shared with the affected vendor, publicly disclosed, or updated in CVE.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The Record Creation Date identifies when the CVE ID was issued to a CVE Numbering Authority (CNA) or the CVE Record was published on the CVE List. Note that the Record Creation Date does not necessarily indicate when this vulnerability was discovered, shared with the affected vendor, publicly disclosed, or updated in CVE.
    """

    cvss: typing.Optional[typing.List[Cvss]] = pydantic.Field(default=None)
    """
    The CVSS object details Common Vulnerability Scoring System (<a target='_blank' href='https://www.first.org/cvss/'>CVSS</a>) scores from the advisory that are related to the vulnerability.
    """

    cwe: typing.Optional[Cwe] = pydantic.Field(default=None)
    """
    The CWE object represents a weakness in a software system that can be exploited by a threat actor to perform an attack. The CWE object is based on the <a target='_blank' href='https://cwe.mitre.org/'>Common Weakness Enumeration (CWE)</a> catalog.
    """

    cwe_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The <a target='_blank' href='https://cwe.mitre.org/'>Common Weakness Enumeration (CWE)</a> unique identifier. For example: <code>CWE-787</code>.
    """

    cwe_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    Common Weakness Enumeration (CWE) definition URL. For example: <code>https://cwe.mitre.org/data/definitions/787.html</code>.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    A brief description of the CVE Record.
    """

    epss: typing.Optional[Epss] = pydantic.Field(default=None)
    """
    The Exploit Prediction Scoring System (EPSS) object describes the estimated probability a vulnerability will be exploited. EPSS is a community-driven effort to combine descriptive information about vulnerabilities (CVEs) with evidence of actual exploitation in-the-wild. (<a target='_blank' href='https://www.first.org/epss/'>EPSS</a>).
    """

    modified_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The Record Modified Date identifies when the CVE record was last updated.
    """

    modified_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The Record Modified Date identifies when the CVE record was last updated.
    """

    product: typing.Optional[Product] = pydantic.Field(default=None)
    """
    The product where the vulnerability was discovered.
    """

    references: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of reference URLs with additional information about the CVE Record.
    """

    related_cwes: typing.Optional[typing.List[Cwe]] = pydantic.Field(default=None)
    """
    Describes the Common Weakness Enumeration <a target='_blank' href='https://cwe.mitre.org/'>(CWE)</a> details related to the CVE Record.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A title or a brief phrase summarizing the CVE record.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    <p>The vulnerability type as selected from a large dropdown menu during CVE refinement.</p>Most frequently used vulnerability types are: <code>DoS</code>, <code>Code Execution</code>, <code>Overflow</code>, <code>Memory Corruption</code>, <code>Sql Injection</code>, <code>XSS</code>, <code>Directory Traversal</code>, <code>Http Response Splitting</code>, <code>Bypass something</code>, <code>Gain Information</code>, <code>Gain Privileges</code>, <code>CSRF</code>, <code>File Inclusion</code>. For more information see <a target='_blank' href='https://www.cvedetails.com/vulnerabilities-by-types.php'>Vulnerabilities By Type</a> distributions.
    """

    uid: str = pydantic.Field()
    """
    The Common Vulnerabilities and Exposures unique number assigned to a specific computer vulnerability. A CVE Identifier begins with 4 digits representing the year followed by a sequence of digits that acts as a unique identifier. For example: <code>CVE-2021-12345</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
