# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .edge import Edge
from .node import Node
from .graph_query_language_id import GraphQueryLanguageId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Graph(UncheckedBaseModel):
    """
    A graph data structure representation with nodes and edges.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The graph description - provides additional details about the graph's purpose and contents.
    """

    edges: typing.Optional[typing.List[Edge]] = pydantic.Field(default=None)
    """
    The edges/connections between nodes in the graph - contains the collection of <code>edge</code> objects defining relationships between nodes.
    """

    is_directed: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if the graph is directed (<code>true</code>) or undirected (<code>false</code>).
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The graph name - a human readable identifier for the graph.
    """

    nodes: typing.List[Node] = pydantic.Field()
    """
    The nodes/vertices of the graph - contains the collection of <code>node</code> objects that make up the graph.
    """

    query_language: typing.Optional[str] = pydantic.Field(default=None)
    """
    The graph query language, normalized to the caption of the <code>query_language_id</code> value.
    """

    query_language_id: typing.Optional[GraphQueryLanguageId] = pydantic.Field(
        default=None
    )
    """
    The normalized identifier of a graph query language that can be used to interact with the graph.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The graph type. Typically useful to represent the specifc type of graph that is used.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier of the graph - a unique ID to reference this specific graph.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
