# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .file import File
import pydantic
from .fingerprint import Fingerprint
from .long_string import LongString
from .script_type_id import ScriptTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Script(UncheckedBaseModel):
    """
    The Script object describes a script or command that can be executed by a shell, script engine, or interpreter. Examples include Bash, JavsScript, PowerShell, Python, VBScript, etc. Note that the term <em>script</em> here denotes not only a script contained within a file but also a script or command typed interactively by a user, supplied on the command line, or provided by some other file-less mechanism.
    """

    file: typing.Optional[File] = pydantic.Field(default=None)
    """
    Present if this script is associated with a file. Not present in the case of a file-less script.
    """

    hashes: typing.Optional[typing.List[Fingerprint]] = pydantic.Field(default=None)
    """
    An array of the script's cryptographic hashes. Note that these hashes are calculated on the script in its original encoding, and not on the normalized UTF-8 encoding found in the <code>script_content</code> attribute.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier for the script or macro, independent of the containing file, used for tracking, auditing, and security analysis.
    """

    parent_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    This attribute relates a sub-script to a parent script having the matching <code>uid</code> attribute. In the case of PowerShell, sub-script execution can be identified by matching the activity correlation ID of the raw ETW events provided by the OS.
    """

    script_content: LongString = pydantic.Field()
    """
    The script content, normalized to UTF-8 encoding irrespective of its original encoding. When emitting this attribute, it may be appropriate to truncate large scripts. When consuming this attribute, large scripts should be anticipated.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The script type, normalized to the caption of the <code>type_id</code> value. In the case of 'Other', it is defined by the event source.
    """

    type_id: ScriptTypeId = pydantic.Field()
    """
    The normalized script type ID.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Some script engines assign a unique ID to each individual execution of a given script. This attribute captures that unique ID. In the case of PowerShell, the unique ID corresponds to the <code>ScriptBlockId</code> in the raw ETW events provided by the OS.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
