# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Trait(UncheckedBaseModel):
    """
    Describes a characteristic or feature of an entity that was observed. For example, this object can be used to represent specific characteristics derived from events or findings that can be surfaced as distinguishing traits of the entity in question.
    """

    category: typing.Optional[str] = pydantic.Field(default=None)
    """
    The high-level grouping or classification this trait belongs to.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the trait.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of the trait. For example, this can be used to indicate if the trait acts as a contributing factor (increases risk/severity) or a mitigating factor (decreases risk/severity), in the context of the related finding.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the trait.
    """

    values: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The values of the trait.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
