# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .mitigation import Mitigation
import pydantic
from .sub_technique import SubTechnique
from .tactic import Tactic
from .technique import Technique
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Attack(UncheckedBaseModel):
    """
    The MITRE ATT&CK® & ATLAS™ object describes the tactic, technique, sub-technique & mitigation associated to an attack.
    """

    mitigation: typing.Optional[Mitigation] = pydantic.Field(default=None)
    """
    The Mitigation object describes the MITRE ATT&CK® or ATLAS™ Mitigation ID and/or name that is associated to an attack.
    """

    sub_technique: typing.Optional[SubTechnique] = pydantic.Field(default=None)
    """
    The Sub-technique object describes the MITRE ATT&CK® or ATLAS™ Sub-technique ID and/or name associated to an attack.
    """

    tactic: typing.Optional[Tactic] = pydantic.Field(default=None)
    """
    The Tactic object describes the MITRE ATT&CK® or ATLAS™ Tactic ID and/or name that is associated to an attack.
    """

    tactics: typing.Optional[typing.List[Tactic]] = pydantic.Field(default=None)
    """
    The Tactic object describes the tactic ID and/or tactic name that are associated with the attack technique, as defined by <a target='_blank' href='https://attack.mitre.org/wiki/ATT&CK_Matrix'>ATT&CK® Matrix</a>.
    """

    technique: typing.Optional[Technique] = pydantic.Field(default=None)
    """
    The Technique object describes the MITRE ATT&CK® or ATLAS™ Technique ID and/or name associated to an attack.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ATT&CK® or ATLAS™ Matrix version.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
