# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from ...base.types.timestamp import Timestamp
import pydantic
import datetime as dt
from .user import User
from .product import Product
from .file_confidentiality_id import FileConfidentialityId
from .file_drive_type_id import FileDriveTypeId
from .encryption_details import EncryptionDetails
from .fingerprint import Fingerprint
from ...base.types.file_name import FileName
from ...base.types.file_path import FilePath
from .digital_signature import DigitalSignature
from .key_value_object import KeyValueObject
from .file_type_id import FileTypeId
from ...base.types.url_string import UrlString
from .url import Url
from .object import Object
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class File(UncheckedBaseModel):
    """
    The File object represents the metadata associated with a file stored in a computer system. It encompasses information about the file itself, including its attributes, properties, and organizational details.
    """

    accessed_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the file was last accessed.
    """

    accessed_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the file was last accessed.
    """

    accessor: typing.Optional[User] = pydantic.Field(default=None)
    """
    The name of the user who last accessed the object.
    """

    accessor_app: typing.Optional[Product] = pydantic.Field(default=None)
    """
    The app which mediated access to the file. This could be separate from the source app, for example a case where a user exports a report from a web app. The source app would be their browser and the accessor app the web app.
    """

    attributes: typing.Optional[int] = pydantic.Field(default=None)
    """
    The bitmask value that represents the file attributes.
    """

    company_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the company that published the file. For example: <code>Microsoft Corporation</code>.
    """

    confidentiality: typing.Optional[str] = pydantic.Field(default=None)
    """
    The file content confidentiality, normalized to the confidentiality_id value. In the case of 'Other', it is defined by the event source.
    """

    confidentiality_id: typing.Optional[FileConfidentialityId] = pydantic.Field(
        default=None
    )
    """
    The normalized identifier of the file content confidentiality indicator.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the file was created.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the file was created.
    """

    creator: typing.Optional[User] = pydantic.Field(default=None)
    """
    The user that created the file.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the file, as returned by file system. For example: the description as returned by the Unix file command or the Windows file type.
    """

    drive_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The drive type, normalized to the caption of the <code>drive_type_id</code> value. In the case of <code>Other</code>, it is defined by the source.
    """

    drive_type_id: typing.Optional[FileDriveTypeId] = pydantic.Field(default=None)
    """
    Identifies the type of a disk drive, i.e. fixed, removable, etc.
    """

    encryption_details: typing.Optional[EncryptionDetails] = pydantic.Field(
        default=None
    )
    """
    The encryption details of the file. Should be populated if the file is encrypted.
    """

    ext: typing.Optional[str] = pydantic.Field(default=None)
    """
    The extension of the file, excluding the leading dot. For example: <code>exe</code> from <code>svchost.exe</code>, or <code>gz</code> from <code>export.tar.gz</code>.
    """

    hashes: typing.Optional[typing.List[Fingerprint]] = pydantic.Field(default=None)
    """
    An array of hash attributes.
    """

    internal_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the file as identified within the file itself. This contrasts with the name by which the file is known on disk. Where available, the internal name is widely used by security practitioners and detection content because the on-disk file name is not reliable. On the Windows OS, most PE files contain a <a href="https://learn.microsoft.com/en-us/windows/win32/menurc/versioninfo-resource">VERSIONINFO</a> resource from which the internal name can be obtained. On macOS, binaries can optionally embed a copy of the application's Info.plist file which in turn contains the name of the executable.
    """

    is_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if the file was deleted from the filesystem.
    """

    is_encrypted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if the file is encrypted.
    """

    is_public: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if the file is publicly accessible. For example in an object's public access in AWS S3
    """

    is_readonly: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates that the file cannot be modified.
    """

    is_system: typing.Optional[bool] = pydantic.Field(default=None)
    """
    The indication of whether the object is part of the operating system.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Labels associated with the object, such as security or sensitivity labels created by a scanning app.
    """

    mime_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Multipurpose Internet Mail Extensions (MIME) type of the file, if applicable.
    """

    modified_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the file was last modified.
    """

    modified_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the file was last modified.
    """

    modifier: typing.Optional[User] = pydantic.Field(default=None)
    """
    The user that last modified the file.
    """

    name: FileName = pydantic.Field()
    """
    The name of the file. For example: <code>svchost.exe</code>
    """

    owner: typing.Optional[User] = pydantic.Field(default=None)
    """
    The user that owns the file/object.
    """

    parent_folder: typing.Optional[str] = pydantic.Field(default=None)
    """
    The parent folder in which the file resides. For example: <code>c:\windows\system32</code>
    """

    path: typing.Optional[FilePath] = pydantic.Field(default=None)
    """
    The full path to the file. For example: <code>c:\windows\system32\svchost.exe</code>.
    """

    product: typing.Optional[Product] = pydantic.Field(default=None)
    """
    The product that created or installed the file.
    """

    security_descriptor: typing.Optional[str] = pydantic.Field(default=None)
    """
    The object security descriptor.
    """

    signature: typing.Optional[DigitalSignature] = pydantic.Field(default=None)
    """
    The digital signature of the file.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size of data, in bytes.
    """

    storage_class: typing.Optional[str] = pydantic.Field(default=None)
    """
    The storage class of the file. For example in AWS S3: <code>STANDARD, STANDARD_IA, GLACIER</code>.
    """

    tags: typing.Optional[typing.List[KeyValueObject]] = pydantic.Field(default=None)
    """
    The list of tags; <code>{key:value}</code> pairs associated to the file.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The file type.
    """

    type_id: FileTypeId = pydantic.Field()
    """
    The file type ID. Note the distinction between a <code>Regular File</code> and an <code>Executable File</code>. If the distinction is not known, or not indicated by the log, use <code>Regular File</code>. In this case, it should not be assumed that a Regular File is not executable.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the file as defined by the storage system, such the file system file ID.
    """

    uri: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The file URI, such as those reporting by static analysis tools. E.g., <code>file:///C:/dev/sarif/sarif-tutorials/samples/Introduction/simple-example.js</code>
    """

    url: typing.Optional[Url] = pydantic.Field(default=None)
    """
    The URL of the file, when applicable.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The file version. For example: <code>8.0.7601.17514</code>.
    """

    volume: typing.Optional[str] = pydantic.Field(default=None)
    """
    The volume on the storage device where the file is located.
    """

    xattributes: typing.Optional[Object] = pydantic.Field(default=None)
    """
    An unordered collection of zero or more name/value pairs where each pair represents a file or folder extended attribute.</p>For example: Windows alternate data stream attributes (ADS stream name, ADS size, etc.), user-defined or application-defined attributes, ACL, owner, primary group, etc. Examples from DCS: </p><ul><li><strong>ads_name</strong></li><li><strong>ads_size</strong></li><li><strong>dacl</strong></li><li><strong>owner</strong></li><li><strong>primary_group</strong></li><li><strong>link_name</strong> - name of the link associated to the file.</li><li><strong>hard_link_count</strong> - the number of links that are associated to the file.</li></ul>
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
