# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from ...base.types.timestamp import Timestamp
import pydantic
import datetime as dt
from .reputation import Reputation
from ...base.types.url_string import UrlString
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Enrichment(UncheckedBaseModel):
    """
    The Enrichment object provides inline enrichment data for specific attributes of interest within an event. It serves as a mechanism to enhance or supplement the information associated with the event by adding additional relevant details or context.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the enrichment data was generated.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the enrichment data was generated.
    """

    data: typing.Optional[typing.Any] = pydantic.Field(default=None)
    """
    The enrichment data associated with the attribute and value. The meaning of this data depends on the type the enrichment record.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    A long description of the enrichment data.
    """

    name: str = pydantic.Field()
    """
    The name of the attribute to which the enriched data pertains.
    """

    provider: typing.Optional[str] = pydantic.Field(default=None)
    """
    The enrichment data provider name.
    """

    reputation: typing.Optional[Reputation] = pydantic.Field(default=None)
    """
    The reputation of the enrichment data.
    """

    short_desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short description of the enrichment data.
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The URL of the source of the enrichment data.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The enrichment type. For example: <code>location</code>.
    """

    value: str = pydantic.Field()
    """
    The value of the attribute to which the enriched data pertains.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
