# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .product import Product
from ...base.types.timestamp import Timestamp
import datetime as dt
from ...base.types.url_string import UrlString
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class TransformationInfo(UncheckedBaseModel):
    """
    The transformation_info object represents the mapping or transformation used.
    """

    lang: typing.Optional[str] = pydantic.Field(default=None)
    """
    The transformation language used to transform the data.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the transformation or mapping.
    """

    product: typing.Optional[Product] = pydantic.Field(default=None)
    """
    The product or instance used to make the transformation
    """

    time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    Time of the transformation.
    """

    time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Time of the transformation.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the mapping or transformation.
    """

    url_string: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The Uniform Resource Locator String where the mapping or transformation exists.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
