# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .d_3_f_tactic import D3FTactic
import pydantic
from .d_3_f_technique import D3FTechnique
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class D3Fend(UncheckedBaseModel):
    """
    The MITRE D3FEND™ object describes the tactic & technique associated with a countermeasure.
    """

    d_3_f_tactic: typing.Optional[D3FTactic] = pydantic.Field(
        alias="d3f_tactic", default=None
    )
    """
    The Tactic object describes the tactic ID and/or name that is associated with a countermeasure.
    """

    d_3_f_technique: typing.Optional[D3FTechnique] = pydantic.Field(
        alias="d3f_technique", default=None
    )
    """
    The Technique object describes the technique ID and/or name associated with a countermeasure.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The D3FEND™ Matrix version.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
