# This file was auto-generated by Fern from our API Definition.

from ...common.types.common_properties import CommonProperties
import typing
import pydantic
from ...open_vocab.types.indicator_type_ov import IndicatorTypeOv
from ...open_vocab.types.pattern_type_ov import PatternTypeOv
import datetime as dt
from ...common.types.kill_chain_phase import KillChainPhase
from ....core.pydantic_utilities import IS_PYDANTIC_V2


class Indicator(CommonProperties):
    type: typing.Literal["indicator"] = "indicator"
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A name used to identify the Indicator.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A description that provides more details and context about the Indicator, potentially including its purpose and its key characteristics.
    """

    indicator_types: typing.Optional[typing.List[IndicatorTypeOv]] = pydantic.Field(
        default=None
    )
    """
    A set of categorizations for this indicator.
    """

    pattern: typing.Optional[str] = pydantic.Field(default=None)
    """
    The detection pattern for this Indicator MAY be expressed as a STIX Pattern as specified in section 9 or another appropriate language such as SNORT, YARA, etc.
    """

    pattern_type: typing.Optional[PatternTypeOv] = pydantic.Field(default=None)
    """
    The type of pattern expression used in the pattern property.
    """

    pattern_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the pattern expression used in the pattern property.
    """

    valid_from: dt.datetime = pydantic.Field()
    """
    The time from which this Indicator is considered a valid indicator of the behaviors it is related or represents.
    """

    valid_until: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time at which this Indicator is no longer considered valid.
    """

    kill_chain_phases: typing.Optional[typing.List[KillChainPhase]] = pydantic.Field(
        default=None
    )
    """
    The kill chain phase to which this Indicator corresponds.
    """

    raw_data: typing.Optional[str] = pydantic.Field(default=None)
    """
    The data as received from the source.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
