# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from ...common.types.id import Id
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class AgentSummary(UncheckedBaseModel):
    """
    The agent summary object gives a summary of an agent in an escalation policy. An agent is a human that can be notified when certain conditions are met
    """

    id: Id = pydantic.Field()
    """
    Unique identifier for the agent.
    """

    name: str = pydantic.Field()
    """
    Name of the agent.
    """

    additional_properties: bool = pydantic.Field()
    """
    Indicates if the agent has additional properties that can be retrieved.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
