# This file was auto-generated by Fern from our API Definition.

from ...common.types.base import Base
from .ticket_id import TicketId
import pydantic
import typing
from .priority import Priority
import datetime as dt
from .status import Status
from .project_id import ProjectId
from .issue_type_id import IssueTypeId
from .attachment_metadata import AttachmentMetadata
from ...engine.types.object import Object
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Ticket(Base):
    """
    Ticketing ticket
    """

    id: TicketId
    summary: str = pydantic.Field()
    """
    Ticket summary.
    """

    creator: typing.Optional[str] = pydantic.Field(default=None)
    """
    User who created this ticket.
    """

    assignee: typing.Optional[str] = pydantic.Field(default=None)
    """
    Who ticket is assigned to.
    """

    contact: typing.Optional[str] = pydantic.Field(default=None)
    """
    Ticket contact information.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Ticket description.
    """

    priority: typing.Optional[Priority] = pydantic.Field(default=None)
    """
    The priority of the Ticket
    """

    due_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The ticket's due date.
    """

    completion_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The ticket's complete date.
    """

    status: typing.Optional[Status] = pydantic.Field(default=None)
    """
    The current status of the ticket.
    """

    project: typing.Optional[ProjectId] = pydantic.Field(default=None)
    """
    The ticket project.
    """

    issue_type: typing.Optional[IssueTypeId] = pydantic.Field(default=None)
    """
    The ticket's type.
    """

    tags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Associate tags with Ticket
    """

    attachments: typing.Optional[typing.List[AttachmentMetadata]] = pydantic.Field(
        default=None
    )
    """
    Metadata of attachments associated with the ticket
    """

    custom_fields: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = (
        pydantic.Field(default=None)
    )
    """
    Custom fields for this ticket, keys are the custom field names.
    """

    unmapped: typing.Optional[Object] = pydantic.Field(default=None)
    """
    The attributes that are not mapped to the ticket schema. The names and values of those attributes are specific to the provider.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
