# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
from .scan_frequency_option import ScanFrequencyOption
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ScanSchedule(UncheckedBaseModel):
    time: str = pydantic.Field()
    """
    Time of the day when the scan are repeated. For scans that are executed once, this is the time when the scan was started. This is formatted as `HH:MM:SS`.
    """

    frequency: ScanFrequencyOption = pydantic.Field()
    """
    Periodicity of the scan; for example, weekly, means that the scan will be repeated every `repeat_interval` weeks.
    """

    repeat_interval: int = pydantic.Field()
    """
    Number of days, weeks, months, or years between scans. For example, `1` means that the scan will be repeated once every `frequency` period.
    """

    days: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Days of the week when the scan will be repeated. For example, `["monday", "friday"]` means that the scan will be repeated on Monday and Friday on the schedule defined by `frequency` and `repeat_interval`.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
