# This file was auto-generated by Fern from our API Definition.

from ...common.types.base import Base
from ...account_base.types.account_id import AccountId
import pydantic
from ...organization_base.types.organization_id import OrganizationId
from ...organization_base.types.environment import Environment
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Account(Base):
    id: AccountId
    fullname: str = pydantic.Field()
    """
    Human friendly display name for this account.
    """

    organization_id: OrganizationId = pydantic.Field()
    """
    Organization that manages this Account.
    """

    environment: Environment = pydantic.Field()
    """
    Environment this account runs in.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    User defined labels that apply to this account. These values can be used in role bindings to limit the scope of permissions.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
