# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import SyncClientWrapper
import typing
from .types.list_connector_capabilities_expand_options import (
    ListConnectorCapabilitiesExpandOptions,
)
from ..core.request_options import RequestOptions
from .types.list_connectors_capabilities_response import (
    ListConnectorsCapabilitiesResponse,
)
from ..core.unchecked_base_model import construct_type
from ..common.errors.bad_request_error import BadRequestError
from ..common.types.problem import Problem
from ..common.errors.unauthorized_error import UnauthorizedError
from ..common.errors.forbidden_error import ForbiddenError
from ..common.errors.not_found_error import NotFoundError
from ..common.errors.method_not_allowed_error import MethodNotAllowedError
from ..common.errors.conflict_error import ConflictError
from ..common.errors.unsupported_media_type_error import UnsupportedMediaTypeError
from ..common.errors.too_many_requests_error import TooManyRequestsError
from ..common.errors.internal_server_error import InternalServerError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from .types.list_provider_capabilities_expand_options import (
    ListProviderCapabilitiesExpandOptions,
)
from .types.list_providers_capabilities_response import (
    ListProvidersCapabilitiesResponse,
)
from ..providers_generated.types.provider_config_id import ProviderConfigId
from .types.get_provider_capabilities_expand_options import (
    GetProviderCapabilitiesExpandOptions,
)
from .types.provider_capabilities_response import ProviderCapabilitiesResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.client_wrapper import AsyncClientWrapper


class CapabilitiesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_connectors(
        self,
        *,
        expand: typing.Optional[
            typing.Union[
                ListConnectorCapabilitiesExpandOptions,
                typing.Sequence[ListConnectorCapabilitiesExpandOptions],
            ]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListConnectorsCapabilitiesResponse:
        """
        Returns a list of all `Connectors`.

        Parameters
        ----------
        expand : typing.Optional[typing.Union[ListConnectorCapabilitiesExpandOptions, typing.Sequence[ListConnectorCapabilitiesExpandOptions]]]
            Expand the capabilities result fields that are otherwise
            omitted or returned as references to OpenAPI spec components.
            NOTE: This can yield very big response objects.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListConnectorsCapabilitiesResponse

        Examples
        --------
        from synqly import SynqlyManagement
        from synqly.capabilities import ListConnectorCapabilitiesExpandOptions

        client = SynqlyManagement(
            token="YOUR_TOKEN",
        )
        client.capabilities.list_connectors(
            expand=ListConnectorCapabilitiesExpandOptions.PROVIDERS,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/capabilities/connectors",
            method="GET",
            params={
                "expand": expand,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ListConnectorsCapabilitiesResponse,
                    construct_type(
                        type_=ListConnectorsCapabilitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list_providers(
        self,
        *,
        expand: typing.Optional[
            typing.Union[
                ListProviderCapabilitiesExpandOptions,
                typing.Sequence[ListProviderCapabilitiesExpandOptions],
            ]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListProvidersCapabilitiesResponse:
        """
        Returns a list of all Provider capabilities and their configurations.

        Parameters
        ----------
        expand : typing.Optional[typing.Union[ListProviderCapabilitiesExpandOptions, typing.Sequence[ListProviderCapabilitiesExpandOptions]]]
            Expand the capabilities result fields that are otherwise
            omitted or returned as references to OpenAPI spec components.
            NOTE: This can yield very big response objects.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListProvidersCapabilitiesResponse

        Examples
        --------
        from synqly import SynqlyManagement
        from synqly.capabilities import ListProviderCapabilitiesExpandOptions

        client = SynqlyManagement(
            token="YOUR_TOKEN",
        )
        client.capabilities.list_providers(
            expand=ListProviderCapabilitiesExpandOptions.CONNECTOR,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/capabilities/providers",
            method="GET",
            params={
                "expand": expand,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ListProvidersCapabilitiesResponse,
                    construct_type(
                        type_=ListProvidersCapabilitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_provider(
        self,
        provider_id: ProviderConfigId,
        *,
        expand: typing.Optional[
            typing.Union[
                GetProviderCapabilitiesExpandOptions,
                typing.Sequence[GetProviderCapabilitiesExpandOptions],
            ]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProviderCapabilitiesResponse:
        """
        Returns the capabilities and configurations for a specific Provider type

        Parameters
        ----------
        provider_id : ProviderConfigId

        expand : typing.Optional[typing.Union[GetProviderCapabilitiesExpandOptions, typing.Sequence[GetProviderCapabilitiesExpandOptions]]]
            Expand the capabilities result fields that are otherwise
            omitted or returned as references to OpenAPI spec components.
            NOTE: This can yield very big response objects.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProviderCapabilitiesResponse

        Examples
        --------
        from synqly import SynqlyManagement
        from synqly.capabilities import GetProviderCapabilitiesExpandOptions
        from synqly.providers_generated import ProviderConfigId

        client = SynqlyManagement(
            token="YOUR_TOKEN",
        )
        client.capabilities.get_provider(
            provider_id=ProviderConfigId.APPSEC_GIT_LAB,
            expand=GetProviderCapabilitiesExpandOptions.CONNECTOR,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/capabilities/providers/{jsonable_encoder(provider_id)}",
            method="GET",
            params={
                "expand": expand,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ProviderCapabilitiesResponse,
                    construct_type(
                        type_=ProviderCapabilitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncCapabilitiesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_connectors(
        self,
        *,
        expand: typing.Optional[
            typing.Union[
                ListConnectorCapabilitiesExpandOptions,
                typing.Sequence[ListConnectorCapabilitiesExpandOptions],
            ]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListConnectorsCapabilitiesResponse:
        """
        Returns a list of all `Connectors`.

        Parameters
        ----------
        expand : typing.Optional[typing.Union[ListConnectorCapabilitiesExpandOptions, typing.Sequence[ListConnectorCapabilitiesExpandOptions]]]
            Expand the capabilities result fields that are otherwise
            omitted or returned as references to OpenAPI spec components.
            NOTE: This can yield very big response objects.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListConnectorsCapabilitiesResponse

        Examples
        --------
        import asyncio

        from synqly import AsyncSynqlyManagement
        from synqly.capabilities import ListConnectorCapabilitiesExpandOptions

        client = AsyncSynqlyManagement(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.capabilities.list_connectors(
                expand=ListConnectorCapabilitiesExpandOptions.PROVIDERS,
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/capabilities/connectors",
            method="GET",
            params={
                "expand": expand,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ListConnectorsCapabilitiesResponse,
                    construct_type(
                        type_=ListConnectorsCapabilitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list_providers(
        self,
        *,
        expand: typing.Optional[
            typing.Union[
                ListProviderCapabilitiesExpandOptions,
                typing.Sequence[ListProviderCapabilitiesExpandOptions],
            ]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListProvidersCapabilitiesResponse:
        """
        Returns a list of all Provider capabilities and their configurations.

        Parameters
        ----------
        expand : typing.Optional[typing.Union[ListProviderCapabilitiesExpandOptions, typing.Sequence[ListProviderCapabilitiesExpandOptions]]]
            Expand the capabilities result fields that are otherwise
            omitted or returned as references to OpenAPI spec components.
            NOTE: This can yield very big response objects.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListProvidersCapabilitiesResponse

        Examples
        --------
        import asyncio

        from synqly import AsyncSynqlyManagement
        from synqly.capabilities import ListProviderCapabilitiesExpandOptions

        client = AsyncSynqlyManagement(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.capabilities.list_providers(
                expand=ListProviderCapabilitiesExpandOptions.CONNECTOR,
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/capabilities/providers",
            method="GET",
            params={
                "expand": expand,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ListProvidersCapabilitiesResponse,
                    construct_type(
                        type_=ListProvidersCapabilitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_provider(
        self,
        provider_id: ProviderConfigId,
        *,
        expand: typing.Optional[
            typing.Union[
                GetProviderCapabilitiesExpandOptions,
                typing.Sequence[GetProviderCapabilitiesExpandOptions],
            ]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProviderCapabilitiesResponse:
        """
        Returns the capabilities and configurations for a specific Provider type

        Parameters
        ----------
        provider_id : ProviderConfigId

        expand : typing.Optional[typing.Union[GetProviderCapabilitiesExpandOptions, typing.Sequence[GetProviderCapabilitiesExpandOptions]]]
            Expand the capabilities result fields that are otherwise
            omitted or returned as references to OpenAPI spec components.
            NOTE: This can yield very big response objects.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProviderCapabilitiesResponse

        Examples
        --------
        import asyncio

        from synqly import AsyncSynqlyManagement
        from synqly.capabilities import GetProviderCapabilitiesExpandOptions
        from synqly.providers_generated import ProviderConfigId

        client = AsyncSynqlyManagement(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.capabilities.get_provider(
                provider_id=ProviderConfigId.APPSEC_GIT_LAB,
                expand=GetProviderCapabilitiesExpandOptions.CONNECTOR,
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/capabilities/providers/{jsonable_encoder(provider_id)}",
            method="GET",
            params={
                "expand": expand,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ProviderCapabilitiesResponse,
                    construct_type(
                        type_=ProviderCapabilitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
