# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.unchecked_base_model import UncheckedBaseModel
from ...capabilities_base.types.provider_id import ProviderId
import pydantic
from ...capabilities_base.types.category_id import CategoryId
import typing
from .provider_operations import ProviderOperations
from .provider_release import ProviderRelease
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.pydantic_utilities import update_forward_refs


class ProviderCapabilities(UncheckedBaseModel):
    id: ProviderId = pydantic.Field()
    """
    Unique identifier for the Provider.
    """

    name: str = pydantic.Field()
    """
    Name of the Provider.
    """

    fullname: str = pydantic.Field()
    """
    Display name of the Provider.
    """

    description: str = pydantic.Field()
    """
    Description of the Provider.
    """

    connector_id: CategoryId = pydantic.Field()
    """
    Id of the Connector that the Provider implements.
    """

    connector: typing.Optional["ConnectorOrId"] = pydantic.Field(default=None)
    """
    Id of the Connector that the Provider implements – or, if
    `expand=connector` is set – the details of the Connector. NOTE:
    The current default behavior is to return the ID of the
    Connector. This field will soon only be populated when
    `expand=connector` is set in the APIs that support it. It is
    recommended you use `connector_id` for a stable reference to the
    Connector ID. This field will soon only be populated when
    `expand=connector` is set in the APIs that support it.
    """

    operations: typing.Optional[typing.List[ProviderOperations]] = pydantic.Field(
        default=None
    )
    """
    Operations that the Provider implements.
    """

    provider_config: typing.Optional[typing.Optional[typing.Any]] = pydantic.Field(
        default=None
    )
    """
    Details on the specific configuration options for the Provider.
    """

    release: typing.Optional[ProviderRelease] = pydantic.Field(default=None)
    """
    Provider availability inforamtion.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


from .connector_or_id import ConnectorOrId  # noqa: E402

update_forward_refs(ProviderCapabilities)
