# This file was auto-generated by Fern from our API Definition.

import typing
from .environment import SynqlyManagementEnvironment
import httpx
from .core.client_wrapper import SyncClientWrapper
from .accounts.client import AccountsClient
from .audit.client import AuditClient
from .auth.client import AuthClient
from .bridges.client import BridgesClient
from .capabilities.client import CapabilitiesClient
from .credentials.client import CredentialsClient
from .integration_points.client import IntegrationPointsClient
from .integrations.client import IntegrationsClient
from .mappings.client import MappingsClient
from .members.client import MembersClient
from .meta.client import MetaClient
from .operations.client import OperationsClient
from .organization_webhooks.client import OrganizationWebhooksClient
from .organization.client import OrganizationClient
from .permissionset.client import PermissionsetClient
from .roles.client import RolesClient
from .status.client import StatusClient
from .sub_orgs.client import SubOrgsClient
from .tokens.client import TokensClient
from .core.client_wrapper import AsyncClientWrapper
from .accounts.client import AsyncAccountsClient
from .audit.client import AsyncAuditClient
from .auth.client import AsyncAuthClient
from .bridges.client import AsyncBridgesClient
from .capabilities.client import AsyncCapabilitiesClient
from .credentials.client import AsyncCredentialsClient
from .integration_points.client import AsyncIntegrationPointsClient
from .integrations.client import AsyncIntegrationsClient
from .mappings.client import AsyncMappingsClient
from .members.client import AsyncMembersClient
from .meta.client import AsyncMetaClient
from .operations.client import AsyncOperationsClient
from .organization_webhooks.client import AsyncOrganizationWebhooksClient
from .organization.client import AsyncOrganizationClient
from .permissionset.client import AsyncPermissionsetClient
from .roles.client import AsyncRolesClient
from .status.client import AsyncStatusClient
from .sub_orgs.client import AsyncSubOrgsClient
from .tokens.client import AsyncTokensClient


class SynqlyManagement:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : SynqlyManagementEnvironment
        The environment to use for requests from the client. from .environment import SynqlyManagementEnvironment



        Defaults to SynqlyManagementEnvironment.SYNQLY



    token : typing.Union[str, typing.Callable[[], str]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from synqly import SynqlyManagement

    client = SynqlyManagement(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: SynqlyManagementEnvironment = SynqlyManagementEnvironment.SYNQLY,
        token: typing.Union[str, typing.Callable[[], str]],
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else None
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(
                timeout=_defaulted_timeout, follow_redirects=follow_redirects
            )
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.accounts = AccountsClient(client_wrapper=self._client_wrapper)
        self.audit = AuditClient(client_wrapper=self._client_wrapper)
        self.auth = AuthClient(client_wrapper=self._client_wrapper)
        self.bridges = BridgesClient(client_wrapper=self._client_wrapper)
        self.capabilities = CapabilitiesClient(client_wrapper=self._client_wrapper)
        self.credentials = CredentialsClient(client_wrapper=self._client_wrapper)
        self.integration_points = IntegrationPointsClient(
            client_wrapper=self._client_wrapper
        )
        self.integrations = IntegrationsClient(client_wrapper=self._client_wrapper)
        self.mappings = MappingsClient(client_wrapper=self._client_wrapper)
        self.members = MembersClient(client_wrapper=self._client_wrapper)
        self.meta = MetaClient(client_wrapper=self._client_wrapper)
        self.operations = OperationsClient(client_wrapper=self._client_wrapper)
        self.organization_webhooks = OrganizationWebhooksClient(
            client_wrapper=self._client_wrapper
        )
        self.organization = OrganizationClient(client_wrapper=self._client_wrapper)
        self.permissionset = PermissionsetClient(client_wrapper=self._client_wrapper)
        self.roles = RolesClient(client_wrapper=self._client_wrapper)
        self.status = StatusClient(client_wrapper=self._client_wrapper)
        self.sub_orgs = SubOrgsClient(client_wrapper=self._client_wrapper)
        self.tokens = TokensClient(client_wrapper=self._client_wrapper)


class AsyncSynqlyManagement:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : SynqlyManagementEnvironment
        The environment to use for requests from the client. from .environment import SynqlyManagementEnvironment



        Defaults to SynqlyManagementEnvironment.SYNQLY



    token : typing.Union[str, typing.Callable[[], str]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from synqly import AsyncSynqlyManagement

    client = AsyncSynqlyManagement(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: SynqlyManagementEnvironment = SynqlyManagementEnvironment.SYNQLY,
        token: typing.Union[str, typing.Callable[[], str]],
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else None
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(
                timeout=_defaulted_timeout, follow_redirects=follow_redirects
            )
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.accounts = AsyncAccountsClient(client_wrapper=self._client_wrapper)
        self.audit = AsyncAuditClient(client_wrapper=self._client_wrapper)
        self.auth = AsyncAuthClient(client_wrapper=self._client_wrapper)
        self.bridges = AsyncBridgesClient(client_wrapper=self._client_wrapper)
        self.capabilities = AsyncCapabilitiesClient(client_wrapper=self._client_wrapper)
        self.credentials = AsyncCredentialsClient(client_wrapper=self._client_wrapper)
        self.integration_points = AsyncIntegrationPointsClient(
            client_wrapper=self._client_wrapper
        )
        self.integrations = AsyncIntegrationsClient(client_wrapper=self._client_wrapper)
        self.mappings = AsyncMappingsClient(client_wrapper=self._client_wrapper)
        self.members = AsyncMembersClient(client_wrapper=self._client_wrapper)
        self.meta = AsyncMetaClient(client_wrapper=self._client_wrapper)
        self.operations = AsyncOperationsClient(client_wrapper=self._client_wrapper)
        self.organization_webhooks = AsyncOrganizationWebhooksClient(
            client_wrapper=self._client_wrapper
        )
        self.organization = AsyncOrganizationClient(client_wrapper=self._client_wrapper)
        self.permissionset = AsyncPermissionsetClient(
            client_wrapper=self._client_wrapper
        )
        self.roles = AsyncRolesClient(client_wrapper=self._client_wrapper)
        self.status = AsyncStatusClient(client_wrapper=self._client_wrapper)
        self.sub_orgs = AsyncSubOrgsClient(client_wrapper=self._client_wrapper)
        self.tokens = AsyncTokensClient(client_wrapper=self._client_wrapper)


def _get_base_url(
    *, base_url: typing.Optional[str] = None, environment: SynqlyManagementEnvironment
) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception(
            "Please pass in either base_url or environment to construct the client"
        )
