# This file was auto-generated by Fern from our API Definition.

from .credential_base import CredentialBase
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class AwsCredential(CredentialBase):
    """
    Access key to authenticate with AWS. Access keys are long-term credentials for an IAM user and consist of an Access Key ID and a Secret Access Key. Follow [this guide to generate credentials](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_access-keys.html).
    You may optionally provide a session token if you are using temporary credentials.
    """

    access_key_id: str = pydantic.Field()
    """
    Access Key ID portion of the AWS access key pair.
    """

    secret_access_key: str = pydantic.Field()
    """
    Secret portion of the AWS access key pair.
    """

    session: typing.Optional[str] = pydantic.Field(default=None)
    """
    A temporary session token. Session tokens are optional and are only necessary if you are using temporary credentials.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
