# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .credential_config import CredentialConfig
from .owner_type import OwnerType
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CreateCredentialRequest(UncheckedBaseModel):
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique short name for this Credential (lowercase [a-z0-9_-], can be used in URLs). Also used for case insensitive duplicate name detection and default sort order. Defaults to CredentialId if both name and fullname are not specified.
    """

    fullname: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human friendly display name for this Credential, will auto-generate 'name' field (if 'name' is not specified). Defaults to the same value as the 'name' field if not specified.
    """

    config: typing.Optional[CredentialConfig] = pydantic.Field(default=None)
    """
    Credential configuration
    """

    owner_type: typing.Optional[OwnerType] = pydantic.Field(default=None)
    """
    One of `account` or `integration_point`; defaults to `account` if not specified.
    """

    expires: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Time when this credential expires and can no longer be used again.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
