# This file was auto-generated by Fern from our API Definition.

from ...common.types.base import Base
from .credential_id import CredentialId
import typing
from ...account_base.types.account_id import AccountId
import pydantic
from ...integration_base.types.integration_id import IntegrationId
from ...integration_points.types.integration_point_id import IntegrationPointId
from ...organization_webhook_base.types.webhook_id import WebhookId
from .owner_type import OwnerType
from .credential_config import CredentialConfig
import datetime as dt
from .managed_type import ManagedType
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Credential(Base):
    """
    Credential to access an integration. Each credential is owned by an Account, Integration, IntegrationPoint or OrganizationWebhook.
    """

    id: CredentialId
    account_id: typing.Optional[AccountId] = pydantic.Field(default=None)
    """
    Account that manages this credential.
    """

    integration_id: typing.Optional[IntegrationId] = pydantic.Field(default=None)
    """
    Integration associated with this credential.
    """

    integration_point_id: typing.Optional[IntegrationPointId] = pydantic.Field(
        default=None
    )
    """
    Integration Point associated with this credential.
    """

    organization_webhook_id: typing.Optional[WebhookId] = pydantic.Field(default=None)
    """
    Organization Webhook associated with this credential.
    """

    owner_type: OwnerType = pydantic.Field()
    """
    One of `account` or `integration_point`.
    """

    fullname: str = pydantic.Field()
    """
    Human friendly display name for this Credential
    """

    config: typing.Optional[CredentialConfig] = pydantic.Field(default=None)
    """
    Credential configuration
    """

    expires: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Time when this credential expires and can no longer be used again.
    """

    managed: ManagedType = pydantic.Field()
    """
    Field is set by the management process. Determines lifecycle and ownership of the credential.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
