# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.unchecked_base_model import UncheckedBaseModel
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic
import typing_extensions
from ...core.unchecked_base_model import UnionMetadata


class CredentialConfig_Aws(UncheckedBaseModel):
    type: typing.Literal["aws"] = "aws"
    access_key_id: str
    secret_access_key: str
    session: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class CredentialConfig_Token(UncheckedBaseModel):
    type: typing.Literal["token"] = "token"
    secret: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class CredentialConfig_Basic(UncheckedBaseModel):
    type: typing.Literal["basic"] = "basic"
    username: str
    secret: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class CredentialConfig_Secret(UncheckedBaseModel):
    type: typing.Literal["secret"] = "secret"
    secret: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class CredentialConfig_OAuthClient(UncheckedBaseModel):
    type: typing.Literal["o_auth_client"] = "o_auth_client"
    token_url: typing.Optional[str] = None
    client_id: str
    client_secret: str
    extra: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


CredentialConfig = typing_extensions.Annotated[
    typing.Union[
        CredentialConfig_Aws,
        CredentialConfig_Token,
        CredentialConfig_Basic,
        CredentialConfig_Secret,
        CredentialConfig_OAuthClient,
    ],
    UnionMetadata(discriminant="type"),
]
