# This file was auto-generated by Fern from our API Definition.

from ...management.types.additional_mapping import AdditionalMapping
import typing
from ...providers_generated.types.provider_config_id import ProviderConfigId
import pydantic
from .additional_mapping_type import AdditionalMappingType
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class AdditionalMappingTemplate(AdditionalMapping):
    providers: typing.List[ProviderConfigId] = pydantic.Field()
    """
    A list of provider ID strings that this mapping applies to. Mapping templates must have at least one provider.
    """

    mapping_type: typing.Optional[AdditionalMappingType] = pydantic.Field(default=None)
    """
    This controls the end-user's responsibility for this mapping when creating an integration in this integration point. Default: 'optional'.
    When set to 'fixed' the mapping is always included and can not be overridden by the end-user.
    When 'optional', the end-user can choose to override the mapping.
    When 'recommended', the provider will enter a warning state if the mapping is missing.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
