# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...member_base.types.create_member_request import CreateMemberRequest
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CreateOrganizationRequest(UncheckedBaseModel):
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique short name for this Organization (lowercase [a-z0-9_-], can be used in URLs). Used for case insensitive duplicate name detection and default sort order. Defaults to OrganizationId if both name and fullname are not specified.
    """

    fullname: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human friendly display name for this Organization, will auto-generate 'name' field (if 'name' is not specified). Defaults to the same value as the 'name' field if not specified.
    """

    contact: typing.Optional[str] = pydantic.Field(default=None)
    """
    Organization email address
    """

    reply_to: typing.Optional[str] = pydantic.Field(default=None)
    """
    Reply-to email address, used for SMTP emails. Defaults to no-reply@synqly.com
    """

    picture: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL of the organization
    """

    member: typing.Optional[CreateMemberRequest] = pydantic.Field(default=None)
    """
    Create organization member
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
