# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .git_lab_credential import GitLabCredential
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class AppsecGitLab(UncheckedBaseModel):
    """
    Configuration for GitLab as an application security provider.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/gitlab-appsec-setup)
    """

    credential: GitLabCredential = pydantic.Field()
    """
    Credentials used for accessing the GitLab API.
    """

    url: str = pydantic.Field()
    """
    Base URL for the GitLab API. This URL should be the same as the URL used to access your GitLab instance.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
