# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .defender_credential import DefenderCredential
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CloudSecurityDefender(UncheckedBaseModel):
    """
    Configuration for the Microsoft Defender for Cloud Provider
    """

    credential: DefenderCredential
    subscription_id: str = pydantic.Field()
    """
    The Azure subscription ID that contains the Microsoft Defender for Cloud workspace.
    """

    tenant_id: str = pydantic.Field()
    """
    The Azure Active Directory tenant ID that contains the Microsoft Defender for Cloud workspace.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base URL to your Microsoft Defender for Cloud workspace.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
