# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .defender_credential import DefenderCredential
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class EdrDefender(UncheckedBaseModel):
    """
    Configuration for Microsoft Defender for Endpoint.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/defender-setup)
    """

    credential: DefenderCredential
    tenant_id: str = pydantic.Field()
    """
    Tenant ID for the Microsoft Defender Management Console.
    """

    url: str = pydantic.Field()
    """
    Base URL for the Microsoft Defender API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
