# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .entra_id_credential import EntraIdCredential
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class IdentityEntraId(UncheckedBaseModel):
    """
    Configuration for Microsoft Entra ID.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/entra-id-setup)
    """

    credential: EntraIdCredential
    tenant_id: str = pydantic.Field()
    """
    Azure Directory (tenant) identifier.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base URL for the the Microsoft Graph API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
