# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.unchecked_base_model import UncheckedBaseModel
import typing
from .git_lab_credential import GitLabCredential
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic
from .hcl_app_scan_on_cloud_credential import HclAppScanOnCloudCredential
from .hcl_app_scan_on_cloud_url import HclAppScanOnCloudUrl
from .open_text_core_application_security_credential import (
    OpenTextCoreApplicationSecurityCredential,
)
from .open_text_core_application_security_url import OpenTextCoreApplicationSecurityUrl
from .appsec_opentext_core_application_security_dataset import (
    AppsecOpentextCoreApplicationSecurityDataset,
)
from .armis_credential import ArmisCredential
from .assets_armis_dataset import AssetsArmisDataset
from .axonius_credential import AxoniusCredential
from .assets_axonius_dataset import AssetsAxoniusDataset
from .claroty_credential import ClarotyCredential
from .claroty_apiurl import ClarotyApiurl
from .crowd_strike_credential import CrowdStrikeCredential
from .assets_crowd_strike_dataset import AssetsCrowdStrikeDataset
from .ivanti_credential import IvantiCredential
from .nozomi_vantage_credential import NozomiVantageCredential
from .assets_nozomi_vantage_dataset import AssetsNozomiVantageDataset
from .qualys_cloud_credential import QualysCloudCredential
from .assets_qualys_cloud_dataset import AssetsQualysCloudDataset
from .service_now_credential import ServiceNowCredential
from .assets_service_now_dataset import AssetsServiceNowDataset
from .sevco_credential import SevcoCredential
from .assets_sevco_dataset import AssetsSevcoDataset
from .tanium_cloud_credential import TaniumCloudCredential
from .assets_tanium_cloud_dataset import AssetsTaniumCloudDataset
from .aws_provider_credential import AwsProviderCredential
from .aws_region import AwsRegion
from .defender_credential import DefenderCredential
from .palo_alto_credential import PaloAltoCredential
from .edr_crowd_strike_dataset import EdrCrowdStrikeDataset
from .malwarebytes_credential import MalwarebytesCredential
from .sentinel_one_credential import SentinelOneCredential
from .sentinel_one_edr_events_credential import SentinelOneEdrEventsCredential
from .sophos_credential import SophosCredential
from .entra_id_credential import EntraIdCredential
from .google_credential import GoogleCredential
from .okta_credential import OktaCredential
from .ping_one_auth_url import PingOneAuthUrl
from .ping_one_credential import PingOneCredential
from .ping_one_apiurl import PingOneApiurl
from .jira_credential import JiraCredential
from .slack_credential import SlackCredential
from .slack_webhook_credential import SlackWebhookCredential
from .teams_credential import TeamsCredential
from .crowdstrike_hec_credential import CrowdstrikeHecCredential
from .elasticsearch_auth_options import ElasticsearchAuthOptions
from .elasticsearch_credential import ElasticsearchCredential
from .google_chronicle_credential import GoogleChronicleCredential
from .google_service_account_credential import GoogleServiceAccountCredential
from .open_search_credential import OpenSearchCredential
from .q_radar_credential import QRadarCredential
from .rapid_7_insight_cloud_credential import Rapid7InsightCloudCredential
from .sentinel_credential import SentinelCredential
from .splunk_hec_token import SplunkHecToken
from .splunk_search_credential import SplunkSearchCredential
from .sumo_logic_collection_url import SumoLogicCollectionUrl
from .sumo_logic_credential import SumoLogicCredential
from .aws_s_3_credential import AwsS3Credential
from .aws_security_lake_credential import AwsSecurityLakeCredential
from .aws_sqs_credential import AwsSqsCredential
from .azure_monitor_logs_credential import AzureMonitorLogsCredential
from .azure_blob_credential import AzureBlobCredential
from .gcs_credential import GcsCredential
from .autotask_api_integration_code_credential import (
    AutotaskApiIntegrationCodeCredential,
)
from .autotask_secret_credential import AutotaskSecretCredential
from .freshdesk_credential import FreshdeskCredential
from .custom_field_mapping import CustomFieldMapping
from .pager_duty_credential import PagerDutyCredential
from .ticketing_pagerduty_dataset import TicketingPagerdutyDataset
from .torq_credential import TorqCredential
from .zendesk_credential import ZendeskCredential
from .vulnerabilities_crowd_strike_dataset import VulnerabilitiesCrowdStrikeDataset
from .nucleus_credential import NucleusCredential
from .vulnerabilities_qualys_cloud_dataset import VulnerabilitiesQualysCloudDataset
from .vulnerabilities_rapid_7_insight_cloud_dataset import (
    VulnerabilitiesRapid7InsightCloudDataset,
)
from .vulnerabilities_tanium_cloud_dataset import VulnerabilitiesTaniumCloudDataset
from .tenable_cloud_credential import TenableCloudCredential
import typing_extensions
from ...core.unchecked_base_model import UnionMetadata


class ProviderConfig_AppsecGitlab(UncheckedBaseModel):
    type: typing.Literal["appsec_gitlab"] = "appsec_gitlab"
    credential: GitLabCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AppsecHclAppscanOnCloud(UncheckedBaseModel):
    type: typing.Literal["appsec_hcl_appscan_on_cloud"] = "appsec_hcl_appscan_on_cloud"
    credential: HclAppScanOnCloudCredential
    url: HclAppScanOnCloudUrl

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AppsecOpentextCoreApplicationSecurity(UncheckedBaseModel):
    type: typing.Literal["appsec_opentext_core_application_security"] = (
        "appsec_opentext_core_application_security"
    )
    credential: OpenTextCoreApplicationSecurityCredential
    url: OpenTextCoreApplicationSecurityUrl

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AppsecOpentextCoreApplicationSecurityMock(UncheckedBaseModel):
    type: typing.Literal["appsec_opentext_core_application_security_mock"] = (
        "appsec_opentext_core_application_security_mock"
    )
    dataset: AppsecOpentextCoreApplicationSecurityDataset

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsArmisCentrix(UncheckedBaseModel):
    type: typing.Literal["assets_armis_centrix"] = "assets_armis_centrix"
    credential: ArmisCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsArmisCentrixMock(UncheckedBaseModel):
    type: typing.Literal["assets_armis_centrix_mock"] = "assets_armis_centrix_mock"
    dataset: AssetsArmisDataset

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsAxonius(UncheckedBaseModel):
    type: typing.Literal["assets_axonius"] = "assets_axonius"
    credential: AxoniusCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsAxoniusMock(UncheckedBaseModel):
    type: typing.Literal["assets_axonius_mock"] = "assets_axonius_mock"
    dataset: AssetsAxoniusDataset

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsClarotyXdome(UncheckedBaseModel):
    type: typing.Literal["assets_claroty_xdome"] = "assets_claroty_xdome"
    credential: ClarotyCredential
    url: ClarotyApiurl

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsCrowdstrike(UncheckedBaseModel):
    type: typing.Literal["assets_crowdstrike"] = "assets_crowdstrike"
    credential: CrowdStrikeCredential
    url: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsCrowdstrikeMock(UncheckedBaseModel):
    type: typing.Literal["assets_crowdstrike_mock"] = "assets_crowdstrike_mock"
    dataset: AssetsCrowdStrikeDataset

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsIvantiNeurons(UncheckedBaseModel):
    type: typing.Literal["assets_ivanti_neurons"] = "assets_ivanti_neurons"
    account_identifier: str
    credential: IvantiCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsNozomiVantage(UncheckedBaseModel):
    type: typing.Literal["assets_nozomi_vantage"] = "assets_nozomi_vantage"
    credential: NozomiVantageCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsNozomiVantageMock(UncheckedBaseModel):
    type: typing.Literal["assets_nozomi_vantage_mock"] = "assets_nozomi_vantage_mock"
    dataset: AssetsNozomiVantageDataset

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsQualysCloud(UncheckedBaseModel):
    type: typing.Literal["assets_qualys_cloud"] = "assets_qualys_cloud"
    credential: QualysCloudCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsQualysCloudMock(UncheckedBaseModel):
    type: typing.Literal["assets_qualys_cloud_mock"] = "assets_qualys_cloud_mock"
    dataset: AssetsQualysCloudDataset

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsServicenow(UncheckedBaseModel):
    type: typing.Literal["assets_servicenow"] = "assets_servicenow"
    credential: ServiceNowCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsServicenowMock(UncheckedBaseModel):
    type: typing.Literal["assets_servicenow_mock"] = "assets_servicenow_mock"
    dataset: AssetsServiceNowDataset

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsSevco(UncheckedBaseModel):
    type: typing.Literal["assets_sevco"] = "assets_sevco"
    credential: SevcoCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsSevcoMock(UncheckedBaseModel):
    type: typing.Literal["assets_sevco_mock"] = "assets_sevco_mock"
    dataset: AssetsSevcoDataset

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsTaniumCloud(UncheckedBaseModel):
    type: typing.Literal["assets_tanium_cloud"] = "assets_tanium_cloud"
    credential: TaniumCloudCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_AssetsTaniumCloudMock(UncheckedBaseModel):
    type: typing.Literal["assets_tanium_cloud_mock"] = "assets_tanium_cloud_mock"
    dataset: AssetsTaniumCloudDataset

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_CloudsecurityAws(UncheckedBaseModel):
    type: typing.Literal["cloudsecurity_aws"] = "cloudsecurity_aws"
    credential: AwsProviderCredential
    region: AwsRegion

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_CloudsecurityCrowdstrike(UncheckedBaseModel):
    type: typing.Literal["cloudsecurity_crowdstrike"] = "cloudsecurity_crowdstrike"
    credential: CrowdStrikeCredential
    url: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_CloudsecurityDefender(UncheckedBaseModel):
    type: typing.Literal["cloudsecurity_defender"] = "cloudsecurity_defender"
    credential: DefenderCredential
    subscription_id: str
    tenant_id: str
    url: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_CloudsecurityPaloalto(UncheckedBaseModel):
    type: typing.Literal["cloudsecurity_paloalto"] = "cloudsecurity_paloalto"
    credential: PaloAltoCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_EdrCrowdstrike(UncheckedBaseModel):
    type: typing.Literal["edr_crowdstrike"] = "edr_crowdstrike"
    credential: CrowdStrikeCredential
    url: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_EdrCrowdstrikeMock(UncheckedBaseModel):
    type: typing.Literal["edr_crowdstrike_mock"] = "edr_crowdstrike_mock"
    dataset: EdrCrowdStrikeDataset

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_EdrDefender(UncheckedBaseModel):
    type: typing.Literal["edr_defender"] = "edr_defender"
    credential: DefenderCredential
    tenant_id: str
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_EdrMalwarebytes(UncheckedBaseModel):
    type: typing.Literal["edr_malwarebytes"] = "edr_malwarebytes"
    account_identifier: str
    credential: MalwarebytesCredential
    url: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_EdrSentinelone(UncheckedBaseModel):
    type: typing.Literal["edr_sentinelone"] = "edr_sentinelone"
    credential: SentinelOneCredential
    edr_events_credential: typing.Optional[SentinelOneEdrEventsCredential] = None
    edr_events_url: typing.Optional[str] = None
    skip_tls_verify: typing.Optional[bool] = None
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_EdrSophos(UncheckedBaseModel):
    type: typing.Literal["edr_sophos"] = "edr_sophos"
    credential: SophosCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_EdrTanium(UncheckedBaseModel):
    type: typing.Literal["edr_tanium"] = "edr_tanium"
    credential: TaniumCloudCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_IdentityEntraId(UncheckedBaseModel):
    type: typing.Literal["identity_entra_id"] = "identity_entra_id"
    credential: EntraIdCredential
    tenant_id: str
    url: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_IdentityGoogle(UncheckedBaseModel):
    type: typing.Literal["identity_google"] = "identity_google"
    client_email: str
    credential: GoogleCredential
    delegate: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_IdentityOkta(UncheckedBaseModel):
    type: typing.Literal["identity_okta"] = "identity_okta"
    credential: OktaCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_IdentityPingone(UncheckedBaseModel):
    type: typing.Literal["identity_pingone"] = "identity_pingone"
    auth_url: PingOneAuthUrl
    client_id: str
    credential: PingOneCredential
    organization_id: str
    url: PingOneApiurl

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_NotificationsJira(UncheckedBaseModel):
    type: typing.Literal["notifications_jira"] = "notifications_jira"
    credential: JiraCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_NotificationsMockNotifications(UncheckedBaseModel):
    type: typing.Literal["notifications_mock_notifications"] = (
        "notifications_mock_notifications"
    )
    channel: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_NotificationsSlack(UncheckedBaseModel):
    type: typing.Literal["notifications_slack"] = "notifications_slack"
    channel: str
    credential: SlackCredential
    url: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_NotificationsSlackWebhook(UncheckedBaseModel):
    type: typing.Literal["notifications_slack_webhook"] = "notifications_slack_webhook"
    webhook_url: SlackWebhookCredential

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_NotificationsTeams(UncheckedBaseModel):
    type: typing.Literal["notifications_teams"] = "notifications_teams"
    channel_id: str
    credential: TeamsCredential
    endpoint: typing.Optional[str] = None
    team_id: str
    tenant_id: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SiemCrowdstrike(UncheckedBaseModel):
    type: typing.Literal["siem_crowdstrike"] = "siem_crowdstrike"
    credential: CrowdStrikeCredential
    hec_credential: typing.Optional[CrowdstrikeHecCredential] = None
    hec_url: typing.Optional[str] = None
    url: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SiemElasticsearch(UncheckedBaseModel):
    type: typing.Literal["siem_elasticsearch"] = "siem_elasticsearch"
    auth_options: typing.Optional[ElasticsearchAuthOptions] = None
    create_index: typing.Optional[str] = None
    credential: ElasticsearchCredential
    index: typing.Optional[str] = None
    kibana_url: typing.Optional[str] = None
    skip_tls_verify: typing.Optional[bool] = None
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SiemGoogleChronicle(UncheckedBaseModel):
    type: typing.Literal["siem_google_chronicle"] = "siem_google_chronicle"
    customer_id: typing.Optional[str] = None
    ingestion_credential: typing.Optional[GoogleChronicleCredential] = None
    ingestion_url: typing.Optional[str] = None
    search_credential: GoogleChronicleCredential
    search_url: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SiemGoogleSecurityOperations(UncheckedBaseModel):
    type: typing.Literal["siem_google_security_operations"] = (
        "siem_google_security_operations"
    )
    credential: GoogleServiceAccountCredential
    customer_id: str
    project_id: str
    region: typing.Optional[str] = None
    url: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SiemMockSiem(UncheckedBaseModel):
    type: typing.Literal["siem_mock_siem"] = "siem_mock_siem"
    index: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SiemOpensearch(UncheckedBaseModel):
    type: typing.Literal["siem_opensearch"] = "siem_opensearch"
    create_index: typing.Optional[str] = None
    credential: OpenSearchCredential
    index: typing.Optional[str] = None
    skip_tls_verify: typing.Optional[bool] = None
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SiemQRadar(UncheckedBaseModel):
    type: typing.Literal["siem_q_radar"] = "siem_q_radar"
    collection_port: int
    credential: QRadarCredential
    skip_tls_verify: typing.Optional[bool] = None
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SiemRapid7Insightidr(UncheckedBaseModel):
    type: typing.Literal["siem_rapid7_insightidr"] = "siem_rapid7_insightidr"
    credential: Rapid7InsightCloudCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SiemSentinel(UncheckedBaseModel):
    type: typing.Literal["siem_sentinel"] = "siem_sentinel"
    credential: SentinelCredential
    default_tables: typing.Optional[typing.List[str]] = None
    ingest_url: typing.Optional[str] = None
    logs_url: typing.Optional[str] = None
    management_url: typing.Optional[str] = None
    resource_group: str
    rule_id: typing.Optional[str] = None
    stream_name: typing.Optional[str] = None
    subscription_id: str
    tenant_id: str
    workspace_id: str
    workspace_name: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SiemSplunk(UncheckedBaseModel):
    type: typing.Literal["siem_splunk"] = "siem_splunk"
    hec_credential: typing.Optional[SplunkHecToken] = None
    hec_url: typing.Optional[str] = None
    index: typing.Optional[str] = None
    search_service_credential: SplunkSearchCredential
    search_service_url: str
    skip_tls_verify: typing.Optional[bool] = None
    source: typing.Optional[str] = None
    source_type: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SiemSumoLogic(UncheckedBaseModel):
    type: typing.Literal["siem_sumo_logic"] = "siem_sumo_logic"
    auto_parse_logs: typing.Optional[bool] = None
    collection_url: typing.Optional[SumoLogicCollectionUrl] = None
    credential: SumoLogicCredential
    siem_logs_only: typing.Optional[bool] = None
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SinkAwsS3(UncheckedBaseModel):
    type: typing.Literal["sink_aws_s3"] = "sink_aws_s3"
    bucket: str
    credential: AwsS3Credential
    path: str
    region: AwsRegion

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SinkAwsSecurityLake(UncheckedBaseModel):
    type: typing.Literal["sink_aws_security_lake"] = "sink_aws_security_lake"
    credential: AwsSecurityLakeCredential
    region: typing.Optional[str] = None
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SinkAwsSqs(UncheckedBaseModel):
    type: typing.Literal["sink_aws_sqs"] = "sink_aws_sqs"
    credential: AwsSqsCredential
    region: typing.Optional[str] = None
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SinkAzureMonitorLogs(UncheckedBaseModel):
    type: typing.Literal["sink_azure_monitor_logs"] = "sink_azure_monitor_logs"
    client_id: str
    credential: AzureMonitorLogsCredential
    rule_id: str
    stream_name: str
    tenant_id: str
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SinkCrowdstrikeHec(UncheckedBaseModel):
    type: typing.Literal["sink_crowdstrike_hec"] = "sink_crowdstrike_hec"
    credential: CrowdstrikeHecCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SinkElasticsearch(UncheckedBaseModel):
    type: typing.Literal["sink_elasticsearch"] = "sink_elasticsearch"
    auth_options: typing.Optional[ElasticsearchAuthOptions] = None
    create_index: str
    credential: ElasticsearchCredential
    skip_tls_verify: typing.Optional[bool] = None
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SinkGoogleSecOps(UncheckedBaseModel):
    type: typing.Literal["sink_google_sec_ops"] = "sink_google_sec_ops"
    credential: GoogleChronicleCredential
    customer_id: str
    url: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SinkGoogleSecurityOperations(UncheckedBaseModel):
    type: typing.Literal["sink_google_security_operations"] = (
        "sink_google_security_operations"
    )
    credential: GoogleServiceAccountCredential
    customer_id: str
    project_id: str
    region: typing.Optional[str] = None
    url: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SinkMockSink(UncheckedBaseModel):
    type: typing.Literal["sink_mock_sink"] = "sink_mock_sink"
    destination: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SinkOpensearch(UncheckedBaseModel):
    type: typing.Literal["sink_opensearch"] = "sink_opensearch"
    create_index: str
    credential: OpenSearchCredential
    skip_tls_verify: typing.Optional[bool] = None
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SinkQRadar(UncheckedBaseModel):
    type: typing.Literal["sink_q_radar"] = "sink_q_radar"
    collection_port: int
    skip_tls_verify: typing.Optional[bool] = None
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_SinkSplunk(UncheckedBaseModel):
    type: typing.Literal["sink_splunk"] = "sink_splunk"
    hec_credential: SplunkHecToken
    hec_url: str
    index: typing.Optional[str] = None
    skip_tls_verify: typing.Optional[bool] = None
    source: typing.Optional[str] = None
    source_type: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_StorageAwsS3(UncheckedBaseModel):
    type: typing.Literal["storage_aws_s3"] = "storage_aws_s3"
    bucket: str
    credential: AwsS3Credential
    endpoint: typing.Optional[str] = None
    region: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_StorageAzureBlob(UncheckedBaseModel):
    type: typing.Literal["storage_azure_blob"] = "storage_azure_blob"
    bucket: str
    credential: AzureBlobCredential

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_StorageGcs(UncheckedBaseModel):
    type: typing.Literal["storage_gcs"] = "storage_gcs"
    bucket: str
    credential: GcsCredential
    region: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_StorageMockStorage(UncheckedBaseModel):
    type: typing.Literal["storage_mock_storage"] = "storage_mock_storage"
    bucket: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_TicketingAutotask(UncheckedBaseModel):
    type: typing.Literal["ticketing_autotask"] = "ticketing_autotask"
    api_integration_code_credential: AutotaskApiIntegrationCodeCredential
    secret_credential: AutotaskSecretCredential
    user_name: str
    zone_path: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_TicketingFreshdesk(UncheckedBaseModel):
    type: typing.Literal["ticketing_freshdesk"] = "ticketing_freshdesk"
    credential: FreshdeskCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_TicketingJira(UncheckedBaseModel):
    type: typing.Literal["ticketing_jira"] = "ticketing_jira"
    credential: JiraCredential
    custom_field_mappings: typing.Optional[typing.List[CustomFieldMapping]] = None
    default_issue_type: typing.Optional[str] = None
    default_project: typing.Optional[str] = None
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_TicketingJiraServiceManagement(UncheckedBaseModel):
    type: typing.Literal["ticketing_jira_service_management"] = (
        "ticketing_jira_service_management"
    )
    credential: JiraCredential
    custom_field_mappings: typing.Optional[typing.List[CustomFieldMapping]] = None
    default_issue_type: typing.Optional[str] = None
    default_project: typing.Optional[str] = None
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_TicketingMockTicketing(UncheckedBaseModel):
    type: typing.Literal["ticketing_mock_ticketing"] = "ticketing_mock_ticketing"
    custom_field_mappings: typing.Optional[typing.List[CustomFieldMapping]] = None
    name: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_TicketingPagerduty(UncheckedBaseModel):
    type: typing.Literal["ticketing_pagerduty"] = "ticketing_pagerduty"
    credential: PagerDutyCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_TicketingPagerdutyMock(UncheckedBaseModel):
    type: typing.Literal["ticketing_pagerduty_mock"] = "ticketing_pagerduty_mock"
    dataset: TicketingPagerdutyDataset

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_TicketingServicenow(UncheckedBaseModel):
    type: typing.Literal["ticketing_servicenow"] = "ticketing_servicenow"
    credential: ServiceNowCredential
    custom_field_mappings: typing.Optional[typing.List[CustomFieldMapping]] = None
    default_project: typing.Optional[str] = None
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_TicketingServicenowSir(UncheckedBaseModel):
    type: typing.Literal["ticketing_servicenow_sir"] = "ticketing_servicenow_sir"
    credential: ServiceNowCredential
    custom_field_mappings: typing.Optional[typing.List[CustomFieldMapping]] = None
    default_project: typing.Optional[str] = None
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_TicketingTorq(UncheckedBaseModel):
    type: typing.Literal["ticketing_torq"] = "ticketing_torq"
    credential: TorqCredential
    custom_field_mappings: typing.Optional[typing.List[CustomFieldMapping]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_TicketingZendesk(UncheckedBaseModel):
    type: typing.Literal["ticketing_zendesk"] = "ticketing_zendesk"
    credential: ZendeskCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_VulnerabilitiesCrowdstrike(UncheckedBaseModel):
    type: typing.Literal["vulnerabilities_crowdstrike"] = "vulnerabilities_crowdstrike"
    credential: CrowdStrikeCredential
    url: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_VulnerabilitiesCrowdstrikeMock(UncheckedBaseModel):
    type: typing.Literal["vulnerabilities_crowdstrike_mock"] = (
        "vulnerabilities_crowdstrike_mock"
    )
    dataset: VulnerabilitiesCrowdStrikeDataset

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_VulnerabilitiesNucleus(UncheckedBaseModel):
    type: typing.Literal["vulnerabilities_nucleus"] = "vulnerabilities_nucleus"
    credential: NucleusCredential
    project_id: str
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_VulnerabilitiesQualysCloud(UncheckedBaseModel):
    type: typing.Literal["vulnerabilities_qualys_cloud"] = (
        "vulnerabilities_qualys_cloud"
    )
    credential: QualysCloudCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_VulnerabilitiesQualysCloudMock(UncheckedBaseModel):
    type: typing.Literal["vulnerabilities_qualys_cloud_mock"] = (
        "vulnerabilities_qualys_cloud_mock"
    )
    dataset: VulnerabilitiesQualysCloudDataset

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_VulnerabilitiesRapid7InsightCloud(UncheckedBaseModel):
    type: typing.Literal["vulnerabilities_rapid7_insight_cloud"] = (
        "vulnerabilities_rapid7_insight_cloud"
    )
    credential: Rapid7InsightCloudCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_VulnerabilitiesRapid7InsightCloudMock(UncheckedBaseModel):
    type: typing.Literal["vulnerabilities_rapid7_insight_cloud_mock"] = (
        "vulnerabilities_rapid7_insight_cloud_mock"
    )
    dataset: VulnerabilitiesRapid7InsightCloudDataset

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_VulnerabilitiesServicenowVr(UncheckedBaseModel):
    type: typing.Literal["vulnerabilities_servicenow_vr"] = (
        "vulnerabilities_servicenow_vr"
    )
    credential: ServiceNowCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_VulnerabilitiesTaniumCloud(UncheckedBaseModel):
    type: typing.Literal["vulnerabilities_tanium_cloud"] = (
        "vulnerabilities_tanium_cloud"
    )
    credential: TaniumCloudCredential
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_VulnerabilitiesTaniumCloudMock(UncheckedBaseModel):
    type: typing.Literal["vulnerabilities_tanium_cloud_mock"] = (
        "vulnerabilities_tanium_cloud_mock"
    )
    dataset: VulnerabilitiesTaniumCloudDataset

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ProviderConfig_VulnerabilitiesTenableCloud(UncheckedBaseModel):
    type: typing.Literal["vulnerabilities_tenable_cloud"] = (
        "vulnerabilities_tenable_cloud"
    )
    credential: TenableCloudCredential
    url: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


ProviderConfig = typing_extensions.Annotated[
    typing.Union[
        ProviderConfig_AppsecGitlab,
        ProviderConfig_AppsecHclAppscanOnCloud,
        ProviderConfig_AppsecOpentextCoreApplicationSecurity,
        ProviderConfig_AppsecOpentextCoreApplicationSecurityMock,
        ProviderConfig_AssetsArmisCentrix,
        ProviderConfig_AssetsArmisCentrixMock,
        ProviderConfig_AssetsAxonius,
        ProviderConfig_AssetsAxoniusMock,
        ProviderConfig_AssetsClarotyXdome,
        ProviderConfig_AssetsCrowdstrike,
        ProviderConfig_AssetsCrowdstrikeMock,
        ProviderConfig_AssetsIvantiNeurons,
        ProviderConfig_AssetsNozomiVantage,
        ProviderConfig_AssetsNozomiVantageMock,
        ProviderConfig_AssetsQualysCloud,
        ProviderConfig_AssetsQualysCloudMock,
        ProviderConfig_AssetsServicenow,
        ProviderConfig_AssetsServicenowMock,
        ProviderConfig_AssetsSevco,
        ProviderConfig_AssetsSevcoMock,
        ProviderConfig_AssetsTaniumCloud,
        ProviderConfig_AssetsTaniumCloudMock,
        ProviderConfig_CloudsecurityAws,
        ProviderConfig_CloudsecurityCrowdstrike,
        ProviderConfig_CloudsecurityDefender,
        ProviderConfig_CloudsecurityPaloalto,
        ProviderConfig_EdrCrowdstrike,
        ProviderConfig_EdrCrowdstrikeMock,
        ProviderConfig_EdrDefender,
        ProviderConfig_EdrMalwarebytes,
        ProviderConfig_EdrSentinelone,
        ProviderConfig_EdrSophos,
        ProviderConfig_EdrTanium,
        ProviderConfig_IdentityEntraId,
        ProviderConfig_IdentityGoogle,
        ProviderConfig_IdentityOkta,
        ProviderConfig_IdentityPingone,
        ProviderConfig_NotificationsJira,
        ProviderConfig_NotificationsMockNotifications,
        ProviderConfig_NotificationsSlack,
        ProviderConfig_NotificationsSlackWebhook,
        ProviderConfig_NotificationsTeams,
        ProviderConfig_SiemCrowdstrike,
        ProviderConfig_SiemElasticsearch,
        ProviderConfig_SiemGoogleChronicle,
        ProviderConfig_SiemGoogleSecurityOperations,
        ProviderConfig_SiemMockSiem,
        ProviderConfig_SiemOpensearch,
        ProviderConfig_SiemQRadar,
        ProviderConfig_SiemRapid7Insightidr,
        ProviderConfig_SiemSentinel,
        ProviderConfig_SiemSplunk,
        ProviderConfig_SiemSumoLogic,
        ProviderConfig_SinkAwsS3,
        ProviderConfig_SinkAwsSecurityLake,
        ProviderConfig_SinkAwsSqs,
        ProviderConfig_SinkAzureMonitorLogs,
        ProviderConfig_SinkCrowdstrikeHec,
        ProviderConfig_SinkElasticsearch,
        ProviderConfig_SinkGoogleSecOps,
        ProviderConfig_SinkGoogleSecurityOperations,
        ProviderConfig_SinkMockSink,
        ProviderConfig_SinkOpensearch,
        ProviderConfig_SinkQRadar,
        ProviderConfig_SinkSplunk,
        ProviderConfig_StorageAwsS3,
        ProviderConfig_StorageAzureBlob,
        ProviderConfig_StorageGcs,
        ProviderConfig_StorageMockStorage,
        ProviderConfig_TicketingAutotask,
        ProviderConfig_TicketingFreshdesk,
        ProviderConfig_TicketingJira,
        ProviderConfig_TicketingJiraServiceManagement,
        ProviderConfig_TicketingMockTicketing,
        ProviderConfig_TicketingPagerduty,
        ProviderConfig_TicketingPagerdutyMock,
        ProviderConfig_TicketingServicenow,
        ProviderConfig_TicketingServicenowSir,
        ProviderConfig_TicketingTorq,
        ProviderConfig_TicketingZendesk,
        ProviderConfig_VulnerabilitiesCrowdstrike,
        ProviderConfig_VulnerabilitiesCrowdstrikeMock,
        ProviderConfig_VulnerabilitiesNucleus,
        ProviderConfig_VulnerabilitiesQualysCloud,
        ProviderConfig_VulnerabilitiesQualysCloudMock,
        ProviderConfig_VulnerabilitiesRapid7InsightCloud,
        ProviderConfig_VulnerabilitiesRapid7InsightCloudMock,
        ProviderConfig_VulnerabilitiesServicenowVr,
        ProviderConfig_VulnerabilitiesTaniumCloud,
        ProviderConfig_VulnerabilitiesTaniumCloudMock,
        ProviderConfig_VulnerabilitiesTenableCloud,
    ],
    UnionMetadata(discriminant="type"),
]
