# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
from ...account_base.types.account_id import AccountId
import pydantic
from ...organization_base.types.environment import Environment
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class RoleAccounts(UncheckedBaseModel):
    ids: typing.List[AccountId] = pydantic.Field()
    """
    List of account ids that this role definition grants access to. Use "\*" to grant access to all account ids.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of account labels this role definition grants access to. If both labels and environments are specified both must pass
    """

    environments: typing.Optional[typing.List[Environment]] = pydantic.Field(
        default=None
    )
    """
    Account environments this role definition grants access to. If both labels and environments are specified both must pass
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
