# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...role_base.types.resources import Resources
from ...permissionset_base.types.permissions import Permissions
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CreateRoleRequest(UncheckedBaseModel):
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique short name for this Role (lowercase [a-z0-9_-], can be used in URLs). Also used for case insensitive duplicate name detection and default sort order. Defaults to RoleId if both name and fullname are not specified.
    """

    fullname: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human friendly display name for this Role, will auto-generate 'name' field (if 'name' is not specified). Defaults to the same value as the 'name' field if not specified.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the resources included in the role and permissions granted on those resources. Includes details of when to use this role along with the intended personas.
    """

    resources: typing.Optional[Resources] = pydantic.Field(default=None)
    """
    Selects the resources the permission set applies to.
    """

    permission_set: Permissions = pydantic.Field()
    """
    Permission set for this role.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
