# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import datetime as dt
import pydantic
from ...account_base.types.account_id import AccountId
import typing
from ...accounts.types.account import Account
from ...integration_base.types.integration_id import IntegrationId
from ...integrations.types.integration import Integration
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Status(UncheckedBaseModel):
    """
    Status object
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Time object was originally created
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Last time object was updated
    """

    account_id: AccountId = pydantic.Field()
    """
    Account associated with this status. Use the expand=accounts parameter with the List API to expand the Account to the full object
    """

    account: typing.Optional[Account] = pydantic.Field(default=None)
    """
    When using the expand option on the List API, the full account object is included in the response
    """

    integration_id: IntegrationId = pydantic.Field()
    """
    Integration associated with this status. Use the expand=integrations parameter with the List API to expand the Integration to the full object
    """

    integration: typing.Optional[Integration] = pydantic.Field(default=None)
    """
    When using the expand option on the List API, the full integration object is included in the response
    """

    status: str = pydantic.Field()
    """
    The current status of the notification.
    """

    requests: int = pydantic.Field()
    """
    Request count
    """

    failed: int = pydantic.Field()
    """
    Failed count
    """

    cpu_time: int = pydantic.Field()
    """
    Cpu time in microseconds
    """

    db_ops: int = pydantic.Field()
    """
    Database operations count
    """

    api_ops: int = pydantic.Field()
    """
    API operations count
    """

    in_bytes: int = pydantic.Field()
    """
    API input byte count
    """

    out_bytes: int = pydantic.Field()
    """
    API output byte count
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
