"""
# AvalonPasm.py - Main Loader For Avalon Python Assembly Library
NOTE: This is the original main loader name
"""
# --- AUTO-GENERATED IntelliSense stubs ---
def APasmEnv(*args, **kwargs): ...
def QEMU(*args, **kwargs): ...
def BIOSCALL(*args, **kwargs): ...
def BIOSCALL_10h(*args, **kwargs): ...
def BIOSCALL_13h(*args, **kwargs): ...
def BIOSCALL_14h(*args, **kwargs): ...
def BIOSCALL_15h(*args, **kwargs): ...
def BIOSCALL_16h(*args, **kwargs): ...
def BIOSCALL_17h(*args, **kwargs): ...
def BIOSCALL_18h(*args, **kwargs): ...
def BIOSCALL_19h(*args, **kwargs): ...
def BIOSCALL_1Ah(*args, **kwargs): ...
def BIOSCALL_12h(*args, **kwargs): ...
UINT_RANGES: dict | None = None
SINT_RANGES: dict | None = None
def UINT(*args, **kwargs): ...
def SINT(*args, **kwargs): ...
def UINT8(*args, **kwargs): ...
def UINT16(*args, **kwargs): ...
def UINT32(*args, **kwargs): ...
def UINT64(*args, **kwargs): ...
def SINT8(*args, **kwargs): ...
def SINT16(*args, **kwargs): ...
def SINT32(*args, **kwargs): ...
def SINT64(*args, **kwargs): ...
mod: dict | None = None
def modrm(*args, **kwargs): ...
org: int | None = None
currentmem: int | None = None
RM: dict | None = None
def adc_rm8_r8(*args, **kwargs): ...
def adc_rm16_r16(*args, **kwargs): ...
def adc_rm32_r32(*args, **kwargs): ...
def adc_rm64_r64(*args, **kwargs): ...
def add_m8r8(*args, **kwargs): ...
def add_m16_32r16_32(*args, **kwargs): ...
def add_r8_m8(*args, **kwargs): ...
def add_r16_32_m16_32(*args, **kwargs): ...
def add_al_imm8(*args, **kwargs): ...
def add_eAX_imm16_32(*args, **kwargs): ...
def cli(*args, **kwargs): ...
def hlt(*args, **kwargs): ...
def jmp(*args, **kwargs): ...
mov_rm8_r8: int | None = None
mov_r8_rm8: int | None = None
mov_rm16_r16: int | None = None
mov_r16_rm16: int | None = None
mov_rm32_r32: int | None = None
mov_r32_rm32: int | None = None
mov_rm64_r64: int | None = None
mov_r64_rm64: int | None = None
mov_rm8_imm8: int | None = None
mov_rm16_imm16: int | None = None
mov_rm32_imm32: int | None = None
mov_rm64_imm32: int | None = None
mov_r8_imm8_base: int | None = None
mov_r16_imm16_base: int | None = None
mov_r32_imm32_base: int | None = None
mov_r64_imm64_base: int | None = None
def MOV_SR(*args, **kwargs): ...
def MOV_imm(*args, **kwargs): ...
reg8: dict | None = None
reg8_64: dict | None = None
reg16: dict | None = None
reg32: dict | None = None
reg64: dict | None = None
def or_rm8_r8(*args, **kwargs): ...
def or_rm16_32_r16_32(*args, **kwargs): ...
def or_rm8_r8m8(*args, **kwargs): ...
def or_rm16_32_rm16_32(*args, **kwargs): ...
def or_AL_imm8(*args, **kwargs): ...
def or_eAX_imm16_32(*args, **kwargs): ...
seg: dict | None = None
seg_reg_val: dict | None = None
lock_prefix: int | None = None
rep_prefix: int | None = None
repne_prefix: int | None = None
opsize_prefix: int | None = None
addrsize_prefix: int | None = None
def segment(*args, **kwargs): ...
def rex(*args, **kwargs): ...
def override_seg_reg(*args, **kwargs): ...
def pusha(*args, **kwargs): ...
def pushad(*args, **kwargs): ...
def pusha_in_32bit(*args, **kwargs): ...
def pushad_in_16bit(*args, **kwargs): ...
def push_es(*args, **kwargs): ...
def pop_es(*args, **kwargs): ...
def push_cs(*args, **kwargs): ...
def push_ss(*args, **kwargs): ...
def pop_ss(*args, **kwargs): ...
def push_ds(*args, **kwargs): ...
def pop_ds(*args, **kwargs): ...
def sbb_al_imm8(*args, **kwargs): ...
def sbb_ax_imm16(*args, **kwargs): ...
def sbb_eax_imm32(*args, **kwargs): ...
def sbb_rax_imm32(*args, **kwargs): ...
def data_signature(*args, **kwargs): ...
def TBytes(*args, **kwargs): ...
def BootPad(*args, **kwargs): ...
def Compile(*args, **kwargs): ...
# --------------------------------------

# --- IntelliSense stubs for VS Code ---
mov_rm8_r8:             int | None = None
mov_r8_rm8:             int | None = None

mov_rm16_r16:           int | None = None
mov_r16_rm16:           int | None = None

mov_rm32_r32:           int | None = None
mov_r32_rm32:           int | None = None

mov_rm64_r64:           int | None = None
mov_r64_rm64:           int | None = None

mov_r8_imm8_base:       int | None = None
mov_r16_imm16_base:     int | None = None
mov_r32_imm32_base:     int | None = None
mov_r64_imm64_base:     int | None = None

reg8:   dict | None = None
reg16:  dict | None = None
reg32:  dict | None = None
reg64:  dict | None = None

def UINT8(value: int) -> bytes: ...
def UINT16(value: int) -> bytes: ...
def UINT32(value: int) -> bytes: ...
def MOV_imm(reg_name: str, value: int) -> bytes: ...
# --------------------------------------

# -- unimportable ----------------------

from APasm_ROOT.classes.enev import APasmEnv
from APasm_ROOT.classes.QEMU import QEMU

# --------------------------------------

import importlib.util
import os
import sys

def import_all_from_folder(folder_path, package_name):
    """Dynamically import all Python files in a folder into globals."""
    for filename in os.listdir(folder_path):
        if filename.endswith(".py") and not filename.startswith("__"):
            file_path = os.path.join(folder_path, filename)
            module_name = f"{package_name}.{filename[:-3]}"
            spec = importlib.util.spec_from_file_location(module_name, file_path)
            module = importlib.util.module_from_spec(spec)
            spec.loader.exec_module(module)
            # Put all module attributes in global namespace
            globals().update({k: v for k, v in vars(module).items() if not k.startswith("_")})

# Auto-load instruction and definition modules
import_all_from_folder("APasm_ROOT/instruction", "APasm_ROOT.instruction")
import_all_from_folder("APasm_ROOT/definitions", "APasm_ROOT.definitions")
import_all_from_folder("APasm_ROOT/utils", "APasm_ROOT.utils")
import_all_from_folder("APasm_ROOT/classes", "APasm_ROOT.classes")
import_all_from_folder("APasm_ROOT/OS", "APasm_ROOT.OS")


