(self.webpackChunksage_agent=self.webpackChunksage_agent||[]).push([[951],{139:e=>{"use strict";e.exports="You are a world leading expert data scientist and quantitaive analyst tasked with **pair-programming data analysis within a Jupyter Notebooks**. You excel in working closely with the USER on tasks related to **data exploration, analysis, visualization, hypothesis testing, and summarization**. Your approach is precise, incremental, and collaborative.\n\n## Important Rules:\n\n* **Always confirm with the user frequently**, especially before executing significant steps or after every 3-5 steps.\n* **Never repeat the entire workflow unnecessarily**, especially after interruptions. If interrupted, clearly ask the user where to resume.\n* **Limit tool calls**: Bundle related dataset and code searches into minimal calls.\n* **Craft precise, descriptive queries** for dataset and code searches—avoid overly broad or vague single-word queries.\n* **Maintain momentum** by continuing to the next task immediately after completing the current one, unless user input is required.\n* **Do not create a plan if the plan would have under 3/4 steps**\n\n## Tool Calling\nFollow these instructions precisely:\n\n* **Explain clearly** before every tool call **why you're using it and what you expect**.\n* **Bundle searches efficiently** into one comprehensive query, not multiple single-word queries.\n* Tools are for your internal use only; **do not call tools from inside code cells**.\n* **Stop after every 3-5 tool calls** to ask the user explicitly if they wish to proceed further or adjust your approach.\n\n---\n\n## Workflow\n\n### Understand the Task:\n\n* Quickly read relevant notebook summary and recent context. Do **not** review the entire notebook unnecessarily.\n* Determine if this is a new or continuing task clearly.\n* Before any tool usage, explicitly ask the user if it's appropriate to perform searches or move ahead.\n\n### Plan your Approach (If the task is complex enough):\n\n* **Check for existing plan** in the first cell of the notebook. If a plan exists, review it and continue from where it left off.\n* **Create plans only when user's request demands it** using `edit_plan` tool\n* **Structure**: `# [Task Name] Plan` with `- [ ] Task description` format\n* **Present plan for user approval** before execution - ALWAYS ask \"Should I proceed with this plan?\". Immediately use `wait_user_reply` tool\n* **Update progress IMMEDIATELY** after each task: mark `[x]` for completed tasks, update current/next steps\n* **Continue incrementally** to next task unless unclear or user input required\n* **Use `wait_user_reply` tool** when you need to pause, ask and wait for user input or confirmation\n\n## Workflow\n\n### Understand the Task:\n\n* Quickly read relevant notebook summary and recent context. Do **not** review the entire notebook unnecessarily.\n* Determine if this is a new or continuing task clearly.\n* Before any tool usage, explicitly ask the user if it's appropriate to perform searches or move ahead.\n\n### Execute Incrementally:\n\n* Write concise code cells (ideally <30 lines). **Execute frequently** to verify correctness.\n* Fix errors directly within the existing cell—do not create new cells to debug.\n* Describe each code cell's purpose clearly and succinctly in Markdown.\n* **Update the plan** after completing each step by marking tasks as complete and updating current/next steps.\n* **Check off completed tasks** in the plan using `[x]` format.\n* **Ask for confirmation** before making significant changes to the plan based on new findings.\n* **Continue immediately** to the next task after completing the current one - maintain momentum.\n* **Only pause** when the next step is unclear or requires user input.\n\n### Dataset Handling:\n\n* Search datasets only if necessary. Clearly state the exact dataset you are seeking.\n* Load from local files; do **not** embed URLs in cells.\n\n### Codebase Handling:\n\n* Write precise, descriptive queries that match your exact code requirements.\n* Avoid unnecessary or redundant code searches.\n\n### Final Outputs:\n\n* **Complete the plan** by marking all tasks as finished and adding a completion summary.\n* Provide a succinct Markdown summary of your analysis outcomes.\n* **Update the plan** with final results and any recommendations for next steps.\n* Explicitly ask the user if they want to continue, refine further, or stop.\n\n### Error and Interruption Management:\n\n* On interruption or error, **check the current plan** to understand where you left off.\n* Clearly summarize the current state and ask the user explicitly how to proceed.\n* **Update the plan** to reflect any changes in approach or new requirements discovered during execution.\n* Never restart from scratch without user consent—always pick up exactly where you left off using the plan as a guide.\n\n---\n\n## Summarization\nClearly summarize every executed code cell, including:\n- Purpose and intent of the cell.\n- Libraries used, defined functions, and key variables.\n- Explanation of computed, visualized, or transformed data.\n\n## Waiting for User Input\nWhen you need to ask the user a question or need them to confirm an action, you MUST use the `wait_user_reply` tool. This pauses your work and signals to the user that their input is required.\n1.  **First, send a message** containing your question or the information you want the user to review.\n2.  **Immediately after**, call the `wait_user_reply` tool.\n"},1384:e=>{"use strict";e.exports="You are an expert data scientist working in Jupyter Notebooks. Your job is to execute the exact task requested using only the cells provided in context.\n\n## Core Rules:\n* **Work only on provided cells** - do not edit cells outside of context\n* **Do exactly what's asked** - nothing more, nothing less\n* **Limit to 5 tool calls** before asking to continue\n\n## Execution:\n* Write concise code (<30 lines per cell) in each cell\n* Execute frequently to verify correctness\n* Fix errors in the same cell. Do not create new cells to debug errors.\n* Continue immediately to next task unless unclear\n\n## Tool Calling\nYou have tools available to complete tasks.\n* Provide tool arguments precisely.\n* Tools are for your internal use only; **do not call tools from \ninside code cells**.\n* **Stop after every 3-5 tool calls** to ask the user explicitly \nif they wish to proceed further or adjust your approach.\n\n## Summarization\n- For each cell provide a complete, detailed summary of the cell, including variables, operation, and goal.\n- After the task is done, write a summary of what you added, removed and changed.\n\n\n## Output:\nFor each executed cell, briefly state:\n- What it does\n- Key results/outputs\n"},2915:e=>{"use strict";e.exports=JSON.parse('{"claude":{"model_name":"claude-sonnet-4-20250514","tool_blacklist":[]},"claude_ask_mode":{"model_name":"claude-sonnet-4-20250514","tool_blacklist":[]},"edit_selection":{"model_name":"claude-3-5-haiku-latest","tool_blacklist":["codebase-list_repos","notebook-add_cell","notebook-remove_cells","notebook-edit_plan","notebook-run_cell","notebook-get_cell_info","notebook-read_cells","web-search_dataset","web-download_dataset","filesystem-list_datasets","filesystem-read_dataset","filesystem-delete_dataset","filesystem-save_dataset","notebook-wait_user_reply"]},"edit_full_cell":{"model_name":"claude-3-5-haiku-latest","tool_blacklist":["codebase-list_repos","notebook-add_cell","notebook-remove_cells","notebook-edit_plan","notebook-run_cell","notebook-get_cell_info","notebook-read_cells","web-search_dataset","web-download_dataset","filesystem-list_datasets","filesystem-read_dataset","filesystem-delete_dataset","filesystem-save_dataset","notebook-wait_user_reply"]},"fast_mode":{"model_name":"claude-sonnet-4-20250514","tool_blacklist":["codebase-list_repos","notebook-edit_plan","notebook-get_cell_info","notebook-read_cells","web-search_dataset","web-download_dataset","filesystem-read_dataset","filesystem-list_datasets","filesystem-delete_dataset","notebook-read_notebook_summary","notebook-wait_user_reply"]}}')},3545:e=>{"use strict";e.exports={api_key:null}},3687:(e,t,o)=>{var n={"./claude_system_prompt.md":139,"./claude_system_prompt_ask_mode.md":8051,"./claude_system_prompt_edit_full_cell.md":8883,"./claude_system_prompt_edit_selection.md":5707,"./claude_system_prompt_fast_mode.md":1384};function s(e){var t=i(e);return o(t)}function i(e){if(!o.o(n,e)){var t=new Error("Cannot find module '"+e+"'");throw t.code="MODULE_NOT_FOUND",t}return n[e]}s.keys=function(){return Object.keys(n)},s.resolve=i,e.exports=s,s.id=3687},5707:e=>{"use strict";e.exports='You are an expert quantitative researcher and data scientist embedded inside a Jupyter notebook environment. You serve as a **selection-level editing assistant**—executing **precise, minimal code edits** on selected portions only.\n\n## Primary Directive\n\n**Return a structured JSON response specifying line-by-line operations. Each line in the selection range must have an explicit operation.**\n\n---\n\n## Rules of Execution\n\n* **Follow User Commands Exactly**: Obey user instructions fully. Do **not** do more than asked. Do not infer or hallucinate missing context, libraries, variables, or data.\n* **Edit Only Selected Code**: Modify only the specific code selection provided. Leave all other cell content unchanged.\n* **Be Context-Aware**: Respect notebook context if available. Don\'t break dependencies or change variable semantics.\n* **Style and Performance**: Prioritize vectorization and correct use of libraries like NumPy, Pandas, Scikit-learn, PyTorch, etc. Make professional plots.\n* **Preserve All Formatting and Nuance**: Do not alter whitespace, indentation, empty lines, or formatting unless explicitly instructed. Every character, space, and line break must remain exactly as in the original selection unless the user requests a change.\n* **Quantitative Style, Not Software Engineering**: Write code like a top-tier quant or data scientist. Favor clarity, elegance, and performance. Avoid overengineering.\n* **No Tool Calls, No Outputs, No Commentary**: Never invoke tools. Never provide any commentary or explanation besides the structured response.\n* **Always Provide Executable Code**: Do not use Markdown formatting, including headers, bold, italic, bullet points, or code blocks.\n\n---\n\n## Output Format\n\n**Return ONLY a JSON object with this exact structure:**\n\n{\n  "operations": [\n    {\n      "line": 1,\n      "action": "KEEP|MODIFY|REMOVE|INSERT",\n      "content": "line content (required for MODIFY/INSERT, empty for KEEP/REMOVE)"\n    }\n  ]\n}\n\n\n### Action Types:\n- **KEEP**: Preserve the original line exactly as-is\n- **MODIFY**: Replace the line with new content\n- **REMOVE**: Delete this line entirely\n- **INSERT**: Add a new line at this position (pushes existing lines down)\n'},5951:(e,t,o)=>{"use strict";var n,s;o.r(t),o.d(t,{ChatBoxWidget:()=>Pe,ChatRequestStatus:()=>n,DiffApprovalStatus:()=>s,NotebookDiffManager:()=>qe,default:()=>pt}),function(e){e.IDLE="idle",e.PENDING="pending",e.COMPLETED="completed",e.ERROR="error",e.CANCELLED="cancelled",e.RETRYING="retrying"}(n||(n={})),function(e){e.PENDING="pending",e.APPROVED="approved",e.REJECTED="rejected",e.PARTIAL="partial"}(s||(s={}));var i=o(3550);const a={"codebase-list_repos":"Sage is listing repos...","notebook-wait_user_reply":"","notebook-edit_plan":"Sage is updating the plan...","notebook-add_cell":"Sage is adding a new cell...","notebook-edit_cell":"Sage is editing a cell...","notebook-get_cell_info":"Sage is getting cell info...","notebook-remove_cells":"Sage is removing cell...","notebook-run_cell":"Sage is running a cell...","notebook-read_cells":"Sage is reading cell...","filesystem-delete_dataset":"Sage is deleting dataset...","filesystem-list_datasets":"Sage is listing datasets...","filesystem-save_dataset":e=>e.filepath?`Sage is saving dataset ${r(e.filepath,!0)}...`:"Sage is saving dataset...","filesystem-read_dataset":e=>e.filepath?`Sage is reading dataset ${r(e.filepath,!0)}...`:"Sage is reading dataset...","web-download_dataset":e=>{var t;const o=e.tickers&&(null===(t=e.tickers)||void 0===t?void 0:t.length);return o&&e.period&&e.interval?`Sage is downloading ${e.tickers.map(r).join(", ")} dataset in the web for the period of ${r(e.period)} and interval of ${r(e.interval)}...`:o&&e.period?`Sage is downloading ${e.tickers.map(r).join(", ")} dataset in the web for the period of ${r(e.period)}...`:o&&e.interval?`Sage is downloading ${e.tickers.map(r).join(", ")} dataset in the web for the interval of ${r(e.interval)}...`:o?`Sage is downloading ${e.tickers.map(r).join(", ")} dataset in the web...`:"Sage is downloading dataset in the web..."},"web-search_dataset":e=>e.queries&&0!==e.queries.length?`Sage is searching for ${e.queries.map(r).join(", ")} dataset in the web...`:"Sage is searching for dataset in the web..."},r=(e,t=!1)=>e?t?`<code class="sage-ai-filepath">${l(e)}</code>`:`<code>${e}</code>`:"",l=e=>{const t=e.split(/[/\\]/);return t.length<=3?e:`.../${t.slice(-2).join("/")}`},c="var(--jp-ui-font-color1)",d={"codebase-list_repos":`<svg width="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M13.2686 14.2686L15 16M12.0627 6.06274L11.9373 5.93726C11.5914 5.59135 11.4184 5.4184 11.2166 5.29472C11.0376 5.18506 10.8425 5.10425 10.6385 5.05526C10.4083 5 10.1637 5 9.67452 5H6.2C5.0799 5 4.51984 5 4.09202 5.21799C3.71569 5.40973 3.40973 5.71569 3.21799 6.09202C3 6.51984 3 7.07989 3 8.2V15.8C3 16.9201 3 17.4802 3.21799 17.908C3.40973 18.2843 3.71569 18.5903 4.09202 18.782C4.51984 19 5.07989 19 6.2 19H17.8C18.9201 19 19.4802 19 19.908 18.782C20.2843 18.5903 20.5903 18.2843 20.782 17.908C21 17.4802 21 16.9201 21 15.8V10.2C21 9.0799 21 8.51984 20.782 8.09202C20.5903 7.71569 20.2843 7.40973 19.908 7.21799C19.4802 7 18.9201 7 17.8 7H14.3255C13.8363 7 13.5917 7 13.3615 6.94474C13.1575 6.89575 12.9624 6.81494 12.7834 6.70528C12.5816 6.5816 12.4086 6.40865 12.0627 6.06274ZM14 12.5C14 13.8807 12.8807 15 11.5 15C10.1193 15 9 13.8807 9 12.5C9 11.1193 10.1193 10 11.5 10C12.8807 10 14 11.1193 14 12.5Z" stroke="${c}" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>`,"notebook-wait_user_reply":"","notebook-edit_plan":`<svg width="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M19.9994 19.2611H10.9294C10.4794 19.2611 10.1094 18.8911 10.1094 18.4411C10.1094 17.9911 10.4794 17.6211 10.9294 17.6211H19.9994C20.4494 17.6211 20.8194 17.9911 20.8194 18.4411C20.8194 18.9011 20.4494 19.2611 19.9994 19.2611Z" fill="${c}"></path> <path d="M19.9994 12.9681H10.9294C10.4794 12.9681 10.1094 12.5981 10.1094 12.1481C10.1094 11.6981 10.4794 11.3281 10.9294 11.3281H19.9994C20.4494 11.3281 20.8194 11.6981 20.8194 12.1481C20.8194 12.5981 20.4494 12.9681 19.9994 12.9681Z" fill="${c}"></path> <path d="M19.9994 6.67125H10.9294C10.4794 6.67125 10.1094 6.30125 10.1094 5.85125C10.1094 5.40125 10.4794 5.03125 10.9294 5.03125H19.9994C20.4494 5.03125 20.8194 5.40125 20.8194 5.85125C20.8194 6.30125 20.4494 6.67125 19.9994 6.67125Z" fill="${c}"></path> <path d="M4.90969 8.03187C4.68969 8.03187 4.47969 7.94187 4.32969 7.79187L3.41969 6.88188C3.09969 6.56188 3.09969 6.04187 3.41969 5.72187C3.73969 5.40187 4.25969 5.40187 4.57969 5.72187L4.90969 6.05188L7.04969 3.91187C7.36969 3.59188 7.88969 3.59188 8.20969 3.91187C8.52969 4.23188 8.52969 4.75188 8.20969 5.07188L5.48969 7.79187C5.32969 7.94187 5.12969 8.03187 4.90969 8.03187Z" fill="${c}"></path> <path d="M4.90969 14.3287C4.69969 14.3287 4.48969 14.2487 4.32969 14.0887L3.41969 13.1788C3.09969 12.8588 3.09969 12.3388 3.41969 12.0188C3.73969 11.6988 4.25969 11.6988 4.57969 12.0188L4.90969 12.3488L7.04969 10.2087C7.36969 9.88875 7.88969 9.88875 8.20969 10.2087C8.52969 10.5288 8.52969 11.0487 8.20969 11.3687L5.48969 14.0887C5.32969 14.2487 5.11969 14.3287 4.90969 14.3287Z" fill="${c}"></path> <path d="M4.90969 20.3288C4.69969 20.3288 4.48969 20.2488 4.32969 20.0888L3.41969 19.1788C3.09969 18.8588 3.09969 18.3388 3.41969 18.0188C3.73969 17.6988 4.25969 17.6988 4.57969 18.0188L4.90969 18.3488L7.04969 16.2087C7.36969 15.8888 7.88969 15.8888 8.20969 16.2087C8.52969 16.5288 8.52969 17.0488 8.20969 17.3688L5.48969 20.0888C5.32969 20.2488 5.11969 20.3288 4.90969 20.3288Z" fill="${c}"></path> </g></svg>`,"notebook-edit_cell":`<svg width="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M18.3785 8.44975L11.4637 15.3647C11.1845 15.6439 10.8289 15.8342 10.4417 15.9117L7.49994 16.5L8.08829 13.5582C8.16572 13.1711 8.35603 12.8155 8.63522 12.5363L15.5501 5.62132M18.3785 8.44975L19.7927 7.03553C20.1832 6.64501 20.1832 6.01184 19.7927 5.62132L18.3785 4.20711C17.988 3.81658 17.3548 3.81658 16.9643 4.20711L15.5501 5.62132M18.3785 8.44975L15.5501 5.62132" stroke="${c}" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M5 20H19" stroke="${c}" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>`,"notebook-remove_cells":`<svg fill="${c}" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="20" height="20" viewBox="0 0 48 48"><path d="M 24 4 C 20.491685 4 17.570396 6.6214322 17.080078 10 L 10.238281 10 A 1.50015 1.50015 0 0 0 9.9804688 9.9785156 A 1.50015 1.50015 0 0 0 9.7578125 10 L 6.5 10 A 1.50015 1.50015 0 1 0 6.5 13 L 8.6386719 13 L 11.15625 39.029297 C 11.427329 41.835926 13.811782 44 16.630859 44 L 31.367188 44 C 34.186411 44 36.570826 41.836168 36.841797 39.029297 L 39.361328 13 L 41.5 13 A 1.50015 1.50015 0 1 0 41.5 10 L 38.244141 10 A 1.50015 1.50015 0 0 0 37.763672 10 L 30.919922 10 C 30.429604 6.6214322 27.508315 4 24 4 z M 24 7 C 25.879156 7 27.420767 8.2681608 27.861328 10 L 20.138672 10 C 20.579233 8.2681608 22.120844 7 24 7 z M 11.650391 13 L 36.347656 13 L 33.855469 38.740234 C 33.730439 40.035363 32.667963 41 31.367188 41 L 16.630859 41 C 15.331937 41 14.267499 40.033606 14.142578 38.740234 L 11.650391 13 z M 20.476562 17.978516 A 1.50015 1.50015 0 0 0 19 19.5 L 19 34.5 A 1.50015 1.50015 0 1 0 22 34.5 L 22 19.5 A 1.50015 1.50015 0 0 0 20.476562 17.978516 z M 27.476562 17.978516 A 1.50015 1.50015 0 0 0 26 19.5 L 26 34.5 A 1.50015 1.50015 0 1 0 29 34.5 L 29 19.5 A 1.50015 1.50015 0 0 0 27.476562 17.978516 z"></path></svg>`,"notebook-run_cell":`<svg fill="${c}" width="20px" viewBox="0 0 32 32" id="icon" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><defs><style>.cls-1{fill:none;}</style></defs><title>run</title><path d="M21,16a6,6,0,1,1-6,6,6,6,0,0,1,6-6m0-2a8,8,0,1,0,8,8,8,8,0,0,0-8-8Z"></path><path d="M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2h4V26H6V12H28V6A2,2,0,0,0,26,4ZM6,10V6H26v4Z"></path><polygon points="19 19 19 25 24 22 19 19"></polygon><rect id="_Transparent_Rectangle_" data-name="<Transparent Rectangle>" class="cls-1" width="32" height="32"></rect></g></svg>`,"filesystem-delete_dataset":`<svg width="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M17 17L21 21M21 17L17 21M13 3H8.2C7.0799 3 6.51984 3 6.09202 3.21799C5.71569 3.40973 5.40973 3.71569 5.21799 4.09202C5 4.51984 5 5.0799 5 6.2V17.8C5 18.9201 5 19.4802 5.21799 19.908C5.40973 20.2843 5.71569 20.5903 6.09202 20.782C6.51984 21 7.0799 21 8.2 21H13M13 3L19 9M13 3V7.4C13 7.96005 13 8.24008 13.109 8.45399C13.2049 8.64215 13.3578 8.79513 13.546 8.89101C13.7599 9 14.0399 9 14.6 9H19M19 9V14" stroke="${c}" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>`,"filesystem-read_dataset":`<svg width="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M13 3H8.2C7.0799 3 6.51984 3 6.09202 3.21799C5.71569 3.40973 5.40973 3.71569 5.21799 4.09202C5 4.51984 5 5.0799 5 6.2V17.8C5 18.9201 5 19.4802 5.21799 19.908C5.40973 20.2843 5.71569 20.5903 6.09202 20.782C6.51984 21 7.0799 21 8.2 21H12M13 3L19 9M13 3V7.4C13 7.96005 13 8.24008 13.109 8.45399C13.2049 8.64215 13.3578 8.79513 13.546 8.89101C13.7599 9 14.0399 9 14.6 9H19M19 9V11M9 17H11M9 13H13M9 9H10M19.2686 19.2686L21 21M20 17.5C20 18.8807 18.8807 20 17.5 20C16.1193 20 15 18.8807 15 17.5C15 16.1193 16.1193 15 17.5 15C18.8807 15 20 16.1193 20 17.5Z" stroke="${c}" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>`,"filesystem-list_datasets":`<svg width="20px" height="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M15 3V6.4C15 6.96005 15 7.24008 15.109 7.45399C15.2049 7.64215 15.3578 7.79513 15.546 7.89101C15.7599 8 16.0399 8 16.6 8H20M10 8H6C4.89543 8 4 8.89543 4 10V19C4 20.1046 4.89543 21 6 21H12C13.1046 21 14 20.1046 14 19V16M16 3H13.2C12.0799 3 11.5198 3 11.092 3.21799C10.7157 3.40973 10.4097 3.71569 10.218 4.09202C10 4.51984 10 5.0799 10 6.2V12.8C10 13.9201 10 14.4802 10.218 14.908C10.4097 15.2843 10.7157 15.5903 11.092 15.782C11.5198 16 12.0799 16 13.2 16H16.8C17.9201 16 18.4802 16 18.908 15.782C19.2843 15.5903 19.5903 15.2843 19.782 14.908C20 14.4802 20 13.9201 20 12.8V7L16 3Z" stroke="${c}" stroke-width="2" stroke-linejoin="round"></path> </g></svg>`,"filesystem-save_dataset":`<svg width="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M17 21V13H7V21M7 3V8H15M19 21H5C4.46957 21 3.96086 20.7893 3.58579 20.4142C3.21071 20.0391 3 19.5304 3 19V5C3 4.46957 3.21071 3.96086 3.58579 3.58579C3.96086 3.21071 4.46957 3 5 3H16L21 8V19C21 19.5304 20.7893 20.0391 20.4142 20.4142C20.0391 20.7893 19.5304 21 19 21Z" stroke="${c}" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>`,"web-download_dataset":`<svg width="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path fill-rule="evenodd" clip-rule="evenodd" d="M8 10C8 7.79086 9.79086 6 12 6C14.2091 6 16 7.79086 16 10V11H17C18.933 11 20.5 12.567 20.5 14.5C20.5 16.433 18.933 18 17 18H16.9C16.3477 18 15.9 18.4477 15.9 19C15.9 19.5523 16.3477 20 16.9 20H17C20.0376 20 22.5 17.5376 22.5 14.5C22.5 11.7793 20.5245 9.51997 17.9296 9.07824C17.4862 6.20213 15.0003 4 12 4C8.99974 4 6.51381 6.20213 6.07036 9.07824C3.47551 9.51997 1.5 11.7793 1.5 14.5C1.5 17.5376 3.96243 20 7 20H7.1C7.65228 20 8.1 19.5523 8.1 19C8.1 18.4477 7.65228 18 7.1 18H7C5.067 18 3.5 16.433 3.5 14.5C3.5 12.567 5.067 11 7 11H8V10ZM13 11C13 10.4477 12.5523 10 12 10C11.4477 10 11 10.4477 11 11V16.5858L9.70711 15.2929C9.31658 14.9024 8.68342 14.9024 8.29289 15.2929C7.90237 15.6834 7.90237 16.3166 8.29289 16.7071L11.2929 19.7071C11.6834 20.0976 12.3166 20.0976 12.7071 19.7071L15.7071 16.7071C16.0976 16.3166 16.0976 15.6834 15.7071 15.2929C15.3166 14.9024 14.6834 14.9024 14.2929 15.2929L13 16.5858V11Z" fill="${c}"></path> </g></svg>`,"web-search_dataset":`<svg width="20px" height="20px" viewBox="-0.5 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M22 11.8201C22 9.84228 21.4135 7.90885 20.3147 6.26436C19.2159 4.61987 17.6542 3.33813 15.8269 2.58126C13.9996 1.82438 11.9889 1.62637 10.0491 2.01223C8.10927 2.39808 6.32748 3.35052 4.92896 4.74904C3.53043 6.14757 2.578 7.92935 2.19214 9.86916C1.80629 11.809 2.00436 13.8197 2.76123 15.6469C3.51811 17.4742 4.79985 19.036 6.44434 20.1348C8.08883 21.2336 10.0222 21.8201 12 21.8201" stroke="${c}" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M2 11.8201H22" stroke="${c}" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M12 21.8201C10.07 21.8201 8.5 17.3401 8.5 11.8201C8.5 6.30007 10.07 1.82007 12 1.82007C13.93 1.82007 15.5 6.30007 15.5 11.8201" stroke="${c}" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M18.3691 21.6901C20.3021 21.6901 21.8691 20.1231 21.8691 18.1901C21.8691 16.2571 20.3021 14.6901 18.3691 14.6901C16.4361 14.6901 14.8691 16.2571 14.8691 18.1901C14.8691 20.1231 16.4361 21.6901 18.3691 21.6901Z" stroke="${c}" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M22.9998 22.8202L20.8398 20.6702" stroke="${c}" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>`,"notebook-add_cell":`<svg width="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M3 10V18C3 19.1046 3.89543 20 5 20H11M3 10V6C3 4.89543 3.89543 4 5 4H19C20.1046 4 21 4.89543 21 6V10M3 10H21M21 10V13" stroke="${c}" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M17 14V17M17 20V17M17 17H14M17 17H20" stroke="${c}" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> <circle cx="6" cy="7" r="1" fill="${c}"></circle> <circle cx="9" cy="7" r="1" fill="${c}"></circle> </g></svg>`,"notebook-read_cells":`<svg width="20px" height="20px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" fill="${c}"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <rect x="0" fill="none" width="24" height="24"></rect> <g> <path d="M9 12h6v-2H9zm-7 0h5v-2H2zm15 0h5v-2h-5zm3 2v2l-6 6H6a2 2 0 0 1-2-2v-6h2v6h6v-4a2 2 0 0 1 2-2h6zM4 8V4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v4h-2V4H6v4z"></path> </g> </g></svg>`,"notebook-get_cell_info":`<svg fill="${c}" width="20px" height="20px" viewBox="0 0 24 24" id="check-double" data-name="Flat Line" xmlns="http://www.w3.org/2000/svg" class="icon flat-line"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><line id="primary" x1="13.22" y1="16.5" x2="21" y2="7.5" style="fill: none; stroke: var(--jp-ui-font-color1); stroke-linecap: round; stroke-linejoin: round; stroke-width: 2;"></line><polyline id="primary-2" data-name="primary" points="3 11.88 7 16.5 14.78 7.5" style="fill: none; stroke: var(--jp-ui-font-color1); stroke-linecap: round; stroke-linejoin: round; stroke-width: 2;"></polyline></g></svg>`},h=`\n  <svg fill="${c}" width="14px" height="14px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">\n  <title></title><g data-name="Layer 2" id="Layer_2">\n  <path d="M18,11a1,1,0,0,1-1,1,5,5,0,0,0-5,5,1,1,0,0,1-2,0,5,5,0,0,0-5-5,1,1,0,0,1,0-2,5,5,0,0,0,5-5,1,1,0,0,1,2,0,5,5,0,0,0,5,5A1,1,0,0,1,18,11Z"></path>\n  <path d="M19,24a1,1,0,0,1-1,1,2,2,0,0,0-2,2,1,1,0,0,1-2,0,2,2,0,0,0-2-2,1,1,0,0,1,0-2,2,2,0,0,0,2-2,1,1,0,0,1,2,0,2,2,0,0,0,2,2A1,1,0,0,1,19,24Z"></path><path d="M28,17a1,1,0,0,1-1,1,4,4,0,0,0-4,4,1,1,0,0,1-2,0,4,4,0,0,0-4-4,1,1,0,0,1,0-2,4,4,0,0,0,4-4,1,1,0,0,1,2,0,4,4,0,0,0,4,4A1,1,0,0,1,28,17Z"></path></g></svg>\n`,u=`<svg width="20px" height="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M16 12.9V17.1C16 20.6 14.6 22 11.1 22H6.9C3.4 22 2 20.6 2 17.1V12.9C2 9.4 3.4 8 6.9 8H11.1C14.6 8 16 9.4 16 12.9Z" stroke="${c}" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M22 6.9V11.1C22 14.6 20.6 16 17.1 16H16V12.9C16 9.4 14.6 8 11.1 8H8V6.9C8 3.4 9.4 2 12.9 2H17.1C20.6 2 22 3.4 22 6.9Z" stroke="${c}" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>`,g=`<svg width="20px" height="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M17.0998 2H12.8998C9.81668 2 8.37074 3.09409 8.06951 5.73901C8.00649 6.29235 8.46476 6.75 9.02167 6.75H11.0998C15.2998 6.75 17.2498 8.7 17.2498 12.9V14.9781C17.2498 15.535 17.7074 15.9933 18.2608 15.9303C20.9057 15.629 21.9998 14.1831 21.9998 11.1V6.9C21.9998 3.4 20.5998 2 17.0998 2Z" fill="${c}"></path> <path d="M11.1 8H6.9C3.4 8 2 9.4 2 12.9V17.1C2 20.6 3.4 22 6.9 22H11.1C14.6 22 16 20.6 16 17.1V12.9C16 9.4 14.6 8 11.1 8ZM12.29 13.65L8.58 17.36C8.44 17.5 8.26 17.57 8.07 17.57C7.88 17.57 7.7 17.5 7.56 17.36L5.7 15.5C5.42 15.22 5.42 14.77 5.7 14.49C5.98 14.21 6.43 14.21 6.71 14.49L8.06 15.84L11.27 12.63C11.55 12.35 12 12.35 12.28 12.63C12.56 12.91 12.57 13.37 12.29 13.65Z" fill="${c}"></path> </g></svg>`;function p(e,t={}){const o=a[e];return"function"==typeof o?o(t):o||"Sage is working..."}function m(e){return d[e]||h}class f{constructor(e,t,o){this.messageHistory=[],this.userMessages=[],this.lastAddedMessageType=null,this.mentionContexts=new Map,this.container=e,this.historyManager=t,this.notebookTools=o,console.log("[ChatMessages] Initialized with empty message history")}loadFromThread(e){this.container.innerHTML="",this.messageHistory=[...e.messages],this.userMessages=e.messages.filter(e=>"user"===e.role),this.mentionContexts=new Map(e.contexts||new Map),this.lastAddedMessageType=null,this.renderAllMessages(),console.log(`[ChatMessages] Loaded ${e.messages.length} messages from thread`)}async renderAllMessages(){let e=null;for(const t of this.messageHistory)if("user"===t.role)Array.isArray(t.content)&&t.content.length>0&&"object"==typeof t.content[0]&&"tool_result"===t.content[0].type?e&&(this.renderToolResult(t.content[0].tool_name||"tool",t.content[0].content,e),e.results.push(t.content[0])):(e=null,this.renderUserMessage("string"==typeof t.content?t.content:JSON.stringify(t.content)));else if("assistant"===t.role)if(Array.isArray(t.content)&&t.content.length>0&&"object"==typeof t.content[0]&&"tool_use"===t.content[0].type){e={assistant:t,results:[]};for(const e of t.content)"tool_use"===e.type&&this.renderToolCall(e)}else e=null,await this.renderAssistantMessage("string"==typeof t.content?t.content:Array.isArray(t.content)&&"object"==typeof t.content[0]&&t.content[0].text?t.content[0].text:JSON.stringify(t.content));this.removeLoadingText()}removeLoadingText(){this.container.querySelectorAll(".sage-ai-loading-text").forEach(e=>{e.classList.remove("sage-ai-loading-text")})}async renderMarkdown(e){try{return i.marked.setOptions({gfm:!0,breaks:!1}),await i.marked.parse(e)}catch(t){return console.error("Error rendering markdown:",t),this.escapeHtml(e)}}escapeHtml(e){return e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;")}renderUserMessage(e){this.closeToolGroupIfOpen();const t=document.createElement("div");t.className="sage-ai-message sage-ai-user-message";const o=document.createElement("div");o.className="sage-ai-message-content",o.innerHTML=this.escapeHtml(e).replace(/\n/g,"<br>"),t.append(o),this.container.appendChild(t),this.lastAddedMessageType="user"}async renderAssistantMessage(e,t){this.closeToolGroupIfOpen();const o=document.createElement("div");o.className="sage-ai-message sage-ai-ai-message";const n=document.createElement("div");n.className="sage-ai-message-header";const s=document.createElement("div");s.className="sage-ai-message-header-image",s.innerHTML='<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">\n      <path d="M6.6243 10.3334C6.56478 10.1026 6.44453 9.89209 6.27605 9.72361C6.10757 9.55513 5.89702 9.43488 5.6663 9.37536L1.5763 8.32069C1.50652 8.30089 1.44511 8.25886 1.40138 8.20099C1.35765 8.14312 1.33398 8.07256 1.33398 8.00002C1.33398 7.92749 1.35765 7.85693 1.40138 7.79906C1.44511 7.74119 1.50652 7.69916 1.5763 7.67936L5.6663 6.62402C5.89693 6.56456 6.10743 6.44441 6.2759 6.27605C6.44438 6.10769 6.56468 5.89728 6.6243 5.66669L7.67897 1.57669C7.69857 1.50664 7.74056 1.44492 7.79851 1.40095C7.85647 1.35699 7.92722 1.33319 7.99997 1.33319C8.07271 1.33319 8.14346 1.35699 8.20142 1.40095C8.25938 1.44492 8.30136 1.50664 8.32097 1.57669L9.37497 5.66669C9.43449 5.89741 9.55474 6.10796 9.72322 6.27644C9.8917 6.44492 10.1023 6.56517 10.333 6.62469L14.423 7.67869C14.4933 7.69809 14.5553 7.74003 14.5995 7.79808C14.6437 7.85612 14.6677 7.92706 14.6677 8.00002C14.6677 8.07298 14.6437 8.14393 14.5995 8.20197C14.5553 8.26002 14.4933 8.30196 14.423 8.32136L10.333 9.37536C10.1023 9.43488 9.8917 9.55513 9.72322 9.72361C9.55474 9.89209 9.43449 10.1026 9.37497 10.3334L8.3203 14.4234C8.3007 14.4934 8.25871 14.5551 8.20075 14.5991C8.1428 14.6431 8.07205 14.6669 7.9993 14.6669C7.92656 14.6669 7.85581 14.6431 7.79785 14.5991C7.73989 14.5551 7.69791 14.4934 7.6783 14.4234L6.6243 10.3334Z" fill="url(#paint0_linear_445_6567)"/>\n      <path d="M13.333 2V4.66667" stroke="url(#paint1_linear_445_6567)" stroke-width="0.984615" stroke-linecap="round" stroke-linejoin="round"/>\n      <path d="M14.6667 3.33331H12" stroke="url(#paint2_linear_445_6567)" stroke-width="0.984615" stroke-linecap="round" stroke-linejoin="round"/>\n      <path d="M2.66699 11.3333V12.6666" stroke="url(#paint3_linear_445_6567)" stroke-width="0.984615" stroke-linecap="round" stroke-linejoin="round"/>\n      <path d="M3.33333 12H2" stroke="url(#paint4_linear_445_6567)" stroke-width="0.984615" stroke-linecap="round" stroke-linejoin="round"/>\n      <defs>\n      <linearGradient id="paint0_linear_445_6567" x1="1.33398" y1="1.33319" x2="14.6677" y2="14.6669" gradientUnits="userSpaceOnUse">\n      <stop stop-color="#FEC163"/>\n      <stop offset="1" stop-color="#DE4313"/>\n      </linearGradient>\n      <linearGradient id="paint1_linear_445_6567" x1="13.333" y1="2" x2="15.0864" y2="2.65753" gradientUnits="userSpaceOnUse">\n      <stop stop-color="#FEC163"/>\n      <stop offset="1" stop-color="#DE4313"/>\n      </linearGradient>\n      <linearGradient id="paint2_linear_445_6567" x1="12" y1="3.33331" x2="12.6575" y2="5.08674" gradientUnits="userSpaceOnUse">\n      <stop stop-color="#FEC163"/>\n      <stop offset="1" stop-color="#DE4313"/>\n      </linearGradient>\n      <linearGradient id="paint3_linear_445_6567" x1="2.66699" y1="11.3333" x2="3.94699" y2="12.2933" gradientUnits="userSpaceOnUse">\n      <stop stop-color="#FEC163"/>\n      <stop offset="1" stop-color="#DE4313"/>\n      </linearGradient>\n      <linearGradient id="paint4_linear_445_6567" x1="2" y1="12" x2="2.96" y2="13.28" gradientUnits="userSpaceOnUse">\n      <stop stop-color="#FEC163"/>\n      <stop offset="1" stop-color="#DE4313"/>\n      </linearGradient>\n      </defs>\n      </svg>',n.append(s);const i=document.createElement("span");i.className="sage-ai-message-header-title",i.innerText="Sage AI",n.append(i),"user"!==this.lastAddedMessageType&&(n.style.display="none");const a=document.createElement("div");a.className="sage-ai-message-content sage-ai-markdown-content",a.innerHTML=await this.renderMarkdown(e),o.appendChild(n),o.appendChild(a),(null!=t?t:this.container).appendChild(o),this.lastAddedMessageType="normal",this.activateCodeBlocks(a)}activateCodeBlocks(e){e.querySelectorAll("pre code").forEach(e=>{var t;const o=document.createElement("div");o.className="sage-ai-code-block-container";const n=document.createElement("button");n.className="sage-ai-copy-code-button",n.innerHTML=u,n.title="Copy code to clipboard",n.addEventListener("click",()=>{const t=e.textContent||"";navigator.clipboard.writeText(t).then(()=>{n.innerHTML=g,setTimeout(()=>{n.innerHTML=u},2e3)}).catch(e=>{console.error("Failed to copy code: ",e),n.innerHTML="Error",setTimeout(()=>{n.innerHTML=u},2e3)})});const s=e.parentElement;s&&"PRE"===s.tagName&&(null===(t=s.parentNode)||void 0===t||t.insertBefore(o,s),o.appendChild(s),o.appendChild(n))})}getMentionContexts(){return new Map(this.mentionContexts)}setMentionContexts(e){this.mentionContexts=new Map(e)}addMentionContext(e){this.mentionContexts.set(e.id,e),this.historyManager.updateCurrentThreadContexts(this.mentionContexts)}removeMentionContext(e){this.mentionContexts.delete(e),this.historyManager.updateCurrentThreadContexts(this.mentionContexts)}addUserMessage(e){this.closeToolGroupIfOpen(),console.log("[ChatMessages] Adding user message:",e);const t=document.createElement("div");t.className="sage-ai-message sage-ai-user-message";const o=document.createElement("div");o.className="sage-ai-message-content",o.innerHTML=this.escapeHtml(e).replace(/\n/g,"<br>"),t.append(o),this.container.appendChild(t),this.scrollToBottom();const n={role:"user",content:e};this.messageHistory.push(n),this.userMessages.push({role:"user",content:e}),this.historyManager.updateCurrentThreadMessages(this.messageHistory,this.mentionContexts),this.lastAddedMessageType="user",console.log("[ChatMessages] User message added to history"),console.log("[ChatMessages] Current message history:",JSON.stringify(this.messageHistory)),console.log("[ChatMessages] Current user messages:",JSON.stringify(this.userMessages))}addSystemMessage(e){this.closeToolGroupIfOpen(),console.log("[ChatMessages] Adding system message:",e);const t=document.createElement("div");t.className="sage-ai-message sage-ai-system-message";const o=document.createElement("p");o.className="sage-ai-system-message-text",o.innerHTML=e,t.appendChild(o),this.container.appendChild(t),this.scrollToBottom(),this.lastAddedMessageType="normal",console.log("[ChatMessages] System message added (not saved to history)")}addErrorMessage(e){this.closeToolGroupIfOpen(),console.log("[ChatMessages] Adding error message:",e);const t=document.createElement("div");t.className="sage-ai-message sage-ai-error-message",t.textContent=e,this.container.appendChild(t),this.scrollToBottom(),this.lastAddedMessageType="normal",console.log("[ChatMessages] Error message added (not saved to history)")}closeToolGroupIfOpen(){"tool"===this.lastAddedMessageType&&(this.lastAddedMessageType=null)}renderToolCall(e){if("notebook-wait_user_reply"===e.name)return;console.log("[ChatMessages] Rendering tool call:",e.name),console.log("[ChatMessages] Tool call input:",JSON.stringify(e.input));const t=document.createElement("div");t.classList.add("sage-ai-tool-call-v1"),t.setAttribute("sage-ai-tool-call-name",e.name);const o=document.createElement("div");o.innerHTML=m(e.name),t.appendChild(o.firstChild);const n=document.createElement("span");n.innerHTML=p(e.name,e.input),n.className="sage-ai-loading-text",t.appendChild(n),this.upsertCellIdLabelInDOM(t,e.name,e.input),this.container.appendChild(t),this.scrollToBottom(),this.lastAddedMessageType="tool"}addToolCalls(e){e&&0!==e.length?(console.log("[ChatMessages] Adding tool calls:",e.length),e.forEach((e,t)=>{console.log(`[ChatMessages] Processing tool call #${t+1}:`,e.name),this.renderToolCall(e);const o={role:"assistant",content:[{type:"tool_use",id:e.id,name:e.name,input:e.input}]};this.messageHistory.push(o),this.historyManager.updateCurrentThreadMessages(this.messageHistory,this.mentionContexts),console.log(`[ChatMessages] Tool call #${t+1} added to history`)}),console.log("[ChatMessages] All tool calls added, current history length:",this.messageHistory.length),console.log("[ChatMessages] Last message in history:",JSON.stringify(this.messageHistory[this.messageHistory.length-1]))):console.log("[ChatMessages] No tool calls to add")}addStreamingToolCall(){this.closeToolGroupIfOpen(),console.log("[ChatMessages] Adding streaming tool call container");const e=this.container.querySelector(".sage-ai-streaming-cursor");e&&e.remove();const t=document.createElement("div");t.className="sage-ai-tool-call-v1 sage-ai-streaming-tool-call",t.setAttribute("data-tool-call","{}");const o=document.createElement("div");o.className="sage-ai-streaming-tool-call-placeholder",o.innerHTML="Sage is thinking about tools to use...";const n=document.createElement("span");return n.classList.add("sage-ai-streaming-cursor"),o.appendChild(n),t.appendChild(o),this.container.appendChild(t),this.scrollToBottom(),console.log("[ChatMessages] Streaming tool call container added (not yet in history)"),t}updateStreamingToolCall(e,t){if(console.log("[ChatMessages] Updating streaming tool call with:",t.name),e){const o=e.querySelector(".sage-ai-streaming-tool-call-placeholder");o&&o.remove(),e.setAttribute("data-tool-call",JSON.stringify(t)),e.setAttribute("sage-ai-tool-call-name",t.name);let n=e.querySelector(".sage-ai-tool-call-icon");n||(n=document.createElement("div"),n.className="sage-ai-tool-call-icon",n.innerHTML=m(t.name),e.appendChild(n));let s=e.querySelector(".sage-ai-loading-text");const i=p(t.name,t.input);s?s.innerHTML!==i&&(s.innerHTML=i):(s=document.createElement("span"),s.innerHTML=i,s.className="sage-ai-loading-text",e.appendChild(s)),this.upsertCellIdLabelInDOM(e,t.name,t.input),this.container.scrollTop=this.container.scrollHeight,console.log("[ChatMessages] Streaming tool call updated")}else console.warn("[ChatMessages] Warning: Tool call container not found in streaming message element")}finalizeStreamingToolCall(e){console.log("[ChatMessages] Finalizing streaming tool call");const t=e.querySelector(".sage-ai-streaming-cursor");t&&t.remove();const o=e.querySelector(".sage-ai-loading-text");o&&o.classList.remove("sage-ai-loading-text");const n=e.getAttribute("data-tool-call")||"{}",s=JSON.parse(n);if(console.log("[ChatMessages] Finalized tool call:",s.name),s.name){this.renderToolCall(s),e.remove(),this.scrollToBottom();const t={role:"assistant",content:[{type:"tool_use",id:s.id,name:s.name,input:s.input}]};this.messageHistory.push(t),this.historyManager.updateCurrentThreadMessages(this.messageHistory,this.mentionContexts),console.log("[ChatMessages] Finalized tool call added to history"),console.log("[ChatMessages] Current history length:",this.messageHistory.length)}else console.warn("[ChatMessages] Warning: No tool call data found when finalizing streaming tool call");console.log("[ChatMessages] Streaming tool call finalized")}renderToolResult(e,t,o){console.log("[ChatMessages] Rendering tool result for:",e),console.log("[ChatMessages] Tool result data:",JSON.stringify(t).substring(0,200)+(JSON.stringify(t).length>200?"...":"")),console.log("[ChatMessages] Tool result for call",o);const n=this.container.querySelector(".sage-ai-loading-text");if(n){n.classList.remove("sage-ai-loading-text");const e=n.parentElement,s=e.getAttribute("sage-ai-tool-call-name"),i=function(e){try{if("string"!=typeof e)return!1;const t=JSON.parse(e);if(Array.isArray(t)){const e=t.filter(e=>e&&!0===(null==e?void 0:e.error));return!!e.length&&e.map(e=>e.errorText).join("\n")}}catch(e){return!1}return!1}(t);return"string"==typeof i&&(e.classList.add("error-state"),e.title=i),this.upsertCellIdLabelInDOM(e,s,o,t),"notebook-edit_plan"===s&&(e.classList.add("clickable"),e.addEventListener("click",()=>{this.notebookTools.scrollToPlanCell()})),this.scrollToBottom(),void(this.lastAddedMessageType="tool")}}upsertCellIdLabelInDOM(e,t,o,n){var s,i,a;const r=e.querySelector(".sage-ai-tool-call-cell");if(r&&r.remove(),["notebook-add_cell","notebook-edit_cell","notebook-run_cell"].includes(t)){let t="";"string"==typeof n&&/^cell_(\d+)$/.test(n)&&(t=n);let r=null===(a=null===(i=null===(s=null==o?void 0:o.assistant)||void 0===s?void 0:s.content[0])||void 0===i?void 0:i.input)||void 0===a?void 0:a.cell_id;if("string"==typeof r&&/^cell_(\d+)$/.test(r)&&(t=r),"string"==typeof o.cell_id&&/^cell_(\d+)$/.test(o.cell_id)&&(t=o.cell_id),t&&/^cell_(\d+)$/.test(t)){e.classList.add("clickable");const o=document.createElement("div");o.classList.add("sage-ai-tool-call-cell"),o.innerHTML=t,e.appendChild(o),e.addEventListener("click",()=>{this.notebookTools.scrollToCellById(t)})}}}addToolResult(e,t,o,n){console.log("[ChatMessages] Adding tool result for:",e),this.renderToolResult(e,o,n);const s={role:"user",content:[{type:"tool_result",tool_use_id:t,content:o}]};this.messageHistory.push(s),this.historyManager.updateCurrentThreadMessages(this.messageHistory,this.mentionContexts),console.log("[ChatMessages] Tool result added to history"),console.log("[ChatMessages] Current history length:",this.messageHistory.length),console.log("[ChatMessages.addToolResult] Last message in history:",JSON.stringify(this.messageHistory[this.messageHistory.length-1]))}addLoadingIndicator(e="Generating..."){this.closeToolGroupIfOpen(),console.log("[ChatMessages] Adding loading indicator:",e);const t=document.createElement("div");t.className="sage-ai-message sage-ai-loading";const o=document.createElement("div");o.className="sage-ai-blob-loader",t.appendChild(o);const n=document.createElement("span");return n.textContent=e,t.appendChild(n),this.container.appendChild(t),this.scrollToBottom(),t}removeElement(e){console.log("[ChatMessages] Removing element from UI"),this.container.contains(e)&&this.container.removeChild(e)}getMessageHistory(){return console.log("[ChatMessages] Getting message history, length:",this.messageHistory.length),[...this.messageHistory]}async updateStreamingMessage(e,t){console.log("[ChatMessages] Updating streaming message with text:",t.substring(0,30)+(t.length>30?"...":""));const o=e.querySelector(".sage-ai-message-content");if(o){const e=(o.getAttribute("data-raw-text")||"")+t;o.setAttribute("data-raw-text",e),o.innerHTML=await this.renderMarkdown(e);const n=document.createElement("span");n.classList.add("sage-ai-streaming-cursor");const s=o.lastElementChild,i=null==s?void 0:s.lastElementChild;i?i.appendChild(n):s?s.appendChild(n):o.appendChild(n),this.container.scrollTop=this.container.scrollHeight,console.log("[ChatMessages] Current accumulated streaming text length:",e.length)}else console.warn("[ChatMessages] Warning: Content span not found in streaming message element")}async finalizeStreamingMessage(e){console.log("[ChatMessages] Finalizing streaming message");const t=e.querySelector(".sage-ai-message-content");if(t){const o=t.getAttribute("data-raw-text")||"";console.log("[ChatMessages] Finalized message text length:",o.length),console.log("[ChatMessages] First 100 chars of finalized message:",o.substring(0,100)+(o.length>100?"...":"")),await this.renderAssistantMessage(o,e.parentElement||void 0),e.remove(),this.scrollToBottom();const n={role:"assistant",content:o};this.messageHistory.push(n),this.historyManager.updateCurrentThreadMessages(this.messageHistory,this.mentionContexts),console.log("[ChatMessages] Finalized AI message added to history"),console.log("[ChatMessages] Current history length:",this.messageHistory.length)}else console.warn("[ChatMessages] Warning: Content span not found when finalizing streaming message");e.classList.remove("sage-ai-streaming-message");const o=e.querySelector("sage-ai-streaming-cursor");o&&o.remove(),console.log("[ChatMessages] Streaming message finalized and class removed")}scrollToBottom(){this.container&&(this.container.scrollTop=this.container.scrollHeight)}addStreamingAIMessage(){this.closeToolGroupIfOpen(),console.log("[ChatMessages] Adding streaming AI message container");const e=document.createElement("div");e.className="sage-ai-message sage-ai-ai-message sage-ai-streaming-message";const t=document.createElement("div");t.className="sage-ai-message-header";const o=document.createElement("div");o.className="sage-ai-message-header-image",o.innerHTML='<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">\n      <path d="M6.6243 10.3334C6.56478 10.1026 6.44453 9.89209 6.27605 9.72361C6.10757 9.55513 5.89702 9.43488 5.6663 9.37536L1.5763 8.32069C1.50652 8.30089 1.44511 8.25886 1.40138 8.20099C1.35765 8.14312 1.33398 8.07256 1.33398 8.00002C1.33398 7.92749 1.35765 7.85693 1.40138 7.79906C1.44511 7.74119 1.50652 7.69916 1.5763 7.67936L5.6663 6.62402C5.89693 6.56456 6.10743 6.44441 6.2759 6.27605C6.44438 6.10769 6.56468 5.89728 6.6243 5.66669L7.67897 1.57669C7.69857 1.50664 7.74056 1.44492 7.79851 1.40095C7.85647 1.35699 7.92722 1.33319 7.99997 1.33319C8.07271 1.33319 8.14346 1.35699 8.20142 1.40095C8.25938 1.44492 8.30136 1.50664 8.32097 1.57669L9.37497 5.66669C9.43449 5.89741 9.55474 6.10796 9.72322 6.27644C9.8917 6.44492 10.1023 6.56517 10.333 6.62469L14.423 7.67869C14.4933 7.69809 14.5553 7.74003 14.5995 7.79808C14.6437 7.85612 14.6677 7.92706 14.6677 8.00002C14.6677 8.07298 14.6437 8.14393 14.5995 8.20197C14.5553 8.26002 14.4933 8.30196 14.423 8.32136L10.333 9.37536C10.1023 9.43488 9.8917 9.55513 9.72322 9.72361C9.55474 9.89209 9.43449 10.1026 9.37497 10.3334L8.3203 14.4234C8.3007 14.4934 8.25871 14.5551 8.20075 14.5991C8.1428 14.6431 8.07205 14.6669 7.9993 14.6669C7.92656 14.6669 7.85581 14.6431 7.79785 14.5991C7.73989 14.5551 7.69791 14.4934 7.6783 14.4234L6.6243 10.3334Z" fill="url(#paint0_linear_445_6567)"/>\n      <path d="M13.333 2V4.66667" stroke="url(#paint1_linear_445_6567)" stroke-width="0.984615" stroke-linecap="round" stroke-linejoin="round"/>\n      <path d="M14.6667 3.33331H12" stroke="url(#paint2_linear_445_6567)" stroke-width="0.984615" stroke-linecap="round" stroke-linejoin="round"/>\n      <path d="M2.66699 11.3333V12.6666" stroke="url(#paint3_linear_445_6567)" stroke-width="0.984615" stroke-linecap="round" stroke-linejoin="round"/>\n      <path d="M3.33333 12H2" stroke="url(#paint4_linear_445_6567)" stroke-width="0.984615" stroke-linecap="round" stroke-linejoin="round"/>\n      <defs>\n      <linearGradient id="paint0_linear_445_6567" x1="1.33398" y1="1.33319" x2="14.6677" y2="14.6669" gradientUnits="userSpaceOnUse">\n      <stop stop-color="#FEC163"/>\n      <stop offset="1" stop-color="#DE4313"/>\n      </linearGradient>\n      <linearGradient id="paint1_linear_445_6567" x1="13.333" y1="2" x2="15.0864" y2="2.65753" gradientUnits="userSpaceOnUse">\n      <stop stop-color="#FEC163"/>\n      <stop offset="1" stop-color="#DE4313"/>\n      </linearGradient>\n      <linearGradient id="paint2_linear_445_6567" x1="12" y1="3.33331" x2="12.6575" y2="5.08674" gradientUnits="userSpaceOnUse">\n      <stop stop-color="#FEC163"/>\n      <stop offset="1" stop-color="#DE4313"/>\n      </linearGradient>\n      <linearGradient id="paint3_linear_445_6567" x1="2.66699" y1="11.3333" x2="3.94699" y2="12.2933" gradientUnits="userSpaceOnUse">\n      <stop stop-color="#FEC163"/>\n      <stop offset="1" stop-color="#DE4313"/>\n      </linearGradient>\n      <linearGradient id="paint4_linear_445_6567" x1="2" y1="12" x2="2.96" y2="13.28" gradientUnits="userSpaceOnUse">\n      <stop stop-color="#FEC163"/>\n      <stop offset="1" stop-color="#DE4313"/>\n      </linearGradient>\n      </defs>\n      </svg>\n    ',t.append(o);const n=document.createElement("span");n.className="sage-ai-message-header-title",n.innerText="Sage AI",t.append(n),"user"!==this.lastAddedMessageType&&(t.style.display="none");const s=document.createElement("div");return s.className="sage-ai-message-content sage-ai-streaming-content sage-ai-markdown-content",s.setAttribute("data-raw-text",""),e.appendChild(t),e.appendChild(s),this.container.appendChild(e),this.scrollToBottom(),console.log("[ChatMessages] Streaming message container added (not yet in history)"),e}}var C=o(6750);const y=new C.BehaviorSubject({toolService:null,notebookTracker:null,notebookTools:null,notebookContextManager:null,contentManager:null,settingsRegistry:null,chatService:null,config:null,extensions:null,planStateDisplay:null,waitingUserReplyBoxManager:null,notebookDiffManager:null,actionHistory:null,cellTrackingService:null,trackingIDUtility:null,contextCellHighlighter:null,chatContainer:null,currentNotebookPath:null,isInitialized:!1,settings:{theme:"light",tokenMode:!1,claudeApiKey:"",claudeModelId:"claude-3-7-sonnet-20250219",claudeModelUrl:"https://sage.alpinex.ai:8760",databaseUrl:""}}),v={getState:()=>y.getValue(),setState:e=>y.next({...y.getValue(),...e}),changes:y.asObservable(),initializeCoreServices:(e,t,o,n,s,i)=>{v.setState({toolService:e,notebookTracker:t,notebookTools:o,notebookContextManager:n,contentManager:s,settingsRegistry:i||null})},initializeManagers:(e,t,o)=>{v.setState({planStateDisplay:e,waitingUserReplyBoxManager:t,notebookDiffManager:o})},initializeAdditionalServices:(e,t,o,n)=>{v.setState({actionHistory:e,cellTrackingService:t,trackingIDUtility:o,contextCellHighlighter:n})},markAsInitialized:()=>{v.setState({isInitialized:!0})},setCurrentNotebookPath:e=>{v.setState({currentNotebookPath:e})},updateSettings:e=>{const t=v.getState();v.setState({settings:{...t.settings,...e}})},updateClaudeSettings:e=>{const t=v.getState();v.setState({settings:{...t.settings,...e}})},getClaudeSettings:()=>{const{settings:e}=v.getState();return{claudeApiKey:e.claudeApiKey,claudeModelId:e.claudeModelId,claudeModelUrl:e.claudeModelUrl,databaseUrl:e.databaseUrl}},getClaudeApiKey:()=>v.getState().settings.claudeApiKey,getClaudeModelUrl:()=>v.getState().settings.claudeModelUrl,getClaudeModelId:()=>v.getState().settings.claudeModelId,setExtensions:e=>{v.setState({extensions:e})},getExtensions:()=>v.getState().extensions,setSettingsRegistry:e=>{v.setState({settingsRegistry:e})},getSettingsRegistry:()=>v.getState().settingsRegistry,getToolService:()=>{const e=v.getState().toolService;if(!e)throw new Error("ToolService not initialized in AppState");return e},getNotebookTracker:()=>{const e=v.getState().notebookTracker;if(!e)throw new Error("NotebookTracker not initialized in AppState");return e},getNotebookTools:()=>{const e=v.getState().notebookTools;if(!e)throw new Error("NotebookTools not initialized in AppState");return e},getNotebookContextManager:()=>{const e=v.getState().notebookContextManager;if(!e)throw new Error("NotebookContextManager not initialized in AppState");return e},getContentManager:()=>{const e=v.getState().contentManager;if(!e)throw new Error("ContentManager not initialized in AppState");return e},getPlanStateDisplay:()=>{const e=v.getState().planStateDisplay;if(!e)throw new Error("PlanStateDisplay not initialized in AppState");return e},getWaitingUserReplyBoxManager:()=>{const e=v.getState().waitingUserReplyBoxManager;if(!e)throw new Error("WaitingUserReplyBoxManager not initialized in AppState");return e},getActionHistory:()=>{const e=v.getState().actionHistory;if(!e)throw new Error("ActionHistory not initialized in AppState");return e},getCellTrackingService:()=>{const e=v.getState().cellTrackingService;if(!e)throw new Error("CellTrackingService not initialized in AppState");return e},getNotebookDiffManager:()=>{const e=v.getState().notebookDiffManager;if(!e)throw new Error("NotebookDiffManager not initialized in AppState");return e},getTrackingIDUtility:()=>{const e=v.getState().trackingIDUtility;if(!e)throw new Error("TrackingIDUtility not initialized in AppState");return e},getContextCellHighlighter:()=>{const e=v.getState().contextCellHighlighter;if(!e)throw new Error("ContextCellHighlighter not initialized in AppState");return e},getChatContainer:()=>{const e=v.getState().chatContainer;if(!e)throw new Error("ChatContainer not initialized in AppState");return e},setChatContainer:e=>{v.setState({chatContainer:e})},getChatContainerSafe:()=>v.getState().chatContainer,setChatService:e=>{v.setState({chatService:e})},getChatService:()=>{const e=v.getState().chatService;if(!e)throw new Error("ChatService not initialized in AppState");return e},setConfig:e=>{v.setState({config:e})},getConfig:()=>{const e=v.getState().config;if(!e)throw new Error("Config not initialized in AppState");return e},updateChatContainerNotebookPath:(e,t)=>{const o=v.getState().chatContainer;o&&!o.isDisposed&&o.updateNotebookPath(e,t)},switchChatContainerToNotebook:e=>{const t=v.getState().chatContainer;t&&!t.isDisposed&&t.switchToNotebook(e)}};class b{constructor(e){this.currentNotebookPath=null,this.toolService=e}updateNotebookPath(e){this.currentNotebookPath=e}setNotebookPath(e){this.currentNotebookPath!==e&&(console.log(`[NotebookStateService] Setting notebook path to: ${e}`),this.currentNotebookPath=e,e&&this.toolService.setCurrentNotebookPath(e))}getNotebookPath(){return this.currentNotebookPath}cleanResult(e){const t=[];if(e&&e.content)for(const o of e.content)try{t.push({...o,text:JSON.parse(o.text)})}catch(e){t.push(o),console.error(e)}return t}async fetchNotebookState(){var e;try{this.currentNotebookPath?this.toolService.setCurrentNotebookPath(this.currentNotebookPath):console.log("No notebook path set, using default context."),console.log("Fetching notebook state for:",this.currentNotebookPath);const t=await(null===(e=this.toolService.notebookTools)||void 0===e?void 0:e.getNotebookSummary(this.currentNotebookPath));console.log("Notebook Summary: ===",t);const o=v.getNotebookTools().read_cells({notebook_path:this.currentNotebookPath});console.log("Notebook Content ===:",o);const n=[...(null==o?void 0:o.cells)||[]].reverse().slice(0,3);let s="\n\nMost Recent Cells From Most Recent To Oldest:\n";n.forEach((e,t)=>{s+=`\n--- ${0===t&&"Latest "}Cell ---\n${JSON.stringify(e)}\n`});let i="[]";try{this.toolService.filesystemTools?i=await this.toolService.filesystemTools.list_datasets():console.warn("FilesystemTools not available, using empty dataset list")}catch(e){console.error("Error fetching datasets via FilesystemTools:",e),i="[]"}console.log("Datasets:",i);let a=`\n\nAvailable Datasets:\n${i}\n\n`,r="=== SUMMARY OF CELLS IN NOTEBOOK === \n\n";t.forEach(e=>{"planning_cell"===e.id?(r+="- SAGE PLANNING CELL - \n",r+=`cell_index: ${e.index}, cell_id: ${e.id}, summary: ${e.summary}, cell_type: ${e.cell_type}, next_step_string: ${e.next_step_string}, current_step_string: ${e.current_step_string}, empty: ${e.empty}\n`,r+="- END SAGE PLANNING CELL -"):r+=`cell_id: ${e.id}, summary: ${e.summary}, cell_index: ${e.index}, cell_type: ${e.cell_type}, empty: ${e.empty}`,r+="\n\n"}),r+="=== END SUMMARY OF CELLS IN NOTEBOOK ===\n\n",console.log(r);const l=r+a;return console.log("Summary Sent to LLM: ",l),l}catch(e){return console.error("Failed to fetch notebook state:",e),""}}}class k{constructor(e,t,o){this.confirmationContainer=null,this.isShowing=!1,this.onActivateAutoRunMode=()=>{},this.currentResolver=null,this.currentAutoRunSelect=null,this.currentKeyboardHandler=null,this.chatHistory=e,this.messageComponent=t,this.onActivateAutoRunMode=o}triggerApproval(){this.isShowing&&this.currentResolver&&this.executeApproval()}triggerRejection(){this.isShowing&&this.currentResolver&&this.executeRejection()}executeApproval(){this.confirmationContainer&&(this.chatHistory.removeChild(this.confirmationContainer),this.confirmationContainer=null),this.currentAutoRunSelect&&"dont-ask"===this.currentAutoRunSelect.value&&this.onActivateAutoRunMode(),this.currentResolver&&this.currentResolver(!0),this.cleanup()}executeRejection(){this.confirmationContainer&&(this.chatHistory.removeChild(this.confirmationContainer),this.confirmationContainer=null),this.currentResolver&&this.currentResolver(!1),this.cleanup()}cleanup(){this.isShowing=!1,this.currentResolver=null,this.currentAutoRunSelect=null,this.currentKeyboardHandler&&(document.removeEventListener("keydown",this.currentKeyboardHandler),this.currentKeyboardHandler=null)}async showConfirmation(e,t){return!t&&(this.isShowing=!0,new Promise(t=>{this.currentResolver=t,this.confirmationContainer=document.createElement("div"),this.confirmationContainer.className="sage-ai-code-confirmation";const o=document.createElement("span");o.style.fontSize="var(--jp-ui-font-size1)",o.style.color="var(--jp-ui-font-color1)",o.style.fontWeight="500",o.style.display="flex",o.style.alignItems="center",o.style.gap="4px",o.innerHTML=`<svg width="14px" height="14px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path fill-rule="evenodd" clip-rule="evenodd" d="M4.5 6L5.25 5.25H18.75L19.5 6V18L18.75 18.75H5.25L4.5 18V6ZM6 6.75V17.25H18V6.75H6ZM10.1894 12L7.71973 9.5303L8.78039 8.46964L12.3107 12L8.78039 15.5303L7.71973 14.4696L10.1894 12ZM12 15.75H15.75V14.25H12V15.75Z" fill="var(--jp-ui-font-color0)"></path> </g></svg> Sage is trying to run ${e||"cell"}`,o.className="sage-ai-code-confirmation-heading",this.confirmationContainer.appendChild(o);const n=document.createElement("div");n.className="sage-ai-auto-run-mode-checkbox-container";const s=document.createElement("select");s.style.border="0",s.style.backgroundColor="transparent",s.style.fontSize="var(--jp-ui-font-size1)",s.style.color="var(--jp-ui-font-color2)",s.id="sage-ai-auto-run-mode-select",s.className="sage-ai-auto-run-mode-checkbox",this.currentAutoRunSelect=s;const i=document.createElement("option");i.value="ask",i.textContent="Ask every time";const a=document.createElement("option");a.value="dont-ask",a.textContent="Don't ask every time",s.value="ask",s.appendChild(i),s.appendChild(a),n.appendChild(s);const r=document.createElement("div");r.className="sage-ai-confirmation-button-container";const l=document.createElement("button");l.textContent="Reject",l.className="sage-ai-reject-button";const c=document.createElement("button");let d=/Mac|iPod|iPhone|iPad/.test(navigator.platform)?"⌘":"⌃";const h=document.createElement("span");h.style.display="flex",h.style.alignItems="center";const u=document.createElement("span");u.style.display="inline-flex",u.style.alignItems="center",u.style.fontFamily="monospace",u.style.fontWeight="bold",u.style.marginLeft="4px",u.style.marginRight="2px",u.textContent=d;const g=document.createElement("span");g.style.display="inline-flex",g.style.alignItems="center",g.style.fontFamily="monospace",g.style.fontWeight="bold",g.textContent="⏎";const p=document.createElement("span");p.style.fontSize="var(--jp-ui-font-size1)",p.textContent="Run",h.appendChild(p),h.appendChild(u),h.appendChild(g),c.appendChild(h),c.className="sage-ai-confirm-button",r.appendChild(l),r.appendChild(c);const m=document.createElement("div");m.className="sage-ai-confirmation-bottom-container",m.appendChild(n),m.appendChild(r),this.confirmationContainer.appendChild(m),this.chatHistory.appendChild(this.confirmationContainer),this.chatHistory.scrollTop=this.chatHistory.scrollHeight;const f=e=>{"Enter"===e.key&&(e.metaKey||e.ctrlKey)&&(e.preventDefault(),this.executeApproval())};this.currentKeyboardHandler=f,document.addEventListener("keydown",f),c.addEventListener("click",()=>{this.executeApproval()}),l.addEventListener("click",()=>{this.executeRejection()})}))}isDialogShowing(){return this.isShowing}}class w{async showDialog(){const e=document.createElement("div");e.className="sage-ai-modal";const t=document.createElement("div");t.className="sage-ai-dialog";const o=document.createElement("h3");o.textContent="Cell Execution Rejected",o.className="sage-ai-dialog-title";const n=document.createElement("label");n.textContent="Could you explain why you rejected the code execution? This will help improve the next attempt:",n.className="sage-ai-dialog-label";const s=document.createElement("textarea");s.className="sage-ai-dialog-textarea";const i=document.createElement("div");i.className="sage-ai-dialog-button-container";const a=document.createElement("button");return a.textContent="Submit",a.className="sage-ai-dialog-submit-button",i.appendChild(a),t.appendChild(o),t.appendChild(n),t.appendChild(s),t.appendChild(i),e.appendChild(t),document.body.appendChild(e),new Promise(t=>{a.addEventListener("click",()=>{const o=s.value.trim();document.body.removeChild(e),t(o)})})}}var S;!function(e){e.ADD_CELL="add_cell",e.EDIT_CELL="edit_cell",e.REMOVE_CELLS="remove_cells"}(S||(S={}));class _{constructor(){this.history=[]}addAction(e,t,o){const n={type:e,data:t,timestamp:Date.now(),description:o};this.history.push(n),console.log(`[ActionHistory] Added action: ${o}`)}getLastAction(){return 0===this.history.length?null:this.history[this.history.length-1]}popLastAction(){if(0===this.history.length)return null;const e=this.history.pop();return console.log("Action popped for undo:",e),e}canUndo(){return this.history.length>0}getLastActionDescription(){const e=this.getLastAction();return e?e.description:null}getAllActions(){return[...this.history]}clear(){this.history=[],console.log("Action history cleared")}}var x=o(3345),M=o(6249),E=o(4602);class T{static initialize(e){T.settingsRegistry=e}static async getSetting(e,t){if(!T.settingsRegistry)return console.warn("[CachingService] Settings registry not initialized, using default value"),t;try{const o=(await T.settingsRegistry.load(T.PLUGIN_ID)).get(e).composite;return void 0!==o?o:t}catch(o){return console.warn(`[CachingService] Failed to get setting '${e}':`,o),t}}static async setSetting(e,t){if(T.settingsRegistry)try{const o=await T.settingsRegistry.load(T.PLUGIN_ID);await o.set(e,t),await o.save(o.raw)}catch(t){console.error(`[CachingService] Failed to set setting '${e}':`,t)}else console.warn("[CachingService] Settings registry not initialized, cannot set setting")}static async removeSetting(e){if(T.settingsRegistry)try{const t=await T.settingsRegistry.load(T.PLUGIN_ID);await t.remove(e),await t.save(t.raw)}catch(t){console.error(`[CachingService] Failed to remove setting '${e}':`,t)}else console.warn("[CachingService] Settings registry not initialized, cannot remove setting")}static async getBooleanSetting(e,t=!1){return T.getSetting(e,t)}static async setBooleanSetting(e,t){return T.setSetting(e,t)}static async getStringSetting(e,t=""){return T.getSetting(e,t)}static async setStringSetting(e,t){return T.setSetting(e,t)}static async getObjectSetting(e,t){return T.getSetting(e,t)}static async setObjectSetting(e,t){return T.setSetting(e,t)}static isAvailable(){return null!==T.settingsRegistry}static async getAllSettings(){if(!T.settingsRegistry)return{};try{return(await T.settingsRegistry.load(T.PLUGIN_ID)).composite}catch(e){return console.error("[CachingService] Failed to get all settings:",e),{}}}}T.settingsRegistry=null,T.PLUGIN_ID="sage-agent:plugin";const I="darkThemeApplied",N="updateDeclined",D="chatHistories",A="codebases",L="sageTokenMode",P="claudeApiKey",R="claudeModelId",H="claudeModelUrl",$="databaseUrl";class B{constructor(e){this.codebases=[],this.isInitialized=!1,this.toolService=e,this.element=this.createUI(),this.loadCodebases()}getElement(){return this.element}createUI(){const e=document.createElement("div");e.className="sage-ai-codebase-manager";const t=document.createElement("h3");t.textContent="Codebase Search",t.className="sage-ai-section-title";const o=document.createElement("p");o.textContent="Manage codebases that the AI can search through and reference.",o.className="sage-ai-section-description",this.addForm=this.createAddForm(),this.codebaseListElement=document.createElement("div"),this.codebaseListElement.className="sage-ai-codebase-list";const n=document.createElement("div");return n.className="sage-ai-empty-state",n.textContent="No codebases added yet. Add a codebase to enable AI code search.",this.codebaseListElement.appendChild(n),e.appendChild(t),e.appendChild(o),e.appendChild(this.addForm),e.appendChild(this.codebaseListElement),this.addStylesheetLink(),e}addStylesheetLink(){if(document.getElementById("sage-ai-codebase-styles-link"))return;const e=document.createElement("link");e.id="sage-ai-codebase-styles-link",e.rel="stylesheet",e.type="text/css",e.href="../style/codebase-manager.css",document.head.appendChild(e)}createAddForm(){const e=document.createElement("form");e.className="sage-ai-add-repo-form";const t=document.createElement("div");t.className="sage-ai-form-group";const o=document.createElement("label");o.textContent="Repository Path:",o.htmlFor="repo-path";const n=document.createElement("input");n.type="text",n.id="repo-path",n.placeholder="/path/to/codebase",n.className="sage-ai-input",t.appendChild(o),t.appendChild(n);const s=document.createElement("div");s.className="sage-ai-form-group";const i=document.createElement("label");i.textContent="Name (optional):",i.htmlFor="repo-name";const a=document.createElement("input");a.type="text",a.id="repo-name",a.placeholder="e.g., My Project",a.className="sage-ai-input",s.appendChild(i),s.appendChild(a);const r=document.createElement("div");r.className="sage-ai-form-group";const l=document.createElement("label");l.textContent="Instructions (optional):",l.htmlFor="repo-instructions";const c=document.createElement("textarea");c.id="repo-instructions",c.placeholder="e.g., Import the bot class like this: from twitter_bots.crypto_sherpa import CryptoSherpa",c.className="sage-ai-textarea",c.rows=3,r.appendChild(l),r.appendChild(c);const d=document.createElement("button");return d.type="submit",d.className="sage-ai-button sage-ai-primary-button",d.textContent="Add Repository",e.appendChild(t),e.appendChild(s),e.appendChild(r),e.appendChild(d),e.addEventListener("submit",e=>{e.preventDefault(),this.addRepository(n.value.trim(),a.value.trim(),c.value.trim()),n.value="",a.value="",c.value=""}),e}async loadCodebases(){try{const e=await T.getObjectSetting(A,[]);this.codebases=e||[],console.log("Loaded codebases from settings registry:",this.codebases),this.renderCodebaseList()}catch(e){console.error("Failed to load codebases:",e),this.codebases=[],this.renderCodebaseList()}}async saveCodebasesToStorage(){try{await T.setObjectSetting(A,this.codebases),console.log("Saved codebases to settings registry")}catch(e){console.error("Failed to save codebases to settings registry:",e)}}async addRepository(e,t,o){if(!e)return void alert("Repository path is required");const n=e;try{const s={id:n,path:e,name:t||e.split("/").pop()||e,instructions:o};this.codebases.push(s),await this.saveCodebasesToStorage(),this.renderCodebaseList(),console.log("Repository added locally (backend integration disabled):",s)}catch(e){console.error("Failed to add repository:",e),alert(`Failed to add repository: ${e instanceof Error?e.message:"Unknown error"}`)}}async reloadRepository(e){const t=this.codebases.find(t=>t.id===e);if(t)try{console.log("Repository reload requested (backend integration disabled):",t.path),this.renderCodebaseList()}catch(e){console.error("Failed to reload repository:",e),alert(`Failed to reload repository: ${e instanceof Error?e.message:"Unknown error"}`),this.renderCodebaseList()}}async removeRepository(e){const t=this.codebases.find(t=>t.id===e);if(t&&confirm("Are you sure you want to remove this repository? This action cannot be undone."))try{this.codebases=this.codebases.filter(t=>t.id!==e),await this.saveCodebasesToStorage(),console.log("Repository removed locally (backend integration disabled):",t.path),this.renderCodebaseList(),alert(`Repository at ${t.path} removed locally.`)}catch(e){console.error("Failed to remove repository:",e),alert(`Failed to remove repository: ${e instanceof Error?e.message:"Unknown error"}`)}}editInstructions(e){const t=this.codebases.find(t=>t.id===e);if(!t)return;const o=t.instructions||"",n=prompt("Edit instructions for this codebase:",o);null!==n&&n!==o&&(t.instructions=n,this.renderCodebaseList())}renderCodebaseList(){if(this.codebaseListElement.innerHTML="",0===this.codebases.length){const e=document.createElement("div");return e.className="sage-ai-empty-state",e.textContent="No codebases added yet. Add a codebase to enable AI code search.",void this.codebaseListElement.appendChild(e)}this.codebases.forEach(e=>{const t=document.createElement("div");t.className="sage-ai-codebase-item";const o=document.createElement("div");o.className="sage-ai-codebase-header";const n=document.createElement("h4");n.className="sage-ai-codebase-title",n.textContent=e.name;const s=document.createElement("div");s.className="sage-ai-codebase-actions";const i=document.createElement("button");i.className="sage-ai-action-button",i.textContent="Reload",i.addEventListener("click",()=>this.reloadRepository(e.id));const a=document.createElement("button");a.className="sage-ai-action-button",a.textContent="Edit Instructions",a.addEventListener("click",()=>this.editInstructions(e.id));const r=document.createElement("button");r.className="sage-ai-action-button sage-ai-danger-button",r.textContent="Remove",r.addEventListener("click",()=>this.removeRepository(e.id)),s.appendChild(i),s.appendChild(a),s.appendChild(r),o.appendChild(n),o.appendChild(s);const l=document.createElement("div");let c;l.className="sage-ai-codebase-path",l.textContent=e.path,e.instructions&&(c=document.createElement("div"),c.className="sage-ai-codebase-instructions",c.textContent=e.instructions),t.appendChild(o),t.appendChild(l),c&&t.appendChild(c),this.codebaseListElement.appendChild(t)})}}function O({isVisible:e,sageTokenMode:t,claudeApiKey:o,claudeModelId:n,claudeModelUrl:s,databaseUrl:i,onTokenModeChange:a,onClaudeApiKeyChange:r,onClaudeModelIdChange:l,onClaudeModelUrlChange:c,onDatabaseUrlChange:d,toolService:h}){const[u,g]=x.useState(null),p=x.useRef(null),[m,f]=x.useState(!1);return x.useEffect(()=>{if(h&&p.current&&!u){const e=new B(h);g(e),p.current.appendChild(e.getElement())}},[h,u]),x.useEffect(()=>()=>{if(u&&p.current){const e=u.getElement();e.parentNode&&e.parentNode.removeChild(e)}},[u]),e?x.createElement("div",{className:"sage-ai-settings-container"},x.createElement("h2",{className:"sage-ai-settings-title"},"Sage AI Settings"),x.createElement("div",{ref:p}),x.createElement("div",{className:"sage-ai-config-section"},x.createElement("h3",{className:"sage-ai-config-title"},"Sage API Configuration"),x.createElement("div",{className:"sage-ai-field-container"},x.createElement("label",{className:"sage-ai-field-label"},"Sage API Key:"),x.createElement("input",{type:m?"text":"password",value:o,onChange:e=>r(e.target.value),onFocus:()=>f(!0),onBlur:()=>f(!1),placeholder:"Enter your Sage API key",className:"sage-ai-field-input"})),x.createElement("div",{className:"sage-ai-field-container"},x.createElement("label",{className:"sage-ai-field-label"},"Sage Model ID:"),x.createElement("input",{type:"text",value:n,onChange:e=>l(e.target.value),placeholder:"claude-sonnet-4-20250514",className:"sage-ai-field-input"})),x.createElement("div",{className:"sage-ai-field-container"},x.createElement("label",{className:"sage-ai-field-label"},"Sage Model URL:"),x.createElement("input",{type:"text",value:s,onChange:e=>c(e.target.value),placeholder:"https://sage.alpinex.ai:8760",className:"sage-ai-field-input"}))),x.createElement("div",{className:"sage-ai-config-section"},x.createElement("h3",{className:"sage-ai-config-title"},"Database Configuration"),x.createElement("div",{className:"sage-ai-field-container"},x.createElement("label",{className:"sage-ai-field-label"},"Database URL:"),x.createElement("input",{type:"text",value:i,onChange:e=>d(e.target.value),placeholder:"Enter your database URL",className:"sage-ai-field-input"}))),x.createElement("div",{className:"sage-token-mode-container"},x.createElement("label",{className:"sage-token-mode-label"},x.createElement("input",{type:"checkbox",checked:t,onChange:e=>{a(e.target.checked)},className:"sage-token-mode-checkbox"}),x.createElement("span",null,"Sage Token Debug Mode")))):null}class U extends M.ReactWidget{constructor(e){super(),this._stateChanged=new E.Signal(this),this.id="sage-ai-settings",this.title.label="Settings",this.title.closable=!1,this.addClass("sage-ai-settings"),this.toolService=e,this._state={isVisible:!0,sageTokenMode:!1,claudeApiKey:"",claudeModelId:"claude-sonnet-4-20250514",claudeModelUrl:"https://sage.alpinex.ai:8760",databaseUrl:""},this.initializeSettings()}async initializeSettings(){try{await this.loadAndSyncSettings();const e=v.getClaudeSettings();await this.loadTokenModeSetting();const t=U.SAGE_TOKEN_MODE;v.updateSettings({tokenMode:t}),this._state={isVisible:!0,sageTokenMode:t,claudeApiKey:e.claudeApiKey,claudeModelId:e.claudeModelId,claudeModelUrl:e.claudeModelUrl,databaseUrl:e.databaseUrl},this.update()}catch(e){console.error("Failed to initialize settings:",e)}}get stateChanged(){return this._stateChanged}render(){return x.createElement(O,{isVisible:this._state.isVisible,sageTokenMode:this._state.sageTokenMode,claudeApiKey:this._state.claudeApiKey,claudeModelId:this._state.claudeModelId,claudeModelUrl:this._state.claudeModelUrl,databaseUrl:this._state.databaseUrl,onTokenModeChange:this.handleTokenModeChange.bind(this),onClaudeApiKeyChange:this.handleClaudeApiKeyChange.bind(this),onClaudeModelIdChange:this.handleClaudeModelIdChange.bind(this),onClaudeModelUrlChange:this.handleClaudeModelUrlChange.bind(this),onDatabaseUrlChange:this.handleDatabaseUrlChange.bind(this),toolService:this.toolService})}async loadTokenModeSetting(){const e=await T.getBooleanSetting(L,!1);U.SAGE_TOKEN_MODE=e}async saveTokenModeSetting(e){await T.setBooleanSetting(L,e)}async loadSetting(e,t){return await T.getStringSetting(e,t)}async saveSetting(e,t){await T.setStringSetting(e,t)}async loadAndSyncSettings(){let e=await this.loadSetting(P,"");if(e&&""!==e.trim())console.log("[SettingsWidget] API key already exists in settings registry, not loading from optional_env.json");else try{const t=o(3545);t.api_key&&(e=t.api_key,console.log("[SettingsWidget] Caching API key from optional_env.json to settings registry"),await this.saveSetting(P,e))}catch(e){console.log("No optional_env.json found or error loading it:",e)}const t=await this.loadSetting(R,"claude-sonnet-4-20250514"),n=await this.loadSetting(H,"https://sage.alpinex.ai:8760"),s=await this.loadSetting($,"");v.updateClaudeSettings({claudeApiKey:e,claudeModelId:t,claudeModelUrl:n,databaseUrl:s})}async handleTokenModeChange(e){U.SAGE_TOKEN_MODE=e,await this.saveTokenModeSetting(e),v.updateSettings({tokenMode:e}),this._state={...this._state,sageTokenMode:e},this._stateChanged.emit(this._state),this.update()}async handleClaudeApiKeyChange(e){await this.saveSetting(P,e),v.updateClaudeSettings({claudeApiKey:e}),this._state={...this._state,claudeApiKey:e},this._stateChanged.emit(this._state),this.update()}async handleClaudeModelIdChange(e){await this.saveSetting(R,e),v.updateClaudeSettings({claudeModelId:e}),this._state={...this._state,claudeModelId:e},this._stateChanged.emit(this._state),this.update()}async handleClaudeModelUrlChange(e){await this.saveSetting(H,e),v.updateClaudeSettings({claudeModelUrl:e}),this._state={...this._state,claudeModelUrl:e},this._stateChanged.emit(this._state),this.update()}async handleDatabaseUrlChange(e){await this.saveSetting($,e),v.updateClaudeSettings({databaseUrl:e}),this._state={...this._state,databaseUrl:e},this._stateChanged.emit(this._state),this.update()}show(){this._state={...this._state,isVisible:!0},this._stateChanged.emit(this._state),this.update()}hide(){this._state={...this._state,isVisible:!1},this._stateChanged.emit(this._state),this.update()}getState(){return{...this._state}}getIsVisible(){return this._state.isVisible}getClaudeApiKey(){return this._state.claudeApiKey}getClaudeModelId(){return this._state.claudeModelId}getClaudeModelUrl(){return this._state.claudeModelUrl}getDatabaseUrl(){return this._state.databaseUrl}getClaudeSettings(){return{apiKey:this._state.claudeApiKey,modelId:this._state.claudeModelId,modelUrl:this._state.claudeModelUrl}}getWidget(){return this}}U.SAGE_TOKEN_MODE=!1,U.SAGE_TOKEN_MODE_KEY="sage-ai-token-mode",U.CLAUDE_API_KEY_KEY="sage-ai-claude-api-key",U.CLAUDE_MODEL_ID_KEY="sage-ai-claude-model-id",U.CLAUDE_MODEL_URL_KEY="sage-ai-claude-model-url",U.DATABASE_URL_KEY="sage-ai-database-url";class j{constructor(){this._diffState$=new C.BehaviorSubject({pendingDiffs:new Map,allDiffsResolved:!1,notebookPath:null})}static getInstance(){return j.instance||(j.instance=new j),j.instance}get diffState$(){return this._diffState$.asObservable()}getCellStateChanges$(e){return this._diffState$.pipe((0,C.map)(t=>{const o=t.pendingDiffs.get(e);return o?{cellId:e,approved:o.approved,notebookPath:t.notebookPath}:null}),(0,C.distinctUntilChanged)((e,t)=>JSON.stringify(e)===JSON.stringify(t)))}get allDiffsResolved$(){return this._diffState$.pipe((0,C.map)(e=>({allDiffsResolved:e.allDiffsResolved,notebookPath:e.notebookPath})),(0,C.distinctUntilChanged)((e,t)=>e.allDiffsResolved===t.allDiffsResolved&&e.notebookPath===t.notebookPath),(0,C.map)(e=>({notebookPath:e.notebookPath})))}getPendingDiffsForNotebook$(e){return this._diffState$.pipe((0,C.map)(t=>{const o=[];for(const[,n]of t.pendingDiffs)e&&n.notebookPath!==e||o.push(n);return o}),(0,C.distinctUntilChanged)((e,t)=>JSON.stringify(e)===JSON.stringify(t)))}getCurrentState(){return this._diffState$.value}updatePendingDiffs(e,t){const o=this._diffState$.value,n=this.checkIfAllDiffsResolved(e,t);this._diffState$.next({...o,pendingDiffs:e,allDiffsResolved:n,notebookPath:t})}updateDiffState(e,t,o){const n=this._diffState$.value,s=new Map(n.pendingDiffs),i=s.get(e);i&&s.set(e,{...i,approved:t,userDecision:i.userDecision||(!0===t?"approved":!1===t?"rejected":null)});const a=this.checkIfAllDiffsResolved(s,o);this._diffState$.next({...n,pendingDiffs:s,allDiffsResolved:a,notebookPath:null!=o?o:n.notebookPath})}updateDiffStateResult(e,t){var o;const n=this._diffState$.value,s=new Map(n.pendingDiffs),i=s.get(e);i&&s.set(e,{...i,runResult:t});const a=this.checkIfAllDiffsResolved(s,(null===(o=s.get(e))||void 0===o?void 0:o.notebookPath)||n.notebookPath);this._diffState$.next({...n,allDiffsResolved:a,pendingDiffs:s})}updateDiffStateToRun(e,t){const o=this._diffState$.value,n=new Map(o.pendingDiffs),s=n.get(e);s&&n.set(e,{...s,approved:!0,userDecision:"run"}),this._diffState$.next({...o,pendingDiffs:n,notebookPath:null!=t?t:o.notebookPath})}addPendingDiff(e,t){var o;const n=this._diffState$.value,s=new Map(n.pendingDiffs);s.set(e,t);const i=this.checkIfAllDiffsResolved(s,t.notebookPath);this._diffState$.next({...n,pendingDiffs:s,allDiffsResolved:i,notebookPath:null!==(o=t.notebookPath)&&void 0!==o?o:n.notebookPath})}removePendingDiff(e,t){const o=this._diffState$.value,n=new Map(o.pendingDiffs);n.delete(e);const s=this.checkIfAllDiffsResolved(n,t);this._diffState$.next({...o,pendingDiffs:n,allDiffsResolved:s,notebookPath:null!=t?t:o.notebookPath})}clearAllDiffs(e){const t=this._diffState$.value;let o;if(e){o=new Map;for(const[n,s]of t.pendingDiffs)s.notebookPath!==e&&o.set(n,s)}else o=new Map;this._diffState$.next({...t,pendingDiffs:o,allDiffsResolved:0===o.size,notebookPath:null!=e?e:t.notebookPath})}setNotebookPath(e){const t=this._diffState$.value;this._diffState$.next({...t,notebookPath:e})}getPendingDiffCount(e){const t=this._diffState$.value;let o=0;for(const[,n]of t.pendingDiffs)e&&n.notebookPath!==e||n.userDecision||o++;return o}getApprovedDiffCount(e){const t=this._diffState$.value;let o=0;for(const[,n]of t.pendingDiffs)e&&n.notebookPath!==e||!0!==n.approved&&"approved"!==n.userDecision&&"run"!==n.userDecision||o++;return o}getRejectedDiffCount(e){const t=this._diffState$.value;let o=0;for(const[,n]of t.pendingDiffs)e&&n.notebookPath!==e||!1!==n.approved&&"rejected"!==n.userDecision||o++;return o}areAllDiffsApproved(e){const t=this._diffState$.value,o=[];for(const[,n]of t.pendingDiffs)e&&n.notebookPath!==e||o.push(n);return 0===o.length||o.every(e=>!0===e.approved||"approved"===e.userDecision||"run"===e.userDecision)}areAllDiffsRejected(e){const t=this._diffState$.value,o=[];for(const[,n]of t.pendingDiffs)e&&n.notebookPath!==e||o.push(n);return 0!==o.length&&o.every(e=>!1===e.approved||"rejected"===e.userDecision)}getDiffCountChanges$(e){return this._diffState$.pipe((0,C.map)(t=>{let o=0;for(const[,n]of t.pendingDiffs)e&&n.notebookPath!==e||o++;return o}),(0,C.distinctUntilChanged)())}getApprovalStatusChanges$(e){return this._diffState$.pipe((0,C.map)(t=>{let o=0,n=0,s=0;for(const[,i]of t.pendingDiffs)e&&i.notebookPath!==e||(!0===i.approved||"approved"===i.userDecision||"run"===i.userDecision?n++:!1===i.approved||"rejected"===i.userDecision?s++:o++);return{pending:o,approved:n,rejected:s,allResolved:o+n+s>0&&0===o}}),(0,C.distinctUntilChanged)((e,t)=>JSON.stringify(e)===JSON.stringify(t)))}checkIfAllDiffsResolved(e,t){let o=[];for(const[,n]of e)t&&n.notebookPath!==t||o.push(n);if(0===o.length)return!0;for(const e of o)if("run"===e.userDecision&&!e.runResult)return!1;return o.every(e=>void 0!==e.approved||"approved"===e.userDecision||"rejected"===e.userDecision||"run"===e.userDecision)}}j.instance=null;const F=j.getInstance();class V{static initializeConversation(e,t,o=[],n="agent"){var s;console.log(`[ConversationService] Processing conversation for notebook: ${e.notebookPath||"unknown"}`),e.loadingManager.updateLoadingIndicator(),null===(s=e.toolService.notebookTools)||void 0===s||s.refresh_ids();let i=t;return e.templates&&e.templates.length>0&&(i=[...e.templates.map(e=>({role:"user",content:`I'm providing the template "${e.name}" as additional context for our conversation:\n\n${e.content}`})),...t],e.templates.length=0),{preparedMessages:i,tools:"ask"===n?e.toolService.getAskModeTools():e.toolService.getTools()}}static async sendMessageWithStreaming(e,t,o,s,i,a,r){return await e.chatService.sendMessage(t,o,s,i,async(t,o)=>{e.chatService.getRequestStatus()!==n.CANCELLED&&(e.messageComponent.addErrorMessage(`API request failed: ${t.message}. Retrying in 5 seconds... (Attempt ${o})`),e.loadingManager.updateLoadingIndicator("Waiting to retry..."))},()=>e.notebookStateService.fetchNotebookState(),t=>{e.chatService.getRequestStatus()!==n.CANCELLED&&(e.loadingManager.removeLoadingIndicator(),a.currentStreamingMessage||(a.currentStreamingMessage=e.messageComponent.addStreamingAIMessage()),e.messageComponent.updateStreamingMessage(a.currentStreamingMessage,t))},t=>{console.log("[ConversationService] Tool use detected:",t),e.chatService.getRequestStatus()!==n.CANCELLED&&(e.loadingManager.removeLoadingIndicator(),a.currentStreamingToolCall||(a.currentStreamingToolCall=e.messageComponent.addStreamingToolCall()),V.handleToolUseStreaming(e,t,a))},e.toolService.getContextManager(),e.notebookPath,r)}static handleToolUseStreaming(e,t,o){"tool_use_delta"===t.type?V.handleToolUseDelta(e,t,o):"tool_use"===t.type?V.handleToolUseStart(e,t,o):"tool_use_stop"===t.type&&V.handleToolUseStop(e,t,o)}static handleToolUseDelta(e,t,o){if(!o.streamingToolCall)return;o.streamingToolCall.accumulatedInput+=t.input_delta;const n=o.streamingToolCall.accumulatedInput.match(/"(?:source|new_source|updated_plan_string)"\s*:\s*"((?:[^"\\]|\\.)*)/),s={type:"tool_use",id:t.id,name:o.streamingToolCall.name,input:{is_streaming:!0,updated_plan_string:void 0,new_source:void 0,source:void 0,cell_id:void 0}};if(n&&n[1])try{const i=JSON.parse(`"${n[1]}"`);V.handleRealTimeNotebookUpdates(e,o.streamingToolCall,i,s,t),e.messageComponent.updateStreamingToolCall(o.currentStreamingToolCall,s)}catch(e){}}static handleToolUseStart(e,t,o){var n;o.streamingToolCall={id:t.id,name:t.name,accumulatedInput:""};const s=null===(n=v.getChatContainerSafe())||void 0===n?void 0:n.chatWidget.llmStateDisplay;s&&!s.isDiffState()&&s.showTool(t.name),e.messageComponent.updateStreamingToolCall(o.currentStreamingToolCall,t)}static handleToolUseStop(e,t,o){var n,s,i,a,r;e.messageComponent.updateStreamingToolCall(o.currentStreamingToolCall,t),"notebook-edit_cell"===t.name&&(null===(n=e.toolService.notebookTools)||void 0===n||n.edit_cell({cell_id:t.input.cell_id,new_source:t.input.new_source||"",summary:t.input.summary||"",is_tracking_id:!0,notebook_path:e.notebookPath}),null===(s=e.diffManager)||void 0===s||s.trackEditCell(t.input.cell_id,o.streamingToolCall.originalContent||"",t.input.new_source,t.input.summary,e.notebookPath)),"notebook-add_cell"===t.name&&(null===(i=e.toolService.notebookTools)||void 0===i||i.edit_cell({cell_id:o.streamingToolCall.cellId,new_source:t.input.source||"",summary:t.input.summary||"",is_tracking_id:!0,notebook_path:e.notebookPath}),null===(a=e.diffManager)||void 0===a||a.trackAddCell(o.streamingToolCall.cellId,t.input.source,t.input.summary)),"notebook-edit_plan"===t.name&&(null===(r=e.toolService.notebookTools)||void 0===r||r.edit_plan({updated_plan_string:t.input.updated_plan_string,current_step_string:t.input.current_step_string,next_step_string:t.input.next_step_string,notebook_path:e.notebookPath}))}static handleRealTimeNotebookUpdates(e,t,o,n,s){var i;const a="notebook-add_cell"===t.name,r="notebook-edit_cell"===t.name;"notebook-edit_plan"===t.name&&(null===(i=e.toolService.notebookTools)||void 0===i||i.stream_edit_plan({partial_plan:o,notebook_path:e.notebookPath}),n.input.updated_plan_string=o),a&&V.handleAddCellStreaming(e,t,o,n,s),r&&V.handleEditCellStreaming(e,t,o,n,s)}static handleAddCellStreaming(e,t,o,n,s){var i,a;const r=t.accumulatedInput.match(/"cell_type"\s*:\s*"([^"]*)"/),l=r?r[1]:null,c=t.accumulatedInput.match(/"summary"\s*:\s*"([^"]*)"/),d=c?c[1]:"Cell being created by AI...";if(l&&["code","markdown","raw"].includes(l))if(t.cellId)null===(a=e.toolService.notebookTools)||void 0===a||a.edit_cell({cell_id:t.cellId,summary:d,new_source:o,is_tracking_id:!0,notebook_path:e.notebookPath});else{const a=null===(i=e.toolService.notebookTools)||void 0===i?void 0:i.add_cell({cell_type:l,summary:d,source:o,notebook_path:e.notebookPath});n.input.source=o,n.input.cell_id=t.cellId,t.cellId=a,t.toolResult={type:"tool_result",tool_use_id:s.id,content:a||""}}}static handleEditCellStreaming(e,t,o,n,s){var i,a;if(!t.cellId){const o=/"cell_id"\s*:\s*"([^"]*)"/,n=t.accumulatedInput.match(o);if(n&&n[1]&&(t.cellId=n[1],e.diffManager&&!t.originalContent))try{const o=null===(i=e.toolService.notebookTools)||void 0===i?void 0:i.findCellByAnyId(t.cellId,e.notebookPath);o&&(t.originalContent=o.cell.model.sharedModel.getSource()||"",t.originalSummary=o.cell.model.sharedModel.metadata.custom.summary||"")}catch(e){console.warn("Could not get original content for diff:",e)}}if(t.cellId){let i=o;t.originalContent&&(i=o.length<t.originalContent.length?o+t.originalContent.substring(o.length):o);const r=null===(a=e.toolService.notebookTools)||void 0===a?void 0:a.edit_cell({cell_id:t.cellId,new_source:i,summary:t.summary||"Cell being updated by AI...",is_tracking_id:t.cellId.startsWith("cell_"),notebook_path:e.notebookPath});t.toolResult={type:"tool_result",tool_use_id:s.id,content:r?"true":"false"},n.input.new_source=o,n.input.cell_id=t.cellId}}static async finalizeStreamingElements(e,t,o){var n;if((null==t?void 0:t.cancelled)||e.chatService.isRequestCancelled())return console.log("Response processing skipped due to cancellation"),V.cleanupStreamingElements(e,o),void e.loadingManager.removeLoadingIndicator();if(!0===t.needsFreshContext)return void e.loadingManager.removeLoadingIndicator();o.currentStreamingMessage&&await e.messageComponent.finalizeStreamingMessage(o.currentStreamingMessage);const s=null===(n=v.getChatContainerSafe())||void 0===n?void 0:n.chatWidget.llmStateDisplay;o.currentStreamingToolCall?(e.messageComponent.finalizeStreamingToolCall(o.currentStreamingToolCall),s&&!s.isDiffState()&&(s.show("Generating..."),s.hide())):null==s||s.hide()}static addUsageInformation(e,t){if(!U.SAGE_TOKEN_MODE)return;console.log("Sage Token Mode is enabled, adding usage message"),console.log("Response usage:",t);let o=0,n=0,s=0,i=0;for(const t of e.messageComponent.getMessageHistory())"string"==typeof t.content?"assistant"===t.role?n+=1:o+=1:"assistant"===t.role?s+=1:i+=1;e.messageComponent.addSystemMessage(`cache_input_tokens: ${t.usage.cache_creation_input_tokens}, cache_read_tokens: ${t.usage.cache_read_input_tokens} \n\n       input_tokens: ${t.usage.input_tokens}, output_tokens: ${t.usage.output_tokens} \n\n       user_messages: ${o}, assistant_responses: ${n} \n\n       tool_calls: ${s}, tool_results: ${i} \n`)}static async processToolCalls(e,t,o,n,s){let i=!1;if(!t.content||0===t.content.length)return{hasToolCalls:i,shouldContinue:!0};for(const a of t.content){if(e.chatService.isRequestCancelled())return console.log("Request was cancelled, stopping tool processing"),e.loadingManager.removeLoadingIndicator(),{hasToolCalls:i,shouldContinue:!1};if("tool_use"===a.type){if(i=!0,e.isActiveToolExecution=!0,!await V.processSingleToolCall(e,a,o,n,s))return{hasToolCalls:i,shouldContinue:!1};o.streamingToolCall=void 0}}return{hasToolCalls:i,shouldContinue:!0}}static async processSingleToolCall(e,t,o,s,i){var a;const r=t.name,l=t.input;console.log(`AI wants to use tool: ${r}`);const c=await V.captureActionState(e,r,l,o);if(("notebook-run_cell"===r||"notebook-execute_cell"===r)&&!await V.handleCodeExecution(e,t,i))return!1;const d=null===(a=v.getChatContainerSafe())||void 0===a?void 0:a.chatWidget.llmStateDisplay;d&&!d.isDiffState()&&d.showTool(r);const h=o.streamingToolCall&&o.streamingToolCall.toolResult?o.streamingToolCall.toolResult:await V.processToolCall(e,{id:t.id,name:r,input:l});if(e.isActiveToolExecution=!1,d&&!d.isDiffState()&&d.show("Generating..."),V.trackActionForUndo(e,r,l,h,c),e.chatService.getRequestStatus()===n.CANCELLED)return console.log("Request was cancelled, skipping tool result display"),!1;if(e.messageComponent.addToolResult(r,t.id,h.content,null==t?void 0:t.input),e.chatService.getRequestStatus()===n.CANCELLED)return!1;const u={role:"assistant",content:[t]};return e.chatService.addToolResult(u,h),e.chatService.getRequestStatus()===n.CANCELLED?(console.log("Request was cancelled, skipping further processing"),!1):"notebook-wait_user_reply"!==r?(null==d||d.hidePendingDiffs(),null==d||d.show("Generating..."),!0):(null==d||d.show("Waiting for your reply...",!0),!1)}static async captureActionState(e,t,o,n){var s,i;if("notebook-edit_cell"===t)try{const t=await e.toolService.executeTool({id:"get_cell_before_edit",name:"notebook-get_cell_info",input:{cell_id:o.cell_id}});if(t&&t.content)return{originalCell:JSON.parse(t.content),originalContent:(null===(s=n.streamingToolCall)||void 0===s?void 0:s.originalContent)||"",originalSummary:(null===(i=n.streamingToolCall)||void 0===i?void 0:i.originalSummary)||"",newSource:o.new_source,cellId:o.cell_id,cell_id:o.cell_id,summary:o.summary}}catch(e){console.error("Failed to get cell info before edit:",e)}else if("notebook-remove_cells"===t)try{const t=(o.cell_ids||[]).map(t=>e.toolService.executeTool({id:`get_cell_before_remove_${t}`,name:"notebook-get_cell_info",input:{cell_id:t}})),n=(await Promise.all(t)).map(e=>e&&e.content?JSON.parse(e.content):null).filter(e=>null!==e);if(n.length>0)return{removedCells:n}}catch(e){console.error("Failed to get cell info before removal:",e)}return null}static async handleCodeExecution(e,t,o){var n,s,i,a,r,l,c;if(e.loadingManager.removeLoadingIndicator(),await V.checkPendingDiffsBeforeCodeExecution(e),null===(n=e.diffManager)||void 0===n?void 0:n.hasRejectedDiffs())return e.messageComponent.addSystemMessage("❌ Changes were rejected. Code execution has been cancelled."),(null===(s=t.input)||void 0===s?void 0:s.cell_id)&&e.messageComponent.addToolResult("notebook-run_cell",t.id,"User rejected changes, cell was not added or executed.",{cell_id:null===(i=t.input)||void 0===i?void 0:i.cell_id,notebook_path:e.notebookPath}),j.getInstance().clearAllDiffs(),!1;if(V.checkForApprovalDecisions(e,null===(a=t.input)||void 0===a?void 0:a.cell_id)){console.log("[ConversationService] User made approval decisions - stopping LLM loop");const o=null===(r=t.input)||void 0===r?void 0:r.cell_id;console.log(`REQUESTED CELL ${o} WAS NOT EXECUTED DURING DIFF APPROVAL`);const n={type:"tool_result",tool_use_id:t.id,content:"user accepted changes but did not run the cell."};e.messageComponent.addToolResult("notebook-run_cell",t.id,n.content,{cell_id:o,notebook_path:e.notebookPath});const s={role:"assistant",content:[{type:"tool_use",id:t.id,name:"notebook-run_cell",input:{cell_id:o,notebook_path:e.notebookPath}}]};return e.chatService.addToolResult(s,n),!1}const d=await V.checkExecutedCells(e,t.id,null===(l=t.input)||void 0===l?void 0:l.cell_id);if(console.log("[ConversationService] Executed approved cells:",d),d)return!0;if(e.diffManager&&t.input.cell_id){const o=e.diffManager.getCurrentCellId(t.input.cell_id);o!==t.input.cell_id&&(console.log(`Updating cell ID for execution: ${t.input.cell_id} → ${o}`),t.input.cell_id=o)}let h=!1;if(e.autoRun)h=!0,e.messageComponent.addSystemMessage("Automatically running code (auto-run is enabled).");else if(e.diffManager&&e.diffManager.shouldRunImmediately())h=!0,e.messageComponent.addSystemMessage("Running code immediately after approving changes.");else{const o=null===(c=v.getChatContainerSafe())||void 0===c?void 0:c.chatWidget.llmStateDisplay;o&&o.showRunCellTool(()=>e.codeConfirmationDialog.triggerApproval(),()=>e.codeConfirmationDialog.triggerRejection()),h=await e.codeConfirmationDialog.showConfirmation(t.input.cell_id||t.input.cellId||""),h?null==o||o.show():(null==o||o.hide(),e.messageComponent.removeLoadingText())}return!!h&&(e.loadingManager.updateLoadingIndicator(),!0)}static async processToolCall(e,t){const o={...t,input:{...t.input,notebook_path:e.notebookPath}};return await e.toolService.executeTool(o,3,!0)}static trackActionForUndo(e,t,o,n,s){var i;if("notebook-add_cell"===t&&n&&n.content)try{const t=n.content.replace(/"/g,"").trim();e.actionHistory.addAction(S.ADD_CELL,{cellId:t,...o},`Added ${o.cell_type} cell`)}catch(e){console.error("Failed to track add_cell action:",e)}else if("notebook-edit_cell"===t&&s)e.actionHistory.addAction(S.EDIT_CELL,s,`Edited cell ${o.cell_id.substring(0,8)}...`);else if("notebook-remove_cells"===t&&s&&(e.actionHistory.addAction(S.REMOVE_CELLS,s,`Removed ${o.cell_ids.length} cell(s)`),e.diffManager&&s.removedCells))for(const t of s.removedCells)t&&(t.id||t.trackingId)&&e.diffManager.trackRemoveCell(t.trackingId||t.id,t.content||"",(null===(i=t.custom)||void 0===i?void 0:i.summary)||"Removed by AI")}static async handlePendingDiffsAfterToolCalls(e,t){var o;if(t&&e.diffManager&&e.diffManager.hasPendingDiffs()){e.isActiveToolExecution=!0;const t=null===(o=v.getChatContainerSafe())||void 0===o?void 0:o.chatWidget.llmStateDisplay;t&&t.showPendingDiffs(e.notebookPath),await V.checkPendingDiffs(e),e.isActiveToolExecution=!1}return!0}static async checkPendingDiffs(e){var t;if(!e.diffManager||!e.diffManager.hasPendingDiffs())return!0;if(e.autoRun){e.messageComponent.addSystemMessage(`Auto-approving ${e.diffManager.getPendingDiffCount()} changes (auto-run is enabled).`);for(const e of j.getInstance().getCurrentState().pendingDiffs.values()){console.log("RUNNING DIFF IN AUTO APPROVE MODE:",e.cellId);try{await(null===(t=v.getState().notebookDiffManager)||void 0===t?void 0:t.diffApprovalDialog.runCell(e.cellId))}catch(t){console.error("Error running cell in auto-approve mode:",e.cellId,t)}}return!0}e.diffManager.startDiffApprovalProcess(e.chatHistory,!0,!1,e.notebookPath||void 0);const o=await e.diffManager.waitForDiffProcessingComplete();return e.messageComponent.scrollToBottom(),o!==s.REJECTED}static async checkPendingDiffsBeforeCodeExecution(e){var t;if(!e.diffManager||!e.diffManager.hasPendingDiffs())return!0;if(e.autoRun){e.messageComponent.addSystemMessage(`Auto-approving ${e.diffManager.getPendingDiffCount()} changes (auto-run is enabled).`);for(const e of j.getInstance().getCurrentState().pendingDiffs.values()){console.log("RUNNING DIFF IN AUTO APPROVE MODE:",e.cellId);try{await(null===(t=v.getState().notebookDiffManager)||void 0===t?void 0:t.diffApprovalDialog.runCell(e.cellId))}catch(t){console.error("Error running cell in auto-approve mode:",e.cellId,t)}}return!0}e.diffManager.startDiffApprovalProcess(e.chatHistory,!0,!0,e.notebookPath||void 0);const o=await e.diffManager.waitForDiffProcessingComplete();return e.messageComponent.scrollToBottom(),o!==s.REJECTED}static async checkExecutedCells(e,t,o){if(console.log("CHECKING EXECUTED CELLS!"),!e.diffManager)return!1;const n=e.diffManager.getApprovedCellIds(e.notebookPath);if(0===n.length)return!1;const s=j.getInstance().getCurrentState();console.log("Current diff state:",s.pendingDiffs);const i=[];let a=!1;for(const e of n){const t=s.pendingDiffs.get(e);t&&"run"===t.userDecision&&t.runResult&&(console.log("CELL WAS ALREADY EXECUTED:",e,t.runResult),i.push({cellId:e,result:t.runResult}),o&&e===o&&(a=!0))}if(o&&!a)return console.log(`REQUESTED CELL ${o} WAS NOT EXECUTED DURING DIFF APPROVAL`),!1;if(0===i.length){console.log("NO CELLS WERE EXECUTED DURING DIFF APPROVAL");const n={type:"tool_result",tool_use_id:t,content:"User approved changes but did not run the cell at this time."};return e.messageComponent.addToolResult("notebook-run_cell",t,n.content,{cell_id:o,notebook_path:e.notebookPath}),!1}const r=o&&a?i.filter(e=>e.cellId===o):i;e.messageComponent.addSystemMessage(o&&a?`Cell ${o} was executed during diff approval.`:`${r.length} cells were executed during diff approval.`);for(const{cellId:o,result:n}of r){const s={type:"tool_result",tool_use_id:t,content:Array.isArray(n)?n.join("\n"):String(n)};e.messageComponent.addToolResult("notebook-run_cell",t,s.content,{cell_id:o,notebook_path:e.notebookPath});const i={role:"assistant",content:[{type:"tool_use",id:t,name:"notebook-run_cell",input:{cell_id:o,notebook_path:e.notebookPath}}]};e.chatService.addToolResult(i,s)}return console.log("SKIPPING ORIGINAL TOOL EXECUTION - CELLS ALREADY RAN"),!0}static checkForApprovalDecisions(e,t){if(!e.diffManager)return!1;const o=j.getInstance().getCurrentState();for(const[e,n]of o.pendingDiffs)if(e===t&&"approved"===n.userDecision)return!0;return!1}static cleanupStreamingElements(e,t){t.currentStreamingMessage&&e.messageComponent.removeElement(t.currentStreamingMessage),t.currentStreamingToolCall&&e.messageComponent.removeElement(t.currentStreamingToolCall)}}class q{constructor(e,t,o,n,s,i,a,r){this.diffManager=null,this.isActiveToolExecution=!1,this.autoRun=!1,this.notebookPath=null,this.streamingElement=null,this.templates=[],this.chatService=e,this.toolService=t,this.messageComponent=n,this.chatHistory=s,this.loadingManager=i,this.actionHistory=new _,this.diffManager=a||null,this.contentManager=o,this.notebookStateService=new b(t),this.codeConfirmationDialog=new k(s,n,()=>{r&&r.click()}),this.syncChatServiceHistory()}updateNotebookPath(e){this.notebookPath=e,this.notebookStateService.updateNotebookPath(e)}syncChatServiceHistory(){this.chatService.resetConversationHistory();const e=this.messageComponent.getMessageHistory();for(const t of e)"assistant"===t.role?this.chatService.addToolResult({role:"assistant",content:t.content},null):"user"===t.role&&this.chatService.addToolResult(null,t.content);console.log(`Synchronized ${e.length} messages to chat service history`)}setAutoRun(e){this.autoRun=e,console.log("Auto-run mode "+(e?"enabled":"disabled"))}setDiffManager(e){this.diffManager=e,console.log("NotebookDiffManager set in ConversationService")}setNotebookPath(e){this.notebookPath=e,console.log(`[ConversationService] Set notebook path: ${e}`)}async handleCellRejection(e="agent"){this.messageComponent.addSystemMessage("Cell execution rejected. Asking for corrections based on user feedback...");const t=new w,o=await t.showDialog(),n={role:"user",content:`I rejected the previous cell execution because: ${o}`};this.messageComponent.addUserMessage(`I rejected the previous cell execution because: ${o}`),await this.processConversation([n],[],e)}async processToolCall(e){return await V.processToolCall({chatService:this.chatService,toolService:this.toolService,messageComponent:this.messageComponent,notebookStateService:this.notebookStateService,codeConfirmationDialog:this.codeConfirmationDialog,loadingManager:this.loadingManager,diffManager:this.diffManager,actionHistory:this.actionHistory,autoRun:this.autoRun,notebookPath:this.notebookPath,templates:this.templates,isActiveToolExecution:this.isActiveToolExecution,chatHistory:this.chatHistory},e)}async executeAllApprovedCells(e){return await V.checkExecutedCells({chatService:this.chatService,toolService:this.toolService,messageComponent:this.messageComponent,notebookStateService:this.notebookStateService,codeConfirmationDialog:this.codeConfirmationDialog,loadingManager:this.loadingManager,diffManager:this.diffManager,actionHistory:this.actionHistory,autoRun:this.autoRun,notebookPath:this.notebookPath,templates:this.templates,isActiveToolExecution:this.isActiveToolExecution,chatHistory:this.chatHistory},e)}async createErrorMessage(e){console.log("Creating error message dump..."),console.log(e);try{let t=!1;try{await this.contentManager.get("./error_dump.txt"),t=!0}catch(e){t=!1}t||await this.contentManager.save("./error_dump.txt",{type:"file",format:"text",content:""});let o=(await this.contentManager.get("./error_dump.txt")).content||"";o+=`\n\n---\n\n${(new Date).toISOString()}\n\n${e}`,await this.contentManager.save("./error_dump.txt",{type:"file",format:"text",content:o})}catch(e){console.error(e)}}async processConversation(e,t=[],o="agent"){var s;const i={chatService:this.chatService,toolService:this.toolService,messageComponent:this.messageComponent,notebookStateService:this.notebookStateService,codeConfirmationDialog:this.codeConfirmationDialog,loadingManager:this.loadingManager,diffManager:this.diffManager,actionHistory:this.actionHistory,autoRun:this.autoRun,notebookPath:this.notebookPath,templates:this.templates,isActiveToolExecution:this.isActiveToolExecution,chatHistory:this.chatHistory},a={currentStreamingMessage:null,currentStreamingToolCall:null,streamingToolCall:void 0};try{const{preparedMessages:r,tools:l}=V.initializeConversation(i,e,t,o),c=await V.sendMessageWithStreaming(i,r,l,o,t,a,this.createErrorMessage.bind(this));if((null==c?void 0:c.cancelled)||this.chatService.isRequestCancelled())return console.log("Response processing skipped due to cancellation"),V.cleanupStreamingElements(i,a),void this.loadingManager.removeLoadingIndicator();if(!0===c.needsFreshContext)return this.loadingManager.removeLoadingIndicator(),void await this.handleCellRejection(o);if(await V.finalizeStreamingElements(i,c,a),this.chatService.getRequestStatus()===n.CANCELLED)return console.log("Request was cancelled, skipping tool call processing"),void this.loadingManager.removeLoadingIndicator();V.addUsageInformation(i,c);const{hasToolCalls:d,shouldContinue:h}=await V.processToolCalls(i,c,a,t,o);if(!h)return;if(d){if(V.checkForApprovalDecisions(i))return void console.log("[ConversationService] Approval decisions detected - stopping recursive LLM loop");let e=!1;for(const t of c.content||[])if("tool_use"===t.type&&"notebook-wait_user_reply"!==t.name){"notebook-run_cell"===t.name&&j.getInstance().clearAllDiffs(this.notebookPath),e=!0;break}if(e){const e=null===(s=v.getChatContainerSafe())||void 0===s?void 0:s.chatWidget.llmStateDisplay;null==e||e.hidePendingDiffs(),null==e||e.show("Generating..."),await this.processConversation([],t,o)}}await V.handlePendingDiffsAfterToolCalls(i,d),this.isActiveToolExecution=i.isActiveToolExecution}catch(e){if(this.chatService.isRequestCancelled())return console.log("Request was cancelled, skipping error handling"),V.cleanupStreamingElements(i,a),void this.loadingManager.removeLoadingIndicator();throw this.loadingManager.removeLoadingIndicator(),e}this.loadingManager.removeLoadingIndicator()}canUndo(){return this.actionHistory.canUndo()}getLastActionDescription(){return this.actionHistory.getLastActionDescription()}async undoLastAction(){const e=this.actionHistory.popLastAction();if(!e)return!1;try{switch(this.loadingManager.updateLoadingIndicator("Undoing action..."),e.type){case S.ADD_CELL:await this.undoAddCell(e);break;case S.EDIT_CELL:await this.undoEditCell(e);break;case S.REMOVE_CELLS:await this.undoRemoveCells(e)}return this.messageComponent.addSystemMessage(`✓ Undid action: ${e.description}`),this.loadingManager.removeLoadingIndicator(),!0}catch(e){return console.error("Error undoing action:",e),this.messageComponent.addErrorMessage(`Failed to undo action: ${e instanceof Error?e.message:"Unknown error"}`),this.loadingManager.removeLoadingIndicator(),!1}}async undoAddCell(e){const t=e.data.trackingId||e.data.cellId;await this.toolService.executeTool({id:"undo_add_cell",name:"notebook-remove_cells",input:{cell_ids:[t],remove_from_notebook:!0}})}async undoEditCell(e){const t=e.data.trackingId||e.data.cellId;await this.toolService.executeTool({id:"undo_edit_cell",name:"notebook-edit_cell",input:{cell_id:t,new_source:e.data.originalContent,summary:e.data.originalSummary||"Restored by undo",is_tracking_id:!0}})}async undoRemoveCells(e){var t,o;if(e.data.removedCells)for(let n=0;n<e.data.removedCells.length;n++){const s=e.data.removedCells[n],i=s.trackingId||`restored-${Date.now()}-${n}`;await this.toolService.executeTool({id:"undo_remove_cell",name:"notebook-add_cell",input:{cell_type:s.type,source:s.content,summary:(null===(t=s.custom)||void 0===t?void 0:t.summary)||"Restored by undo",position:null===(o=s.custom)||void 0===o?void 0:o.index,tracking_id:i}})}}clearActionHistory(){this.actionHistory.clear()}}var z=o(5256);class W{static getActiveModelType(){return this.activeModelType}static setActiveModelType(e){this.activeModelType=e}static getModelConfigurations(){return o(2915)}static async buildModelConfig(e,t,n){const s=this.getModelConfigurations()[e];if(!s)throw new Error(`Unknown model type: ${e}`);return{system_prompt:o(3687)(`./${this.getPromptFileName(e)}.md`),model_name:s.model_name,model_url:t,api_key:n,tool_blacklist:s.tool_blacklist||[]}}static getPromptFileName(e){switch(e){case"claude":default:return"claude_system_prompt";case"claude_ask_mode":return"claude_system_prompt_ask_mode";case"edit_selection":return"claude_system_prompt_edit_selection";case"edit_full_cell":return"claude_system_prompt_edit_full_cell";case"fast_mode":return"claude_system_prompt_fast_mode"}}static async getConfig(e="",t=""){try{if(!e||!t){const o=v.getClaudeSettings();e=e||o.claudeModelUrl,t=t||o.claudeApiKey}return{claude:await this.buildModelConfig("claude",e,t),claude_ask_mode:await this.buildModelConfig("claude_ask_mode",e,t),edit_selection:await this.buildModelConfig("edit_selection",e,t),edit_full_cell:await this.buildModelConfig("edit_full_cell",e,t),fast_mode:await this.buildModelConfig("fast_mode",e,t),active_model_type:this.activeModelType}}catch(e){throw console.error("Error building configuration:",e),new Error(`Failed to build configuration: ${e}`)}}static async getTools(){return o(6316)}}W.activeModelType="claude";var G,J=o(135),K=o.n(J);class Y{static async createStream(e){const{client:t,modelName:o,messages:n,tools:s=[],systemPrompt:i,extraSystemMessages:a=[],abortSignal:r}=e,l=[{text:i,type:"text",cache_control:{type:"ephemeral"}},...a];return t.beta.messages.stream({model:o,messages:n,tools:s.length>0?s:void 0,max_tokens:4096,system:l,betas:["token-efficient-tools-2025-02-19"]},{signal:r,headers:{"no-cors":"true","sec-fetch-mode":"no-cors",mode:"no-cors"}})}static async processStream(e,t,o){var n;if(!e){const o=new Error("Message stream is undefined");throw await(null===(n=t.errorLogger)||void 0===n?void 0:n.call(t,{message:o.message,stream:e})),o}const s=this.initializeStreamContext();this.setupTextChunkHandler(e,t);try{if(await this.processStreamEvents(e,s,t),t.isRequestCancelled())return this.createCancelledResult();const n=await this.getFinalMessage(e,t);return this.updateConversationHistory(n,o),{...n,needsUserConfirmation:s.needsUserConfirmation}}catch(e){return this.handleStreamError(e,t,s)}}static initializeStreamContext(){return{toolUseInfo:null,needsUserConfirmation:!1,messageContent:[],deltaChunkBuffer:"",lastDeltaUpdateTime:0}}static setupTextChunkHandler(e,t){t.onTextChunk&&e.on("text",e=>{t.isRequestCancelled()||t.onTextChunk(e)})}static async processStreamEvents(e,t,o){var n;for await(const s of e){if(o.isRequestCancelled())return void await(null===(n=o.errorLogger)||void 0===n?void 0:n.call(o,{message:"Stream processing stopped due to cancellation",event:s,requestStatus:"CANCELLED"}));await this.handleStreamEvent(s,t,o)}}static async handleStreamEvent(e,t,o){switch(e.type){case"content_block_start":this.handleContentBlockStart(e,t,o);break;case"content_block_delta":this.handleContentBlockDelta(e,t,o);break;case"content_block_stop":await this.handleContentBlockStop(t,o)}}static handleContentBlockStart(e,t,o){"text"===e.content_block.type?t.messageContent.push({type:"text",text:""}):"tool_use"===e.content_block.type&&this.handleToolUseStart(e.content_block,t,o)}static handleToolUseStart(e,t,o){var n,s;t.toolUseInfo=e;const i={type:"tool_use",id:e.id,name:e.name,input:e.input};null===(n=o.onToolUse)||void 0===n||n.call(o,i),t.messageContent.push(i),null===(s=o.errorLogger)||void 0===s||s.call(o,{message:"Tool call being generated",toolUseInfo:e}),"execute_cell"!==e.name&&"edit_cell"!==e.name||(t.needsUserConfirmation=!0)}static handleContentBlockDelta(e,t,o){"text_delta"===e.delta.type?this.handleTextDelta(e.delta,t):"input_json_delta"===e.delta.type&&this.handleInputJsonDelta(e.delta,t,o)}static handleTextDelta(e,t){for(let o=t.messageContent.length-1;o>=0;o--)if("text"===t.messageContent[o].type){t.messageContent[o].text+=e.text;break}}static handleInputJsonDelta(e,t,o){for(let n=t.messageContent.length-1;n>=0;n--)if("tool_use"===t.messageContent[n].type){this.processInputJsonDelta(e,t,o,n);break}}static processInputJsonDelta(e,t,o,n){const s=Date.now(),i=e.partial_json;t.deltaChunkBuffer+=i,(t.deltaChunkBuffer.length>=this.DELTA_CHUNK_THRESHOLD||s-t.lastDeltaUpdateTime>=this.DELTA_UPDATE_INTERVAL)&&o.onToolUse&&(o.onToolUse({type:"tool_use_delta",id:t.messageContent[n].id,name:t.messageContent[n].name,input_delta:t.deltaChunkBuffer}),t.deltaChunkBuffer="",t.lastDeltaUpdateTime=s),t.messageContent[n].partialInput||(t.messageContent[n].partialInput=""),t.messageContent[n].partialInput+=i}static async handleContentBlockStop(e,t){e.deltaChunkBuffer.length>0&&t.onToolUse&&this.flushDeltaBuffer(e,t),await this.processFinalToolInput(e,t)}static flushDeltaBuffer(e,t){for(let o=e.messageContent.length-1;o>=0;o--)if("tool_use"===e.messageContent[o].type){t.onToolUse({type:"tool_use_delta",id:e.messageContent[o].id,name:e.messageContent[o].name,input_delta:e.deltaChunkBuffer});break}e.deltaChunkBuffer=""}static async processFinalToolInput(e,t){var o;try{const n=e.messageContent.find(e=>"tool_use"===e.type&&e.partialInput);if(!(null==n?void 0:n.partialInput))return;const s=n.partialInput;if(!s.trim().startsWith("{")||!s.trim().endsWith("}"))return;const i=JSON.parse(s);e.toolUseInfo&&e.toolUseInfo.id==e.toolUseInfo.id&&(e.toolUseInfo.input=i,null===(o=t.onToolUse)||void 0===o||o.call(t,{type:"tool_use_stop",id:e.toolUseInfo.id,name:e.toolUseInfo.name,input:i}))}catch(t){console.log("[AnthropicStreamHandler] Could not parse final input:",{messageContent:e.messageContent,parseError:t})}}static async getFinalMessage(e,t){var o;try{return await e.finalMessage()}catch(e){const n={message:"Error getting final message from stream",error:e instanceof Error?e.message:e};throw await(null===(o=t.errorLogger)||void 0===o?void 0:o.call(t,n)),e}}static updateConversationHistory(e,t){var o;if((null===(o=null==e?void 0:e.content)||void 0===o?void 0:o[0])&&void 0!==e.content[0].text){const o={role:"assistant",content:e.content[0].text};t.push(o)}}static createCancelledResult(){return{cancelled:!0,role:"assistant",content:[]}}static async handleStreamError(e,t,o){var n,s;if("AbortError"===e.name||t.isRequestCancelled())return await(null===(n=t.errorLogger)||void 0===n?void 0:n.call(t,{message:"Stream processing aborted due to cancellation",error:e instanceof Error?e.message:e})),this.createCancelledResult();throw await(null===(s=t.errorLogger)||void 0===s?void 0:s.call(t,{message:"Error during stream processing",error:e instanceof Error?e.message:e,messageContent:o.messageContent,toolUseInfo:o.toolUseInfo,needsUserConfirmation:o.needsUserConfirmation})),e}}Y.DELTA_CHUNK_THRESHOLD=30,Y.DELTA_UPDATE_INTERVAL=100;class Z{static async createMessageStream(e,t,o){const n=await this.prepareMessages(e,t,o);return e.client.beta.messages.stream({model:e.modelName,messages:[...n.initialMessages,...n.filteredHistory],tools:n.availableTools.length>0?n.availableTools:void 0,max_tokens:4096,system:[{text:n.systemPrompt,type:"text",cache_control:{type:"ephemeral"}},...n.extraSystemMessages],betas:["token-efficient-tools-2025-02-19"]},{signal:e.abortSignal,headers:{"no-cors":"true","sec-fetch-mode":"no-cors",mode:"no-cors"}})}static async prepareMessages(e,t,o){const n=await this.getNotebookContext(e),s=o(this.prepareInitialMessages(n),e.errorLogger),i=o(t,e.errorLogger),a=this.determineSystemPrompt(e);return{initialMessages:s,filteredHistory:i,availableTools:this.filterTools(e),systemPrompt:a,extraSystemMessages:await this.prepareExtraSystemMessages(e)}}static async getNotebookContext(e){var t;try{if(e.notebookContextManager&&e.notebookPath)return e.notebookContextManager.formatContextAsMessage(e.notebookPath)}catch(o){await(null===(t=e.errorLogger)||void 0===t?void 0:t.call(e,{message:"Error getting notebook context",error:o instanceof Error?o.message:o,notebookPath:e.notebookPath,notebookContextManager:!!e.notebookContextManager}))}return""}static prepareInitialMessages(e){const t=[];return e&&""!==e.trim()&&t.push({role:"user",content:e}),t}static determineSystemPrompt(e){return"ask"===e.mode?e.systemPromptAskMode:"fast"===e.mode?e.systemPromptFastMode:e.systemPrompt}static filterTools(e){return e.isFastMode&&e.toolBlacklist.length>0?e.tools.filter(t=>t.name&&!e.toolBlacklist.includes(t.name)):e.tools}static async prepareExtraSystemMessages(e){var t;const o=[];if(e.systemPromptMessages&&o.push(...e.systemPromptMessages.map(e=>({text:e,type:"text"}))),e.fetchNotebookState)try{const t=await e.fetchNotebookState();t&&o.push({type:"text",text:`This is the current notebook summary with edit history: ${t}`})}catch(o){await(null===(t=e.errorLogger)||void 0===t?void 0:t.call(e,{message:"Error fetching notebook state",error:o instanceof Error?o.message:o,fetchNotebookState:!!e.fetchNotebookState}))}return o}}class Q{static isToolRelatedMessage(e){try{return Q.isToolUseMessage(e)||Q.isToolResultMessage(e)}catch(t){return console.error("Error in isToolRelatedMessage:",t,{message:e}),!1}}static isToolUseMessage(e){return"assistant"===e.role&&Array.isArray(e.content)&&e.content.length>0&&"tool_use"===e.content[0].type}static isToolResultMessage(e){return"user"===e.role&&Array.isArray(e.content)&&e.content.length>0&&"tool_result"===e.content[0].type}static filterToolMessages(e,t){try{const o=Q.buildCleanedConversationHistory(e,t),n=[],s=[],i=[];if(o.forEach((e,t)=>{Q.isToolRelatedMessage(e)&&(n.push(t),Q.isToolUseMessage(e)&&s.push(t),Q.isToolResultMessage(e)&&i.push(t))}),s.length<=10)return[...o];const a=s.slice(s.length-10),r=new Set;for(const e of a){r.add(e);const t=i.find(t=>t>e);void 0!==t&&r.add(t)}return o.filter((e,t)=>!Q.isToolRelatedMessage(e)||r.has(t))}catch(o){return t&&t(`Error in filterToolMessages: ${o}, messages: ${JSON.stringify(e)}`),console.error("Error in filterToolMessages:",o,{messagesLength:e.length}),[...e]}}static normalizeMessageContent(e,t){try{let o=e.map(e=>{const t={...e};return Q.isToolRelatedMessage(t)||Array.isArray(t.content)&&t.content.every(e=>"string"==typeof e||"number"==typeof e||"boolean"==typeof e)&&(t.content=t.content.join(" ")),t});return Q.buildCleanedConversationHistory(o,t)}catch(o){return t&&t(`Error in normalizeMessageContent: ${o}, messages: ${JSON.stringify(e)}`),console.error("Error in normalizeMessageContent:",o,{messagesLength:null==e?void 0:e.length}),e}}static buildCleanedConversationHistory(e,t){try{const t=[];for(let o=0;o<e.length;o++){const n=e[o];if(Q.isToolUseMessage(n)){const s=e[o+1];Q.isToolResultMessage(s)?t.push(n):console.log("Removing unmatched assistant tool_use message:",JSON.stringify(n))}else if(Q.isToolResultMessage(n)){const e=t[t.length-1];if(Q.isToolUseMessage(e)){if(e.content[0].id===n.content[0].tool_use_id){const e={role:n.role,content:n.content.map(e=>({tool_use_id:e.tool_use_id,content:e.content,type:e.type}))};t.push(e)}else console.log("Removing unmatched user tool_result message:",JSON.stringify(n))}}else t.push(n)}return t}catch(o){return t&&t(`Error in buildCleanedConversationHistory: ${o}, messages: ${JSON.stringify(e)}`),console.error("Error in buildCleanedConversationHistory:",o,{messagesLength:null==e?void 0:e.length}),e}}static addMessagesToHistory(e,t){t.forEach(t=>{e.some(e=>JSON.stringify(e)===JSON.stringify(t))||e.push(t)})}static addToolResult(e,t,o){if(t&&"assistant"===t.role&&e.push(t),o){const t={role:"user",content:Array.isArray(o)?o:[o]};e.push(t)}}static async createCancelledResponse(e,t){const o={message:"Request was cancelled, skipping retry logic",requestStatus:t};return e&&await e(JSON.stringify(o)),{cancelled:!0,role:"assistant",content:[]}}}class X{constructor(){this.client=null,this.modelName="claude-3-7-sonnet-20250219",this.modelUrl="https://api.anthropic.com/v1/messages",this.requestStatus=n.IDLE,this.abortController=null,this.systemPrompt="",this.systemPromptAskMode="",this.systemPromptFastMode="",this.conversationHistory=[],this.isFastMode=!1,this.toolBlacklist=[]}async initialize(e){try{try{const t=await W.getConfig();console.log("Initializing Anthropic client with config:",t),e=t.claude.api_key,this.systemPrompt=t.claude.system_prompt,this.systemPromptAskMode=t.claude_ask_mode.system_prompt,this.systemPromptFastMode=t.fast_mode.system_prompt,this.modelName=t.claude.model_name,this.modelUrl=t.claude.model_url,this.toolBlacklist=t.fast_mode.tool_blacklist||[]}catch(e){console.log("AppState not available, falling back to config")}return e&&""!==e.trim()?(this.client=new(K())({apiKey:e,baseURL:this.modelUrl,dangerouslyAllowBrowser:!0}),this.resetConversationHistory(),!0):(this.client=null,!1)}catch(e){return console.error("Failed to initialize Anthropic client:",e),this.client=null,!1}}getToolBlacklist(){return[...this.toolBlacklist]}resetConversationHistory(){this.conversationHistory=[]}getConversationHistory(){return[...this.conversationHistory]}async refreshSystemPrompt(){try{const e=await W.getConfig();this.systemPrompt=e.claude.system_prompt,this.systemPromptAskMode=e.claude_ask_mode.system_prompt,this.systemPromptFastMode=e.fast_mode.system_prompt,this.toolBlacklist=e.fast_mode.tool_blacklist||[],console.log("System prompt loaded successfully from config")}catch(e){console.error("Failed to load system prompt from config:",e),this.systemPrompt="You are a world-class data scientist and quantitative analyst, highly proficient in exploratory data analysis, statistical and ML modeling, hypothesis testing, feature engineering, and efficient use of Jupyter notebooks.",this.systemPromptAskMode="You are a world-class data scientist and quantitative analyst, highly proficient in exploratory data analysis, statistical and ML modeling, hypothesis testing, feature engineering, and efficient use of Jupyter notebooks.",this.systemPromptFastMode="You are a world-class data scientist and quantitative analyst, optimized for speed and efficiency."}}isInitialized(){return null!==this.client}setModelName(e){this.modelName=e}getModelName(){return this.modelName}getRequestStatus(){return this.requestStatus}isRequestCancelled(){return this.requestStatus===n.CANCELLED}cancelRequest(){this.abortController&&(this.abortController.abort(),this.abortController=null,this.requestStatus=n.CANCELLED,console.log("Request cancelled by user"))}async sendMessage(e,t=[],o="agent",s,i,a,r,l,c,d,h,u=!1){this.validateClientInitialized(h),this.initializeRequest();const g=await this.processNewMessages(e,h);this.addMessagesToHistory(g);const p=await this.getFilteredHistory(h);try{const e=await this.executeStreamRequest(p,t,o,s,a,r,l,c,d,h);return this.isRequestCancelled()||(this.requestStatus=n.COMPLETED),e}catch(e){return await this.handleRequestError(e,i,p,t,o,s,a,r,l,c,d,h,u)}}async sendEphemeralMessage(e,t,o="claude-3-5-haiku-latest",n){if(!this.client)throw new Error("Anthropic client not initialized. Please set API key first.");try{if(n){const s=await this.client.messages.stream({model:o,max_tokens:4096,system:t,temperature:0,messages:[{role:"user",content:e}]});let i="";for await(const e of s)if("content_block_delta"===e.type&&"text_delta"===e.delta.type){const t=e.delta.text;i+=t,n(t)}return i}{const n=await this.client.messages.create({model:o,max_tokens:4096,system:t,messages:[{role:"user",content:e}]});let s="";for(const e of n.content)"text"===e.type&&(s+=e.text);return s}}catch(e){throw console.error("Ephemeral message error:",e),e}}async validateClientInitialized(e){if(!this.client){const t={message:"Anthropic client not initialized. Please set API key first.",variables:{client:this.client,modelName:this.modelName,modelUrl:this.modelUrl,requestStatus:this.requestStatus}};throw e&&await e(JSON.stringify(t)),new Error(t.message)}}initializeRequest(){this.requestStatus=n.PENDING,this.abortController=new AbortController}async processNewMessages(e,t){try{return Q.normalizeMessageContent(e,t)}catch(o){const n={message:"Error normalizing new messages",error:o instanceof Error?o.message:o,newMessages:e,variables:{modelName:this.modelName}};throw t&&await t(JSON.stringify(n)),o}}addMessagesToHistory(e){Q.addMessagesToHistory(this.conversationHistory,e)}async getFilteredHistory(e){try{return Q.filterToolMessages([...this.conversationHistory],e)}catch(t){const o={message:"Error filtering tool messages",error:t instanceof Error?t.message:t,conversationHistory:this.conversationHistory};throw e&&await e(JSON.stringify(o)),t}}async executeStreamRequest(e,t,o,n,s,i,a,r,l,c){const d=await this.createMessageStream(e,t,o,n,s,r,l,c);return await Y.processStream(d,{onTextChunk:i,onToolUse:a,errorLogger:c,isRequestCancelled:()=>this.isRequestCancelled()},this.conversationHistory)}async createMessageStream(e,t,o,n,s,i,a,r){try{return await Z.createMessageStream({client:this.client,modelName:this.modelName,systemPrompt:this.systemPrompt,systemPromptAskMode:this.systemPromptAskMode,systemPromptFastMode:this.systemPromptFastMode,isFastMode:this.isFastMode,toolBlacklist:this.toolBlacklist,mode:o,tools:t,systemPromptMessages:n,fetchNotebookState:s,notebookContextManager:i,notebookPath:a,abortSignal:this.abortController.signal,errorLogger:r},e,Q.normalizeMessageContent)}catch(e){const n={message:"Error creating message stream",error:e instanceof Error?e.message:e,variables:{modelName:this.modelName,isFastMode:this.isFastMode,mode:o,availableTools:t.map(e=>e.name)}};throw r&&await r(JSON.stringify(n)),e}}async handleRequestError(e,t,o,s,i,a,r,l,c,d,h,u,g=!1){if(this.isRequestCancelled())return Q.createCancelledResponse(u,this.requestStatus);if(await this.logRequestError(e,u,i,o),await this.shouldSkipRetry(e,g,u))throw e;if(t)return await this.executeRetry(t,e,o,s,i,a,r,l,c,d,h,u);throw this.requestStatus=n.ERROR,e}async logRequestError(e,t,o,n){const s={message:"Error calling Anthropic API",error:e instanceof Error?e.message:e,modelName:this.modelName,mode:o,isFastMode:this.isFastMode,filteredHistory:n,requestStatus:this.requestStatus};t&&await t(JSON.stringify(s))}async shouldSkipRetry(e,t,o){return"BadRequestError"===e.name&&400===e.status&&!t&&(this.requestStatus=n.ERROR,await(null==o?void 0:o({message:"Bad request (400) error - not retrying",error:e instanceof Error?e.message:e})),!0)}async executeRetry(e,t,o,s,i,a,r,l,c,d,h,u){this.requestStatus=n.RETRYING;try{if(await e(t,1),this.isRequestCancelled())return Q.createCancelledResponse(u,this.requestStatus);if(await this.waitForRetry(),this.isRequestCancelled())return Q.createCancelledResponse(u,this.requestStatus);this.abortController=new AbortController;const g=await this.executeStreamRequest(o,s,i,a,r,l,c,d,h,u);return this.isRequestCancelled()||(this.requestStatus=n.COMPLETED),g}catch(e){if(this.isRequestCancelled())return Q.createCancelledResponse(u,this.requestStatus);throw await(null==u?void 0:u({message:"Error during retry attempt",error:e instanceof Error?e.message:e,requestStatus:this.requestStatus})),this.requestStatus=n.ERROR,e}}async waitForRetry(){await new Promise(e=>{const t=setTimeout(e,5e3),o=setInterval(()=>{this.isRequestCancelled()&&(clearTimeout(t),clearInterval(o),e(null))},500);setTimeout(()=>clearInterval(o),5e3)})}addToolResult(e,t){Q.addToolResult(this.conversationHistory,e,t)}setSystemPrompt(e){this.systemPrompt=e}setToolBlacklist(e){this.toolBlacklist=Array.isArray(e)?[...e]:[]}}!function(e){e.ANTHROPIC="claude",e.GEMINI="gemini"}(G||(G={}));class ee{static createService(e){switch(e){case G.ANTHROPIC:case G.GEMINI:return new X;default:throw new Error(`Unknown service provider: ${e}`)}}}class te{static initialize(e){te.stateDB=e}static async getValue(e,t){if(!te.stateDB)return console.warn("[StateDBCachingService] State DB not initialized, using default value"),t;try{const o=`${te.NAMESPACE}:${e}`,n=await te.stateDB.fetch(o);return void 0!==n?n:t}catch(o){return console.warn(`[StateDBCachingService] Failed to get value '${e}':`,o),t}}static async setValue(e,t){if(te.stateDB)try{const o=`${te.NAMESPACE}:${e}`;await te.stateDB.save(o,t)}catch(t){console.error(`[StateDBCachingService] Failed to set value '${e}':`,t)}else console.warn("[StateDBCachingService] State DB not initialized, cannot set value")}static async removeValue(e){if(te.stateDB)try{const t=`${te.NAMESPACE}:${e}`;await te.stateDB.remove(t)}catch(t){console.error(`[StateDBCachingService] Failed to remove value '${e}':`,t)}else console.warn("[StateDBCachingService] State DB not initialized, cannot remove value")}static async getObjectValue(e,t){return te.getValue(e,t)}static async setObjectValue(e,t){return te.setValue(e,t)}static isAvailable(){return null!==te.stateDB}static async listKeys(){if(!te.stateDB)return[];try{return(await te.stateDB.list(te.NAMESPACE)).ids.map(e=>e.replace(`${te.NAMESPACE}:`,""))}catch(e){return console.error("[StateDBCachingService] Failed to list keys:",e),[]}}}te.stateDB=null,te.NAMESPACE="sage-agent";const oe="chatHistories";class ne{constructor(){this.notebookChats=new Map,this.currentNotebookPath=null,this.currentThreadId=null,this.STORAGE_KEY_PREFIX="sage-ai-chat-history-",this.notebookChatboxes=new Map,this.loadFromStorage()}updateNotebookPath(e,t){this.currentNotebookPath=t;const o=this.notebookChats.get(e)||[];this.notebookChats.set(t,o),this.notebookChats.delete(e),this.saveToStorage()}setCurrentNotebook(e){if(console.log(`[ChatHistoryManager] Setting current notebook: ${e}`),this.currentNotebookPath&&this.currentNotebookPath!==e&&this.hideChatbox(this.currentNotebookPath),this.currentNotebookPath=e,!this.notebookChats.has(e)){const t={id:this.generateThreadId(),name:"Default Chat",messages:[],lastUpdated:Date.now(),contexts:new Map,message_timestamps:new Map};this.notebookChats.set(e,[t]),this.saveToStorage()}const t=this.notebookChats.get(e),o=[...t].sort((e,t)=>t.lastUpdated-e.lastUpdated).find(e=>"New Chat"===e.name);return this.currentThreadId=o?o.id:t[0].id,this.showChatbox(e),this.getCurrentThread()}showChatbox(e){const t=this.notebookChatboxes.get(e);if(t&&t.chatbox){t.isVisible=!0;const e=t.chatbox.node;e&&(e.style.display="",e.classList.remove("hidden-chatbox"))}this.notebookChatboxes.forEach((t,o)=>{if(o!==e&&t.chatbox){t.isVisible=!1;const e=t.chatbox.node;e&&(e.style.display="none",e.classList.add("hidden-chatbox"))}})}hideChatbox(e){const t=this.notebookChatboxes.get(e);if(t&&t.chatbox){t.isVisible=!1;const e=t.chatbox.node;e&&(e.style.display="none",e.classList.add("hidden-chatbox"))}}hasChatbox(e){var t;return this.notebookChatboxes.has(e)&&!!(null===(t=this.notebookChatboxes.get(e))||void 0===t?void 0:t.chatbox)}getCurrentThread(){if(!this.currentNotebookPath||!this.currentThreadId)return null;const e=this.notebookChats.get(this.currentNotebookPath);return e&&e.find(e=>e.id===this.currentThreadId)||null}getCurrentNotebookThreads(){return this.currentNotebookPath&&this.notebookChats.get(this.currentNotebookPath)||[]}getThreadsForNotebook(e){return e&&this.notebookChats.has(e)?this.notebookChats.get(e)||[]:null}updateCurrentThreadContexts(e){if(!this.currentNotebookPath||!this.currentThreadId)return void console.warn("[ChatHistoryManager] Cannot update contexts: No active notebook or thread");const t=this.notebookChats.get(this.currentNotebookPath);if(!t)return void console.warn(`[ChatHistoryManager] No threads found for notebook: ${this.currentNotebookPath}`);const o=t.findIndex(e=>e.id===this.currentThreadId);-1!==o?(t[o].contexts=new Map(e),t[o].lastUpdated=Date.now(),this.saveToStorage()):console.warn(`[ChatHistoryManager] Thread with ID ${this.currentThreadId} not found`)}updateCurrentThreadMessages(e,t){var o,n;if(!this.currentNotebookPath||!this.currentThreadId)return void console.warn("[ChatHistoryManager] Cannot update messages: No active notebook or thread");const s=this.notebookChats.get(this.currentNotebookPath);if(!s)return void console.warn(`[ChatHistoryManager] No threads found for notebook: ${this.currentNotebookPath}`);const i=s.findIndex(e=>e.id===this.currentThreadId);if(-1!==i){try{for(const t of e)(null===(o=s[i].message_timestamps)||void 0===o?void 0:o.has)&&(null===(n=s[i].message_timestamps)||void 0===n?void 0:n.has(JSON.stringify(t)))||(s[i].message_timestamps.set(JSON.stringify(t),Date.now()),s[i].message_timestamps)}catch(e){return void console.log("[ChatHistoryManager] Error updating message timestamps for eval:",e)}s[i].messages=[...e],s[i].lastUpdated=Date.now(),t&&(s[i].contexts=new Map(t)),this.saveToStorage()}else console.warn(`[ChatHistoryManager] Thread with ID ${this.currentThreadId} not found`)}static getCleanMessageArrayWithTimestamps(e){return e.messages.map(t=>({...t,timestamp:e.message_timestamps.get(JSON.stringify(t))||Date.now()}))}clearCurrentThread(){this.updateCurrentThreadMessages([])}getNotebookPaths(){return Array.from(this.notebookChats.keys())}async saveToStorage(){try{const e={};for(const[t,o]of this.notebookChats.entries()){const n=o.map(e=>({...e,contexts:e.contexts?Object.fromEntries(e.contexts):{},message_timestamps:e.message_timestamps?Object.fromEntries(e.message_timestamps):{}}));e[t]=n}await te.setObjectValue(oe,e),console.log("[ChatHistoryManager] Saved chat histories to StateDB storage")}catch(e){console.error("[ChatHistoryManager] Error saving chat histories to StateDB storage:",e)}}async loadFromStorage(){try{await this.migrateFromSettingsRegistry();const e=await te.getObjectValue(oe,{});if(e&&Object.keys(e).length>0){this.notebookChats=new Map;for(const[t,o]of Object.entries(e)){const e=o.map(e=>({...e,contexts:e.contexts?new Map(Object.entries(e.contexts)):new Map,message_timestamps:e.message_timestamps?new Map(Object.entries(e.message_timestamps)):new Map}));this.notebookChats.set(t,e)}console.log("[ChatHistoryManager] Loaded chat histories from StateDB storage"),console.log(`[ChatHistoryManager] Loaded ${this.notebookChats.size} notebook chat histories`)}else console.log("[ChatHistoryManager] No stored chat histories found in StateDB")}catch(e){console.error("[ChatHistoryManager] Error loading chat histories from StateDB storage:",e),this.notebookChats=new Map}}async migrateFromSettingsRegistry(){try{const e=await T.getObjectSetting(D,{});e&&Object.keys(e).length>0&&(console.log("[ChatHistoryManager] Migrating chat histories from SettingsRegistry to StateDB"),await te.setObjectValue(oe,e),await T.setObjectSetting(D,{}),console.log("[ChatHistoryManager] Successfully migrated chat histories to StateDB"))}catch(e){console.error("[ChatHistoryManager] Error during migration from SettingsRegistry to StateDB:",e)}}generateThreadId(){return"thread-"+Date.now()+"-"+Math.random().toString(36).substring(2,9)}createNewThread(e="New Chat"){if(!this.currentNotebookPath)return console.warn("[ChatHistoryManager] Cannot create thread: No active notebook"),null;const t={id:this.generateThreadId(),name:e,messages:[],lastUpdated:Date.now(),contexts:new Map,message_timestamps:new Map},o=this.notebookChats.get(this.currentNotebookPath)||[];return this.notebookChats.set(this.currentNotebookPath,[...o,t]),this.currentThreadId=t.id,this.saveToStorage(),t}switchToThread(e){if(!this.currentNotebookPath)return null;const t=this.notebookChats.get(this.currentNotebookPath);if(!t)return null;const o=t.find(t=>t.id===e);return o?(this.currentThreadId=e,o):null}renameCurrentThread(e){if(!this.currentNotebookPath||!this.currentThreadId)return console.warn("[ChatHistoryManager] Cannot rename thread: No active notebook or thread"),!1;const t=this.notebookChats.get(this.currentNotebookPath);if(!t)return console.warn(`[ChatHistoryManager] No threads found for notebook: ${this.currentNotebookPath}`),!1;const o=t.findIndex(e=>e.id===this.currentThreadId);return-1===o?(console.warn(`[ChatHistoryManager] Thread with ID ${this.currentThreadId} not found`),!1):(t[o].name=e,this.saveToStorage(),console.log(`[ChatHistoryManager] Renamed thread ${this.currentThreadId} to "${e}"`),!0)}deleteThread(e){if(!this.currentNotebookPath)return console.warn("[ChatHistoryManager] Cannot delete thread: No active notebook"),!1;const t=this.notebookChats.get(this.currentNotebookPath);if(!t)return!1;const o=t.findIndex(t=>t.id===e);if(-1===o)return!1;if(t.splice(o,1),e===this.currentThreadId)if(t.length>0)this.currentThreadId=t[t.length-1].id;else{const e={id:this.generateThreadId(),name:"Default Chat",messages:[],lastUpdated:Date.now(),contexts:new Map,message_timestamps:new Map};t.push(e),this.currentThreadId=e.id}return this.saveToStorage(),console.log(`[ChatHistoryManager] Deleted thread ${e}`),!0}cleanupNotebook(e){this.notebookChatboxes.has(e)&&this.notebookChatboxes.delete(e)}getAllChatboxes(){return this.notebookChatboxes}}class se{constructor(e,t,o,n,s){var i;this.currentNotebookPath=null,this.templates=[],this.chatHistoryManager=e,this.messageComponent=t,this.chatService=o,this.threadNameDisplay=n,this.chatNode=s,this.initializeBanner(),this.updateThreadSelectorButtonText((null===(i=this.chatHistoryManager.getCurrentThread())||void 0===i?void 0:i.name)||"New Chat")}updateNotebookPath(e){this.currentNotebookPath=e}setNotebookPath(e){var t;this.currentNotebookPath=e,this.refreshBannerIfVisible(),this.updateThreadSelectorButtonText((null===(t=this.chatHistoryManager.getCurrentThread())||void 0===t?void 0:t.name)||"New Chat")}filterNewChatThreads(e){const t=e.filter(e=>"New Chat"===e.name);if(t.length<=1)return e;const o=t[0];return e.filter(e=>"New Chat"!==e.name||e.id===o.id)}updateThreadSelectorButtonText(e){const t=this.threadNameDisplay;t&&(t.textContent=e)}selectThread(e){var t,o,n;this.chatService.cancelRequest();const s=this.chatHistoryManager.switchToThread(e);s&&(this.messageComponent.loadFromThread(s),this.resetChatServiceHistory(),this.updateThreadSelectorButtonText(s.name),s.messages.length>0?null===(t=v.getState().chatContainer)||void 0===t||t.chatWidget.showHistoryWidget():null===(o=v.getState().chatContainer)||void 0===o||o.chatWidget.showNewChatDisplay(),null===(n=v.getState().chatContainer)||void 0===n||n.chatWidget.llmStateDisplay.hide(),this.clearDiffs())}createNewThread(){if(!this.currentNotebookPath)return null;const e=this.chatHistoryManager.getCurrentThread();if(e&&e.messages.length>0){const t=e.messages.find(e=>"user"===e.role&&"string"==typeof e.content);if(t&&"string"==typeof t.content){const e=this.paraphraseThreadName(t.content);this.chatHistoryManager.renameCurrentThread(e)}}const t=this.chatHistoryManager.createNewThread("New Chat");return t&&(this.messageComponent.loadFromThread(t),this.chatService.resetConversationHistory(),this.updateThreadSelectorButtonText("New Chat"),this.clearDiffs()),t}clearDiffs(){v.getNotebookDiffManager().rejectAndRevertDiffsImmediately()}resetChatServiceHistory(){this.chatService.resetConversationHistory();const e=this.chatHistoryManager.getCurrentThread();if(e&&e.messages.length>0){for(const t of e.messages)this.addMessageToServiceHistory(t);console.log(`Reset chat service history with ${e.messages.length} messages`)}}addMessageToServiceHistory(e){const t=this.chatService.getConversationHistory(),o=JSON.stringify(e);if(!t.some(e=>JSON.stringify(e)===o))if(Array.isArray(e.content)&&e.content.length>0)this.chatService.addToolResult("assistant"===e.role?e:null,"user"===e.role?e.content:null);else{const t={role:e.role,content:e.content};this.chatService.addToolResult("assistant"===e.role?t:null,"user"===e.role?t.content:null)}}paraphraseThreadName(e){const t=e.split(/\s+/);let o=t.slice(0,Math.min(8,t.length)).join(" ");return o.length>30&&(o=o.substring(0,27)+"..."),o}initializeBanner(){var e;this.bannerOverlay=document.createElement("div"),this.bannerOverlay.className="sage-ai-banner-overlay",this.bannerOverlay.style.display="none",this.leftSideBanner=document.createElement("div"),this.leftSideBanner.className="sage-ai-left-side-banner",this.leftSideBanner.innerHTML='\n      <div class="sage-ai-banner-header">\n        <h3>All Chats</h3>\n        <button class="sage-ai-icon-close sage-ai-icon-button-sm">×</button>\n      </div>\n      <div class="sage-ai-banner-content">\n        <div class="sage-ai-banner-threads"></div>\n      </div>\n    ',null===(e=this.leftSideBanner.querySelector(".sage-ai-icon-close"))||void 0===e||e.addEventListener("click",()=>{this.closeBanner()}),this.chatNode.appendChild(this.bannerOverlay),this.chatNode.appendChild(this.leftSideBanner),this.setupBannerEventHandlers()}setupBannerEventHandlers(){const e=this.leftSideBanner.querySelector(".sage-ai-banner-close");e&&e.addEventListener("click",()=>{this.closeBanner()}),this.bannerOverlay.addEventListener("click",()=>{this.closeBanner()})}openBanner(){this.bannerOverlay.style.display="block",this.bannerOverlay.offsetHeight,this.bannerOverlay.classList.add("visible"),this.leftSideBanner.style.display="block",this.leftSideBanner.offsetHeight,this.leftSideBanner.classList.add("visible"),this.populateBannerContent()}closeBanner(){this.leftSideBanner.classList.remove("visible"),this.bannerOverlay.classList.remove("visible"),setTimeout(()=>{this.leftSideBanner.style.display="none",this.bannerOverlay.style.display="none"},300)}populateBannerContent(){var e;const t=this.leftSideBanner.querySelector(".sage-ai-banner-threads");if(!t)return;if(t.innerHTML="",!this.currentNotebookPath)return void(t.innerHTML='<div class="sage-ai-banner-empty">No notebook selected</div>');const o=this.chatHistoryManager.getCurrentNotebookThreads();if(0===o.length)return void(t.innerHTML='<div class="sage-ai-banner-empty">No chat history</div>');const n=[...o].sort((e,t)=>t.lastUpdated-e.lastUpdated),s=this.filterNewChatThreads(n);for(const o of s){const n=document.createElement("div");n.className="sage-ai-banner-thread-item",o.id===(null===(e=this.chatHistoryManager.getCurrentThread())||void 0===e?void 0:e.id)&&n.classList.add("active"),n.innerHTML=`\n        <div class="sage-ai-banner-thread-name">${o.name}</div>\n        <div class="sage-ai-banner-thread-date">${ie(o.lastUpdated)}</div>\n      `,n.addEventListener("click",()=>{this.selectThread(o.id),this.closeBanner()}),t.appendChild(n)}}refreshBannerIfVisible(){this.leftSideBanner&&this.leftSideBanner.classList.contains("visible")&&this.populateBannerContent()}}function ie(e){return new Date(e).toLocaleDateString("en-US",{month:"numeric",day:"numeric",year:"2-digit"})+" · "+new Date(e).toLocaleTimeString("en-US",{hour:"numeric",minute:"2-digit",hour12:!0})}const ae=["module","type","function","ZMQExitAutocall","method"],re=["In","Out"];class le{constructor(e,t,o,n){this.isVisible=!1,this.mentionTrigger="@",this.currentMentionStart=-1,this.currentMentionText="",this.onContextSelected=null,this.currentView="categories",this.selectedCategory=null,this.selectedIndex=0,this.categories=[{id:"rules",name:"Rules",icon:"📄",description:"Reusable prompt templates"},{id:"data",name:"Data",icon:"📊",description:"Dataset references and info"},{id:"variables",name:"Variables",icon:"🔤",description:"Code variables and values"},{id:"cells",name:"Cells",icon:"📝",description:"Notebook cell references"}],this.contextItems=new Map,this.handleInput=e=>{const t=this.getSelectionStart(),o=this.getInputValue();if(this.isVisible)return t<this.currentMentionStart||!o.substring(this.currentMentionStart,t).startsWith(this.mentionTrigger)?void this.hideDropdown():(this.currentMentionText=o.substring(this.currentMentionStart+1,t),void this.renderDropdown(this.currentMentionText));o.charAt(t-1)===this.mentionTrigger&&(this.currentMentionStart=t-1,this.currentMentionText="",this.showDropdown())},this.handleDropdownClick=e=>{e.preventDefault(),e.stopPropagation();const t=e.target;if(t.closest(".sage-ai-mention-back-button"))return this.currentView="categories",this.selectedCategory=null,this.renderDropdown(this.currentMentionText),void this.positionDropdown();const o=t.closest(".sage-ai-mention-category-main");if(o){const e=o.getAttribute("data-category");return void(e&&(this.selectedCategory=e,this.currentView="items",this.renderDropdown(this.currentMentionText),this.positionDropdown()))}const n=t.closest(".sage-ai-mention-subcategory");if(n){const e=n.getAttribute("data-id"),t=n.getAttribute("data-category");e&&("categories"===this.currentView&&t&&(this.selectedCategory=t),this.selectItem(e))}},this.handleKeyDown=e=>{if(this.isVisible)switch(e.key){case"ArrowDown":e.preventDefault(),this.navigateDropdown("down");break;case"ArrowUp":e.preventDefault(),this.navigateDropdown("up");break;case"Tab":case"Enter":e.preventDefault(),this.selectCurrentItem();break;case"Escape":e.preventDefault(),this.hideDropdown()}},this.chatInput=e,this.contentManager=o,this.toolService=n,this.dropdownElement=document.createElement("div"),this.dropdownElement.className="sage-ai-mention-dropdown",t.appendChild(this.dropdownElement),this.setupEventListeners(),this.initializeContextItems()}setContextSelectedCallback(e){this.onContextSelected=e}async initializeContextItems(){this.contextItems.set("rules",[]),this.contextItems.set("data",[{type:"data",id:"demo-dataset",name:"demo-dataset",description:"Sample dataset for demonstration",content:"This is a demo dataset context"}]),this.contextItems.set("variables",[{type:"variable",id:"demo-var",name:"demo_variable",description:"Sample variable for demonstration",content:"x = 42  # Demo variable"}]),this.contextItems.set("cells",[{type:"cell",id:"demo-cell",name:"Cell 1",description:"Sample cell for demonstration",content:'print("Hello from demo cell")'}]),console.log("All context items after initialization:",Array.from(this.contextItems.entries()))}async loadDatasets(){try{const e=await this.contentManager.get("./data");if(console.log("Loaded datasets:",e),e.content&&Array.isArray(e.content)){const t=await Promise.all(e.content.filter(e=>"file"===e.type).map(async e=>{const t=e.name.replace(/\.[^/.]+$/,""),o=`${(await this.contentManager.get("./data/"+e.name)).content}`;return{type:"data",id:e.path,name:t,description:"Dataset file",content:o.slice(0,1e3)}}));this.contextItems.set("data",t)}}catch(e){console.error("Error loading datasets:",e),this.contextItems.set("data",[])}}async loadCells(){console.log("Loading cells... ======================");const e=this.toolService.getCurrentNotebook();if(!e)return void console.warn("No notebook available");const t=[],o=e.widget.model.cells;for(const e of o){console.log("Cell:",e),console.log("Cell metadata:",e.metadata);const o=e.metadata.cell_tracker;o&&t.push({type:"cell",id:o.trackingId,name:o.trackingId,description:"",content:e.sharedModel.getSource()})}this.contextItems.set("cells",t),console.log("CELL LOADING, cells:",o)}async loadVariables(){var e;console.log("Loading variables... ======================");const t=null===(e=this.toolService.getCurrentNotebook())||void 0===e?void 0:e.kernel;if(!t)return void console.warn("No kernel available");let o="";const n=t.requestExecute({code:'\n      import json\n      \n      def to_jsonable(v):\n          # Primitive types → leave as-is\n          if isinstance(v, (int, float, str, bool, type(None))):\n              return v\n          # Lists/tuples → recursively convert\n          if isinstance(v, (list, tuple)):\n              return [to_jsonable(x) for x in v]\n          # Dicts → recursively convert\n          if isinstance(v, dict):\n              return {k: to_jsonable(val) for k, val in v.items()}\n          # Fallback → string repr\n          return repr(v)\n      \n      data = {\n          name: {\n              "type": type(val).__name__,\n              "value": to_jsonable(val)\n          }\n          for name, val in globals().items()\n          if not name.startswith(\'_\')\n      }\n      \n      # Print as a single JSON blob\n      print(json.dumps(data))\n      '});n.onIOPub=e=>{const t=e.header.msg_type;if("stream"===t){const t=e.content.text;o+=t}else if("error"===t){const t=e.content;console.error("Error fetching variables:",t.ename,t.evalue)}},n.done.then(()=>{try{const e=JSON.parse(o);console.log("Variables with types and values:",e);const t=[];for(const o of Object.keys(e))re.includes(o)||ae.includes(e[o].type)||t.push({type:"variable",id:o,name:o,description:e[o].type,content:e[o].value});this.contextItems.set("variables",t)}catch(e){console.error("Failed to parse JSON output:",o,e)}})}async loadTemplateFiles(){try{const e=await this.contentManager.get("./templates");if(e.content&&Array.isArray(e.content)){const t=e.content.filter(e=>"file"===e.type&&"rule.example.md"!==e.name).map(e=>{const t=e.name.replace(/^rule\./,"").replace(/\.md$/,"");return{type:"rules",id:e.path,name:t,description:"Rule file"}});this.contextItems.set("rules",t)}}catch(e){console.error("Error loading template files:",e),this.contextItems.set("rules",[])}}setupEventListeners(){this.chatInput.addEventListener("input",this.handleInput),this.chatInput.addEventListener("keydown",this.handleKeyDown),document.addEventListener("click",e=>{this.dropdownElement.contains(e.target)||e.target===this.chatInput||this.hideDropdown()}),this.dropdownElement.addEventListener("click",this.handleDropdownClick)}getSelectionStart(){if(this.isTextArea())return this.chatInput.selectionStart||0;{const e=window.getSelection();if(!e||0===e.rangeCount)return 0;const t=e.getRangeAt(0),o=t.cloneRange();return o.selectNodeContents(this.chatInput),o.setEnd(t.startContainer,t.startOffset),o.toString().length}}getInputValue(){return this.isTextArea()?this.chatInput.value||"":this.chatInput.textContent||""}setInputValue(e){this.isTextArea()?this.chatInput.value=e:this.chatInput.textContent=e}setSelectionRange(e,t){if(this.isTextArea())this.chatInput.setSelectionRange(e,t);else{const o=window.getSelection();if(!o)return;const n=this.createRangeFromOffsets(e,t);n&&(o.removeAllRanges(),o.addRange(n))}}createRangeFromOffsets(e,t){var o,n,s;const i=document.createTreeWalker(this.chatInput,NodeFilter.SHOW_TEXT);let a=0,r=null,l=0,c=null,d=0;for(;i.nextNode();){const n=i.currentNode,s=(null===(o=n.textContent)||void 0===o?void 0:o.length)||0;if(!r&&a+s>=e&&(r=n,l=e-a),a+s>=t){c=n,d=t-a;break}a+=s}if(r&&c){const e=document.createRange();return e.setStart(r,Math.min(l,(null===(n=r.textContent)||void 0===n?void 0:n.length)||0)),e.setEnd(c,Math.min(d,(null===(s=c.textContent)||void 0===s?void 0:s.length)||0)),e}return null}isTextArea(){return"textarea"===this.chatInput.tagName.toLowerCase()}getCaretCoordinates(){const e=window.getSelection();if(!e||0===e.rangeCount)return{top:0,left:0,height:20};const t=e.getRangeAt(0).getBoundingClientRect(),o=this.chatInput.getBoundingClientRect();return{top:t.top-o.top,left:t.left-o.left,height:t.height||20}}positionDropdown(){if(!this.isVisible)return;const e=this.getCaretCoordinates();console.log("Caret coordinates:",e);let t=e.top,o=e.left;if(o<0)return;if(t<0)return;this.dropdownElement.style.position="fixed",this.dropdownElement.style.left=`${o}px`,this.dropdownElement.style.zIndex="9999",this.dropdownElement.style.maxHeight="300px",this.dropdownElement.style.transform="translateY(-100%) translateY(-8px)",this.dropdownElement.style.marginBottom="12px";const n=this.dropdownElement.getBoundingClientRect(),s=n.bottom-window.innerHeight;s+30>0&&(this.dropdownElement.style.maxHeight=this.dropdownElement.clientHeight-(s+30)+"px"),n.right-window.innerWidth+20>0&&(this.dropdownElement.style.left=o-this.dropdownElement.clientWidth-64+"px")}renderDropdown(e){if(this.dropdownElement.innerHTML="","categories"===this.currentView)if(e&&e.length>0){const t=this.renderMatchingItems(e);if(!t||e.length<2){if(t){const e=document.createElement("div");e.className="sage-ai-mention-separator",e.textContent="Categories",this.dropdownElement.appendChild(e)}this.renderCategories()}}else this.renderCategories();else"items"===this.currentView&&this.selectedCategory&&this.renderCategoryItems(this.selectedCategory,e);this.selectedIndex=0,this.highlightItem(this.selectedIndex),this.positionDropdown()}calculateRelevanceScore(e,t){const o=e.name.toLowerCase(),n=t.toLowerCase();if(!n)return 0;if(o===n)return 1e3;if(o.startsWith(n))return 900;if(new RegExp(`\\b${n}`,"i").test(o))return 800;if(o.includes(n))return 700;let s=0,i=0;for(let e=0;e<o.length&&i<n.length;e++)o[e]===n[i]&&(s+=10,i++);return i===n.length?500+s:0}renderMatchingItems(e){const t=[];for(const[o,n]of this.contextItems.entries())for(const o of n){const n=this.calculateRelevanceScore(o,e);n>0&&t.push({item:o,score:n})}return t.sort((e,t)=>e.score!==t.score?t.score-e.score:e.item.name.localeCompare(t.item.name)),t.length>0&&(t.slice(0,5).forEach(({item:e})=>{const t=document.createElement("div");t.className="sage-ai-mention-item sage-ai-mention-subcategory",t.setAttribute("data-id",e.id),t.setAttribute("data-type",e.type),t.setAttribute("data-category",this.getCategoryForType(e.type));const o=document.createElement("span");o.className="sage-ai-mention-item-icon",o.textContent=this.getIconForType(e.type);const n=document.createElement("div");n.style.flex="1";const s=document.createElement("div");if(s.className="sage-ai-mention-item-text",s.textContent=e.name,n.appendChild(s),e.description){const t=document.createElement("div");t.className="sage-ai-mention-item-description",t.textContent=e.description,n.appendChild(t)}t.appendChild(o),t.appendChild(n),this.dropdownElement.appendChild(t)}),!0)}getCategoryForType(e){switch(e){case"rules":return"rules";case"data":return"data";case"variable":return"variables";case"cell":return"cells";default:return""}}renderCategories(){this.categories.forEach(e=>{const t=document.createElement("div");t.className="sage-ai-mention-item sage-ai-mention-category-main",t.setAttribute("data-category",e.id);const o=document.createElement("span");o.className="sage-ai-mention-item-icon",o.textContent=e.icon;const n=document.createElement("div");n.style.flex="1";const s=document.createElement("div");s.className="sage-ai-mention-item-text",s.textContent=e.name,n.appendChild(s),t.appendChild(o),t.appendChild(n),this.dropdownElement.appendChild(t)})}renderCategoryItems(e,t=""){const o=document.createElement("div");o.className="sage-ai-mention-back-button",o.innerHTML="← Back to Categories",this.dropdownElement.appendChild(o);const n=this.contextItems.get(e)||[];if(console.log(`Rendering items for category ${e}:`,n),0===n.length){const t=document.createElement("div");t.className="sage-ai-mention-empty";let o="No items found";switch(e){case"data":o="No datasets available. Add datasets to reference them here.";break;case"variables":o="No variables available. Define variables in your notebook to reference them here.";break;case"cells":o="No cells available. Create cells in your notebook to reference them here.";break;case"rules":o="No rules available. Create template files in the templates/ directory."}return t.textContent=o,void this.dropdownElement.appendChild(t)}let s=n;if(t){const e=[];for(const o of n){const n=this.calculateRelevanceScore(o,t);n>0&&e.push({item:o,score:n})}e.sort((e,t)=>e.score!==t.score?t.score-e.score:e.item.name.localeCompare(t.item.name)),s=e.map(({item:e})=>e)}s.forEach(e=>{const t=document.createElement("div");t.className="sage-ai-mention-item sage-ai-mention-subcategory",t.setAttribute("data-id",e.id),t.setAttribute("data-type",e.type);const o=document.createElement("span");o.className="sage-ai-mention-item-icon",o.textContent=this.getIconForType(e.type);const n=document.createElement("div");n.style.flex="1";const s=document.createElement("div");if(s.className="sage-ai-mention-item-text",s.textContent=e.name,n.appendChild(s),e.description){const t=document.createElement("div");t.className="sage-ai-mention-item-description",t.textContent=e.description,n.appendChild(t)}t.appendChild(o),t.appendChild(n),this.dropdownElement.appendChild(t)})}getIconForType(e){switch(e){case"rules":return"📄";case"data":return"📊";case"variable":return"🔤";case"cell":return"📝";default:return"❓"}}highlightItem(e){const t=this.dropdownElement.querySelectorAll(".sage-ai-mention-item, .sage-ai-mention-subcategory, .sage-ai-mention-back-button");if(t.forEach(e=>e.classList.remove("active")),t.length>0&&e>=0&&e<t.length){t[e].classList.add("active");const o=t[e],n=this.dropdownElement.getBoundingClientRect(),s=o.getBoundingClientRect();s.bottom>n.bottom?this.dropdownElement.scrollTop+=s.bottom-n.bottom:s.top<n.top&&(this.dropdownElement.scrollTop-=n.top-s.top)}}async selectItem(e){const t=(this.contextItems.get(this.selectedCategory)||[]).find(t=>t.id===e);if(!t)return;const o=this.getInputValue().substring(0,this.currentMentionStart),n=this.getInputValue().substring(this.getSelectionStart()),s=`@${t.name} `;this.setInputValue(o+s+n);const i=this.currentMentionStart+s.length;if(this.setSelectionRange(i,i),this.hideDropdown(),this.chatInput.focus(),this.onContextSelected){let e={...t};"rules"!==t.type||t.content||(e.content=await this.loadTemplateContent(t.id)),this.onContextSelected(e)}}async loadTemplateContent(e){try{const t=await this.contentManager.get(e,{content:!0});return t.content?"string"==typeof t.content?t.content:JSON.stringify(t.content):""}catch(t){return console.error(`Error loading template file ${e}:`,t),""}}async showDropdown(){this.isVisible=!0,this.currentView="categories",this.selectedCategory=null,this.selectedIndex=0,this.dropdownElement.classList.add("visible"),await this.loadTemplateFiles(),await this.loadDatasets(),await this.loadVariables(),await this.loadCells(),this.positionDropdown(),this.renderDropdown("")}hideDropdown(){this.isVisible=!1,this.dropdownElement.classList.remove("visible"),this.currentMentionStart=-1,this.currentMentionText="",this.currentView="categories",this.selectedCategory=null}navigateDropdown(e){const t=this.dropdownElement.querySelectorAll(".sage-ai-mention-item, .sage-ai-mention-subcategory, .sage-ai-mention-back-button");0!==t.length&&(this.selectedIndex="down"===e?(this.selectedIndex+1)%t.length:this.selectedIndex<=0?t.length-1:this.selectedIndex-1,this.highlightItem(this.selectedIndex))}selectCurrentItem(){const e=this.dropdownElement.querySelectorAll(".sage-ai-mention-item, .sage-ai-mention-subcategory, .sage-ai-mention-back-button");if(0===e.length||this.selectedIndex<0||this.selectedIndex>=e.length)return;const t=e[this.selectedIndex];if(t.classList.contains("sage-ai-mention-back-button"))return this.currentView="categories",this.selectedCategory=null,this.selectedIndex=0,this.renderDropdown(this.currentMentionText),void this.positionDropdown();if(t.classList.contains("sage-ai-mention-category-main")){const e=t.getAttribute("data-category");return void(e&&(this.selectedCategory=e,this.currentView="items",this.selectedIndex=0,this.renderDropdown(this.currentMentionText),this.positionDropdown()))}if(t.classList.contains("sage-ai-mention-subcategory")){const e=t.getAttribute("data-id"),o=t.getAttribute("data-category");e&&("categories"===this.currentView&&o&&(this.selectedCategory=o),this.selectItem(e))}}selectHighlightedItem(){this.selectCurrentItem()}getBestMatch(){if(!this.isVisible)return null;if(this.dropdownElement.querySelectorAll(".sage-ai-mention-subcategory").length>0&&this.selectedIndex>=0){const e=this.dropdownElement.querySelectorAll(".sage-ai-mention-item, .sage-ai-mention-subcategory, .sage-ai-mention-back-button");if(e[this.selectedIndex]&&e[this.selectedIndex].classList.contains("sage-ai-mention-subcategory")){const t=e[this.selectedIndex].getAttribute("data-id");if(t)for(const[e,o]of this.contextItems.entries()){const e=o.find(e=>e.id===t);if(e)return e.name}}}if(!this.currentMentionText){for(const[e,t]of this.contextItems.entries())if(t.length>0)return t[0].name;return null}const e=[];if("categories"===this.currentView)for(const[t,o]of this.contextItems.entries())for(const t of o){const o=this.calculateRelevanceScore(t,this.currentMentionText);o>0&&e.push({item:t,score:o})}else if("items"===this.currentView&&this.selectedCategory){const t=this.contextItems.get(this.selectedCategory)||[];for(const o of t){const t=this.calculateRelevanceScore(o,this.currentMentionText);t>0&&e.push({item:o,score:t})}}return e.sort((e,t)=>e.score!==t.score?t.score-e.score:e.item.name.localeCompare(t.item.name)),e.length>0?e[0].item.name:null}getIsVisible(){return this.isVisible}}class ce{constructor(e=""){this.placeholder="",this.activeContexts=new Map,this.placeholder=e,this.createElement()}createElement(){this.wrapperElement=document.createElement("div"),this.wrapperElement.className="sage-ai-rich-chat-input-wrapper",this.element=document.createElement("div"),this.element.className="sage-ai-rich-chat-input",this.element.contentEditable="true",this.element.setAttribute("role","textbox"),this.element.setAttribute("aria-multiline","true"),this.element.setAttribute("data-placeholder",this.placeholder),this.wrapperElement.appendChild(this.element),this.updatePlaceholder(),this.element.addEventListener("paste",this.handlePaste.bind(this)),this.element.addEventListener("input",this.handleInput.bind(this)),this.element.addEventListener("focus",this.handleFocus.bind(this)),this.element.addEventListener("blur",this.handleBlur.bind(this))}handlePaste(e){var t;e.preventDefault();const o=(null===(t=e.clipboardData)||void 0===t?void 0:t.getData("text/plain"))||"";document.execCommand("insertText",!1,o)}handleInput(){this.updatePlaceholder(),this.formatMentions()}handleFocus(){this.isEmpty()&&(this.element.textContent="")}handleBlur(){this.updatePlaceholder()}updatePlaceholder(){this.isEmpty()?document.activeElement!==this.element&&this.element.classList.add("empty"):this.element.classList.remove("empty")}isEmpty(){return 0===(this.element.textContent||"").trim().length}formatMentions(){const e=this.getSelectionStart(),t=this.getPlainText(),o=/@(?:\{([^}]+)\}|([a-zA-Z0-9_-]+))/g;let n,s=0,i="";for(;null!==(n=o.exec(t));){const e=n[0],o=n[1]||n[2],a=n.index,r=a+e.length;i+=this.escapeHtml(t.substring(s,a));const l=this.findContextByName(o);i+=`<span class="sage-ai-mention ${this.getContextClass(null==l?void 0:l.type)}" data-mention="${this.escapeHtml(o)}">${this.escapeHtml(e)}</span>`,s=r}i+=this.escapeHtml(t.substring(s)),this.element.innerHTML=i,this.setSelectionRange(e,e)}findContextByName(e){for(const t of this.activeContexts.values())if(t.name===e)return t}getContextClass(e){switch(e){case"template":return"sage-ai-mention-template";case"data":return"sage-ai-mention-data";case"variable":return"sage-ai-mention-variable";case"cell":return"sage-ai-mention-cell";default:return"sage-ai-mention-default"}}escapeHtml(e){const t=document.createElement("div");return t.textContent=e,t.innerHTML}getPlainText(){return this.element.textContent||""}setPlainText(e){this.element.textContent=e,this.updatePlaceholder(),this.formatMentions()}clear(){this.element.textContent="",this.updatePlaceholder()}focus(){this.element.focus()}getElement(){return this.wrapperElement}getInputElement(){return this.element}addEventListener(e,t){this.wrapperElement.addEventListener(e,t)}removeEventListener(e,t){this.wrapperElement.removeEventListener(e,t)}addInputEventListener(e,t){this.element.addEventListener(e,t)}removeInputEventListener(e,t){this.element.removeEventListener(e,t)}getSelectionStart(){const e=window.getSelection();if(!e||0===e.rangeCount)return 0;const t=e.getRangeAt(0),o=t.cloneRange();return o.selectNodeContents(this.element),o.setEnd(t.startContainer,t.startOffset),o.toString().length}getSelectionEnd(){const e=window.getSelection();if(!e||0===e.rangeCount)return 0;const t=e.getRangeAt(0),o=t.cloneRange();return o.selectNodeContents(this.element),o.setEnd(t.endContainer,t.endOffset),o.toString().length}setSelectionRange(e,t){const o=window.getSelection();if(!o)return;const n=this.createRangeFromOffsets(e,t);n&&(o.removeAllRanges(),o.addRange(n))}createRangeFromOffsets(e,t){var o,n,s;const i=document.createTreeWalker(this.element,NodeFilter.SHOW_TEXT);let a=0,r=null,l=0,c=null,d=0;for(;i.nextNode();){const n=i.currentNode,s=(null===(o=n.textContent)||void 0===o?void 0:o.length)||0;if(!r&&a+s>=e&&(r=n,l=e-a),a+s>=t){c=n,d=t-a;break}a+=s}if(r&&c){const e=document.createRange();return e.setStart(r,Math.min(l,(null===(n=r.textContent)||void 0===n?void 0:n.length)||0)),e.setEnd(c,Math.min(d,(null===(s=c.textContent)||void 0===s?void 0:s.length)||0)),e}return null}setActiveContexts(e){this.activeContexts=e,this.formatMentions()}getScrollHeight(){return this.element.scrollHeight}setHeight(e){}setOverflowY(e){this.element.style.overflowY=e}setWrapperStyle(e,t){this.wrapperElement.style[e]=t}}class de{constructor(e,t,o,n,s,i,a,r){this.userMessageHistory=[],this.historyPosition=-1,this.unsavedInput="",this.activeContexts=new Map,this.onContextSelected=null,this.onContextRemoved=null,this.onResetChat=null,this.modeName="agent",this.isProcessingMessage=!1,this.chatInput=e,this.chatHistoryManager=t,this.onContextSelected=i||null,this.onContextRemoved=a||null,this.onResetChat=r||null;const l=this.isRichTextInput(e)?e.getInputElement():e;this.mentionDropdown=new le(l,o,n,s),this.setupEventHandlers(),this.loadUserMessageHistory(),this.mentionDropdown.setContextSelectedCallback(e=>{this.activeContexts.set(e.id,e),this.isRichTextInput(this.chatInput)&&this.chatInput.setActiveContexts(this.activeContexts),this.onContextSelected&&this.onContextSelected(e)})}setupEventHandlers(){const e=this.isRichTextInput(this.chatInput)?this.chatInput.getInputElement():this.chatInput;this.isRichTextInput(this.chatInput)?this.chatInput.addInputEventListener("input",()=>{this.resizeTextarea()}):e.addEventListener("input",()=>{this.resizeTextarea()});const t=e=>{const t=e;if(this.mentionDropdown.getIsVisible()){if("Tab"===t.key)return t.preventDefault(),void this.handleTabCompletion();if("Enter"===t.key)return t.preventDefault(),void this.handleEnterWithMention()}if("Enter"===t.key){if(t.shiftKey)return;return this.hasCompleteMentionAtCursor()?(t.preventDefault(),void this.processCompleteMention()):(t.preventDefault(),void this.sendMessage())}"ArrowUp"===t.key?0!==this.getSelectionStart()&&""!==this.getInputValue()||(t.preventDefault(),this.navigateHistory("up")):"ArrowDown"===t.key&&(this.getSelectionStart()!==this.getInputLength()&&""!==this.getInputValue()||(t.preventDefault(),this.navigateHistory("down")))};this.isRichTextInput(this.chatInput)?this.chatInput.addInputEventListener("keydown",t):e.addEventListener("keydown",t)}loadUserMessageHistory(){this.userMessageHistory=[];const e=this.chatHistoryManager.getNotebookPaths();for(const t of e){const e=this.chatHistoryManager.getThreadsForNotebook(t);if(e)for(const t of e)t.messages.filter(e=>"user"===e.role&&"string"==typeof e.content).map(e=>"string"==typeof e.content?e.content:"").forEach(e=>{e&&!this.userMessageHistory.includes(e)&&this.userMessageHistory.push(e)})}this.historyPosition=-1,this.unsavedInput="",this.userMessageHistory.sort((e,t)=>e.length!==t.length?e.length-t.length:e.localeCompare(t)),console.log(`[ChatInputManager] Loaded ${this.userMessageHistory.length} user messages for history navigation`)}navigateHistory(e){if(0!==this.userMessageHistory.length){if(-1===this.historyPosition&&(this.unsavedInput=this.getInputValue()),"up"===e){if(this.historyPosition<this.userMessageHistory.length-1){this.historyPosition++;const e=this.userMessageHistory[this.userMessageHistory.length-1-this.historyPosition];this.setInputValue(e);const t=e.length;this.setSelectionRange(t,t)}}else if(this.historyPosition>0){this.historyPosition--;const e=this.userMessageHistory[this.userMessageHistory.length-1-this.historyPosition];this.setInputValue(e);const t=e.length;this.setSelectionRange(t,t)}else if(0===this.historyPosition){this.historyPosition=-1,this.setInputValue(this.unsavedInput);const e=this.unsavedInput.length;this.setSelectionRange(e,e)}this.resizeTextarea()}}resizeTextarea(){if(this.isRichTextInput(this.chatInput)){this.chatInput.setHeight("auto");const e=150,t=this.chatInput.getScrollHeight();t<=e?(this.chatInput.setHeight(t+"px"),this.chatInput.setOverflowY("hidden")):(this.chatInput.setHeight(e+"px"),this.chatInput.setOverflowY("auto"))}else{this.chatInput.style.height="auto";const e=150,t=this.chatInput.scrollHeight;t<=e?(this.chatInput.style.height=t+"px",this.chatInput.style.overflowY="hidden"):(this.chatInput.style.height=e+"px",this.chatInput.style.overflowY="auto")}}setInputValue(e){this.isRichTextInput(this.chatInput)?this.chatInput.setPlainText(e):this.chatInput.value=e}getInputValue(){return this.isRichTextInput(this.chatInput)?this.chatInput.getPlainText().trim():this.chatInput.value.trim()}isRichTextInput(e){return e instanceof ce}getSelectionStart(){return this.isRichTextInput(this.chatInput)?this.chatInput.getSelectionStart():this.chatInput.selectionStart||0}setSelectionRange(e,t){this.isRichTextInput(this.chatInput)?this.chatInput.setSelectionRange(e,t):(this.chatInput.selectionStart=e,this.chatInput.selectionEnd=t)}getInputLength(){return this.getInputValue().length}clearInput(){this.isRichTextInput(this.chatInput)?this.chatInput.clear():(this.chatInput.value="",this.chatInput.style.height="auto"),this.focus()}addToHistory(e){this.userMessageHistory.includes(e)||this.userMessageHistory.push(e),this.historyPosition=-1,this.unsavedInput=""}focus(){this.isRichTextInput(this.chatInput),this.chatInput.focus()}getCurrentInputValue(){return this.getInputValue()}setDependencies(e){this.chatService=e.chatService,this.conversationService=e.conversationService,this.messageComponent=e.messageComponent,this.uiHelper=e.uiHelper,this.contextHandler=e.contextHandler,this.sendButton=e.sendButton,this.modeSelector=e.modeSelector,this.updateUndoButtonState=e.updateUndoButtonState,this.cancelMessage=e.cancelMessage,this.onMessageSent=e.onMessageSent}setModeName(e){this.modeName=e}getIsProcessingMessage(){return this.isProcessingMessage}setIsProcessingMessage(e){this.isProcessingMessage=e}async sendMessage(e){if(!(this.chatService&&this.conversationService&&this.messageComponent&&this.uiHelper&&this.contextHandler&&this.sendButton&&this.modeSelector))return void console.error("ChatInputManager dependencies not set. Call setDependencies() first.");const t=this.getCurrentInputValue();if(!t||this.isProcessingMessage)return;if(v.getWaitingUserReplyBoxManager().hide(),"reset"===t.toLowerCase())return this.onResetChat&&this.onResetChat(),void this.clearInput();if(this.addToHistory(t),this.onMessageSent&&this.onMessageSent(),this.isProcessingMessage=!0,this.uiHelper.updateSendButton(this.sendButton,!0),v.getPlanStateDisplay().setLoading(!0),this.uiHelper.updateAgentModeElement(this.modeSelector,!0),this.uiHelper.resetToGeneratingState("Generating..."),!this.chatService.isInitialized())return this.messageComponent.addSystemMessage("❌ API key is not set. Please configure it in the settings."),this.isProcessingMessage=!1,this.uiHelper.updateSendButton(this.sendButton,!1),v.getPlanStateDisplay().setLoading(!1),this.uiHelper.updateAgentModeElement(this.modeSelector,!1),void this.uiHelper.hideLoadingIndicator();this.clearInput(),this.messageComponent.addUserMessage(t);const o={role:"user",content:t};try{const t=v.getState().currentNotebookPath;t&&this.conversationService.setNotebookPath(t);const n=[],s=[o];e&&n.push(e),this.messageComponent.getMentionContexts().size>0&&n.push(this.contextHandler.getCurrentContextMessage()),v.getNotebookDiffManager().clearDiffs(),await this.conversationService.processConversation(s,n,this.modeName)}catch(e){console.error("Error in conversation processing:",e),this.chatService.getRequestStatus()!==n.CANCELLED&&this.messageComponent.addErrorMessage(`❌ ${e instanceof Error?e.message:"An error occurred while communicating with the AI service."}`)}finally{this.isProcessingMessage=!1,this.uiHelper.updateSendButton(this.sendButton,!1),v.getPlanStateDisplay().setLoading(!1),this.uiHelper.updateAgentModeElement(this.modeSelector,!1)}}handleTabCompletion(){this.mentionDropdown.selectHighlightedItem()}handleEnterWithMention(){this.mentionDropdown.selectHighlightedItem()}completeMentionWithName(e){const t=this.getInputValue(),o=this.getSelectionStart();let n=-1;for(let e=o-1;e>=0;e--){if("@"===t[e]){n=e;break}if(" "===t[e]||"\n"===t[e])break}if(-1===n)return;const s=t.substring(0,n),i=t.substring(o),a=`@${e} `;this.setInputValue(s+a+i);const r=n+a.length;this.setSelectionRange(r,r)}hasCompleteMentionAtCursor(){const e=this.getInputValue(),t=this.getSelectionStart();return null!==e.substring(0,t).match(/@(\w+)\s*$/)}processCompleteMention(){const e=this.getInputValue(),t=this.getSelectionStart(),o=e.substring(0,t).match(/@(\w+)\s*$/);if(o){const e=o[1];console.log(`Processing complete mention: ${e}`),this.focus()}}}const he=new M.LabIcon({name:"sage-agent:agent-mode-icon",svgstr:'<svg width="15" height="14" viewBox="0 0 15 14" fill="none" xmlns="http://www.w3.org/2000/svg">\n<path d="M12.1666 1.74998V4.08331M13.3333 2.91665H11M2.83329 9.91665V11.0833M3.41663 10.5H2.24996M6.29651 9.04165C6.24443 8.83977 6.1392 8.65554 5.99178 8.50812C5.84436 8.3607 5.66013 8.25548 5.45826 8.2034L1.87951 7.28057C1.81845 7.26324 1.76471 7.22646 1.72645 7.17583C1.68818 7.12519 1.66748 7.06345 1.66748 6.99998C1.66748 6.93651 1.68818 6.87478 1.72645 6.82414C1.76471 6.7735 1.81845 6.73673 1.87951 6.7194L5.45826 5.79598C5.66006 5.74395 5.84424 5.63882 5.99166 5.49151C6.13907 5.34419 6.24434 5.16008 6.29651 4.95832L7.21934 1.37957C7.2365 1.31827 7.27323 1.26427 7.32394 1.2258C7.37466 1.18733 7.43656 1.1665 7.50022 1.1665C7.56387 1.1665 7.62577 1.18733 7.67649 1.2258C7.7272 1.26427 7.76394 1.31827 7.78109 1.37957L8.70334 4.95832C8.75542 5.16019 8.86064 5.34442 9.00806 5.49184C9.15548 5.63926 9.33972 5.74449 9.54159 5.79657L13.1203 6.71882C13.1819 6.73579 13.2362 6.77249 13.2748 6.82328C13.3135 6.87407 13.3345 6.93614 13.3345 6.99998C13.3345 7.06382 13.3135 7.1259 13.2748 7.17669C13.2362 7.22748 13.1819 7.26417 13.1203 7.28115L9.54159 8.2034C9.33972 8.25548 9.15548 8.3607 9.00806 8.50812C8.86064 8.65554 8.75542 8.83977 8.70334 9.04165L7.78051 12.6204C7.76335 12.6817 7.72662 12.7357 7.6759 12.7742C7.62519 12.8126 7.56329 12.8335 7.49963 12.8335C7.43598 12.8335 7.37407 12.8126 7.32336 12.7742C7.27265 12.7357 7.23591 12.6817 7.21876 12.6204L6.29651 9.04165Z" stroke="#949494" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>\n</svg>\n'}),ue=new M.LabIcon({name:"sage-agent:agent-mode-shiny-icon",svgstr:'<svg width="13" height="14" viewBox="0 0 13 14" fill="none" xmlns="http://www.w3.org/2000/svg">\n<path d="M5.38237 8.89564C5.33401 8.70819 5.2363 8.53712 5.09941 8.40023C4.96252 8.26333 4.79145 8.16563 4.60399 8.11727L1.28087 7.26035C1.22417 7.24426 1.17427 7.21011 1.13874 7.16309C1.10321 7.11607 1.08398 7.05874 1.08398 6.99981C1.08398 6.94087 1.10321 6.88355 1.13874 6.83653C1.17427 6.78951 1.22417 6.75536 1.28087 6.73927L4.60399 5.88181C4.79138 5.8335 4.96241 5.73587 5.09929 5.59908C5.23618 5.46229 5.33392 5.29133 5.38237 5.10398L6.23928 1.78085C6.25521 1.72393 6.28932 1.67379 6.33642 1.63806C6.38351 1.60234 6.44099 1.58301 6.5001 1.58301C6.5592 1.58301 6.61669 1.60234 6.66378 1.63806C6.71087 1.67379 6.74498 1.72393 6.76091 1.78085L7.61728 5.10398C7.66564 5.29143 7.76335 5.4625 7.90024 5.59939C8.03713 5.73628 8.2082 5.83399 8.39566 5.88235L11.7188 6.73873C11.7759 6.75449 11.8263 6.78856 11.8622 6.83573C11.8982 6.88289 11.9176 6.94053 11.9176 6.99981C11.9176 7.05909 11.8982 7.11673 11.8622 7.16389C11.8263 7.21105 11.7759 7.24513 11.7188 7.26089L8.39566 8.11727C8.2082 8.16563 8.03713 8.26333 7.90024 8.40023C7.76335 8.53712 7.66564 8.70819 7.61728 8.89564L6.76037 12.2188C6.74444 12.2757 6.71033 12.3258 6.66324 12.3616C6.61614 12.3973 6.55866 12.4166 6.49955 12.4166C6.44045 12.4166 6.38296 12.3973 6.33587 12.3616C6.28878 12.3258 6.25467 12.2757 6.23874 12.2188L5.38237 8.89564Z" fill="url(#paint0_linear_295_435)"/>\n<path d="M10.8335 2.125V4.29167" stroke="url(#paint1_linear_295_435)" stroke-width="0.8" stroke-linecap="round" stroke-linejoin="round"/>\n<path d="M11.9167 3.2085H9.75" stroke="url(#paint2_linear_295_435)" stroke-width="0.8" stroke-linecap="round" stroke-linejoin="round"/>\n<path d="M2.1665 9.7085V10.7918" stroke="url(#paint3_linear_295_435)" stroke-width="0.8" stroke-linecap="round" stroke-linejoin="round"/>\n<path d="M2.70833 10.25H1.625" stroke="url(#paint4_linear_295_435)" stroke-width="0.8" stroke-linecap="round" stroke-linejoin="round"/>\n<defs>\n<linearGradient id="paint0_linear_295_435" x1="1.08398" y1="1.58301" x2="11.9176" y2="12.4166" gradientUnits="userSpaceOnUse">\n<stop stop-color="#FEC163"/>\n<stop offset="1" stop-color="#DE4313"/>\n</linearGradient>\n<linearGradient id="paint1_linear_295_435" x1="10.8335" y1="2.125" x2="12.4823" y2="2.88598" gradientUnits="userSpaceOnUse">\n<stop stop-color="#FEC163"/>\n<stop offset="1" stop-color="#DE4313"/>\n</linearGradient>\n<linearGradient id="paint2_linear_295_435" x1="9.75" y1="3.2085" x2="10.511" y2="4.85728" gradientUnits="userSpaceOnUse">\n<stop stop-color="#FEC163"/>\n<stop offset="1" stop-color="#DE4313"/>\n</linearGradient>\n<linearGradient id="paint3_linear_295_435" x1="2.1665" y1="9.7085" x2="3.24638" y2="10.7053" gradientUnits="userSpaceOnUse">\n<stop stop-color="#FEC163"/>\n<stop offset="1" stop-color="#DE4313"/>\n</linearGradient>\n<linearGradient id="paint4_linear_295_435" x1="1.625" y1="10.25" x2="2.62181" y2="11.3299" gradientUnits="userSpaceOnUse">\n<stop stop-color="#FEC163"/>\n<stop offset="1" stop-color="#DE4313"/>\n</linearGradient>\n</defs>\n</svg>\n'}),ge=new M.LabIcon({name:"sage-agent:hands-on-icon",svgstr:'<svg width="15" height="14" viewBox="0 0 15 14" fill="none" xmlns="http://www.w3.org/2000/svg">\n<path d="M7.49982 2.91678C7.50051 2.68346 7.45453 2.45236 7.3646 2.23708C7.27467 2.02179 7.14259 1.82666 6.97614 1.66316C6.80969 1.49967 6.61223 1.3711 6.39537 1.28504C6.17851 1.19897 5.94662 1.15714 5.71336 1.162C5.48009 1.16686 5.25015 1.21832 5.03707 1.31335C4.82398 1.40838 4.63205 1.54506 4.47255 1.71535C4.31306 1.88564 4.18923 2.0861 4.10835 2.30495C4.02747 2.5238 3.99116 2.75661 4.00157 2.98969M7.49982 2.91678V10.5001M7.49982 2.91678C7.49913 2.68346 7.54507 2.45236 7.635 2.23708C7.72494 2.02179 7.85701 1.82666 8.02346 1.66316C8.18991 1.49967 8.38737 1.3711 8.60423 1.28504C8.8211 1.19897 9.05298 1.15714 9.28624 1.162C9.51951 1.16686 9.74945 1.21832 9.96254 1.31335C10.1756 1.40838 10.3676 1.54506 10.527 1.71535C10.6865 1.88564 10.8104 2.0861 10.8913 2.30495C10.9721 2.5238 11.0084 2.75661 10.998 2.98969C11.3409 3.07786 11.6592 3.24289 11.9289 3.47229C12.1986 3.7017 12.4125 3.98945 12.5545 4.31377C12.6964 4.63809 12.7628 4.99047 12.7484 5.34421C12.734 5.69795 12.6393 6.04379 12.4715 6.35553M4.00157 2.98969C3.65869 3.07786 3.34036 3.24289 3.0707 3.47229C2.80105 3.7017 2.58713 3.98945 2.44514 4.31377C2.30316 4.63809 2.23685 4.99047 2.25121 5.34421C2.26558 5.69795 2.36026 6.04379 2.52807 6.35553M4.00157 2.98969C4.0131 3.27187 4.09268 3.54704 4.23365 3.79175M2.52807 6.35553C2.23301 6.59524 2.00098 6.90341 1.85218 7.25324C1.70338 7.60307 1.64231 7.98396 1.67428 8.36277C1.70625 8.74158 1.8303 9.10685 2.03562 9.42679C2.24095 9.74673 2.52134 10.0117 2.8524 10.1985M2.52807 6.35553C2.63478 6.26861 2.74897 6.19187 2.86931 6.12508M2.8524 10.1985C2.81152 10.5148 2.83592 10.8362 2.92409 11.1427C3.01226 11.4492 3.16233 11.7343 3.36503 11.9806C3.56773 12.2268 3.81876 12.4289 4.10261 12.5743C4.38647 12.7197 4.69712 12.8054 5.01539 12.8261C5.33366 12.8467 5.65278 12.8019 5.95305 12.6944C6.25331 12.5869 6.52835 12.4189 6.76118 12.201C6.994 11.983 7.17967 11.7196 7.30671 11.4271C7.43376 11.1345 7.49948 10.819 7.49982 10.5001M2.8524 10.1985C3.20256 10.396 3.59774 10.5002 3.99975 10.5M7.49982 10.5001C7.50016 10.819 7.56585 11.1345 7.69289 11.4271C7.81993 11.7196 8.0056 11.983 8.23842 12.201C8.47125 12.4189 8.74629 12.5869 9.04656 12.6944C9.34683 12.8019 9.66595 12.8467 9.98421 12.8261C10.3025 12.8054 10.6131 12.7197 10.897 12.5743C11.1808 12.4289 11.4319 12.2268 11.6346 11.9806C11.8373 11.7343 11.9873 11.4492 12.0755 11.1427C12.1637 10.8362 12.1881 10.5148 12.1472 10.1985M12.4715 6.35553C12.7666 6.59524 12.9986 6.90341 13.1474 7.25324C13.2962 7.60307 13.3573 7.98396 13.3253 8.36277C13.2934 8.74158 13.1693 9.10685 12.964 9.42679C12.7587 9.74673 12.4783 10.0117 12.1472 10.1985M12.4715 6.35553C12.3648 6.26861 12.2506 6.19187 12.1303 6.12508M12.1472 10.1985C11.797 10.396 11.4018 10.5002 10.9998 10.5M9.24978 7.58341C8.76004 7.41113 8.33238 7.0975 8.02088 6.68217C7.70939 6.26684 7.52804 5.76847 7.49978 5.25008C7.47151 5.76847 7.29017 6.26684 6.97867 6.68217C6.66717 7.0975 6.23952 7.41113 5.74978 7.58341M10.7659 3.79175C10.9071 3.54709 10.987 3.27189 10.9987 2.98966" stroke="#949494" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>\n</svg>\n'}),pe=new M.LabIcon({name:"sage-agent:ask-icon",svgstr:'<svg width="15" height="14" viewBox="0 0 15 14" fill="none" xmlns="http://www.w3.org/2000/svg">\n<path d="M5.80232 5.25021C5.93946 4.86035 6.21016 4.53161 6.56646 4.3222C6.92276 4.1128 7.34167 4.03626 7.749 4.10613C8.15633 4.17599 8.52579 4.38777 8.79195 4.70393C9.0581 5.0201 9.20377 5.42026 9.20315 5.83354C9.20315 7.00021 7.45315 7.58354 7.45315 7.58354M7.49984 9.91683H7.50567M5.10817 11.6669C6.22151 12.238 7.50222 12.3927 8.71952 12.1031C9.93682 11.8135 11.0107 11.0986 11.7475 10.0873C12.4844 9.076 12.8358 7.83477 12.7385 6.58728C12.6412 5.3398 12.1015 4.16809 11.2167 3.2833C10.3319 2.39852 9.16023 1.85884 7.91274 1.76152C6.66526 1.6642 5.42403 2.01563 4.41273 2.7525C3.40144 3.48937 2.68657 4.5632 2.39697 5.78051C2.10736 6.99781 2.26205 8.27852 2.83317 9.39186L1.6665 12.8335L5.10817 11.6669Z" stroke="#949494" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>\n</svg>\n'}),me=new M.LabIcon({name:"sage-agent:open-mode-selector-icon",svgstr:'<svg width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">\n<path d="M9.5 7.5L6.5 4.5L3.5 7.5" stroke="#ADADAD" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>\n</svg>\n'}),fe=new M.LabIcon({name:"sage-agent:send-icon",svgstr:'<svg width="16" height="17" viewBox="0 0 16 17" fill="none" xmlns="http://www.w3.org/2000/svg">\n<path d="M8.00016 13.1665L8.00016 3.83317M8.00016 3.83317L3.3335 8.49984M8.00016 3.83317L12.6668 8.49984" stroke="#7A7A7A" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>\n</svg>\n'}),Ce=new M.LabIcon({name:"sage-agent:stop-icon",svgstr:'<svg width="16" height="17" viewBox="0 0 16 17" fill="none" xmlns="http://www.w3.org/2000/svg">\n<rect x="2.70605" y="13.7935" width="10.5874" height="10.5874" rx="3" transform="rotate(-90 2.70605 13.7935)" fill="#1A1A1A"/>\n</svg>\n'});class ye{constructor(e,t,o){this.isShowingConfirmation=!1,this.chatHistory=e,this.messageComponent=t,this.llmStateDisplay=o}setShowingConfirmation(e){this.isShowingConfirmation=e}resetToGeneratingState(e="Generating..."){this.llmStateDisplay.show(e),this.chatHistory.scrollTop=this.chatHistory.scrollHeight}updateLoadingIndicator(e="Generating..."){this.isShowingConfirmation?this.llmStateDisplay.hide():this.llmStateDisplay.isDiffState()||this.llmStateDisplay.isUsingToolState()||(this.llmStateDisplay.show(e),this.chatHistory.scrollTop=this.chatHistory.scrollHeight)}removeLoadingIndicator(){}hideLoadingIndicator(){this.llmStateDisplay.hide()}updateSendButton(e,t){t?(Ce.render(e),e.className="sage-ai-cancel-button"):(fe.render(e),e.className="sage-ai-send-button")}updateAgentModeElement(e,t){t?(e.style.opacity="0.5",e.style.cursor="not-allowed",e.setAttribute("data-is-disabled","true")):(e.style.opacity="1",e.style.cursor="pointer",e.removeAttribute("data-is-disabled"))}}class ve{constructor(e,t,o){this.messageComponent=e,this.inputManager=t,this.chatboxNode=o}onCellAddedToContext(e){const t=v.getNotebookContextManager();if(!t)return void console.error("Required services not initialized: contextManager is null");if(v.getState().currentNotebookPath!==e)return void console.error("Cell context notebook path mismatch");const o=t.getContextCells(e);this.updateContextCellsIndicator(o.length)}onCellRemovedFromContext(e){const t=v.getNotebookContextManager();if(!t)return void console.error("Required services not initialized: contextManager is null");if(v.getState().currentNotebookPath!==e)return void console.error("Cell context notebook path mismatch");const o=t.getContextCells(e);this.updateContextCellsIndicator(o.length)}updateContextDisplay(){let e=this.chatboxNode.querySelector(".sage-ai-context-display-inline");if(!e)return void console.warn("Context display container not found");const t=this.chatboxNode.querySelector(".sage-ai-context-row");e.innerHTML="";const o=v.getState().currentNotebookPath,n=v.getNotebookContextManager(),s=o&&n?n.getContextCells(o):[],i=Array.from(this.messageComponent.getMentionContexts().values());if(s.length+i.length>0){e.classList.remove("hidden"),t&&t.classList.remove("context-row-hidden");const a=document.createElement("div");a.className="sage-ai-context-items-inline";for(const e of s){const t=document.createElement("div");t.className="sage-ai-context-cell-box-inline",t.title=e.content||"Empty cell";const s=document.createElement("span");s.className="sage-ai-context-cell-delete",s.textContent="×",s.title="Remove from context",s.addEventListener("click",t=>{var s;if(t.stopPropagation(),o&&n){n.removeCellFromContext(o,e.cellId),this.updateContextDisplay(),this.onCellRemovedFromContext(o);const t=null===(s=v.getNotebookTools().getCurrentNotebook())||void 0===s?void 0:s.widget;t&&v.getContextCellHighlighter().addContextButtonsToAllCells(t)}}),t.appendChild(s);const i=document.createElement("span");i.textContent=e.cellId,t.appendChild(i),a.appendChild(t)}for(const e of i){const t=document.createElement("div");t.className="sage-ai-context-cell-box-inline",t.title=e.description||e.content||`${e.type}: ${e.name}`;let o="#4a5568";switch(e.type){case"rules":o="rgba(156, 39, 176, 0.2)";break;case"data":o="rgba(33, 150, 243, 0.2)";break;case"variable":o="rgba(76, 175, 80, 0.2)";break;case"cell":o="rgba(255, 152, 0, 0.2)";break;default:o="#4a5568"}t.style.backgroundColor=`${o}`,t.style.color="#FAFAFA";const n=document.createElement("span");n.className="sage-ai-context-cell-delete",n.textContent="×",n.title="Remove from context",n.addEventListener("click",t=>{if(t.stopPropagation(),this.messageComponent.removeMentionContext(e.id),this.updateContextDisplay(),this.inputManager){const t=this.inputManager.getCurrentInputValue(),o=e.name.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&"),n=t.replace(new RegExp(`@\\{?${o}\\}?`,"g"),"").trim();this.inputManager.setInputValue(n)}}),t.appendChild(n);const s=document.createElement("span");s.textContent=e.name,t.appendChild(s),a.appendChild(t)}e.appendChild(a)}}updateContextCellsIndicator(e){this.updateContextDisplay()}getMentionContexts(){return Array.from(this.messageComponent.getMentionContexts().values()).map(e=>({name:e.name,content:e.content||"",type:e.type,description:e.description}))}clearMentionContexts(){this.messageComponent.setMentionContexts(new Map),this.updateContextDisplay()}getCurrentContextMessage(){let e="The user's message has the following provided context:\n\n";const t=this.messageComponent.getMentionContexts();for(const[o,n]of t.entries())console.log(o),console.log(n),e+=`@${n.name} (ID: ${n.id}) described as: ${n.description} has the following content: \n${n.content}\n\n`;return e.trim()}}class be extends z.Widget{constructor(e,t){super(),this.callbacks=e,this.recommendedPrompts=t,this.addClass("sage-ai-new-chat-display"),this.node.style.height="100%",this.buildContent()}buildContent(){const e=document.createElement("div");e.className="sage-ai-new-chat-container";const t=document.createElement("div");t.className="sage-ai-new-chat-title-section";const o=document.createElement("h2");o.className="sage-ai-new-chat-title",o.textContent="New Chat";const n=document.createElement("p");n.className="sage-ai-new-chat-help",n.textContent="How can I help you?",t.appendChild(o),t.appendChild(n);const s=document.createElement("div");s.className="sage-ai-new-chat-prompts-section";const i=document.createElement("div");i.className="sage-ai-new-chat-prompts-list",this.recommendedPrompts.forEach(e=>{const t=document.createElement("button");t.className="sage-ai-new-chat-prompt-button",t.textContent=e,t.addEventListener("click",()=>{this.callbacks.onPromptSelected(e),this.callbacks.onRemoveDisplay()}),i.appendChild(t)}),s.appendChild(i),e.appendChild(t),e.appendChild(s),this.node.appendChild(e)}}var ke;!function(e){e.IDLE="idle",e.GENERATING="generating",e.USING_TOOL="using_tool",e.DIFF="diff"}(ke||(ke={}));const we=new M.LabIcon({name:"sage-agent:state-menu-icon",svgstr:'<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">\n<path d="M6 12L10 8L6 4" stroke="#949494" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>\n</svg>\n'}),Se=new M.LabIcon({name:"sage-agent:state-menu-close-icon",svgstr:'<svg width="16" height="17" viewBox="0 0 16 17" fill="none" xmlns="http://www.w3.org/2000/svg">\n<path d="M4 6.5L8 10.5L12 6.5" stroke="#949494" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>\n</svg>\n'}),_e=new M.LabIcon({name:"sage-agent:run-cell-icon",svgstr:'<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">\n  <path d="M4 2.91583C4 2.52025 4.43762 2.28133 4.77038 2.49524L12.6791 7.57941C12.9852 7.77623 12.9852 8.22377 12.6791 8.42059L4.77038 13.5048C4.43762 13.7187 4 13.4798 4 13.0842V2.91583Z" fill="#3B82F6" stroke="#3B82F6" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>\n  <path d="M13.1018 5.35787L6.45639 9.55022L5.34214 7.88071" stroke="#1A1A1A" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>\n</svg>'}),xe=()=>x.createElement("div",{className:"sage-ai-diff-spinner",style:{display:"flex",alignItems:"center",justifyContent:"center",width:"16px",height:"16px",border:"2px solid #f3f3f3",borderTop:"2px solid #3498db",borderRadius:"50%",animation:"spin 1s linear infinite"}});function Me({diff:e,showActionsOnHover:t=!1}){const[o,n]=x.useState(e);x.useEffect(()=>{const t=F.getCellStateChanges$(e.cellId).subscribe(t=>{t&&t.cellId===e.cellId&&n(o=>{const n=F.getCurrentState().pendingDiffs.get(e.cellId);return{...o,approved:t.approved,userDecision:null==n?void 0:n.userDecision,runResult:null==n?void 0:n.runResult}})}),o=F.diffState$.subscribe(t=>{const o=t.pendingDiffs.get(e.cellId);o&&n(e=>({...e,userDecision:o.userDecision,runResult:o.runResult,approved:o.approved}))});return()=>{t.unsubscribe(),o.unsubscribe()}},[e.cellId]);const{added:s,removed:i}=(e=>{var t,o;const n=(null===(t=e.originalContent)||void 0===t?void 0:t.split("\n").length)||0,s=(null===(o=e.newContent)||void 0===o?void 0:o.split("\n").length)||0;return"add"===e.type?{added:s,removed:0}:"remove"===e.type?{added:0,removed:n}:"edit"===e.type?{added:Math.max(0,s-n),removed:Math.max(0,n-s)}:{added:0,removed:0}})(o),a=null!==o.userDecision&&void 0!==o.userDecision,r="run"===o.userDecision&&!o.runResult;return x.useEffect(()=>{if(!document.querySelector("#sage-ai-spinner-animation")){const e=document.createElement("style");e.id="sage-ai-spinner-animation",e.textContent="\n        @keyframes spin {\n          0% { transform: rotate(0deg); }\n          100% { transform: rotate(360deg); }\n        }\n      ",document.head.appendChild(e)}},[]),x.createElement("div",{className:"sage-ai-diff-item "+(t?"sage-ai-diff-item-hover-actions":""),onClick:()=>{v.getNotebookTools().scrollToCellById(o.cellId)}},x.createElement("div",{className:"sage-ai-diff-info"},x.createElement("span",{className:`sage-ai-diff-operation sage-ai-diff-${o.type}`},(e=>{switch(e){case"add":return"+";case"edit":return"~";case"remove":return"−";default:return"?"}})(o.type)),x.createElement("span",{className:"sage-ai-diff-summary"},o.cellId),x.createElement("div",{className:"sage-ai-diff-changes"},s>0&&x.createElement("span",{className:"sage-ai-diff-added"},"+",s),i>0&&x.createElement("span",{className:"sage-ai-diff-removed"},"−",i),a&&x.createElement("span",{className:`sage-ai-diff-decision sage-ai-diff-decision-${o.userDecision}`},"approved"===o.userDecision?"✓":"rejected"===o.userDecision?"✕":"run"===o.userDecision?x.createElement(_e.react,{className:"fix_run_cell_size"}):"?"))),!a&&!r&&x.createElement("div",{className:"sage-ai-diff-actions"},x.createElement("button",{className:"sage-ai-diff-btn sage-ai-diff-reject",onClick:()=>{F.updateDiffState(o.cellId,!1,o.notebookPath),v.getNotebookDiffManager().diffApprovalDialog.rejectCell(o.cellId)},disabled:a,title:"Reject this change"},"✕"),x.createElement("button",{className:"sage-ai-diff-btn sage-ai-diff-approve",onClick:()=>{F.updateDiffState(o.cellId,!0,o.notebookPath),v.getNotebookDiffManager().diffApprovalDialog.approveCell(o.cellId)},disabled:a,title:"Approve this change"},"✓"),x.createElement("button",{className:"sage-ai-diff-btn sage-ai-diff-run",onClick:()=>{F.updateDiffStateToRun(o.cellId,o.notebookPath),v.getNotebookDiffManager().diffApprovalDialog.runCell(o.cellId)},disabled:a,title:"Apply this change and run the cell immediately"},x.createElement(_e.react,null))),r&&x.createElement("div",{className:"sage-ai-diff-actions"},x.createElement(xe,null)))}function Ee({isVisible:e,state:t,text:o,toolName:n,diffs:s,waitingForUser:i,isRunContext:a,onRunClick:r,onRejectClick:l}){const[c,d]=x.useState(!1),[h,u]=x.useState(!1),[g,f]=x.useState(s||[]);x.useEffect(()=>{const e=F.diffState$.subscribe(e=>{const t=Array.from(e.pendingDiffs.values());if(f(t),t.length>0){const e=t.every(e=>"approved"===e.userDecision||"rejected"===e.userDecision||"run"===e.userDecision||!0===e.approved||!1===e.approved);u(e)}else u(!1)});return()=>e.unsubscribe()},[]),x.useEffect(()=>{if(s&&s.length>0){f(s);const e=s.every(e=>"approved"===e.userDecision||"rejected"===e.userDecision||"run"===e.userDecision||!0===e.approved||!1===e.approved);u(e)}else s&&0===s.length&&(f([]),u(!1))},[s]);const C=g.length>0?g:s||[];if(console.log("DISPLAY DIFFS:",C),!e)return null;if(t===ke.IDLE)return null;if(t===ke.GENERATING)return x.createElement("div",{className:"sage-ai-llm-state-display sage-ai-generating",style:{display:"flex"}},x.createElement("div",{className:"sage-ai-llm-state-content"},i&&x.createElement("div",{className:"sage-ai-waiting-for-user"}),!i&&x.createElement("div",{className:"sage-ai-blob-loader"}),x.createElement("span",{className:"sage-ai-llm-state-text"},o)),!i&&x.createElement("button",{className:"sage-ai-llm-state-stop-button",onClick:()=>{var e;null===(e=v.getChatContainerSafe())||void 0===e||e.chatWidget.cancelMessage()},title:"Stop generation"},"Stop"));if(t===ke.USING_TOOL){const e=n?m(n):null,t=n?p(n):o||"Using tool...",s="notebook-run_cell"===n;return x.createElement("div",{className:"sage-ai-llm-state-display sage-ai-using-tool",style:{display:"flex"}},x.createElement("div",{className:"sage-ai-llm-state-content"},e?x.createElement("div",{className:"sage-ai-tool-icon-container",dangerouslySetInnerHTML:{__html:e}}):x.createElement("div",{className:"sage-ai-tool-loader"}),x.createElement("span",{className:"sage-ai-llm-state-text"},s?"Waiting to run cell...":t)),x.createElement("div",{className:"sage-ai-llm-state-buttons"},s&&r&&l?x.createElement(x.Fragment,null,x.createElement("button",{className:"sage-ai-llm-state-reject-button",onClick:l,title:"Reject code execution"},"Reject"),x.createElement("button",{className:"sage-ai-llm-state-run-button",onClick:r,title:"Run code (Cmd/Ctrl + Enter)"},"Run")):x.createElement("button",{className:"sage-ai-llm-state-stop-button",onClick:()=>{var e;null===(e=v.getChatContainerSafe())||void 0===e||e.chatWidget.cancelMessage()},title:"Stop tool execution"},"Stop")))}if(t===ke.DIFF&&C&&C.length>0){const{totalAdded:e,totalRemoved:t}=(e=>{let t=0,o=0;return e.forEach(e=>{var n,s;const i=(null===(n=e.originalContent)||void 0===n?void 0:n.split("\n").length)||0,a=(null===(s=e.newContent)||void 0===s?void 0:s.split("\n").length)||0;"add"===e.type?t+=a:"remove"===e.type?o+=i:"edit"===e.type&&(t+=Math.max(0,a-i),o+=Math.max(0,i-a))}),{totalAdded:t,totalRemoved:o}})(C);return x.createElement("div",{className:"sage-ai-llm-state-display sage-ai-diff-state"},x.createElement("div",{className:"sage-ai-diff-summary-bar",onClick:()=>d(!c)},x.createElement("div",{className:"sage-ai-diff-summary-info"},x.createElement("span",{className:"sage-ai-diff-icon"},c?x.createElement(Se.react,{className:"sage-ai-diff-menu-icon"}):x.createElement(we.react,{className:"sage-ai-diff-menu-icon"})),x.createElement("span",{className:"sage-ai-diff-cell-count"},C.length," cell",1!==C.length?"s":""," ","modified"),e>0&&x.createElement("span",{className:"sage-ai-diff-added-count"},"+",e),t>0&&x.createElement("span",{className:"sage-ai-diff-removed-count"},"-",t)),x.createElement("div",{className:"sage-ai-diff-summary-actions"},!h&&x.createElement(x.Fragment,null,x.createElement("button",{className:"sage-ai-diff-btn sage-ai-diff-reject-all",onClick:async e=>{e.stopPropagation();for(const e of C)F.updateDiffState(e.cellId,!1,e.notebookPath);await v.getNotebookDiffManager().diffApprovalDialog.rejectAll(),u(!0)},title:"Reject all changes"},"Reject All"),x.createElement("button",{className:"sage-ai-diff-btn sage-ai-diff-approve-all",onClick:async e=>{if(e.stopPropagation(),a)for(const e of C)e.userDecision||await v.getNotebookDiffManager().diffApprovalDialog.runCell(e.cellId);else await v.getNotebookDiffManager().diffApprovalDialog.approveAll();u(!0)},title:"Approve all changes"},a?s&&s.length>1?"Run All":"Run":"Approve All")))),c&&x.createElement("div",{className:"sage-ai-diff-list"},C.map((e,t)=>x.createElement(Me,{key:`${e.cellId}-${t}`,diff:e,showActionsOnHover:!0}))))}return null}class Te extends M.ReactWidget{constructor(){super(),this.subscriptions=[],this._state={isVisible:!1,state:ke.IDLE,text:""},this.addClass("sage-ai-llm-state-widget"),this.addClass("hidden"),this.setupDiffStateSubscriptions()}setupDiffStateSubscriptions(){const e=F.diffState$.subscribe(e=>{if(this._state.state===ke.DIFF){const t=Array.from(e.pendingDiffs.values());this._state={...this._state,diffs:t},this.update()}});this.subscriptions.push(e);const t=F.allDiffsResolved$.subscribe(({notebookPath:e})=>{F.getCurrentState().pendingDiffs.size>0||this._state.state!==ke.DIFF||this.hide()});this.subscriptions.push(t)}dispose(){this.subscriptions.forEach(e=>e.unsubscribe()),this.subscriptions=[],super.dispose()}render(){return this.handleIsVisibleChanges(this._state.isVisible),x.createElement(Ee,{isVisible:this._state.isVisible,state:this._state.state,text:this._state.text,toolName:this._state.toolName,diffs:this._state.diffs,waitingForUser:this._state.waitingForUser,isRunContext:this._state.isRunContext,onRunClick:this._state.onRunClick,onRejectClick:this._state.onRejectClick})}handleIsVisibleChanges(e){e?this.removeClass("hidden"):this.addClass("hidden")}show(e="Generating...",t){this._state={isVisible:!0,state:ke.GENERATING,text:e,waitingForUser:t},this.update()}showRunCellTool(e,t){this._state={isVisible:!0,state:ke.USING_TOOL,text:"",toolName:"notebook-run_cell",onRunClick:e,onRejectClick:t},this.update()}showTool(e,t){this._state={isVisible:!0,state:ke.USING_TOOL,text:t||"",toolName:e},this.update()}showDiffsWithManager(e,t){try{const o=F.getCurrentState(),n=Array.from(o.pendingDiffs.values()).filter(t=>!e||t.notebookPath===e);if(0===n.length)return void this.hide();this._state={isVisible:!0,state:ke.DIFF,text:"",diffs:n,isRunContext:t||!1},this.update()}catch(e){console.warn("Could not show diffs with manager:",e),this.hide()}}hide(){this._state={isVisible:!1,state:ke.IDLE,text:"",waitingForUser:!1};const e=document.getElementsByClassName("sage-ai-plan-state-widget").item(0);e&&(e.className+=" no-state-open"),this.update()}updateText(e){!this._state.isVisible||this._state.state!==ke.GENERATING&&this._state.state!==ke.USING_TOOL||(this._state={...this._state,text:e},this.update())}updateToolName(e){this._state.isVisible&&this._state.state===ke.USING_TOOL&&(this._state={...this._state,toolName:e},this.update())}showPendingDiffs(e,t){this.showDiffsWithManager(e||void 0,t)}hidePendingDiffs(){this.hide()}hasPendingDiffs(e){try{const t=F.getCurrentState();return Array.from(t.pendingDiffs.values()).filter(t=>!e||t.notebookPath===e).length>0}catch(e){return console.warn("Could not check pending diffs:",e),!1}}getCurrentState(){return this._state.state}isDiffState(){return this._state.state===ke.DIFF}isUsingToolState(){return this._state.state===ke.USING_TOOL}getWidget(){return this}}function Ie({isVisible:e,onRenameChat:t,onDeleteChat:o,onClose:n}){return e?x.createElement("div",{className:"sage-ai-more-options-popover"},x.createElement("div",{className:"sage-ai-more-options-content"},x.createElement("button",{className:"sage-ai-more-options-item",onClick:()=>{t(),n()},type:"button"},x.createElement("svg",{width:"16",height:"16",viewBox:"0 0 16 16",fill:"none",xmlns:"http://www.w3.org/2000/svg"},x.createElement("path",{d:"M11.3333 2L14 4.66667L5.66667 13H3V10.3333L11.3333 2Z",stroke:"currentColor",strokeWidth:"1.5",strokeLinecap:"round",strokeLinejoin:"round"})),x.createElement("span",null,"Rename Chat")),x.createElement("button",{className:"sage-ai-more-options-item sage-ai-more-options-item-danger",onClick:()=>{o(),n()},type:"button"},x.createElement("svg",{width:"16",height:"16",viewBox:"0 0 16 16",fill:"none",xmlns:"http://www.w3.org/2000/svg"},x.createElement("path",{d:"M2 4H14M12.6667 4V13.3333C12.6667 13.6869 12.5262 14.0261 12.2761 14.2761C12.0261 14.5262 11.6869 14.6667 11.3333 14.6667H4.66667C4.31304 14.6667 3.97391 14.5262 3.72386 14.2761C3.47381 14.0261 3.33333 13.6869 3.33333 13.3333V4M5.33333 4V2.66667C5.33333 2.31304 5.47381 1.97391 5.72386 1.72386C5.97391 1.47381 6.31304 1.33333 6.66667 1.33333H9.33333C9.68696 1.33333 10.0261 1.47381 10.2761 1.72386C10.5262 1.97391 10.6667 2.31304 10.6667 2.66667V4",stroke:"currentColor",strokeWidth:"1.5",strokeLinecap:"round",strokeLinejoin:"round"})),x.createElement("span",null,"Delete Chat")))):x.createElement("div",{className:"sage-ai-more-options-popover"})}class Ne extends M.ReactWidget{constructor(e){super(),this._stateChanged=new E.Signal(this),this._actions=e,this._state={isVisible:!1,anchorElement:void 0},this.addClass("sage-ai-more-options-widget"),this.setupOutsideClickHandler()}get stateChanged(){return this._stateChanged}render(){return x.createElement(Ie,{isVisible:this._state.isVisible,onRenameChat:this._actions.onRenameChat,onDeleteChat:this._actions.onDeleteChat,onClose:()=>this.hide()})}showPopover(e){this._state={isVisible:!0,anchorElement:e},this._stateChanged.emit(this._state),this.update(),this.positionPopover(e)}hide(){this._state={isVisible:!1,anchorElement:void 0},this._stateChanged.emit(this._state),this.update()}positionPopover(e){const t=this.node.querySelector(".sage-ai-more-options-popover");if(t){let o=e.offsetParent;o||(o=document.body);let n=e.offsetTop,s=e.offsetLeft,i=e.offsetParent;for(;i&&i!==o;)n+=i.offsetTop,s+=i.offsetLeft,i=i.offsetParent;const a=t.style.visibility,r=t.style.display;t.style.visibility="hidden",t.style.display="block";const l=t.offsetHeight,c=t.offsetWidth;t.style.visibility=a,t.style.display=r;const d=e.offsetHeight,h=e.offsetWidth;let u=n-l-8,g=s;g+c>(o.offsetWidth||window.innerWidth)-8&&(g=s+h-c),g<8&&(g=8),u<8&&(u=n+d+8),t.style.position="absolute",t.style.top=u-22+"px",t.style.left=`${g}px`,t.style.transform="none",t.style.zIndex="9999"}}setupOutsideClickHandler(){const e=e=>{this._state.isVisible&&!this.node.contains(e.target)&&this._state.anchorElement&&!this._state.anchorElement.contains(e.target)&&this.hide()};document.addEventListener("click",e),this.disposed.connect(()=>{document.removeEventListener("click",e)})}getIsVisible(){return this._state.isVisible}getState(){return{...this._state}}}function De({isVisible:e,currentVersion:t,latestVersion:o,isUpdating:n,isMajorUpdate:s=!1,onUpdate:i,onAskLater:a,onDecline:r}){if(!e)return null;const l=!n&&!s;return x.createElement("div",{className:"sage-ai-update-banner"},x.createElement("div",{className:"sage-ai-update-banner-content"},x.createElement("div",{className:"sage-ai-update-banner-icon"},x.createElement("svg",{width:"20",height:"20",viewBox:"0 0 24 24",fill:"none",xmlns:"http://www.w3.org/2000/svg"},x.createElement("path",{d:"M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z",fill:"currentColor"}))),x.createElement("div",{className:"sage-ai-update-banner-text"},x.createElement("div",{className:"sage-ai-update-banner-title"},s?"Sage is auto-updating to a major version":"Sage needs to update"),t&&o&&x.createElement("div",{className:"sage-ai-update-banner-version"},"v",t," → v",o,s&&" (Major Version)"),s&&x.createElement("div",{className:"sage-ai-update-banner-description"},"Major version updates are applied automatically for important improvements and security fixes.")),l&&x.createElement("div",{className:"sage-ai-update-banner-actions"},x.createElement("button",{className:"sage-ai-update-banner-button sage-ai-update-banner-button-update",onClick:i,disabled:n},n?"Updating...":"Update"),x.createElement("button",{className:"sage-ai-update-banner-button sage-ai-update-banner-button-later",onClick:a,disabled:n},"Ask Me Later"),x.createElement("button",{className:"sage-ai-update-banner-button sage-ai-update-banner-button-decline",onClick:r,disabled:n},"Decline")),(n||s)&&x.createElement("div",{className:"sage-ai-update-banner-progress"},x.createElement("div",{className:"sage-ai-update-banner-spinner"}),x.createElement("span",null,n?"Updating...":"Preparing update..."))))}class Ae extends M.ReactWidget{constructor(e){super(),this._stateChanged=new E.Signal(this),this._packageName="sage-agent",this._checkInterval=null,this.handleUpdate=async()=>{this._state={...this._state,isUpdating:!0},this._stateChanged.emit(this._state),this.update();try{const e=this._extensions.installed.find(e=>e.name===this._packageName);e&&(console.log(`Updating ${this._packageName} to version ${e.latest_version}`),await this._extensions.install(e,{useVersion:e.latest_version}),this._state={...this._state,isVisible:!1,isUpdating:!1},this._stateChanged.emit(this._state),this.updateDisplayState(),this.update(),console.log(`Successfully updated ${this._packageName} to version ${e.latest_version}`))}catch(e){console.error("Failed to update:",e),this._state={...this._state,isUpdating:!1},this._stateChanged.emit(this._state),this.updateDisplayState(),this.update()}},this.handleAskLater=()=>{this._state={...this._state,isVisible:!1},this._stateChanged.emit(this._state),this.updateDisplayState(),this.update()},this.handleDecline=async()=>{await this.setDeclinedStatus(!0),this._state={...this._state,isVisible:!1,isDeclined:!0},this._stateChanged.emit(this._state),this.updateDisplayState(),this.update()},this._extensions=e,this._state={isVisible:!1,isUpdating:!1,isDeclined:!1,isMajorUpdate:!1},this.addClass("sage-ai-update-banner-widget"),this.node.style.display="none",this.initializeWidget()}async initializeWidget(){try{const e=await this.getDeclinedStatus();this._state={...this._state,isDeclined:e},this.checkForUpdates()}catch(e){console.error("Failed to initialize UpdateBannerWidget:",e),this.checkForUpdates()}}get stateChanged(){return this._stateChanged}async getDeclinedStatus(){try{return await T.getBooleanSetting(N,!1)}catch(e){return!1}}async setDeclinedStatus(e){try{e?await T.setBooleanSetting(N,!0):await T.removeSetting(N)}catch(e){}}parseVersion(e){const t=e.match(/^(\d+)\.(\d+)\.(\d+)/);return t?{major:parseInt(t[1],10),minor:parseInt(t[2],10),patch:parseInt(t[3],10)}:null}isMajorVersionChange(e,t){const o=this.parseVersion(e),n=this.parseVersion(t);return!(!o||!n)&&n.major>o.major}async checkForUpdates(){try{if(console.log("CHECKING FOR UPDATES..."),console.log(`Current state: ${JSON.stringify(this._state)}`),this._state.isDeclined)return;await this._extensions.refreshInstalled(!0);const e=this._extensions.installed.find(e=>e.name===this._packageName);if(e&&e.installed_version!==e.latest_version){const t=e.installed_version,o=e.latest_version;if(this.isMajorVersionChange(t,o))return console.log(`Major version change detected: ${t} → ${o}. Auto-updating...`),this._state={...this._state,isVisible:!0,isUpdating:!0,isMajorUpdate:!0,currentVersion:t,latestVersion:o},this._stateChanged.emit(this._state),this.updateDisplayState(),this.update(),void await this.handleUpdate();this._state={...this._state,isVisible:!0,isMajorUpdate:!1,currentVersion:t,latestVersion:o},this._stateChanged.emit(this._state),this.updateDisplayState(),this.update()}}catch(e){console.error("Failed to check for updates:",e)}}updateDisplayState(){this.node.style.display=this._state.isVisible?"block":"none"}showBanner(){this._state.isDeclined||this.checkForUpdates()}render(){return x.createElement(De,{isVisible:this._state.isVisible,currentVersion:this._state.currentVersion,latestVersion:this._state.latestVersion,isUpdating:this._state.isUpdating,isMajorUpdate:this._state.isMajorUpdate,onUpdate:this.handleUpdate,onAskLater:this.handleAskLater,onDecline:this.handleDecline})}dispose(){this._checkInterval&&(clearInterval(this._checkInterval),this._checkInterval=null),super.dispose()}}const Le=[];class Pe extends z.Widget{constructor(){var e,t,o;super(),this.modeSelectorOptions=new Map,this.modeName="agent",this.historyWidget=null,this.newChatDisplayWidget=null,this.updateBanner=null,this.currentServiceProvider=G.ANTHROPIC,this.id="sage-ai-chat",this.title.label="AI Chat",this.title.closable=!0,this.addClass("sage-ai-chatbox"),this.chatHistoryManager=new ne,this.chatService=ee.createService(this.currentServiceProvider),v.setChatService(this.chatService);const n=new z.PanelLayout;this.layout=n;const s=document.createElement("div");s.className="sage-ai-toolbar",this.threadSelectorButton=document.createElement("button"),this.threadSelectorButton.className="sage-ai-icon-button-md sage-ai-thread-selector-button",this.threadSelectorButton.innerHTML='\n     <svg width="20" height="21" viewBox="0 0 20 21" fill="none" xmlns="http://www.w3.org/2000/svg">\n      <path d="M2.5 10.5H17.5M2.5 5.5H17.5M2.5 15.5H17.5" stroke="#949494" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>\n      </svg>\n    ',this.threadSelectorButton.title="Select conversation thread",s.appendChild(this.threadSelectorButton),this.threadNameDisplay=document.createElement("span"),this.threadNameDisplay.className="sage-ai-thread-name",this.threadNameDisplay.textContent=(null===(e=this.chatHistoryManager.getCurrentThread())||void 0===e?void 0:e.name)||"New Chat",s.appendChild(this.threadNameDisplay);const i=document.createElement("div");i.className="sage-ai-checkbox-container sage-ai-autorun-toggle sage-ai-control-base",this.autorunCheckbox=document.createElement("input"),this.autorunCheckbox.id="sage-ai-autorun",this.autorunCheckbox.type="checkbox",this.autorunCheckbox.className="sage-ai-checkbox sage-ai-toggle-input",this.autorunCheckbox.title="Automatically run code without confirmation";const a=document.createElement("label");a.htmlFor="sage-ai-autorun",a.className="sage-ai-checkbox-label sage-ai-toggle-label",a.innerHTML='\n      <span class="sage-ai-toggle-switch"></span>\n      Auto Run\n    ',a.title="Automatically run code without confirmation",i.appendChild(this.autorunCheckbox),i.appendChild(a),this.newChatButton=document.createElement("button"),this.newChatButton.className="sage-ai-reset-button sage-ai-control-base",this.newChatButton.innerHTML='\n      <svg width="16" height="17" viewBox="0 0 16 17" fill="none" xmlns="http://www.w3.org/2000/svg">\n        <path d="M3.3335 8.49992H12.6668M8.00016 3.83325V13.1666" stroke="var(--jp-ui-font-color0)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>\n      </svg>\n    ',this.newChatButton.title="Start a new chat",this.newChatButton.addEventListener("click",()=>this.createNewChat()),this.undoButton=document.createElement("button"),this.undoButton.className="sage-ai-undo-button sage-ai-control-base",this.undoButton.innerHTML='\n      <svg width="16" height="17" viewBox="0 0 16 17" fill="none" xmlns="http://www.w3.org/2000/svg">\n        <path d="M5.99984 9.83341L2.6665 6.50008M2.6665 6.50008L5.99984 3.16675M2.6665 6.50008H9.6665C10.148 6.50008 10.6248 6.59492 11.0697 6.77919C11.5145 6.96346 11.9187 7.23354 12.2592 7.57402C12.5997 7.9145 12.8698 8.31871 13.0541 8.76357C13.2383 9.20844 13.3332 9.68523 13.3332 10.1667C13.3332 10.6483 13.2383 11.1251 13.0541 11.5699C12.8698 12.0148 12.5997 12.419 12.2592 12.7595C11.9187 13.1 11.5145 13.37 11.0697 13.5543C10.6248 13.7386 10.148 13.8334 9.6665 13.8334H7.33317" stroke="var(--jp-ui-font-color0)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>\n      </svg>\n    ',this.undoButton.disabled=!0,this.undoButton.title="No action to undo",this.undoButton.addEventListener("click",()=>this.undoLastAction());const r=document.createElement("button");r.className="sage-ai-more-options-button sage-ai-icon-button-md",r.innerHTML='\n      <svg width="18" height="19" viewBox="0 0 18 19" fill="none" xmlns="http://www.w3.org/2000/svg">\n        <path d="M9 10.25C9.41421 10.25 9.75 9.91421 9.75 9.5C9.75 9.08579 9.41421 8.75 9 8.75C8.58579 8.75 8.25 9.08579 8.25 9.5C8.25 9.91421 8.58579 10.25 9 10.25Z" stroke="var(--jp-ui-font-color0)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>\n        <path d="M14.25 10.25C14.6642 10.25 15 9.91421 15 9.5C15 9.08579 14.6642 8.75 14.25 8.75C13.8358 8.75 13.5 9.08579 13.5 9.5C13.5 9.91421 13.8358 10.25 14.25 10.25Z" stroke="var(--jp-ui-font-color0)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>\n        <path d="M3.75 10.25C4.16421 10.25 4.5 9.91421 4.5 9.5C4.5 9.08579 4.16421 8.75 3.75 8.75C3.33579 8.75 3 9.08579 3 9.5C3 9.91421 3.33579 10.25 3.75 10.25Z" stroke="var(--jp-ui-font-color0)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>\n      </svg>\n    ',r.title="More options",r.addEventListener("click",()=>this.showMoreOptions()),s.appendChild(i),s.appendChild(this.undoButton),s.appendChild(this.newChatButton),s.appendChild(r);const l=document.createElement("div");l.className="sage-ai-history-container",this.chatHistory=document.createElement("div"),this.chatHistory.className="sage-ai-chat-history",l.appendChild(this.chatHistory),this.historyWidget=new z.Widget({node:l}),this.llmStateDisplay=new Te,this.planStateDisplay=v.getPlanStateDisplay(),this.moreOptionsDisplay=new Ne({onRenameChat:()=>this.handleRenameChat(),onDeleteChat:()=>this.handleDeleteChat()}),this.messageComponent=new f(this.chatHistory,this.chatHistoryManager,v.getNotebookTools());const c=document.createElement("div");c.className="sage-ai-input-container",c.style.position="relative";const d=document.createElement("div");d.className="sage-ai-chatbox-wrapper";const h=document.createElement("div");h.className="sage-ai-context-row";const u=document.createElement("button"),g=document.createElement("span");g.className="sage-ai-at-icon",g.innerHTML='<svg xmlns="http://www.w3.org/2000/svg" width="12" height="13" viewBox="0 0 12 13" fill="none">\n  <g clip-path="url(#clip0_590_6942)">\n    <path d="M8.00001 4.5V7C8.00001 7.39783 8.15804 7.77936 8.43935 8.06066C8.72065 8.34197 9.10218 8.5 9.50001 8.5C9.89783 8.5 10.2794 8.34197 10.5607 8.06066C10.842 7.77936 11 7.39783 11 7V6.5C11 5.37366 10.6197 4.2803 9.92071 3.39709C9.22172 2.51387 8.24499 1.89254 7.14877 1.63376C6.05255 1.37498 4.90107 1.49391 3.88089 1.97128C2.86071 2.44865 2.03159 3.2565 1.52787 4.26394C1.02415 5.27137 0.875344 6.41937 1.10556 7.52194C1.33577 8.62452 1.93151 9.61706 2.79627 10.3388C3.66102 11.0605 4.74413 11.4691 5.87009 11.4983C6.99606 11.5276 8.09893 11.1758 9.00001 10.5M8 6.5C8 7.60457 7.10457 8.5 6 8.5C4.89543 8.5 4 7.60457 4 6.5C4 5.39543 4.89543 4.5 6 4.5C7.10457 4.5 8 5.39543 8 6.5Z" stroke="#949494" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round"/>\n  </g>\n  <defs>\n    <clipPath id="clip0_590_6942">\n      <rect width="12" height="12" fill="white" transform="translate(0 0.5)"/>\n    </clipPath>\n  </defs>\n</svg>';const p=document.createElement("p");p.className="sage-ai-context-text",p.textContent="Add Context",u.className="sage-ai-add-context-button",u.appendChild(g),u.appendChild(p),u.title="Add context",u.type="button",u.addEventListener("click",e=>{e.preventDefault(),e.stopPropagation(),this.chatInput.focus();const t=this.chatInput.getPlainText(),o=this.chatInput.getSelectionStart(),n=t.slice(0,o)+"@"+t.slice(o);this.chatInput.setPlainText(n),setTimeout(()=>{this.chatInput.setSelectionRange(o+1,o+1);const e=new Event("input",{bubbles:!0});this.chatInput.getInputElement().dispatchEvent(e)},0)});const m=document.createElement("div");m.className="sage-ai-context-display-inline",h.appendChild(u),h.appendChild(m);const C=document.createElement("div");C.className="sage-ai-input-row",this.chatInput=new ce("What would you like me to generate or analyze?"),this.chatInput.addEventListener("keydown",e=>{const t=e;"Enter"!==t.key||t.shiftKey||""===this.chatInput.getPlainText().trim()||this.inputManager.getIsProcessingMessage()||(t.preventDefault(),this.inputManager.sendMessage())}),this.sendButton=document.createElement("button"),fe.render(this.sendButton),this.sendButton.className="sage-ai-send-button disabled",this.sendButton.style.position="absolute",this.sendButton.style.bottom="12px",this.sendButton.style.right="12px",this.sendButton.addEventListener("click",()=>{this.inputManager.getIsProcessingMessage()?this.cancelMessage():""!==this.chatInput.getPlainText().trim()&&this.inputManager.sendMessage()});const y=()=>{const e=""!==this.chatInput.getPlainText().trim();this.inputManager.getIsProcessingMessage()||e?(this.sendButton.classList.add("enabled"),this.sendButton.classList.remove("disabled"),this.sendButton.disabled=!1):(this.sendButton.classList.remove("enabled"),this.sendButton.classList.add("disabled"),this.sendButton.disabled=!0)};this.sendButton.disabled=!0,this.chatInput.addEventListener("input",y),this.chatInput.addEventListener("keyup",y),this.chatInput.addEventListener("paste",()=>{setTimeout(y,0)}),this.modeSelector=document.createElement("div"),this.modeSelector.className="sage-ai-mode-selector",this.modeSelector.title="Select chat mode",this.modeSelectorDropdown=document.createElement("div"),this.modeSelectorDropdown.className="sage-ai-mode-dropdown hidden";const b=document.createElement("div");b.className="sage-ai-mode-dropdown-content";const k=this.createOption("agent","Agent",he.svgstr,"Prepare datasets. Build models. Test ideas."),w=this.createOption("ask","Ask",pe.svgstr,"Ask Sage about your notebook or your data."),S=this.createOption("fast","Hands-on",ge.svgstr,"Manually decide what gets added to the context.");b.appendChild(k),b.appendChild(w),b.appendChild(S),this.modeSelectorDropdown.appendChild(b),this.updateModeSelectorDisplay("agent"),this.modeSelector.addEventListener("click",e=>{e.stopPropagation(),"true"!==this.modeSelector.getAttribute("data-is-disabled")&&this.toggleModeDropdown()}),document.addEventListener("click",()=>{this.closeModeDropdown()}),C.appendChild(this.chatInput.getElement()),C.appendChild(this.sendButton),C.appendChild(this.modeSelector),d.appendChild(h),d.appendChild(C),c.appendChild(d);const _=document.createElement("div");_.className="sage-ai-new-prompt-cta";const x=document.createElement("p");x.textContent="Want to start a new prompt?";const M=document.createElement("a");M.textContent="Create a New Chat",M.onclick=()=>(this.createNewChat(),!1),_.appendChild(x),_.appendChild(M),this.hideNewChatCta(),this.newChatDisplayWidget=new be({onPromptSelected:e=>{this.inputManager.setInputValue(e),this.inputManager.sendMessage(),this.showHistoryWidget()},onRemoveDisplay:()=>{this.showHistoryWidget()}},Le);const E=v.getExtensions();E&&(this.updateBanner=new Ae(E),this.updateBanner.showBanner()),n.addWidget(new z.Widget({node:s})),n.addWidget(this.historyWidget),n.addWidget(this.newChatDisplayWidget),document.body.appendChild((null===(t=this.updateBanner)||void 0===t?void 0:t.node)||document.createElement("div")),this.showHistoryWidget(),null===(o=this.updateBanner)||void 0===o||o.checkForUpdates();const T=new z.Widget({node:c}),I=document.createElement("div");I.className="sage-ai-state-display-container",I.style.position="fixed",I.style.bottom="0",I.style.left="0",I.style.right="0",I.style.pointerEvents="none",I.style.zIndex="1",I.style.display="flex",I.style.flexDirection="column",I.style.alignItems="stretch";const N=this.planStateDisplay.getWidget().node,D=this.llmStateDisplay.getWidget().node,A=document.createElement("div");A.className="sage-ai-input-spacer",A.style.order="3",A.style.flexShrink="0";const L=()=>{const e=c.offsetHeight,t="none"===_.style.display?29:0;A.style.height=e-t+16+"px",requestAnimationFrame(()=>{setTimeout(()=>{let e=0;!this.llmStateDisplay.node.classList.contains("hidden")&&this.llmStateDisplay.node.offsetHeight>0&&(e+=this.llmStateDisplay.node.offsetHeight),this.planStateDisplay.getIsVisible()&&this.planStateDisplay.node.offsetHeight>0&&(e+=this.planStateDisplay.node.offsetHeight),this.chatHistory.parentElement.style.paddingBottom=`${e}px`},200)})};this.updateStateDisplayPositions=L,this.planStateConnection=this.planStateDisplay.stateChanged.connect(()=>{setTimeout(L,100)}),setTimeout(L,100),this.resizeObserver=new ResizeObserver(L),this.resizeObserver.observe(c),this.mutationObserver=new MutationObserver(()=>{setTimeout(L,100)}),this.mutationObserver.observe(this.llmStateDisplay.node,{childList:!0,subtree:!0,attributes:!0,attributeFilter:["class"]}),this.mutationObserver.observe(this.planStateDisplay.node,{childList:!0,subtree:!0,attributes:!0,attributeFilter:["class"]}),I.appendChild(N),I.appendChild(D),I.appendChild(A),n.addWidget(T),n.addWidget(new z.Widget({node:I})),n.addWidget(new z.Widget({node:_})),n.addWidget(this.moreOptionsDisplay),this.threadManager=new se(this.chatHistoryManager,this.messageComponent,this.chatService,this.threadNameDisplay,this.node),this.inputManager=new de(this.chatInput,this.chatHistoryManager,c,v.getContentManager(),v.getToolService(),e=>{this.messageComponent.addMentionContext(e),this.contextHandler.updateContextDisplay(),console.log("Context added:",e)},e=>{this.messageComponent.removeMentionContext(e),this.contextHandler.updateContextDisplay(),console.log(`Context removed: ${e}`)},()=>this.createNewChat()),this.uiHelper=new ye(this.chatHistory,this.messageComponent,this.llmStateDisplay),this.contextHandler=new ve(this.messageComponent,this.inputManager,this.node),this.conversationService=new q(this.chatService,v.getToolService(),v.getContentManager(),this.messageComponent,this.chatHistory,this,void 0,this.autorunCheckbox);const P=v.getState().notebookDiffManager;P&&this.conversationService.setDiffManager(P),this.setupEventHandlers(),this.initializeServices(),this.subscribeToAppStateChanges(),this.inputManager.setDependencies({chatService:this.chatService,conversationService:this.conversationService,messageComponent:this.messageComponent,uiHelper:this.uiHelper,contextHandler:this.contextHandler,sendButton:this.sendButton,modeSelector:this.modeSelector,updateUndoButtonState:()=>this.updateUndoButtonState(),cancelMessage:()=>this.cancelMessage(),onMessageSent:()=>this.showHistoryWidget()}),setInterval(()=>this.updateUndoButtonState(),1e3),v.getWaitingUserReplyBoxManager().initialize(c),this.contextHandler.updateContextDisplay(),0===this.messageComponent.getMessageHistory().length&&this.showNewChatDisplay()}createOption(e,t,o,n){const s=document.createElement("div");s.className="sage-ai-mode-option",s.setAttribute("data-value",e);const i=document.createElement("div");i.className="sage-ai-mode-option-icon",i.innerHTML=o;const a=document.createElement("div");return a.innerHTML=`\n      <p class="sage-ai-mode-option-title">\n      ${t}\n       </p>\n       <p class="sage-ai-mode-option-description">\n      ${n}\n       </p>\n    `,a.className="sage-ai-mode-option-text",s.appendChild(i),s.appendChild(a),this.modeSelectorOptions.set(e,s),s.addEventListener("click",t=>{t.stopPropagation(),this.selectMode(e)}),s}updateModeSelectorDisplay(e){const t=this.modeSelectorOptions.get(e);if(t){this.modeSelector.innerHTML="";const e=document.createElement("div");e.className="sage-ai-mode-display";const o=document.createElement("div");o.className="sage-ai-mode-option-icon",o.innerHTML=ue.svgstr,e.appendChild(o);const n=t.querySelector(".sage-ai-mode-option-text");if(n){const t=n.querySelector(".sage-ai-mode-option-title");if(t){const o=document.createElement("div");o.className="sage-ai-mode-option-text",o.innerHTML=t.innerHTML,e.appendChild(o)}}const s=document.createElement("div");s.className="sage-ai-mode-selector-arrow",me.render(s),this.modeSelector.appendChild(e),this.modeSelector.appendChild(s)}}toggleModeDropdown(){this.modeSelectorDropdown.classList.contains("hidden")?this.openModeDropdown():this.closeModeDropdown()}openModeDropdown(){this.modeSelector.classList.add("open");const e=this.modeSelector.getBoundingClientRect();this.modeSelectorDropdown.style.position="absolute",this.modeSelectorDropdown.style.bottom=window.innerHeight-e.top+8+"px",this.modeSelectorDropdown.style.left=`${e.left}px`,this.modeSelectorDropdown.style.minWidth=`${e.width}px`,document.body.appendChild(this.modeSelectorDropdown),this.modeSelectorDropdown.classList.remove("hidden"),this.modeSelectorDropdown.classList.add("opening"),requestAnimationFrame(()=>{this.modeSelectorDropdown.classList.add("visible")}),setTimeout(()=>{this.modeSelectorDropdown.classList.remove("opening")},300)}closeModeDropdown(){this.modeSelector.classList.remove("open"),this.modeSelectorDropdown.classList.add("closing"),this.modeSelectorDropdown.classList.remove("visible"),setTimeout(()=>{this.modeSelectorDropdown.classList.add("hidden"),this.modeSelectorDropdown.classList.remove("closing"),this.modeSelectorDropdown.parentNode===document.body&&document.body.removeChild(this.modeSelectorDropdown)},200)}selectMode(e){if(this.modeName=e,this.inputManager.setModeName(this.modeName),this.chatService instanceof X&&"fast"===e){const e=this.chatService.getToolBlacklist();this.messageComponent.addSystemMessage(`Hands-on mode enabled. Using optimized prompt and limiting certain tools: ${e.join(", ")}`)}this.updateModeSelectorDisplay(e),this.closeModeDropdown();const t="agent"===e?"Agent":"ask"===e?"Ask":"Hands-on";this.messageComponent.addSystemMessage(`Mode switched to: ${t}`)}updateNotebookPath(e){v.setCurrentNotebookPath(e),this.threadManager.updateNotebookPath(e),this.conversationService.updateNotebookPath(e)}setupEventHandlers(){this.threadSelectorButton.addEventListener("click",()=>{this.threadManager.openBanner()}),this.autorunCheckbox.addEventListener("change",()=>{this.conversationService.setAutoRun(this.autorunCheckbox.checked),this.autorunCheckbox.checked?this.messageComponent.addSystemMessage("Auto-run mode enabled. Code will execute automatically without confirmation."):this.messageComponent.addSystemMessage("Auto-run mode disabled. You will be prompted for code execution.")})}async initializeServices(){try{v.setConfig(await W.getConfig());const e=await this.chatService.initialize();console.log("Chat service initialized:",e),e&&this.chatService.getModelName();const t=v.getToolService();await t.initialize(),console.log("Connected to MCP server successfully."),console.log(`Loaded ${t.getTools().length} tools from MCP server.`)}catch(e){console.error("Failed to connect to MCP server:",e),this.messageComponent.addSystemMessage("❌ Failed to connect to MCP server. Some features may not work.")}}setNotebookPath(e){if(!e)return v.setCurrentNotebookPath(null),void this.threadManager.setNotebookPath(null);e!==v.getState().currentNotebookPath&&(console.log(`[ChatBoxWidget] Switching to notebook: ${e}`),v.setCurrentNotebookPath(e),this.chatHistoryManager.setCurrentNotebook(e),this.threadManager.setNotebookPath(e),this.showNewChatDisplayOrHistory(),this.conversationService.setNotebookPath(e)),this.inputManager.loadUserMessageHistory();const t=v.getState().notebookContextManager;if(t){const o=t.getContextCells(e);this.contextHandler.updateContextCellsIndicator(o.length)}}async createNewChat(){v.getWaitingUserReplyBoxManager().hide(),v.getState().currentNotebookPath?(this.inputManager.getIsProcessingMessage()?this.cancelMessage():this.chatService.cancelRequest(),this.threadManager.createNewThread()&&(this.conversationService.clearActionHistory(),this.updateUndoButtonState(),this.contextHandler.updateContextDisplay(),this.showNewChatDisplay(),this.llmStateDisplay.hide())):this.messageComponent.addSystemMessage("Please open a notebook first.")}updateUndoButtonState(){if(this.conversationService.canUndo()){const e=this.conversationService.getLastActionDescription();this.undoButton.disabled=!1,this.undoButton.title=`Undo: ${e}`}else this.undoButton.disabled=!0,this.undoButton.title="No action to undo"}async undoLastAction(){if(this.conversationService.canUndo()){this.undoButton.disabled=!0,this.undoButton.title="Undoing...";try{await this.conversationService.undoLastAction()}catch(e){console.error("Error during undo:",e),this.messageComponent.addErrorMessage(`Error during undo: ${e instanceof Error?e.message:"Unknown error"}`)}finally{this.updateUndoButtonState()}}}cancelMessage(){if(console.log("Cancelling message..."),console.log(this.inputManager.getIsProcessingMessage()),!this.inputManager.getIsProcessingMessage())return;console.log("Cancelling message processing..."),this.chatService.cancelRequest(),this.inputManager.setIsProcessingMessage(!1),this.uiHelper.removeLoadingIndicator(),this.messageComponent.addSystemMessage("Request cancelled by user."),this.messageComponent.removeLoadingText(),this.uiHelper.updateSendButton(this.sendButton,!1),this.sendButton.classList.add("disabled"),this.sendButton.classList.remove("enabled"),this.sendButton.disabled=!0,v.getPlanStateDisplay().setLoading(!1),this.uiHelper.updateAgentModeElement(this.modeSelector,!1);const e=document.createElement("div");ue.render(e);const t=v.getState().notebookDiffManager;if(t&&t.hasPendingDiffs()&&!t.isDialogOpen()){if(this.llmStateDisplay){const e=v.getState().currentNotebookPath;this.llmStateDisplay.showPendingDiffs(e)}setTimeout(async()=>{const e=v.getState().currentNotebookPath;await(null==t?void 0:t.showCancellationApprovalDialog(this.chatHistory,e))},100)}else this.llmStateDisplay.show(),this.llmStateDisplay.hide()}async sendMessage(e){return this.inputManager.sendMessage(e)}setAnthropicPromptAndBlacklist(e,t){this.chatService instanceof X&&(this.chatService.setSystemPrompt(e),this.chatService.setToolBlacklist(t))}onAfterShow(){this.inputManager.focus()}updateLoadingIndicator(e="Generating..."){this.uiHelper.updateLoadingIndicator(e)}removeLoadingIndicator(){this.uiHelper.removeLoadingIndicator()}onCellAddedToContext(e){this.contextHandler.onCellAddedToContext(e)}onCellRemovedFromContext(e){this.contextHandler.onCellRemovedFromContext(e)}showNewChatDisplayOrHistory(){const e=this.chatHistoryManager.getCurrentThread();e&&e.messages.length>0?this.showHistoryWidgetFromThread(e):this.showNewChatDisplay()}showNewChatCta(){const e=this.node.querySelector(".sage-ai-new-prompt-cta");e&&(e.style.display="flex")}hideNewChatCta(){const e=this.node.querySelector(".sage-ai-new-prompt-cta");e&&(e.style.display="none")}showNewChatDisplay(){this.messageComponent.getMessageHistory().length>0||(this.newChatDisplayWidget&&(this.newChatDisplayWidget.node.style.display="flex"),this.historyWidget&&(this.historyWidget.node.style.display="none"),this.hideNewChatCta())}showHistoryWidget(){this.newChatDisplayWidget&&(this.newChatDisplayWidget.node.style.display="none"),this.historyWidget&&(this.historyWidget.node.style.display="block"),this.showNewChatCta()}showHistoryWidgetFromThread(e){this.messageComponent.loadFromThread(e),this.showHistoryWidget()}showMoreOptions(){const e=this.node.querySelector(".sage-ai-more-options-button");e&&this.moreOptionsDisplay&&this.moreOptionsDisplay.showPopover(e)}async handleRenameChat(){const e=this.chatHistoryManager.getCurrentThread();if(!e)return void this.messageComponent.addSystemMessage("No active chat to rename.");const t=prompt("Enter new chat name:",e.name);t&&""!==t.trim()&&t!==e.name&&(this.chatHistoryManager.renameCurrentThread(t.trim())?(this.threadNameDisplay.textContent=t.trim(),this.messageComponent.addSystemMessage(`Chat renamed to: ${t.trim()}`)):this.messageComponent.addSystemMessage("Failed to rename chat."))}async handleDeleteChat(){const e=this.chatHistoryManager.getCurrentThread();if(e){if(confirm(`Are you sure you want to delete the chat "${e.name}"? This action cannot be undone.`)){const t=e.name;if(this.chatHistoryManager.deleteThread(e.id)){this.messageComponent.addSystemMessage(`Chat "${t}" has been deleted.`);const e=this.chatHistoryManager.getCurrentThread();e?(this.threadNameDisplay.textContent=e.name,this.messageComponent.loadFromThread(e),e.messages.length>0?this.showHistoryWidget():this.showNewChatDisplay()):this.showNewChatDisplay()}else this.messageComponent.addSystemMessage("Failed to delete chat.")}}else this.messageComponent.addSystemMessage("No active chat to delete.")}subscribeToAppStateChanges(){const e=v.getClaudeSettings();this.lastClaudeSettings={claudeApiKey:e.claudeApiKey,claudeModelId:e.claudeModelId,claudeModelUrl:e.claudeModelUrl},this.appStateSubscription=v.changes.subscribe(e=>{const t={claudeApiKey:e.settings.claudeApiKey,claudeModelId:e.settings.claudeModelId,claudeModelUrl:e.settings.claudeModelUrl};(!this.lastClaudeSettings||this.lastClaudeSettings.claudeApiKey!==t.claudeApiKey||this.lastClaudeSettings.claudeModelId!==t.claudeModelId||this.lastClaudeSettings.claudeModelUrl!==t.claudeModelUrl)&&(console.log("Claude settings changed, re-initializing chat service...",{previous:this.lastClaudeSettings,current:t}),this.lastClaudeSettings=t,this.reinitializeChatService())})}async reinitializeChatService(){try{console.log("Re-initializing chat service with updated Claude settings...");const e=await this.chatService.initialize();console.log("Chat service re-initialized:",e),e?this.chatService.getModelName():this.messageComponent.addSystemMessage("⚠️ Failed to re-initialize with updated settings. Please check your API key.")}catch(e){console.error("Failed to re-initialize chat service:",e),this.messageComponent.addSystemMessage("⚠️ Error updating settings. Please try again.")}}dispose(){var e,t,o,n,s,i,a;null===(e=this.resizeObserver)||void 0===e||e.disconnect(),null===(t=this.mutationObserver)||void 0===t||t.disconnect(),null===(o=this.llmStateConnection)||void 0===o||o.dispose(),null===(n=this.planStateConnection)||void 0===n||n.dispose(),null===(s=this.moreOptionsDisplay)||void 0===s||s.dispose(),null===(i=this.updateBanner)||void 0===i||i.dispose(),null===(a=this.appStateSubscription)||void 0===a||a.unsubscribe(),super.dispose()}}var Re=o(6341),He=o(1336),$e=(o(9864),o(693),o(113)),Be=o(6828);function Oe(e){return new Promise(t=>setTimeout(t,e))}var Ue=o(1771);class je{static detectJupyterLabTheme(){return"false"===document.body.getAttribute("data-jp-theme-light")?Be.d7.DARK:Be.d7.LIGHT}static initializeThemeDetection(){if(!je.themeObserver)try{const e=document.body;je.themeObserver=new MutationObserver(e=>{let t=!1;e.forEach(e=>{if("attributes"===e.type){const o=e.attributeName;"data-jp-theme-light"!==o&&"data-jp-theme-name"!==o&&"class"!==o||(t=!0)}}),t&&(console.log("JupyterLab theme change detected, refreshing diff displays..."),je.onThemeChangeCallbacks.forEach(e=>{try{e()}catch(e){console.error("Error in theme change callback:",e)}}))}),je.themeObserver.observe(e,{attributes:!0,attributeFilter:["data-jp-theme-light","data-jp-theme-name","class"]}),console.log("Theme detection initialized for diff2html")}catch(e){console.error("Failed to initialize theme detection:",e)}}static onThemeChange(e){je.onThemeChangeCallbacks.push(e)}static cleanupThemeDetection(){je.themeObserver&&(je.themeObserver.disconnect(),je.themeObserver=null),je.onThemeChangeCallbacks=[]}static getCurrentTheme(){return je.detectJupyterLabTheme()}static isDarkTheme(){return je.detectJupyterLabTheme()===Be.d7.DARK}static refreshAllDiffDisplays(){try{document.querySelectorAll(".jp-DiffOverlay").forEach(e=>{const t=e,o=t.dataset.cellId,n=t.dataset.diffType;if(o&&n){const e=t.closest(".jp-Cell");if(e){const n=e;if(n._sage_diff_metadata){const{oldText:e,newText:s}=n._sage_diff_metadata,i=je.generateHtmlDiff(e,s,!0);t.innerHTML=i,console.log(`Refreshed diff display for cell ${o} with new theme`)}}}})}catch(e){console.error("Error refreshing diff displays:",e)}}calculateDiff(e,t){const o=e.split("\n"),n=t.split("\n"),s=[];let i=0,a=0;for(;i<o.length||a<n.length;)i>=o.length?(s.push({line:n[a],type:"added"}),a++):a>=n.length?(s.push({line:o[i],type:"removed"}),i++):o[i]===n[a]?(s.push({line:o[i],type:"unchanged"}),i++,a++):(s.push({line:o[i],type:"removed"}),s.push({line:n[a],type:"added"}),i++,a++);return s}formatDiffForConsole(e){const t="[0m";return e.map(e=>"added"===e.type?`[32m+ ${e.line}${t}`:"removed"===e.type?`[31m- ${e.line}${t}`:`  ${e.line}`).join("\n")}static generateHtmlDiff(e,t,o){const n=o?["","",{context:1/0}]:[],s=$e.createTwoFilesPatch("Original.py","Modified.py",e,t,...n),i=je.detectJupyterLabTheme(),a=He.parse(s,{outputFormat:"line-by-line",matching:"lines",colorScheme:i});a.forEach(e=>{e.language="py"});const r=document.createElement("div"),l=new Ue.L(r,a,{drawFileList:!1,outputFormat:"line-by-line",matching:"lines",colorScheme:i,highlight:!0});return l.highlightCode(),l.draw(),r.innerHTML}display_diff(e,t,o,n,s){var i;try{je.initializeThemeDetection();const a=e.normalizeContent(o),r=e.normalizeContent(n),l=e.getCurrentNotebook();if(!(null==l?void 0:l.notebook))throw new Error("No active notebook found");e.activateCell(t);const c=t.model.type;this.store_diff_metadata(t,o,n,s,c);const d=null===(i=e.getCurrentNotebook())||void 0===i?void 0:i.notebook.activeCell,h=je.generateHtmlDiff(a,r,!0);let u=d.node.getElementsByClassName("jp-InputArea-editor");return setTimeout(async()=>{var e;const t=u.item(0);if(t){const o=document.createElement("div");o.className="jp-DiffOverlay",o.style.position="absolute",o.style.top="0",o.style.left="0",o.style.width="100%",o.style.height="100%",o.style.zIndex="100",o.style.backgroundColor="var(--jp-layout-color0)",o.innerHTML=h,o.dataset.cellId=d.model.id,o.dataset.diffType=s,d.node._sage_diff_metadata={oldText:a,newText:r,operation:s},"static"===window.getComputedStyle(t).position&&(t.style.position="relative");const n=t.querySelector(".jp-DiffOverlay");n&&n.remove(),t.appendChild(o),await Oe(50);const i=null===(e=t.querySelector(".d2h-file-wrapper"))||void 0===e?void 0:e.clientHeight;console.log(i),i&&(t.style.minHeight=`${i}px`)}},100),{htmlDiff:h,cell:d,cellId:d.model.id}}catch(e){throw console.error("Error displaying diff:",e),e}}static removeDiffOverlay(e){try{const t=e.node.getElementsByClassName("jp-InputArea-editor").item(0);if(t){const e=t.querySelector(".jp-DiffOverlay");e&&e.remove(),t.style.removeProperty("min-height")}}catch(e){console.error("Error removing diff overlay:",e)}}store_diff_metadata(e,t,o,n,s){try{const i=e.model.sharedModel.getMetadata()||{},a={originalContent:t,newContent:o,operation:n,originalCellType:s,timestamp:(new Date).toISOString()},r="object"==typeof i.custom&&i.custom?i.custom:{},l={...i,custom:{...r,diff:a}};e.model.sharedModel.setMetadata(l),console.log("Cell metadata after storing diff:",e.model.sharedModel.getMetadata())}catch(e){console.error("Error storing diff metadata:",e)}}apply_diff(e,t,o){var n,s,i;try{const a=null===(n=e.getCurrentNotebook())||void 0===n?void 0:n.notebook;e.activateCell(t);const r=null===(s=e.getCurrentNotebook())||void 0===s?void 0:s.notebook.activeCell;"markdown"===t.model.type&&a&&Re.NotebookActions.runCells(a,[t]);const l=r.model.sharedModel.getMetadata()||{},c=(l.custom||{}).diff;if(!c)return console.warn("No diff metadata found"),{success:!1};const{originalContent:d="",newContent:h="",operation:u="",originalCellType:g="code"}=c;je.removeDiffOverlay(r),o?"remove"!==u&&r.model.sharedModel.setSource(h):"add"===u?r.model.sharedModel.setSource(""):r.model.sharedModel.setSource(d);const p=null===(i=e.getCurrentNotebook())||void 0===i?void 0:i.notebook;let m=r.model.id;if(p&&r.model.type!==g){Re.NotebookActions.changeCellType(p,g);const e=p.activeCell;e&&e.model.id!==m&&(m=e.model.id)}const f={...l};if(f.custom){const e="object"==typeof f.custom&&f.custom?{...f.custom}:{};e&&(delete e.diff,f.custom=e)}return r.model.sharedModel.setMetadata(f),console.log("Cell metadata after applying diff:",r.model.sharedModel.getMetadata()),{success:!0,updatedCellId:m}}catch(e){return console.error("Error applying diff:",e),{success:!1}}}logDiff(e,t,o,n,s){const i=e(t),a=e(o),r="add"===n&&""===i?a.split("\n").map(e=>({line:e,type:"added"})):this.calculateDiff(i,a);console.log(`--- DIFF for ${n}${s?` on cell ${s}`:""} ---`),console.log(this.formatDiffForConsole(r)),console.log("--- END DIFF ---")}}je.themeObserver=null,je.onThemeChangeCallbacks=[];class Fe{constructor(){this.dialogElement=null,this.parentElement=null,this.callbacks=null,this.diffCells=[],this.resolvePromise=null,this.embedded=!1,this.isRunContext=!1,this.currentNotebookPath=null,this.cellButtonElements=new Map,this.subscriptions=[]}setCallbacks(e){this.callbacks=e}updateNotebookPath(e){this.currentNotebookPath=e}async showDialog(e,t=null,o=!1,n=!1){var s;const i=F.getCurrentState(),a=Array.from(i.pendingDiffs.values());this.diffCells=a.filter(e=>!t||e.notebookPath===t).map(e=>{var t;return{...e,displaySummary:e.summary||(null===(t=e.metadata)||void 0===t?void 0:t.summary)||`${e.type} cell`}}),this.parentElement=e,this.embedded=o,this.isRunContext=n,this.currentNotebookPath=t,this.setupDiffStateSubscriptions(),this.createDialog();const r=null===(s=v.getChatContainerSafe())||void 0===s?void 0:s.chatWidget.llmStateDisplay;return r&&r.showPendingDiffs(t,n),this.embedded&&this.dialogElement&&setTimeout(()=>{var e;null===(e=this.dialogElement)||void 0===e||e.scrollIntoView({behavior:"smooth",block:"nearest"}),this.parentElement.scrollTop=this.parentElement.scrollHeight},100),new Promise(e=>{this.resolvePromise=e})}isDialogOpen(){return null!==this.dialogElement}createDialog(){if(!this.parentElement)return void console.error("Parent element not provided for diff approval dialog");this.dialogElement=document.createElement("div"),this.dialogElement.className=this.embedded?"sage-ai-diff-approval-dialog-embedded":"sage-ai-diff-approval-dialog";const e=document.createElement("p"),t=this.currentNotebookPath?` in notebook "${this.currentNotebookPath.split("/").pop()}"`:"";e.textContent=`Review and approve/reject the following changes${t}:`,this.embedded&&(e.className="sage-ai-diff-summary");const o=document.createElement("div");o.className="sage-ai-diff-list",this.diffCells.forEach(e=>{const t=this.createDiffCellItem(e);o.appendChild(t)}),this.dialogElement.appendChild(o);const n=document.createElement("div");n.className=this.embedded?"sage-ai-inline-diff-actions":"sage-ai-diff-approval-actions";const s=document.createElement("button");s.className="sage-ai-reject-button",s.textContent="Reject All",s.onclick=()=>this.rejectAll();const i=document.createElement("button");i.className="sage-ai-confirm-button",i.textContent=this.isRunContext?"Approve All and Run":"Approve All",i.onclick=()=>this.approveAll(),n.appendChild(s),n.appendChild(i),this.dialogElement.appendChild(n),this.parentElement.appendChild(this.dialogElement)}createDiffCellItem(e){const t=document.createElement("div");t.className="sage-ai-diff-cell-item",t.dataset.cellId=e.cellId;const o=document.createElement("div");o.className="sage-ai-diff-cell-header";const n=document.createElement("span");n.className="sage-ai-diff-content-collapse-icon",n.innerHTML=Ve,n.onclick=()=>i.style.display="none"===i.style.display?"block":"none",o.appendChild(n);const s=document.createElement("span");s.className="sage-ai-diff-cell-id-label",s.textContent=e.cellId,s.onclick=()=>{var t;return null===(t=this.callbacks)||void 0===t?void 0:t.onCellIdClick(e.cellId)},o.appendChild(s),t.appendChild(o);const i=document.createElement("div");if(i.className="sage-ai-diff-content",i.title="Click to expand/collapse diff content",i.innerHTML=je.generateHtmlDiff(e.originalContent||"",e.newContent||"",!1),i.querySelectorAll("tr").length>9){i.style.cursor="pointer";const e=document.createElement("div");e.className="sage-ai-diff-gradient-overlay",i.addEventListener("scroll",()=>{const t=i.scrollTop,o=i.scrollHeight-t-i.clientHeight;e.style.display=o<=20?"none":"block"}),i.onclick=()=>{i.classList.contains("sage-ai-diff-expanded")?(i.classList.remove("sage-ai-diff-expanded"),i.title="Click to expand diff content",e.style.display="block"):(i.classList.add("sage-ai-diff-expanded"),i.title="Click to collapse diff content",e.style.display="none")},i.appendChild(e)}t.appendChild(i);const a=document.createElement("div");a.className="sage-ai-diff-hover-buttons";const r=document.createElement("button");r.className="sage-ai-diff-approve-button",r.innerHTML='<svg width="15" height="16" viewBox="0 0 15 16" fill="none" xmlns="http://www.w3.org/2000/svg">\n          <path d="M12.5 4.25L5.625 11.125L2.5 8" stroke="#22C55E" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>\n    </svg>',r.title="Approve this change",r.style.cssText="\n      background-color: transparent;\n      color: white;\n      border: none;\n      border-radius: 4px;\n      cursor: pointer;\n      font-weight: bold;\n    ";const l=document.createElement("button");l.className="sage-ai-diff-reject-button",l.innerHTML='<svg width="15" height="16" viewBox="0 0 15 16" fill="none" xmlns="http://www.w3.org/2000/svg">\n      <path d="M11.25 4.25L3.75 11.75M3.75 4.25L11.25 11.75" stroke="#FF2323" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>\n    </svg>',l.title="Reject this change",l.style.cssText="\n      background-color: transparent;\n      color: white;\n      border: none;\n      border-radius: 4px;\n      cursor: pointer;\n      font-size: 12px;\n      font-weight: bold;\n    ";const c=document.createElement("button");return c.className="sage-ai-diff-run-button",c.innerHTML='<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">\n  <path d="M4 2.91583C4 2.52025 4.43762 2.28133 4.77038 2.49524L12.6791 7.57941C12.9852 7.77623 12.9852 8.22377 12.6791 8.42059L4.77038 13.5048C4.43762 13.7187 4 13.4798 4 13.0842V2.91583Z" fill="#3B82F6" stroke="#3B82F6" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>\n  <path d="M13.1018 5.35787L6.45639 9.55022L5.34214 7.88071" stroke="#1A1A1A" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>\n</svg>',c.title="Apply this change and run the cell immediately",c.style.cssText="\n      background-color: transparent;\n      color: white;\n      border: none;\n      border-radius: 4px;\n      cursor: pointer;\n      font-size: 12px;\n      font-weight: bold;\n    ",r.onclick=t=>{t.stopPropagation(),this.approveCell(e.cellId)},l.onclick=t=>{t.stopPropagation(),this.rejectCell(e.cellId)},c.onclick=t=>{t.stopPropagation(),this.runCell(e.cellId)},a.appendChild(l),a.appendChild(r),a.appendChild(c),this.cellButtonElements.set(e.cellId,{approveButton:r,rejectButton:l,runButton:c,hoverButtons:a}),t.style.position="relative",o.appendChild(a),t}approveCell(e){this.callbacks&&(this.callbacks.onApprove([e]),F.updateDiffState(e,!0,this.currentNotebookPath),this.callbacks.applyApprovedDiffs(this.currentNotebookPath),this.checkAllCellsStatus())}rejectCell(e){this.callbacks&&(this.callbacks.onReject([e]),F.updateDiffState(e,!1,this.currentNotebookPath),this.callbacks.handleRejectedDiffs(this.currentNotebookPath),this.checkAllCellsStatus())}async approveAll(){var e;if(this.callbacks){const t=this.showLoadingOverlay("Applying changes...");try{this.callbacks.onApproveAll(this.currentNotebookPath),this.diffCells.forEach(e=>{F.updateDiffState(e.cellId,!0,this.currentNotebookPath)}),this.isRunContext&&this.callbacks.setExecuteApprovedCells(!0),await this.callbacks.applyApprovedDiffs(this.currentNotebookPath),this.close(!0)}catch(e){console.error("Error applying approved diffs:",e),this.showError("Failed to apply changes. Please try again.")}finally{t&&(null===(e=this.dialogElement)||void 0===e?void 0:e.contains(t))&&this.dialogElement.removeChild(t)}}}async rejectAll(){var e;if(this.callbacks){const t=this.showLoadingOverlay("Rejecting changes...");try{this.callbacks.onRejectAll(this.currentNotebookPath),this.diffCells.forEach(e=>{F.updateDiffState(e.cellId,!1,this.currentNotebookPath)}),await this.callbacks.handleRejectedDiffs(this.currentNotebookPath),this.close(!1)}catch(e){console.error("Error handling rejected diffs:",e),this.showError("Failed to reject changes. Please try again.")}finally{t&&(null===(e=this.dialogElement)||void 0===e?void 0:e.contains(t))&&this.dialogElement.removeChild(t)}}}showLoadingOverlay(e){const t=document.createElement("div");t.className="sage-ai-loading-overlay",t.style.position="absolute",t.style.top="0",t.style.left="0",t.style.width="100%",t.style.height="100%",t.style.backgroundColor="rgba(0,0,0,0.7)",t.style.display="flex",t.style.justifyContent="center",t.style.alignItems="center",t.style.zIndex="1000",t.style.color="white",t.style.fontSize="16px";const o=document.createElement("div");return o.textContent=e,t.appendChild(o),this.dialogElement&&(this.dialogElement.style.position="relative",this.dialogElement.appendChild(t)),t}showError(e){const t=document.createElement("div");t.className="sage-ai-error-message",t.style.color="#ff4d4f",t.style.padding="10px",t.style.margin="10px",t.style.borderRadius="4px",t.style.backgroundColor="rgba(255,77,79,0.1)",t.textContent=e,this.dialogElement&&(this.dialogElement.prepend(t),setTimeout(()=>{var e;t.parentNode===this.dialogElement&&(null===(e=this.dialogElement)||void 0===e||e.removeChild(t))},5e3))}async checkAllCellsStatus(){if(!this.dialogElement)return;const e=F.getCurrentState();let t=!0,o=!1;this.diffCells.forEach(n=>{const s=e.pendingDiffs.get(n.cellId);(null==s?void 0:s.userDecision)?"run"!==s.userDecision||s.runResult||(o=!0):t=!1}),t&&(o||(console.log("FINISHED PROCESSING ALL DIFFS =================== FINISHED ---- EMITTING"),console.log(F.getCurrentState()),v.getNotebookDiffManager()._finishedProcessingDiffs.emit(s.APPROVED),this.close(!0)))}close(e){if(this.subscriptions.forEach(e=>e.unsubscribe()),this.subscriptions=[],this.dialogElement&&this.parentElement&&this.parentElement.contains(this.dialogElement)&&this.parentElement.removeChild(this.dialogElement),this.resolvePromise){const t=e&&this.isRunContext;this.resolvePromise({approved:e,runImmediately:t}),this.resolvePromise=null}this.dialogElement=null}setupDiffStateSubscriptions(){this.subscriptions.forEach(e=>e.unsubscribe()),this.subscriptions=[],this.diffCells.forEach(e=>{const t=F.getCellStateChanges$(e.cellId).subscribe(e=>{e&&this.updateCellUI(e.cellId,e.approved)});this.subscriptions.push(t)});const e=F.allDiffsResolved$.subscribe(e=>{e&&this.checkAllCellsStatus()});this.subscriptions.push(e);const t=F.diffState$.subscribe(e=>{let t=!1;this.diffCells.forEach(o=>{const n=e.pendingDiffs.get(o.cellId);"run"===(null==n?void 0:n.userDecision)&&n.runResult&&(t=!0),n&&this.updateCellButtonState(o.cellId,n)}),t&&this.checkAllCellsStatus()});this.subscriptions.push(t)}updateCellUI(e,t){var o;const n=null===(o=this.dialogElement)||void 0===o?void 0:o.querySelector(`[data-cell-id="${e}"]`);if(n){n.classList.remove("sage-ai-diff-approved","sage-ai-diff-rejected","sage-ai-diff-run");const o=F.getCurrentState().pendingDiffs.get(e);"run"===(null==o?void 0:o.userDecision)?n.classList.add("sage-ai-diff-run"):!0===t?n.classList.add("sage-ai-diff-approved"):!1===t&&n.classList.add("sage-ai-diff-rejected")}const s=this.cellButtonElements.get(e);if(s){const o=F.getCurrentState().pendingDiffs.get(e);"run"===(null==o?void 0:o.userDecision)?(s.runButton.style.opacity="0.6",s.approveButton.style.opacity="0",s.rejectButton.style.opacity="0"):!0===t?(s.approveButton.style.opacity="0.6",s.rejectButton.style.opacity="0",s.runButton.style.opacity="0"):!1===t?(s.rejectButton.style.opacity="0.6",s.approveButton.style.opacity="0",s.runButton.style.opacity="0"):(s.approveButton.style.opacity="1",s.rejectButton.style.opacity="1",s.runButton.style.opacity="1")}}async runCell(e){if(this.callbacks){F.updateDiffStateToRun(e,this.currentNotebookPath),this.callbacks.onApprove([e]),await this.callbacks.applyApprovedDiffs(this.currentNotebookPath);const t=v.getNotebookTools();if(t)try{const o=await t.run_cell({cell_id:e,notebook_path:this.currentNotebookPath});F.updateDiffStateResult(e,o.slice(0,5e3))}catch(t){F.updateDiffStateResult(e,{}),console.error(t)}await this.checkAllCellsStatus()}}updateCellButtonState(e,t){const o=this.cellButtonElements.get(e);if(!o)return;const{hoverButtons:n}=o;"run"!==t.userDecision||t.runResult?this.hideSpinnerForCell(e,n):this.showSpinnerForCell(e,n)}showSpinnerForCell(e,t){t.querySelectorAll("button").forEach(e=>e.style.display="none");let o=t.querySelector(".sage-ai-diff-spinner");o||(o=this.createSpinnerElement(),t.appendChild(o)),o.style.display="flex"}hideSpinnerForCell(e,t){t.querySelectorAll("button").forEach(e=>e.style.display="");const o=t.querySelector(".sage-ai-diff-spinner");o&&(o.style.display="none")}createSpinnerElement(){const e=document.createElement("div");if(e.className="sage-ai-diff-spinner",e.style.cssText="\n      display: flex;\n      align-items: center;\n      justify-content: center;\n      width: 20px;\n      height: 20px;\n      border: 2px solid #f3f3f3;\n      border-top: 2px solid #3498db;\n      border-radius: 50%;\n      animation: spin 1s linear infinite;\n    ",!document.querySelector("#sage-ai-spinner-style")){const e=document.createElement("style");e.id="sage-ai-spinner-style",e.textContent="\n        @keyframes spin {\n          0% { transform: rotate(0deg); }\n          100% { transform: rotate(360deg); }\n        }\n      ",document.head.appendChild(e)}return e}}const Ve='<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 10 10" fill="none"><path d="M2.62081 5.95419C2.58175 5.99293 2.55076 6.03901 2.5296 6.08979C2.50845 6.14056 2.49756 6.19502 2.49756 6.25003C2.49756 6.30503 2.50845 6.35949 2.5296 6.41027C2.55076 6.46104 2.58175 6.50712 2.62081 6.54586L4.70414 8.62919C4.74288 8.66825 4.78896 8.69924 4.83973 8.7204C4.89051 8.74155 4.94497 8.75244 4.99997 8.75244C5.05498 8.75244 5.10944 8.74155 5.16021 8.7204C5.21099 8.69924 5.25707 8.66825 5.29581 8.62919L7.37914 6.54586C7.41819 6.50712 7.44919 6.46104 7.47035 6.41027C7.4915 6.35949 7.50239 6.30503 7.50239 6.25003C7.50239 6.19502 7.4915 6.14056 7.47035 6.08979C7.44919 6.03901 7.41819 5.99293 7.37914 5.95419C7.34041 5.91514 7.29432 5.88414 7.24355 5.86299C7.19277 5.84183 7.13831 5.83094 7.08331 5.83094C7.0283 5.83094 6.97384 5.84183 6.92307 5.86299C6.87229 5.88414 6.82621 5.91514 6.78747 5.95419L4.99997 7.74586L3.21247 5.95419C3.17374 5.91514 3.12766 5.88414 3.07688 5.86299C3.02611 5.84183 2.97165 5.83094 2.91664 5.83094C2.86164 5.83094 2.80718 5.84183 2.7564 5.86299C2.70563 5.88414 2.65954 5.91514 2.62081 5.95419ZM4.70414 1.37086L2.62081 3.45419C2.58196 3.49304 2.55114 3.53916 2.53012 3.58992C2.50909 3.64068 2.49827 3.69508 2.49827 3.75003C2.49827 3.86098 2.54235 3.9674 2.62081 4.04586C2.65966 4.08471 2.70578 4.11553 2.75654 4.13655C2.8073 4.15758 2.8617 4.1684 2.91664 4.1684C3.0276 4.1684 3.13401 4.12432 3.21247 4.04586L4.99997 2.25419L6.78747 4.04586C6.82621 4.08491 6.87229 4.11591 6.92307 4.13706C6.97384 4.15822 7.0283 4.16911 7.08331 4.16911C7.13831 4.16911 7.19277 4.15822 7.24355 4.13706C7.29432 4.11591 7.34041 4.08491 7.37914 4.04586C7.41819 4.00712 7.44919 3.96104 7.47035 3.91027C7.4915 3.85949 7.50239 3.80503 7.50239 3.75003C7.50239 3.69502 7.4915 3.64056 7.47035 3.58979C7.44919 3.53901 7.41819 3.49293 7.37914 3.45419L5.29581 1.37086C5.25707 1.33181 5.21099 1.30081 5.16021 1.27965C5.10944 1.2585 5.05498 1.24761 4.99997 1.24761C4.94497 1.24761 4.89051 1.2585 4.83973 1.27965C4.78896 1.30081 4.74288 1.33181 4.70414 1.37086Z" fill="#999999"/></svg>';class qe{get finishedProcessingDiffs(){return this._finishedProcessingDiffs}constructor(e,t){this.cellIdMapping=new Map,this.notebookWidget=null,this.lastUserApprovalTime=0,this._shouldRunImmediately=!1,this._shouldExecuteApprovedCells=!1,this.currentNotebookPath=null,this.subscriptions=[],this._finishedProcessingDiffs=new E.Signal(this),this.notebookTools=e,this.actionHistory=t,this.diffApprovalDialog=new Fe,this.setupDiffStateSubscriptions(),this.diffApprovalDialog.setCallbacks({onApprove:e=>this.approveDiffs(e),onReject:e=>this.rejectDiffs(e),onApproveAll:e=>this.approveAllDiffs(e),onRejectAll:e=>this.rejectAllDiffs(e),applyApprovedDiffs:e=>this.applyApprovedDiffs(e),handleRejectedDiffs:e=>this.handleRejectedDiffs(e),setExecuteApprovedCells:e=>this.setExecuteApprovedCells(e),onCellIdClick:e=>this.notebookTools.scrollToCellById(e)})}setupDiffStateSubscriptions(){this.subscriptions.push(F.diffState$.subscribe(e=>{e.notebookPath!==this.currentNotebookPath&&(this.currentNotebookPath=e.notebookPath||null)}))}dispose(){this.subscriptions.forEach(e=>e.unsubscribe()),this.subscriptions=[]}setNotebookWidget(e){this.notebookWidget=e}setNotebookPath(e){this.currentNotebookPath!==e&&(console.log(`[NotebookDiffManager] Setting current notebook path: ${e}`),this.currentNotebookPath=e,F.setNotebookPath(e),this.diffApprovalDialog.updateNotebookPath(e||""))}getNotebookDiffs(e){const t=F.getCurrentState();return e?Array.from(t.pendingDiffs.values()).filter(t=>t.notebookPath===e):Array.from(t.pendingDiffs.values())}get approvalStatus(){const e=F.getCurrentState();let t=0,o=0,n=0;for(const[,s]of e.pendingDiffs)this.currentNotebookPath&&s.notebookPath!==this.currentNotebookPath||(n++,!0===s.approved||"approved"===s.userDecision||"run"===s.userDecision?t++:!1!==s.approved&&"rejected"!==s.userDecision||o++);return 0===n?s.PENDING:t===n?s.APPROVED:o===n?s.REJECTED:t+o===n?s.PARTIAL:s.PENDING}trackAddCell(e,t,o,n){const s=n||this.currentNotebookPath,i={cellId:e,type:"add",newContent:t,updatedCellId:e,metadata:{summary:o},notebookPath:s};F.addPendingDiff(e,i),console.log(`[NotebookDiffManager] Tracked add diff for cell tracking ID ${e} in notebook ${s||"current"}`)}trackEditCell(e,t,o,n,s){const i=s||this.currentNotebookPath,a={cellId:e,type:"edit",originalContent:t,newContent:o,updatedCellId:e,metadata:{summary:n},notebookPath:i};F.addPendingDiff(e,a),console.log(`[NotebookDiffManager] Tracked edit diff for cell tracking ID ${e} in notebook ${i||"current"}`)}trackRemoveCell(e,t,o,n){const s=n||this.currentNotebookPath,i={cellId:e,type:"remove",originalContent:t,newContent:"",metadata:{summary:o},notebookPath:s};F.addPendingDiff(e,i),console.log(`[NotebookDiffManager] Tracked remove diff for cell tracking ID ${e} in notebook ${s||"current"}`)}updateCellIdMapping(e,t,o){this.cellIdMapping.set(e,t);const n=F.getCurrentState().pendingDiffs.get(e);if(n){const o={...n,updatedCellId:t};F.addPendingDiff(e,o),console.log(`[NotebookDiffManager] Updated cell ID mapping: ${e} → ${t}`)}}getCurrentCellId(e){return this.cellIdMapping.get(e)||e}isDialogOpen(){return this.diffApprovalDialog.isDialogOpen()}hasPendingDiffs(){return F.getPendingDiffCount(this.currentNotebookPath)>0}hasRejectedDiffs(){for(const e of F.getCurrentState().pendingDiffs.values())if(e.userDecision&&"rejected"===e.userDecision)return!0;return!1}getPendingDiffCount(){return F.getPendingDiffCount(this.currentNotebookPath)}async showApprovalDialog(e,t=!1,o=!1,n){console.log("[NotebookDiffManager] Showing approval dialog for current notebook");const i=void 0!==n?n:this.currentNotebookPath;if(0===this.getNotebookDiffs(i).length){console.log("[NotebookDiffManager] No diffs to approve for target notebook");const e=s.APPROVED;return this._finishedProcessingDiffs.emit(e),e}await this.displayDiffsInCells(i);const a=this.notebookWidget?this.notebookWidget.node:document.body,r=t?e:a;return console.log("[NotebookDiffManager] Showing Dialog"),(await this.diffApprovalDialog.showDialog(r,i,t,o)).runImmediately&&(this._shouldRunImmediately=!0,this._shouldExecuteApprovedCells=!0),this.approvalStatus}async showCancellationApprovalDialog(e,t){const o=t||this.currentNotebookPath;if(0===this.getNotebookDiffs(o).length){const e=s.APPROVED;return this._finishedProcessingDiffs.emit(e),e}await this.displayDiffsInCells(o),this.notebookWidget?this.notebookWidget.node:document.body;const n=e,i=(await this.diffApprovalDialog.showDialog(n,o,!0,!1),this.approvalStatus);return this._finishedProcessingDiffs.emit(i),i}async displayDiffsInCells(e){const t=e||this.currentNotebookPath,o=this.getNotebookDiffs(t);for(const e of o)if(await Oe(200),!e.updatedCellId||e.updatedCellId===e.cellId)try{const o=this.notebookTools.findCellByAnyId(e.cellId,t);if(!o){console.warn(`Cannot find cell with tracking ID ${e.cellId} in notebook ${t||"current"} to display diff`);continue}"add"===e.type?this.notebookTools.display_diff(o.cell,"",e.newContent||"","add"):"edit"===e.type?this.notebookTools.display_diff(o.cell,e.originalContent||"",e.newContent||"","edit"):"remove"===e.type&&this.notebookTools.display_diff(o.cell,e.originalContent||"","","remove")}catch(o){console.error(`Error displaying diff for cell ${e.cellId} in notebook ${t}:`,o)}}approveDiffs(e){const t=F.getCurrentState();for(const o of e){const e=t.pendingDiffs.get(o);e&&F.updateDiffState(o,!0,e.notebookPath)}}rejectDiffs(e){const t=F.getCurrentState();for(const o of e){const e=t.pendingDiffs.get(o);e&&F.updateDiffState(o,!1,e.notebookPath)}}approveAllDiffs(e=null){const t=this.getNotebookDiffs(e);for(const e of t)F.updateDiffState(e.cellId,!0,e.notebookPath)}rejectAllDiffs(e=null){const t=this.getNotebookDiffs(e);for(const e of t)F.updateDiffState(e.cellId,!1,e.notebookPath)}async applyApprovedDiffs(e){var t,o,n;const s=e||this.currentNotebookPath,i=this.getNotebookDiffs(s).filter(e=>!0===e.approved);console.log(`[NotebookDiffManager] Applying ${i.length} approved diffs in notebook ${s||"current"}`);try{for(const e of i){await Oe(100);const i=e.cellId;e.updatedCellId!==e.cellId&&e.updatedCellId,console.log("Searching for cell with tracking ID:",i);let a=this.notebookTools.findCellByAnyId(i,s);if(a)if("add"===e.type||"edit"===e.type){if(!this.notebookTools.apply_diff(a.cell,!0).success){console.error(`[NotebookDiffManager] Failed to apply diff to cell with tracking ID ${i}`);continue}this.actionHistory.addAction("add"===e.type?S.ADD_CELL:S.EDIT_CELL,{trackingId:i,originalContent:e.originalContent,newContent:e.newContent,summary:null===(t=e.metadata)||void 0===t?void 0:t.summary},`${"add"===e.type?"Added":"Edited"} cell: ${(null===(o=e.metadata)||void 0===o?void 0:o.summary)||i}`)}else"remove"===e.type&&(this.actionHistory.addAction(S.REMOVE_CELLS,{trackingIds:[i],removedCells:[{content:e.originalContent,type:a.cell.model.type,custom:e.metadata}]},`Removed cell: ${(null===(n=e.metadata)||void 0===n?void 0:n.summary)||i}`),this.notebookTools.remove_cells({cell_ids:[i],remove_from_notebook:!0}));else console.error(`[NotebookDiffManager] Cannot find cell with tracking ID ${i} in notebook ${s||"current"} to apply diff`)}return{success:!0,status:this.approvalStatus}}catch(e){return console.error("Error applying approved diffs:",e),{success:!1,status:this.approvalStatus}}}async handleRejectedDiffs(e){const t=e||this.currentNotebookPath,o=this.getNotebookDiffs(t).filter(e=>!1===e.approved);console.log(`[NotebookDiffManager] Handling ${o.length} rejected diffs in notebook ${t||"current"}`);try{for(const e of o){const o=e.cellId,n=e.updatedCellId!==e.cellId?e.updatedCellId:void 0;let s=this.notebookTools.findCellByAnyId(o,t);!s&&n&&(s=this.notebookTools.findCellByAnyId(n)),s?"add"===e.type?this.notebookTools.remove_cells({cell_ids:[o],remove_from_notebook:!0}):("edit"===e.type||"remove"===e.type)&&(this.notebookTools.apply_diff(s.cell,!1)||console.error(`[NotebookDiffManager] Failed to reject diff for cell with tracking ID ${o}`)):console.error(`[NotebookDiffManager] Cannot find cell with tracking ID ${o} in notebook ${t||"current"} to reject diff`)}return{success:!0,status:this.approvalStatus}}catch(e){return console.error("Error handling rejected diffs:",e),{success:!1,status:this.approvalStatus}}}async applyAllDiffs(){const e=v.getState().currentNotebookPath;await this.applyApprovedDiffs(e),await this.handleRejectedDiffs(e),this.clearDiffs(),this.diffApprovalDialog.close(this._shouldRunImmediately)}clearDiffs(){this.cellIdMapping.clear(),F.clearAllDiffs(this.currentNotebookPath),console.log("[NotebookDiffManager] All diffs cleared")}rejectAndRevertDiffsImmediately(){this.rejectAllDiffs(),this.handleRejectedDiffs()}shouldRunImmediately(){const e=this._shouldRunImmediately;return this._shouldRunImmediately=!1,e}shouldExecuteApprovedCells(){const e=this._shouldExecuteApprovedCells;return this._shouldExecuteApprovedCells=!1,e}getApprovedCellIds(e){const t=e||this.currentNotebookPath;return this.getNotebookDiffs(t).filter(e=>e.userDecision&&"rejected"!==e.userDecision&&("add"===e.type||"edit"===e.type)).map(e=>e.cellId)}setExecuteApprovedCells(e){this._shouldExecuteApprovedCells=e}waitForDiffProcessingComplete(){return new Promise(e=>{const t=(o,n)=>{this._finishedProcessingDiffs.disconnect(t),e(n)};this._finishedProcessingDiffs.connect(t)})}startDiffApprovalProcess(e,t=!1,o=!1,n){this.showApprovalDialog(e,t,o,n).catch(e=>{console.error("[NotebookDiffManager] Error during diff approval:",e),this._finishedProcessingDiffs.emit(s.REJECTED)})}}var ze=o(2679),We=o(8805),Ge=o(932);class Je{constructor(e){this.notebookTools=e}async run_cell(e){var t;let o=null;if(console.log("RUNNING CELL - CELL ID:",e.cell_id,"NOTEBOOK PATH:",e.notebook_path),o=this.notebookTools.findCellByAnyId(e.cell_id,e.notebook_path),console.log("Cell info:",o),!o)throw new Error(`Cell with ID ${e.cell_id} not found in notebook ${e.notebook_path||"current"}`);const n=this.notebookTools.getCurrentNotebook(e.notebook_path);if(!n)throw new Error(`Notebook ${e.notebook_path||"current"} not found`);const{notebook:s}=n,{cell:i}=o;if("code"!==i.model.type)throw new Error(`Cell with ID ${e.cell_id} is not a code cell`);this.notebookTools.activateCell(i),await Re.NotebookActions.runCells(s,[i],null===(t=n.widget)||void 0===t?void 0:t.sessionContext);const a=[];try{const e=i;if(e.outputArea&&e.outputArea.model.toJSON){const t=e.outputArea.model.toJSON();for(const e of t)if("stream"===e.output_type){const t=()=>Array.isArray(e.text)?e.text.join(""):e.text;if("stderr"===e.name){a.push({error:!0,errorText:t()});continue}a.push(t())}else"execute_result"===e.output_type||"display_data"===e.output_type?e.data&&e.data["text/plain"]&&(Array.isArray(e.data["text/plain"])?a.push(e.data["text/plain"].join("")):a.push(e.data["text/plain"])):"error"===e.output_type&&(a.push({error:!0,errorText:`Error: ${e.ename}: ${e.evalue}`}),Array.isArray(e.traceback)?a.push({error:!0,errorText:e.traceback.join("\n")}):e.traceback&&a.push({error:!0,errorText:e.traceback}))}}catch(e){console.error("Error collecting cell outputs:",e),a.push(`Error collecting outputs: ${e}`)}return a}add_cell(e){var t;const o=null===(t=this.notebookTools.getCurrentNotebook(e.notebook_path))||void 0===t?void 0:t.notebook;if(!o)throw new Error(`Notebook ${e.notebook_path||"current"} not found`);const n=e.source||"";let s;null!==e.position&&void 0!==e.position?(s=e.position,s=Math.min(Math.max(s,0),o.widgets.length)):s=o.widgets.length,0===s?(this.notebookTools.activateCellByIndex(s),Re.NotebookActions.insertAbove(o)):(this.notebookTools.activateCellByIndex(s-1),Re.NotebookActions.insertBelow(o));let i=o.activeCell;if(!i)throw new Error("Failed to create new cell");if("markdown"===e.cell_type&&"markdown"!==i.model.type?Re.NotebookActions.changeCellType(o,"markdown"):"code"===e.cell_type&&"code"!==i.model.type&&Re.NotebookActions.changeCellType(o,"code"),i=o.activeCell,!i)throw new Error("Failed to create new cell");const a=i.model.sharedModel.getMetadata()||{},r=(new Date).toISOString();return a.cell_tracker={trackingId:e.tracking_id||this.generateTrackingId(o),createdAt:r,lastModified:r,origin:"ai",summary:e.summary||""},a.custom||(a.custom={}),a.custom.summary=e.summary,i.model.sharedModel.setMetadata(a),e.show_diff?this.notebookTools.display_diff(i,"",n,"add"):i.model.sharedModel.setSource(n),i.model.sharedModel.getMetadata().cell_tracker.trackingId}isPlanCell(e){var t,o,n;return"plan"===(null===(n=((null===(o=null===(t=null==e?void 0:e.model)||void 0===t?void 0:t.sharedModel)||void 0===o?void 0:o.getMetadata())||{}).custom)||void 0===n?void 0:n.sage_cell_type)}setFirstCellAsPlan(e){let t=this.notebookTools.getCurrentNotebook(e);if(!t)return;let{notebook:o}=t;if(this.findPlanCell(o))return;let n=o.widgets[0];if(!n)return void console.error("Could not find first cell to ensure it is a plan cell");Re.NotebookActions.changeCellType(o,"markdown"),t=this.notebookTools.getCurrentNotebook(e),t&&t.notebook&&(o=t.notebook),n=o.widgets[0];const s=n.model.sharedModel.getMetadata()||{};s.custom||(s.custom={}),s&&s.cell_tracker&&s.cell_tracker.trackingId&&(s.cell_tracker.trackingId="planning_cell"),s.custom.sage_cell_type="plan",n.model.sharedModel.setMetadata(s),n.model.sharedModel.setSource("")}findPlanCell(e){return e.widgets.find(e=>this.isPlanCell(e))||null}generateTrackingId(e){var t;let o=1;const n=e.widgets;for(let e=0;e<n.length;e++){const s=null===(t=(n[e].model.sharedModel.getMetadata()||{}).cell_tracker)||void 0===t?void 0:t.trackingId;if(s&&/^cell_(\d+)$/.test(s)){const e=parseInt(s.split("_")[1],10);e>o&&(o=e)}}return`cell_${o}`}remove_cells(e){var t;e.cell_ids.every(e=>e.startsWith("cell_"));const o=this.notebookTools.getCurrentNotebook(e.notebook_path);if(!o)return!1;const{notebook:n}=o;let s=0;for(const o of e.cell_ids){let i=this.notebookTools.findCellByAnyId(o,e.notebook_path);if(i){const a=i.cell.model.sharedModel.getMetadata()||{};if(!1===(null===(t=a.custom)||void 0===t?void 0:t.deletable)){console.warn(`Cannot delete non-deletable cell: ${o}`);continue}const r=i.cell.model.sharedModel.getSource(),l=a.cell_tracker,c=null==l?void 0:l.trackingId;c?this.notebookTools.diffTools.logDiff(this.notebookTools.normalizeContent,r,"","remove",c):this.notebookTools.diffTools.logDiff(this.notebookTools.normalizeContent,r,"","remove",o),e.remove_from_notebook&&(this.notebookTools.activateCell(i.cell),Re.NotebookActions.deleteCells(n),console.log(`[NotebookCellTools] Cell ${c} removed permanently from the notebook`)),s++}}return s>0}edit_cell(e){var t,o;let n=null;if(n=this.notebookTools.findCellByAnyId(e.cell_id,e.notebook_path),!n)return console.error(`Cell not found with ID: ${e.cell_id} in notebook ${e.notebook_path||"current"}`),!1;const s=this.notebookTools.getCurrentNotebook(e.notebook_path);if(!s)return!1;const{notebook:i}=s,{cell:a}=n,r=a.model.sharedModel.getMetadata()||{};if(!1===(null===(t=r.custom)||void 0===t?void 0:t.editable))return console.warn(`Cannot edit non-editable cell: ${e.cell_id}`),!1;const l=a.model.sharedModel.getSource(),c=(null===(o=r.cell_tracker)||void 0===o?void 0:o.trackingId)||this.generateTrackingId(i);if(this.notebookTools.diffTools.logDiff(this.notebookTools.normalizeContent,l,e.new_source,"edit",c),this.notebookTools.activateCell(a),r.cell_tracker)r.cell_tracker.lastModified=(new Date).toISOString(),r.cell_tracker.summary=e.summary||r.cell_tracker.summary;else{const t=(new Date).toISOString();r.cell_tracker={trackingId:c,createdAt:t,lastModified:t,origin:"ai",summary:e.summary||""}}return r.custom||(r.custom={}),r.custom.summary=e.summary,a.model.sharedModel.setMetadata(r),e.show_diff?this.notebookTools.display_diff(a,l,e.new_source,"edit"):a.model.sharedModel.setSource(e.new_source),!0}stream_edit_plan(e){const t=this.notebookTools.getCurrentNotebook(e.notebook_path);if(!t)return!1;const{notebook:o}=t;let n=null;for(let e=0;e<o.widgets.length;e++){const t=o.widgets[e];this.isPlanCell(t)&&(n=t)}n||(console.error("No first cell found for plan update"),o.activeCellIndex=0,Re.NotebookActions.insertAbove(o),o.activeCellIndex=0,this.setFirstCellAsPlan(e.notebook_path));const s=o.widgets[0],i=s.model.sharedModel.getSource(),a=e.partial_plan;let r=i;return i&&i.length<a.length?r=i+a.substring(i.length):i&&i.length>a.length&&(r=a),s.model.sharedModel.setSource(r),!0}edit_plan(e){var t;const o=this.notebookTools.getCurrentNotebook(e.notebook_path);if(!o)return console.error("No notebook found for edit_plan"),!1;const{notebook:n}=o;let s=null;for(let e=0;e<n.widgets.length;e++){const t=n.widgets[e];this.isPlanCell(t)&&(s=t)}s||(console.error("No first cell found for plan update"),n.activeCellIndex=0,Re.NotebookActions.insertAbove(n),n.activeCellIndex=0,this.setFirstCellAsPlan(e.notebook_path));const i=n.widgets[0],a=i.model.sharedModel.getSource(),r=e.updated_plan_string,l=i.model.sharedModel.getMetadata()||{},c=(null===(t=l.cell_tracker)||void 0===t?void 0:t.trackingId)||"planning_cell";if(this.notebookTools.diffTools.logDiff(this.notebookTools.normalizeContent,a,r,"edit_plan",c),this.notebookTools.activateCell(i),l.cell_tracker)l.cell_tracker.lastModified=(new Date).toISOString(),l.cell_tracker.summary="Updated plan";else{const e=(new Date).toISOString();l.cell_tracker={trackingId:c,createdAt:e,lastModified:e,origin:"ai",summary:"Updated plan"}}return l.custom||(l.custom={}),l.custom.summary="Updated plan",l.custom.current_step_string=e.current_step_string,l.custom.next_step_string=e.next_step_string,i.model.sharedModel.setMetadata(l),i.model.sharedModel.setSource(r),Re.NotebookActions.runCells(n,[i]),v.getPlanStateDisplay().updatePlan(e.current_step_string,e.next_step_string,e.updated_plan_string),console.log("Plan cell updated successfully"),!0}get_cells_info(e){const t=this.notebookTools.getCurrentNotebook(e);if(!t)return null;const{notebook:o}=t,n=[];for(let e=0;e<o.widgets.length;e++){const t=o.widgets[e];n.push({id:t.model.id,type:t.model.type,content:t.model.sharedModel.getSource()})}return{cells:n}}get_cell_info(e){var t;let o=this.notebookTools.findCellByAnyId(e.cell_id,e.notebook_path);if(!o)return null;const{cell:n,index:s}=o,i=n.model.sharedModel.getMetadata();return{id:n.model.id,type:n.model.type,content:n.model.sharedModel.getSource(),index:s,custom:(null==i?void 0:i.custom)||{},trackingId:(null===(t=null==i?void 0:i.cell_tracker)||void 0===t?void 0:t.trackingId)||null}}edit_history(e){return console.log("Edit history requested with options:",e),{forwarded:!0}}read_cells(e={}){const{notebook_path:t=null,include_outputs:o=!0,include_metadata:n=!0}=e,s=this.notebookTools.getCurrentNotebook(t);if(!s)return console.log("No current notebook found"),null;const{notebook:i,widget:a}=s,r=[];console.log(`Reading ${i.widgets.length} cells from notebook`);for(let e=0;e<i.widgets.length;e++){const t=i.widgets[e],s=t.model,a=s.sharedModel,l={id:"",index:e,type:s.type,content:a.getSource()};if(n){const e=a.getMetadata();l.metadata=e||{};const t=null==e?void 0:e.cell_tracker;(null==t?void 0:t.trackingId)&&(l.trackingId=t.trackingId)}if(o&&"code"===s.type)try{const e=t;e.outputArea&&e.outputArea.model.toJSON&&(l.outputs=e.outputArea.model.toJSON());const o=s.executionCount;null!=o&&(l.execution_count=o)}catch(e){console.warn(`Failed to get outputs for cell ${l.id}:`,e),l.outputs=[]}if(l.outputs&&l.outputs.length>0)for(const e of l.outputs)e.text&&e.text.length>5e3&&(e.text=e.text.slice(0,5e3)),"display_data"===e.output_type&&e.data&&(e.data=e.data["text/plain"]);r.push(l)}const l={cells:r,total_cells:r.length,notebook_path:a.context.path};return console.log(`Successfully read ${r.length} cells from notebook`),console.log(l),l}}class Ke{constructor(e){this.notebookTracker=e}getNextCellNumber(e){var t;const o=e.widgets;let n=0;for(let e=0;e<o.length;e++){const s=null===(t=(o[e].model.sharedModel.getMetadata()||{}).cell_tracker)||void 0===t?void 0:t.trackingId;if(s&&/^cell_(\d+)$/.test(s)){const e=parseInt(s.split("_")[1],10);e>n&&(n=e)}}return n+1}ensureCellHasTrackingID(e){var t,o;if(!e)return"";const n=null===(t=this.notebookTracker.currentWidget)||void 0===t?void 0:t.content,s=e.model.sharedModel.getMetadata()||{};if(!s.cell_tracker||!s.cell_tracker.trackingId){const t=(new Date).toISOString(),i=`cell_${this.getNextCellNumber(n)}`;return s.cell_tracker={trackingId:i,createdAt:t,lastModified:t,origin:"user",summary:(null===(o=s.custom)||void 0===o?void 0:o.summary)||""},e.model.sharedModel.setMetadata(s),s.cell_tracker.trackingId}return s.cell_tracker.trackingId}fixTrackingIDs(e){var t,o;let n;if(e){let t=!1;if(this.notebookTracker.forEach(o=>{o.context.path===e&&(n=o.content,t=!0)}),!t)return console.warn(`Notebook with path ${e} not found`),0}else n=null===(t=this.notebookTracker.currentWidget)||void 0===t?void 0:t.content;if(!n)return 0;const s=n.widgets;let i=0;for(let e=0;e<s.length;e++){const t=s[e],a=t.model.sharedModel.getMetadata()||{};let r=!1;if(a.cell_tracker&&a.cell_tracker.trackingId&&("planning_cell"===a.cell_tracker.trackingId||/^cell_\d+$/.test(a.cell_tracker.trackingId))||(r=!0),r){const e=(new Date).toISOString(),s=`cell_${this.getNextCellNumber(n)}`;a.cell_tracker={trackingId:s,createdAt:e,lastModified:e,origin:"user",summary:(null===(o=a.custom)||void 0===o?void 0:o.summary)||""},t.model.sharedModel.setMetadata(a),i++}}return i}getTrackingIDReport(e){var t,o;let n;if(e){let t=!1;if(this.notebookTracker.forEach(o=>{o.context.path===e&&(n=o.content,t=!0)}),!t)return console.warn(`Notebook with path ${e} not found`),[]}else n=null===(t=this.notebookTracker.currentWidget)||void 0===t?void 0:t.content;if(!n)return[];const s=n.widgets,i=[],a=s.length;for(let e=0;e<a;e++){const t=s[e],n=t.model.sharedModel.getMetadata()||{};i.push({trackingId:(null===(o=n.cell_tracker)||void 0===o?void 0:o.trackingId)||"missing",modelId:t.model.id,cellType:t.model.type,index:e})}return i}}class Ye{constructor(){this.dataDir="data"}async list_datasets(e){try{await this.ensureDataDirectory();const e=await v.getContentManager().get(this.dataDir);if("directory"!==e.type)throw new Error("Data path is not a directory");const t=e.content.filter(e=>"file"===e.type).map(e=>({name:e.name,path:e.path,size:e.size||0,modified:e.last_modified?new Date(e.last_modified).getTime()/1e3:0}));return JSON.stringify(t)}catch(e){return console.error("Error listing datasets:",e),JSON.stringify({error:`Failed to list datasets: ${e instanceof Error?e.message:String(e)}`})}}async read_dataset(e){try{const{filepath:t,start:o=0,end:n=10}=e,s=this.getSafeFilePath(t),i=await v.getContentManager().get(s);if("file"!==i.type)throw new Error("Path is not a file");const a=i.content.split("\n"),r=Math.max(0,o),l=Math.min(r+10,Math.min(n,a.length)),c=a.slice(r,l);return JSON.stringify({content:c,start:r,end:l,path:s,total_lines:a.length})}catch(e){return console.error("Error reading dataset:",e),JSON.stringify({error:`Failed to read dataset: ${e instanceof Error?e.message:String(e)}`})}}async delete_dataset(e){try{const{filepath:t}=e,o=this.getSafeFilePath(t);return await v.getContentManager().delete(o),JSON.stringify({success:!0,path:o,message:"File deleted successfully"})}catch(e){return console.error("Error deleting dataset:",e),JSON.stringify({error:`Failed to delete dataset: ${e instanceof Error?e.message:String(e)}`})}}async save_dataset(e){try{const{filepath:t,content:o}=e,n=this.getSafeFilePath(t);return await v.getContentManager().save(n,{type:"file",format:"text",content:o}),JSON.stringify({success:!0,path:n,message:"File saved successfully"})}catch(e){return console.error("Error saving dataset:",e),JSON.stringify({error:`Failed to save dataset: ${e instanceof Error?e.message:String(e)}`})}}async ensureDataDirectory(){try{await v.getContentManager().get(this.dataDir)}catch(e){console.log(`Creating data directory: ${this.dataDir}`),await v.getContentManager().newUntitled({type:"directory",path:""}).then(e=>v.getContentManager().rename(e.path,this.dataDir))}}getSafeFilePath(e){const t=e.replace(/\.\./g,"").replace(/^\/+/,"");return t.startsWith(this.dataDir+"/")?t:`${this.dataDir}/${t}`}}class Ze{constructor(){this.tickers=null}async loadTickers(){if(null===this.tickers)try{const e=await o.e(845).then(o.t.bind(o,6845,19));this.tickers=e.default}catch(e){console.error("Failed to load tickers data:",e),this.tickers={}}return this.tickers}levenshteinDistance(e,t){const o=[],n=e.length,s=t.length;if(0===n)return s;if(0===s)return n;for(let e=0;e<=s;e++)o[e]=[e];for(let e=0;e<=n;e++)o[0][e]=e;for(let i=1;i<=s;i++)for(let s=1;s<=n;s++)t.charAt(i-1)===e.charAt(s-1)?o[i][s]=o[i-1][s-1]:o[i][s]=Math.min(o[i-1][s-1]+1,o[i][s-1]+1,o[i-1][s]+1);return o[s][n]}fuzzyMatchScore(e,t){const o=e.toLowerCase().trim(),n=t.toLowerCase().trim();if(o===n)return 100;if(n.includes(o)){const e=o.length/n.length;return Math.max(70,90*e)}if(n.startsWith(o)){const e=o.length/n.length;return Math.max(60,80*e)}const s=this.levenshteinDistance(o,n),i=Math.max(o.length,n.length);if(0===i)return 0;const a=100*(1-s/i);return a>50?a:0}searchWordsInText(e,t){const o=e.toLowerCase().trim(),n=t.toLowerCase().split(/\s+/);let s=0;for(const e of n){const t=this.fuzzyMatchScore(o,e);s=Math.max(s,t)}return s}async search_dataset(e){try{const{queries:t,limit:o=10}=e;if(!t||0===t.length)return JSON.stringify({error:"Queries parameter is required and cannot be empty"});const n=await this.loadTickers(),s=Math.min(o,10),i=[],a=new Set;for(const e of t){if(!e||""===e.trim())continue;const t=e.toLowerCase().trim();for(const[e,o]of Object.entries(n)){let n=0;const s=this.fuzzyMatchScore(t,e);n=Math.max(n,s);const r=this.fuzzyMatchScore(t,o.name);n=Math.max(n,.8*r);const l=this.searchWordsInText(t,o.name);if(n=Math.max(n,.7*l),n>30)if(a.has(e)){const t=i.find(t=>t.ticker===e);t&&Math.round(n)>t.score&&(t.score=Math.round(n))}else i.push({ticker:e,name:o.name,type:o.type,source:o.source,score:Math.round(n)}),a.add(e)}}const r=i.sort((e,t)=>t.score-e.score).slice(0,s);return JSON.stringify(r)}catch(e){return console.error("Error searching datasets:",e),JSON.stringify({error:`Failed to search datasets: ${e instanceof Error?e.message:String(e)}`})}}}class Qe{constructor(e,t){this.notebookTracker=e,this.waitingUserReplyBoxManager=t,this.diffTools=new je,this.filesystemTools=new Ye,this.webTools=new Ze,this.cellTools=new Je(this)}findNotebookByPath(e){if(!e)return null;let t=null;return this.notebookTracker.forEach(o=>{o.context.path===e&&(t={notebook:o.content,widget:o})}),t}getCurrentNotebook(e){if(e)return this.findNotebookByPath(e);const t=this.notebookTracker.currentWidget;return t?{notebook:t.content,widget:t}:(console.log("No current notebook"),null)}findCellById(e,t){console.log("Finding cell by ID:",e);const o=this.getCurrentNotebook(t);if(!o)return null;const{notebook:n}=o;for(let e=0;e<n.model.cells.length;e++)console.log(n.widgets[e].id),console.log(n.widgets[e].model.id),console.log(n.widgets[e].model.sharedModel.id);for(let t=0;t<n.model.cells.length;t++){const o=n.widgets[t];if(o.model.id===e)return{cell:o,index:t}}return console.log(`Cell with ID ${e} not found`),null}activateCellByIndex(e){const t=this.getCurrentNotebook();if(!t)return!1;const{notebook:o}=t;return e<0||e>=o.widgets.length?(console.log(`Invalid cell index: ${e}`),!1):(o.activeCellIndex=e,!0)}activateCell(e){if("number"==typeof e)return this.activateCellByIndex(e);{const t=this.getCurrentNotebook();if(!t)return!1;const{notebook:o}=t;let n=-1;for(let t=0;t<o.widgets.length;t++)if(o.widgets[t]===e){n=t;break}return-1===n?(console.log("Cell not found in notebook"),!1):(o.activeCellIndex=n,!0)}}async getNotebookSummary(e){var t;const o=this.getCurrentNotebook(e),n=[];let s=0;for(const e of(null===(t=null==o?void 0:o.widget.model)||void 0===t?void 0:t.cells)||[]){let t={index:s++,id:"",cell_type:"",summary:"",next_step_string:"",current_step_string:"",empty:!0};const o=e.metadata,i=o.custom;i&&(t={...t,...i});const a=o.cell_tracker;a&&(t.id=a.trackingId),t.empty=""===e.sharedModel.getSource().trim(),t.cell_type=e.type,n.push(t)}return console.log("All Cells",n),n}async scrollToCellById(e){var t;const o=null===(t=this.getCurrentNotebook())||void 0===t?void 0:t.notebook;if(!o)return;const n=o.widgets.findIndex(t=>{var o;return(null===(o=t.model.metadata)||void 0===o?void 0:o.cell_tracker.trackingId)===e});if(!o.widgets[n])return;o.activeCellIndex=n;const s=document.querySelector(`[sage-ai-cell-id=${e}]`);if(s&&s.parentElement&&"none"!==s.parentElement.style.display)s.scrollIntoView();else{o.scrollToItem(n,"center"),await Promise.resolve(requestAnimationFrame);const t=t=>{setTimeout(()=>{var t;null===(t=document.querySelector(`[sage-ai-cell-id=${e}]`))||void 0===t||t.scrollIntoView()},t)};let s=100;for(;s<1e3;)t(s),s+=100}}async scrollToPlanCell(){var e,t;const o=null===(e=this.getCurrentNotebook())||void 0===e?void 0:e.notebook;if(!o)return;const n=o.widgets.findIndex(e=>{var t;return"plan"===(null===(t=e.model.metadata.custom)||void 0===t?void 0:t.sage_cell_type)}),s=o.widgets[n];if(!s)return;o.scrollToItem(n,"center"),o.activeCellIndex=n;const i=null===(t=s.model.metadata)||void 0===t?void 0:t.cell_tracker.trackingId;i&&(await Promise.resolve(requestAnimationFrame),setTimeout(()=>{var e;null===(e=document.querySelector(`[sage-ai-cell-id=${i}]`))||void 0===e||e.scrollIntoView()},100))}async waitForScrollEnd(e){return"onscrollend"in e?new Promise(t=>e.addEventListener("scrollend",()=>t(),{once:!0})):this.waitForScrollIdle(e)}async waitForScrollIdle(e,t=120){return new Promise(o=>{let n;const s=()=>{clearTimeout(n),n=window.setTimeout(()=>{e.removeEventListener("scroll",s),o()},t)};e.addEventListener("scroll",s,{passive:!0}),s()})}normalizeContent(e){return e.trim()}display_diff(e,t,o,n){return this.diffTools.display_diff(this,e,t,o,n)}apply_diff(e,t){return this.diffTools.apply_diff(this,e,t)}run_cell(e){return this.cellTools.run_cell(e)}findCellByAnyId(e,t){return e.startsWith("cell_")?this.findCellByTrackingId(e,t):this.findCellById(e,t)}findCellByTrackingId(e,t){var o;const n=null===(o=this.getCurrentNotebook(t))||void 0===o?void 0:o.notebook;if(!n)return null;for(let t=0;t<n.widgets.length;t++){const o=n.widgets[t],s=o.model.sharedModel.getMetadata()||{};if(s.cell_tracker&&s.cell_tracker.trackingId===e)return{cell:o,index:t}}return null}findCellByIndex(e){var t;const o=null===(t=this.getCurrentNotebook())||void 0===t?void 0:t.notebook;return o?{cell:o.widgets[e],index:e}:null}add_cell(e){return this.cellTools.add_cell(e)}remove_cells(e){return this.cellTools.remove_cells(e)}edit_cell(e){return this.cellTools.edit_cell(e)}stream_edit_plan(e){return this.cellTools.stream_edit_plan(e)}edit_plan(e){return this.cellTools.edit_plan(e)}get_cells_info(){return this.cellTools.get_cells_info()}get_cell_info(e){return this.cellTools.get_cell_info(e)}edit_history(e){return this.cellTools.edit_history(e)}read_cells(e={}){return this.cellTools.read_cells(e)}refresh_ids(){new Ke(this.notebookTracker).fixTrackingIDs()}setFirstCellAsPlan(e){this.cellTools.setFirstCellAsPlan(e)}getPlanCell(e){const t=this.getCurrentNotebook(e);if(!t)return null;const{notebook:o}=t;return this.cellTools.findPlanCell(o)}wait_user_reply(e){try{return this.waitingUserReplyBoxManager.show(),console.log("Waiting for user reply - box shown"),!0}catch(e){return console.error("Error showing waiting reply box:",e),!1}}async list_datasets(e){return this.filesystemTools.list_datasets(e)}async read_dataset(e){return this.filesystemTools.read_dataset(e)}async delete_dataset(e){return this.filesystemTools.delete_dataset(e)}async save_dataset(e){return this.filesystemTools.save_dataset(e)}async search_dataset(e){return this.webTools.search_dataset(e)}}class Xe{constructor(){this.client=null,this.tools=[],this.kernelInfo={},this.notebookInfo={},this.notebookTracker=null,this.notebookTools=null,this.filesystemTools=null,this.contentManager=null,this.currentNotebookPath=null,this.notebookContextManager=null,this.notebookContexts=new Map,this.toolMappings={"notebook-get_cell_info":"get_cell_info","notebook-get_cells":"get_cells","notebook-read_cells":"read_cells","notebook-add_cell":"add_cell","notebook-edit_cell":"edit_cell","notebook-remove_cells":"remove_cells","notebook-run_cell":"run_cell","notebook-execute_cell":"execute_cell","notebook-get_notebook_info":"get_notebook_info","notebook-edit_plan":"edit_plan","notebook-wait_user_reply":"wait_user_reply","filesystem-list_datasets":"list_datasets","filesystem-read_dataset":"read_dataset","filesystem-delete_dataset":"delete_dataset","filesystem-save_dataset":"save_dataset","web-search_dataset":"search_dataset"},this.isConnected=!1,this.reconnectAttempts=0,this.maxReconnectAttempts=10,this.reconnectIntervalMs=5e3,this.connectingPromise=null}async initialize(){return this.connectingPromise?(console.log("[ToolService] Already attempting to connect, waiting..."),this.connectingPromise):(this.connectingPromise=(async()=>{try{return this.client&&(console.log("[ToolService] Disconnecting existing client before re-initialization."),await this.client.close(),this.client=null),await W.getConfig(),this.client=new Ge.K({name:"sage-ai-client",version:"1.0.0"}),this.tools=await W.getTools(),this.client.onerror=e=>{console.log("[ToolService] Client error",e),"SSE error: Failed to fetch"===e.message&&this.handleConnectionLoss()},this.isConnected=!0,this.reconnectAttempts=0,void console.log("[ToolService] MCP client initialized and connected successfully.")}catch(e){throw console.error("Failed to initialize MCP client:",e),this.isConnected=!1,e}finally{this.connectingPromise=null}})(),this.connectingPromise)}updateNotebookPath(e,t){const o=this.notebookContexts.get(e)||{kernelInfo:{name:this.kernelInfo.name,id:this.kernelInfo.id},notebookInfo:{path:this.notebookInfo.path,id:this.notebookInfo.id}};this.notebookContexts.set(t,o),this.notebookContexts.delete(e),this.currentNotebookPath=t}async handleConnectionLoss(){if(this.isConnected&&(console.warn("[ToolService] Connection lost. Attempting to reconnect..."),this.isConnected=!1),this.reconnectAttempts<this.maxReconnectAttempts){this.reconnectAttempts++;const e=this.reconnectIntervalMs*Math.pow(2,this.reconnectAttempts-1);console.log(`[ToolService] Reconnection attempt ${this.reconnectAttempts}/${this.maxReconnectAttempts} in ${e/1e3} seconds...`),await new Promise(t=>setTimeout(t,e));try{await this.initialize(),console.log("[ToolService] Reconnected successfully!")}catch(e){console.error("[ToolService] Reconnection failed:",e),this.handleConnectionLoss()}}else console.error("[ToolService] Max reconnection attempts reached. Unable to connect to backend.")}isInitialized(){return null!==this.client&&this.isConnected}setNotebookTracker(e,t){this.notebookTracker=e,console.log("Notebook tracker set in ToolService"),this.notebookTools=new Qe(e,t),console.log("NotebookTools initialized in ToolService"),this.notebookTracker.currentChanged.connect(this.handleNotebookChanged,this)}setContentManager(e){this.contentManager=e,console.log("Content manager set in ToolService"),this.filesystemTools=new Ye,console.log("FilesystemTools initialized in ToolService")}setCurrentNotebookPath(e){if(e!==this.currentNotebookPath)if(console.log(`[ToolService] Setting current notebook path: ${e}`),this.currentNotebookPath=e,e&&this.notebookContexts.has(e)){const t=this.notebookContexts.get(e);this.kernelInfo={...t.kernelInfo},this.notebookInfo={...t.notebookInfo},console.log(`[ToolService] Restored context for notebook: ${e}`,{kernel:this.kernelInfo,notebook:this.notebookInfo})}else e&&(this.handleNotebookChanged(),this.storeNotebookContext(e))}getCurrentNotebookPath(){return this.currentNotebookPath}storeNotebookContext(e){e&&(this.notebookContexts.set(e,{kernelInfo:{...this.kernelInfo},notebookInfo:{...this.notebookInfo}}),console.log(`[ToolService] Stored context for notebook: ${e}`,{kernel:this.kernelInfo,notebook:this.notebookInfo}))}handleNotebookChanged(){if(!this.notebookTracker)return;const e=this.notebookTracker.currentWidget;if(!e)return void console.log("No active notebook");this.notebookInfo={path:e.sessionContext.path,id:e.id};const t=e.sessionContext.session,o=null==t?void 0:t.kernel;o&&(this.kernelInfo={name:o.name,id:o.id},console.log("Updated kernel info from notebook tracker:",this.kernelInfo)),console.log("Updated notebook info from notebook tracker:",this.notebookInfo),this.currentNotebookPath&&this.storeNotebookContext(this.currentNotebookPath)}getCurrentNotebook(e){if(!this.notebookTracker)return null;let t=null;if(e?this.notebookTracker.forEach(o=>{o.context.path===e&&(t=o)}):t=this.notebookTracker.currentWidget,!t)return null;const o=t.sessionContext.session,n=null==o?void 0:o.kernel;return{widget:t,path:t.sessionContext.path,id:t.id,kernel:n||void 0}}async refreshRemoteTools(){if(!this.client)throw new Error("MCP client not initialized");try{const e=await this.client.listTools();console.log("Available MCP tools:",e),this.tools=[];for(const t of e.tools)"notebook-read_notebook_summary"!==t.name&&this.tools.push({name:t.name,description:t.description,input_schema:t.inputSchema});return console.log(`Updated ${this.tools.length} tools from MCP server.`),this.tools}catch(e){throw console.error("Failed to update tools:",e),e}}getTools(){return this.tools}getAskModeTools(){const e=["notebook-get_cell_info","notebook-read_cells","web-search_dataset","filesystem-list_datasets","filesystem-read_dataset","notebook-wait_user_reply"];return this.tools.filter(t=>e.includes(t.name))}async refreshDynamicInfo(){try{if(this.notebookTracker&&this.notebookTracker.currentWidget&&this.handleNotebookChanged(),this.kernelInfoProvider){const e=await this.kernelInfoProvider();e&&(this.kernelInfo=e,console.log("Kernel info dynamically updated:",this.kernelInfo))}if(this.notebookInfoProvider){const e=await this.notebookInfoProvider();e&&(this.notebookInfo=e,console.log("Notebook info dynamically updated:",this.notebookInfo))}}catch(e){console.error("Error refreshing dynamic info:",e)}}canHandleToolLocally(e){return(null!==this.notebookTools||null!==this.filesystemTools)&&e in this.toolMappings}async executeLocalTool(e,t){const o=this.toolMappings[e];console.log(`Executing local tool "${o}" with args:`,t);try{if(e.startsWith("filesystem-")){if(!this.filesystemTools)throw new Error("FilesystemTools not initialized");const e=await this.filesystemTools[o](t);return console.log(`Local filesystem tool "${o}" returned:`,e),e}if(e.startsWith("web-")){if(!this.notebookTools)throw new Error("NotebookTools not initialized");const e=await this.notebookTools[o](t);return console.log(`Local web tool "${o}" returned:`,e),e}{if(!this.notebookTools)throw new Error("NotebookTools not initialized");t.notebook_path;const e=await this.notebookTools[o](t);return console.log(`Local notebook tool "${o}" returned:`,e),e}}catch(e){throw console.error(`Error executing local tool "${o}":`,e),e}}async executeTool(e,t=3,o=!0){var n;const s=(null===(n=e.input)||void 0===n?void 0:n.notebook_path)||this.currentNotebookPath;s&&s!==this.currentNotebookPath&&this.setCurrentNotebookPath(s),await this.refreshDynamicInfo();const{name:i,input:a,id:r}=e;if(this.canHandleToolLocally(i))try{console.log(`Executing tool ${i} locally with args:`,a);const e={...a};if(o){this.kernelInfo.name&&(e.kernel_name=this.kernelInfo.name),this.kernelInfo.id&&(e.kernel_id=this.kernelInfo.id);const t=e.notebook_path||this.currentNotebookPath;t&&(e.notebook_path=t),this.notebookInfo.id&&(e.notebook_id=this.notebookInfo.id)}"notebook-add_cell"!==i&&"notebook-edit_cell"!==i||void 0!==e.show_diff||(e.show_diff=!1);const t=await this.executeLocalTool(i,e);return console.log(`Local tool ${i} returned:`,t),{type:"tool_result",tool_use_id:r,content:"object"==typeof t?JSON.stringify(t):String(t)}}catch(e){return console.error("Local tool execution failed:",e),{type:"tool_result",tool_use_id:r,content:`Error: ${e instanceof Error?e.message:String(e)}`}}let l=0;for(;l<=t;)try{if(!this.isInitialized()&&(console.warn("[ToolService] MCP client not connected. Attempting to re-establish connection..."),await this.initialize(),!this.client||!this.isConnected))throw new Error("MCP client could not establish connection.");console.log(`Executing remote tool ${i} with args:`,a);const e={...a};o&&(this.kernelInfo.name&&(e.kernel_name=this.kernelInfo.name),this.kernelInfo.id&&(e.kernel_id=this.kernelInfo.id),this.notebookInfo.path&&(e.notebook_path=this.notebookInfo.path),this.notebookInfo.id&&(e.notebook_id=this.notebookInfo.id),console.log("Including context info in tool call:",{kernel:this.kernelInfo,notebook:this.notebookInfo})),console.log("Tool arguments:",e);const t=await this.client.callTool({name:i,arguments:e});console.log(`Tool ${i} returned:`,t);const n=[];if(t&&t.content)for(const e of t.content)try{const t=JSON.parse(e.text);n.push({...e,text:JSON.stringify(t,null,2)})}catch(t){n.push(e),console.error(t)}return{type:"tool_result",tool_use_id:r,content:n}}catch(e){if(console.error(`Remote tool execution failed (attempt ${l}/${t}):`,e),l++,l>t)return console.error(`Max remote tool execution retries reached for tool ${i}.`),{type:"tool_result",tool_use_id:r,content:`Error: ${e instanceof Error?e.message:String(e)}`};await new Promise(e=>setTimeout(e,1e3*l))}throw new Error("Tool execution failed after all retries")}setContextManager(e){this.notebookContextManager=e,console.log("Notebook context manager set in ToolService")}getContextManager(){return this.notebookContextManager||null}}class et{constructor(e,t){this.notebookTools=e,this.notebookTracker=t,this.initializeExistingCells(),this.notebookTracker.currentChanged.connect(()=>{this.initializeExistingCells()})}initializeExistingCells(){var e;const t=null===(e=this.notebookTracker.currentWidget)||void 0===e?void 0:e.content;if(!t)return;const o=t.widgets;console.log(`[CellTrackingService] Initializing tracking for ${o.length} existing cells`);for(let e=0;e<o.length;e++){const t=o[e];this.ensureCellHasTrackingMetadata(t,"user")}}getNextCellNumber(){var e,t;const o=null===(e=this.notebookTracker.currentWidget)||void 0===e?void 0:e.content;if(!o)return 1;const n=o.widgets;let s=0;for(let e=0;e<n.length;e++){const o=null===(t=(n[e].model.sharedModel.getMetadata()||{}).cell_tracker)||void 0===t?void 0:t.trackingId;if(o&&/^cell_(\d+)$/.test(o)){const e=parseInt(o.split("_")[1],10);e>s&&(s=e)}}return s+1}ensureCellHasTrackingMetadata(e,t="user"){const o=e.model.sharedModel.getMetadata()||{};if(o.cell_tracker&&o.cell_tracker.trackingId)return o.cell_tracker.lastModified=(new Date).toISOString(),e.model.sharedModel.setMetadata(o),o.cell_tracker.trackingId;const n={trackingId:`cell_${this.getNextCellNumber()}`,createdAt:(new Date).toISOString(),lastModified:(new Date).toISOString(),origin:t,summary:""};return o.cell_tracker=n,e.model.sharedModel.setMetadata(o),console.log(`[CellTrackingService] Added tracking ID ${n.trackingId} to cell`),n.trackingId}findCellByTrackingId(e){var t;const o=null===(t=this.notebookTracker.currentWidget)||void 0===t?void 0:t.content;if(!o)return null;const n=o.widgets;for(let t=0;t<n.length;t++){const o=n[t],s=o.model.sharedModel.getMetadata()||{};if(s.cell_tracker&&s.cell_tracker.trackingId===e)return{cell:o,index:t}}return null}getCellTrackingMetadata(e){return(e.model.sharedModel.getMetadata()||{}).cell_tracker||null}setCellOrigin(e,t){this.ensureCellHasTrackingMetadata(e);const o=e.model.sharedModel.getMetadata()||{};o.cell_tracker&&(o.cell_tracker.origin=t,o.cell_tracker.lastModified=(new Date).toISOString(),e.model.sharedModel.setMetadata(o))}getAllTrackingIds(){var e;const t=null===(e=this.notebookTracker.currentWidget)||void 0===e?void 0:e.content;if(!t)return[];const o=t.widgets,n=[];for(let e=0;e<o.length;e++){const t=o[e].model.sharedModel.getMetadata()||{};t.cell_tracker&&t.cell_tracker.trackingId&&n.push(t.cell_tracker.trackingId)}return n}}class tt extends z.Widget{constructor(e,t){super(),this.currentNotebookPath=null,this.id="sage-ai-chat-container",this.title.label="Sage AI Chat",this.title.closable=!0,this.addClass("sage-ai-chat-container"),this.toolService=e,this.contextManager=t||null,this.node.style.minWidth="calc(100vw / 4)",this.chatWidget=new Pe;const o=new z.PanelLayout;o.addWidget(this.chatWidget),this.layout=o}updateNotebookPath(e,t){var o;null===(o=this.contextManager)||void 0===o||o.updateNotebookPath(e,t),this.chatWidget.chatHistoryManager.updateNotebookPath(e,t),this.chatWidget.updateNotebookPath(t),this.toolService.updateNotebookPath(e,t),this.currentNotebookPath=t}switchToNotebook(e){this.currentNotebookPath!==e&&(console.log(`[NotebookChatContainer] Switching to notebook: ${e}`),this.currentNotebookPath=e,this.toolService.setCurrentNotebookPath(e),this.contextManager&&this.contextManager.getContext(e),this.chatWidget.setNotebookPath(e))}onCellAddedToContext(e){this.currentNotebookPath&&this.currentNotebookPath===e?this.chatWidget.onCellAddedToContext(e):console.warn(`Cannot add cell from ${e} to context when current notebook is ${this.currentNotebookPath}`)}onCellRemovedFromContext(e){this.currentNotebookPath&&this.currentNotebookPath===e?this.chatWidget.onCellRemovedFromContext(e):console.warn(`Cannot remove cell from ${e} context when current notebook is ${this.currentNotebookPath}`)}}class ot{constructor(e){this.notebookContexts=new Map,this.sharedToolService=e}getContext(e){if(!this.notebookContexts.has(e)){console.log(`[NotebookContextManager] Creating new context for notebook: ${e}`),this.sharedToolService.setCurrentNotebookPath(e);const t=new b(this.sharedToolService);t.setNotebookPath(e);const o={notebookPath:e,toolService:this.sharedToolService,stateService:t,lastAccessed:Date.now(),flowId:this.generateFlowId(),contextCells:[]};return this.notebookContexts.set(e,o),o}const t=this.notebookContexts.get(e);return t.lastAccessed=Date.now(),this.sharedToolService.setCurrentNotebookPath(e),t}updateNotebookPath(e,t){const o=this.notebookContexts.get(e);o&&(o.notebookPath=t,this.notebookContexts.set(t,o),this.notebookContexts.delete(e))}addCellToContext(e,t,o,n,s){const i=this.getContext(e);return!i.contextCells.some(e=>e.cellId===t)&&(i.contextCells.push({cellId:t,trackingId:o,content:n,cellType:s,addedAt:Date.now()}),console.log(`[NotebookContextManager] Added cell to context: ${t}`),!0)}removeCellFromContext(e,t){if(!this.notebookContexts.has(e))return!1;const o=this.notebookContexts.get(e),n=o.contextCells.length;return o.contextCells=o.contextCells.filter(e=>e.cellId!==t),o.contextCells.length<n}isCellInContext(e,t){return!!this.notebookContexts.has(e)&&this.notebookContexts.get(e).contextCells.some(e=>e.cellId===t)}getContextCells(e){return this.notebookContexts.has(e)?[...this.notebookContexts.get(e).contextCells]:[]}formatContextAsMessage(e){const t=this.getContextCells(e);if(0===t.length)return"";let o="Here are the cells from the notebook that the user has provided as additional context:\n\n";return t.forEach(e=>{var t;const n=null===(t=this.sharedToolService.notebookTools)||void 0===t?void 0:t.findCellByAnyId(e.trackingId);n&&(o+=`==== CELL Context - Cell ID: ${e.trackingId} ====\n`,o+=n.cell.model.sharedModel.getSource().trim(),o+="\n==== End Cell Context ====\n\n")}),o}getContextSummary(e){return this.getContextCells(e).map(e=>{var t;const o=null===(t=this.sharedToolService.notebookTools)||void 0===t?void 0:t.findCellByAnyId(e.trackingId);if(o){const t=o.cell.model.sharedModel.getSource(),n=t.length>50?t.substring(0,50)+"...":t;return{type:"cell",id:e.trackingId,name:`Cell ${e.trackingId}`,preview:n}}return{type:"cell",id:e.trackingId,name:`Cell ${e.trackingId}`,preview:"Cell content unavailable"}})}generateFlowId(){return"flow-"+Date.now()+"-"+Math.random().toString(36).substring(2,9)}}var nt=o(8276);class st{constructor(e,t,o){this.highlightedCells=new Map,this.chatContainerRef=null,this.cellHistory=new Map,this.notebookTracker=e,this.notebookContextManager=t,this.notebookTools=o,this.addContextHighlightCSS(),this.setupListeners()}async onPromptSubmit(e,t){var o,n,s,i,a,r,l,c,d;console.log("Prompt submitted for cell",(null===(o=e.model)||void 0===o?void 0:o.id)||e.id,":",t);const h=(null===(i=null===(s=null===(n=e.model)||void 0===n?void 0:n.sharedModel.getMetadata())||void 0===s?void 0:s.cell_tracker)||void 0===i?void 0:i.trackingId)||(null===(a=e.model)||void 0===a?void 0:a.id)||e.id||"[unknown]";if("[unknown]"===h)return console.error("Could not determine cell ID for prompt submission.",e),!1;const u=this.notebookTracker.activeCell;if(!u)return console.warn("No active cell"),!1;const g=u.editor,p=null==g?void 0:g.getSelection(),m=(null==g?void 0:g.model.sharedModel.source.split("\n"))||[],f=this.calculateEndLine(null==p?void 0:p.end,m),C=null==g?void 0:g.model.sharedModel.source.substring(g.getOffsetAt((null==p?void 0:p.start)||{line:0,column:0}),g.getOffsetAt(f)),y=C&&C.trim().length>0,b=(null===(r=null==p?void 0:p.start)||void 0===r?void 0:r.line)||0,k=f.line,w=m.slice(b,k+1),S=v.getConfig();let _,x;y?(_=S.edit_selection,x="edit_selection"):(_=S.edit_full_cell,x="edit_full_cell");const M=_.system_prompt;try{const e=this.notebookTools.findCellByTrackingId(h),o=null==e?void 0:e.cell.model.sharedModel.getSource(),n=null===(d=null===(c=null===(l=this.notebookTools.findCellByIndex(((null==e?void 0:e.index)||0)-1))||void 0===l?void 0:l.cell)||void 0===c?void 0:c.model)||void 0===d?void 0:d.sharedModel.getSource();let s="";if(y){const e=w.map((e,t)=>`${(b+t+1).toString().padStart(3," ")}: ${e}`).join("\n"),o=m.map((e,t)=>`${(t+1).toString().padStart(3," ")}:${e}`).join("\n");s=`EDIT SELECTION MODE: Edit the selected lines (${b+1}-${k+1}) using structured operations.\n\nFULL CELL CONTEXT:\n\`\`\`\n${o}\n\`\`\`\n\nSELECTED LINES TO EDIT (${b+1}-${k+1}):\n\`\`\`\n${e}\n\`\`\`\n\nReturn a JSON object with operations for each line in the selection range. Use KEEP, MODIFY, REMOVE, or INSERT actions. Consider the full cell context when making edits.\n\nUser request: ${t}`}else s=`\n              EDIT FULL CELL MODE: Edit and improve the complete cell.\n\n              CELL TO EDIT:\n              \`\`\`\n              ${o}\n              \`\`\`\n\n              PREVIOUS CELL CONTENT:\n              \`\`\`\n              ${n}\n              \`\`\`\n\n              Return only the fully edited cell. Apply your quantitative expertise to improve the code.\n\n              User request: ${t}`;const i=v.getChatService();if(y){const e=this.notebookTools.findCellByTrackingId(h);if(!e)throw new Error(`Could not find cell with ID ${h}`);let t="",o=[];const n=e=>{try{const t=(0,nt.parse)(e.trim());if((null==t?void 0:t.operations)&&Array.isArray(t.operations))return t.operations.filter(e=>void 0!==e.line&&e.action&&["KEEP","MODIFY","REMOVE","INSERT"].includes(e.action))}catch(e){}return[]},a=t=>{if(0===t.length)return;const o=[...m];let n=0;const s=t.sort((e,t)=>e.line-t.line);for(const e of s){const t=e.line-1+n;switch(e.action){case"KEEP":break;case"MODIFY":t<o.length&&void 0!==e.content&&(o[t]=e.content);break;case"REMOVE":t<o.length&&(o.splice(t,1),n--);break;case"INSERT":t<=o.length&&void 0!==e.content&&(o.splice(t,0,e.content),n++)}}e.cell.model.sharedModel.setSource(o.join("\n"))},r=await i.sendEphemeralMessage(s,M,"claude-3-5-haiku-latest",e=>{t+=e;const s=n(t);s.length>0&&(s.length!==o.length||s.some((e,t)=>{const n=o[t];return!n||e.line!==n.line||e.action!==n.action||e.content!==n.content}))&&(a(s),o=[...s])});try{const e=n(r);if(!(e.length>0))throw new Error("No valid operations found in response");a(e),console.log(`Applied ${e.length} edit_selection operations to lines ${b+1}-${k+1} in cell ${h}`)}catch(e){return console.error("Failed to parse final edit_selection response:",e),console.error("Raw response:",r),alert("Error processing edit_selection: Invalid response format. Please try again."),!1}}else{const e=this.notebookTools.findCellByTrackingId(h);if(!e)throw new Error(`Could not find cell with ID ${h}`);let t="",o="",n=!1,a=/```(?:python|py)?\s*/i,r=/```/;const l=await i.sendEphemeralMessage(s,M,"claude-3-5-haiku-latest",s=>{if(t+=s,n)if(r.test(s)){n=!1;const e=o.lastIndexOf("```");-1!==e&&(o=o.substring(0,e)),o=o.replace(/^\s*(python|py)\s*\n?/i,"")}else o+=s;else{const e=t.match(a);e?(n=!0,o=t.substring(t.indexOf(e[0])+e[0].length),o=o.replace(/^\s*(python|py)\s*\n?/i,"")):o=t}if(o.includes("\n")){const t=o.split("\n"),n=[...m],s=Math.min(t.length,m.length);for(let e=0;e<s;e++)void 0!==t[e]&&(n[e]=t[e]);if(t.length>m.length)for(let e=m.length;e<t.length;e++)void 0!==t[e]&&n.push(t[e]);e.cell.model.sharedModel.setSource(n.join("\n"))}else if(o.trim()&&!o.includes("\n")){const t=[...m];t.length>0?t[0]=o.trim():t.push(o.trim()),e.cell.model.sharedModel.setSource(t.join("\n"))}});let c=o.trim();if(!c&&l.trim())if(l.includes("```")){const e=l.match(/```(?:python|py)?\s*([\s\S]*?)```/i);e&&(c=e[1].replace(/^\s*(python|py)\s*\n?/i,"").trim())}else c=l.trim();else c&&(c=c.replace(/^```(?:python|py)?\s*/i,"").replace(/```$/,"").replace(/^\s*(python|py)\s*\n?/i,"").trim());c&&(e.cell.model.sharedModel.setSource(c),console.log(`Applied edit_full_cell response to cell ${h} with progressive transformation`))}return console.log(`Ephemeral ${x} request completed using Haiku model.`),!0}catch(e){const t=e instanceof Error?e.message:String(e);return console.error(`Failed to process: ${t}`,e),!1}}async handlePromptSubmit(e,t){var o;if(t.trim()){const n=e.node.querySelector(".sage-ai-prompt-input"),s=e.node.querySelector(".sage-ai-quick-gen-prompt-error-message"),i=e.node.querySelector(".sage-ai-quick-gen-submit"),a=e.node.querySelector(".sage-ai-quick-gen-undo"),r=e.node.querySelector(".sage-ai-blob-loader"),l=null===(o=(e.model.sharedModel.getMetadata()||{}).cell_tracker)||void 0===o?void 0:o.trackingId,c=e.model.sharedModel.getSource();l&&(this.cellHistory.has(l)||this.cellHistory.set(l,[]),this.cellHistory.get(l).push(c)),r.style.display="block",i.disabled=!0,n.disabled=!0,a&&(a.disabled=!0);const d=await this.onPromptSubmit(e,t);if(r.style.display="none",i.disabled=!1,n.disabled=!1,d){n.value="",s.classList.add("sage-ai-quick-gen-prompt-error-message-hidden");const t=e.model.sharedModel.getSource();c!==t&&this.showDiffView(e,c,t),this.updateUndoButtonState(e)}else s.classList.remove("sage-ai-quick-gen-prompt-error-message-hidden"),a&&(a.disabled=!0)}}calculateEndLine(e,t){var o;return e?e.line>=t.length?{line:t.length-1,column:(null===(o=t[t.length-1])||void 0===o?void 0:o.length)||0}:e:null}showDiffView(e,t,o){const n=e.node.querySelector(".sage-ai-prompt-input");try{n.disabled=!0;const s=je.generateHtmlDiff(t,o,!0),i=e.node.querySelector(".cm-editor");i&&i.classList.add("sage-ai-hide-editor");const a=document.createElement("div");a.className="jp-DiffOverlay sage-ai-quick-gen-diff-overlay",a.style.minHeight="40px",a.style.top="0",a.style.left="0",a.style.width="100%",a.style.height="100%",a.style.zIndex="100",a.style.backgroundColor="var(--jp-layout-color0)",a.style.borderRadius="4px",a.innerHTML=s,a.dataset.cellId=e.model.id,a.dataset.diffType="quick_gen";const r=e.node.querySelector(".jp-InputArea-editor");if(r){"static"===window.getComputedStyle(r).position&&(r.style.position="relative");const o=r.querySelector(".sage-ai-quick-gen-diff-overlay");o&&o.remove(),r.appendChild(a);const s=document.createElement("div");s.style.position="absolute",s.style.top="8px",s.style.right="8px",s.style.zIndex="101",s.style.display="flex",s.style.gap="8px";const l=document.createElement("button");l.className="sage-ai-diff-approve-button",l.innerHTML="✓ Approve",l.style.background="#4CAF50",l.style.color="white",l.style.border="none",l.style.borderRadius="4px",l.style.padding="6px 12px",l.style.cursor="pointer",l.style.fontSize="12px",l.style.fontWeight="bold";const c=document.createElement("button");c.className="sage-ai-diff-reject-button",c.innerHTML="✕ Reject",c.style.background="#f44336",c.style.color="white",c.style.border="none",c.style.borderRadius="4px",c.style.padding="6px 12px",c.style.cursor="pointer",c.style.fontSize="12px",c.style.fontWeight="bold",l.addEventListener("click",()=>{a.remove(),s.remove(),i.classList.remove("sage-ai-hide-editor"),n.disabled=!1}),c.addEventListener("click",()=>{e.model.sharedModel.setSource(t),a.remove(),s.remove(),i.classList.remove("sage-ai-hide-editor"),n.disabled=!1}),s.appendChild(l),s.appendChild(c),a.appendChild(s)}}catch(e){console.error("Error showing diff view:",e),n.disabled=!1}}setChatContainer(e){this.chatContainerRef=e}handleUndo(e){var t;const o=null===(t=(e.model.sharedModel.getMetadata()||{}).cell_tracker)||void 0===t?void 0:t.trackingId;if(o&&this.cellHistory.has(o)){const t=this.cellHistory.get(o);if(t&&t.length>0){const n=t.pop();e.model.sharedModel.setSource(n),this.updateUndoButtonState(e),0===t.length&&this.cellHistory.delete(o)}}}clearCellHistory(e){this.cellHistory.delete(e)}getUndoStepsAvailable(e){const t=this.cellHistory.get(e);return t?t.length:0}updateUndoButtonState(e){var t;const o=null===(t=(e.model.sharedModel.getMetadata()||{}).cell_tracker)||void 0===t?void 0:t.trackingId,n=e.node.querySelector(".sage-ai-quick-gen-undo");if(n&&o){const e=this.getUndoStepsAvailable(o);n.disabled=0===e,n.title=e>0?`Undo AI changes (${e} step${e>1?"s":""} available)`:"No AI changes to undo"}}setupListeners(){this.notebookTracker.currentChanged.connect((e,t)=>{var o;t&&(this.highlightContextCells(t),null===(o=t.model)||void 0===o||o.cells.changed.connect(()=>{this.refreshHighlighting(t)}))}),this.notebookTracker.currentWidget&&this.highlightContextCells(this.notebookTracker.currentWidget)}refreshHighlighting(e){const t=e.context.path;this.highlightedCells.delete(t),this.highlightContextCells(e)}addContextHighlightCSS(){const e=document.createElement("style");e.id="sage-ai-context-highlight-style",e.textContent="\n      .sage-ai-in-context-cell {\n        position: relative;\n      }\n      .sage-ai-cell-id-label {\n        position: absolute;\n        right: 8px;\n        top: -8px;\n        transform: translateY(-50%);\n        background: #f2f7fd;\n        color: #1976d2;\n        border: 1px solid #dce5f2;\n        border-radius: 4px;\n        font-size: 10px;\n        padding: 2px 6px;\n        z-index: 101;\n        pointer-events: none;\n      }\n      \n      .sage-ai-context-indicator {\n        position: absolute;\n        left: -24px;\n        top: 0;\n        bottom: 0;\n        width: 4px;\n        background-color: #4CAF50;\n        border-radius: 2px;\n      }\n      \n      .sage-ai-context-badge {\n        position: absolute;\n        left: -80px;\n        top: 50%;\n        transform: translateY(-50%);\n        background-color: #4CAF50;\n        color: white;\n        padding: 2px 5px;\n        border-radius: 4px;\n        font-size: 10px;\n        white-space: nowrap;\n        opacity: 0;\n        transition: opacity 0.3s;\n      }\n      \n      .sage-ai-in-context-cell:hover .sage-ai-context-badge {\n        opacity: 1;\n      }\n      \n      .sage-ai-context-buttons {\n        position: absolute;\n        top: 0px;\n        left: 78px;\n        transform: translateY(-100%);\n        display: flex;\n        gap: 8px;\n        opacity: 1;\n        z-index: 100;\n      }\n      \n      .sage-ai-add-button, .sage-ai-remove-button {\n        padding: 2px 8px;\n        font-size: 10px;\n        border-radius: 4px;\n        cursor: pointer;\n        display: flex;\n        align-items: center;\n        gap: 4px;\n      }\n      \n      .sage-ai-add-button {\n        background-color: #f2f7fd;\n        color: #1976d2;\n        border: 1px solid #dce5f2;\n      }\n      \n      .sage-ai-add-button:hover {\n        background-color: #e1f0ff;\n        border-color: #a9c6e9;\n      }\n      \n      .sage-ai-remove-button {\n        background-color: #ffebee;\n        color: #e53935;\n        border: 1px solid #ffcdd2;\n      }\n      \n      .sage-ai-remove-button:hover {\n        background-color: #ffcdd2;\n        border-color: #ef9a9a;\n      }\n\n      .sage-ai-quick-generation {\n        display: flex;\n        align-items: center;\n        border: 0;\n        cursor: pointer;\n        font-size: 10px;\n        background-color: #f2f7fd;\n        color: #1976d2;\n        border: 1px solid #dce5f2;\n      }\n      \n      .sage-ai-quick-generation:hover {\n        background-color: #e1f0ff;\n        border-color: #a9c6e9;\n      }\n\n      .sage-ai-quick-generation-hidden {\n        display: none !important;\n      }\n      \n      .sage-ai-quick-gen-prompt-container {\n        display: inline-flex;\n        justify-content: center;\n        align-items: center;\n        gap: 4px;\n        flex: 1;\n        padding: 6px;\n      }\n\n      .sage-ai-quick-gen-prompt-input-container {\n        display: flex;\n        flex-direction: column;\n        gap: 4px;\n        flex: 1;\n      }\n\n      .sage-ai-quick-gen-prompt-error-message {\n        color: #f1625f;\n        font-size: var(--jp-ui-font-size0);\n        position: absolute;\n        top: 28px;\n        left: 93px;\n      }\n\n      .sage-ai-quick-gen-prompt-error-message-hidden {\n        display: none;\n      }\n\n      .sage-ai-prompt-input {\n        font-size: var(--jp-ui-font-size1);\n        padding: 4px;\n        margin: 0;\n        min-height: 20px;\n        width: 100%;\n        border: 0;\n        background-color: transparent;\n        outline: 0;\n      }\n\n      .sage-ai-quick-gen-submit {\n        display: flex;\n        align-items: center;\n        background: transparent;\n        border: 0;\n        padding: 0;\n        margin: 0;\n      }\n\n      .sage-ai-quick-gen-undo {\n        display: flex;\n        align-items: center;\n        background: transparent;\n        border: 0;\n        padding: 0;\n        margin: 0;\n        cursor: pointer;\n        opacity: 0.5;\n        transition: opacity 0.2s;\n      }\n\n      .sage-ai-quick-gen-undo:enabled {\n        opacity: 1;\n        cursor: pointer;\n      }\n\n      .sage-ai-quick-gen-undo:disabled {\n        opacity: 0.3;\n        cursor: not-allowed;\n      }\n\n      .sage-ai-quick-gen-cancel {\n        color: var(--jp-ui-font-color1);\n        font-size: 14px;\n        cursor: pointer;\n        line-height: 0;\n      }\n\n      .sage-ai-quick-gen-container {\n        display: flex;\n        flex-direction: column;\n        flex: 1;\n        border: var(--jp-border-width) solid var(--jp-cell-editor-border-color);\n      }\n\n      .sage-ai-quick-gen-active .jp-InputArea-editor {\n        border-top: var(--jp-border-width) solid var(--jp-cell-editor-border-color) !important; /* Use !important to override */\n        border-left: 0 !important;\n        border-right: 0 !important;\n        border-bottom: 0 !important;\n      }\n\n      .sage-ai-quick-gen-active .jp-Toolbar {\n        top: 39px !important; /* Use !important to override */\n      }\n\n      /* Reset toolbar position when quick gen is not active */\n      .jp-Cell:not(.sage-ai-quick-gen-active) .jp-Toolbar {\n          top: 0 !important; /* Ensure it resets */\n      }\n\n      .sage-ai-placeholder-quick-gen {\n        color: #828282;\n        position: absolute;\n        bottom: 12px;\n        left: 84px;\n      }\n\n      .sage-ai-placeholder-quick-gen-hidden {\n        display: none;\n      }\n\n      .sage-ai-placeholder-quick-gen-button {\n        display: inline-flex;\n        align-items: center;\n        gap: 2px;\n        color: #1976D2 !important;\n      }\n\n      .sage-ai-placeholder-quick-gen-button:hover {\n        cursor: pointer;\n        color: rgb(19, 93, 167) !important;\n      }\n\n      .sage-ai-placeholder-quick-gen-button:hover svg {\n        cursor: pointer;\n        fill: rgb(19, 93, 167) !important;\n      }\n      \n      .sage-ai-plan-label {\n        border-color: #12ff00 !important;\n      }\n\n      .sage-ai-quick-gen-diff-overlay {\n        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);\n        transition: opacity 0.3s ease;\n      }\n\n      .sage-ai-quick-gen-diff-overlay:hover {\n        box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);\n      }\n\n      .sage-ai-diff-approve-button:hover {\n        background: #45a049 !important;\n        transform: scale(1.05);\n        transition: all 0.2s ease;\n      }\n\n      .sage-ai-diff-reject-button:hover {\n        background: #d32f2f !important;\n        transform: scale(1.05);\n        transition: all 0.2s ease;\n      }\n    ",document.head.appendChild(e)}highlightContextCells(e){const t=e.context.path;if(!t)return;const o=this.notebookContextManager.getContextCells(t),n=new Set;this.highlightedCells.set(t,n);for(const e of o){const o=e.trackingId||e.cellId,s=this.notebookTools.findCellByAnyId(o,t);s&&(this.highlightCell(s.cell,!0),n.add(o))}this.addContextButtonsToAllCells(e)}addContextButtonsToAllCells(e){var t;const o=e.content.widgets,n=e.context.path;for(let e=0;e<o.length;e++){const s=o[e],i=null===(t=(s.model.sharedModel.getMetadata()||{}).cell_tracker)||void 0===t?void 0:t.trackingId,a=s.node.querySelector(".sage-ai-cell-id-label");if(a&&a.remove(),i){const e=document.createElement("div");e.setAttribute("sage-ai-cell-id",i),e.className="sage-ai-cell-id-label","planning_cell"===i&&(e.className+=" sage-ai-plan-label"),e.textContent=i,s.node.appendChild(e);const t=this.notebookContextManager.isCellInContext(n,i);this.addContextButtonsToCell(s,i,n,t)}}}addContextButtonsToCell(e,t,o,n){const s=e.node.querySelector(".sage-ai-context-buttons");s&&s.remove();const i=document.createElement("div");if(i.className="sage-ai-context-buttons",n){const n=document.createElement("button");n.className="sage-ai-remove-button",n.textContent="Remove from Chat",n.addEventListener("click",n=>{n.stopPropagation(),n.preventDefault(),this.notebookContextManager.removeCellFromContext(o,t),this.highlightCell(e,!1),this.refreshHighlighting(this.notebookTracker.currentWidget),this.chatContainerRef&&!this.chatContainerRef.isDisposed&&this.chatContainerRef.onCellRemovedFromContext(o,t)}),i.appendChild(n),e.node.classList.add("sage-ai-in-context-cell")}else{const n=document.createElement("button");n.className="sage-ai-add-button",n.innerHTML='\n        <svg xmlns="http://www.w3.org/2000/svg" height="12" width="12" viewBox="0 0 24 24">\n          <path fill="#1976d2" d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6z"/>\n        </svg>\n        Add to Context\n      ',n.addEventListener("click",n=>{n.stopPropagation(),n.preventDefault();const s=e.model.sharedModel.getSource(),i=e.model.type;this.notebookContextManager.addCellToContext(o,t,t,s,i),this.refreshHighlighting(this.notebookTracker.currentWidget),this.chatContainerRef&&!this.chatContainerRef.isDisposed&&this.chatContainerRef.onCellAddedToContext(o,t)}),i.appendChild(n),e.node.classList.remove("sage-ai-in-context-cell")}if(!e.node.querySelector(".sage-ai-quick-gen-container")){const t=document.createElement("button");t.className="sage-ai-quick-generation",t.innerHTML=it,t.append("Generate with Sage"),i.appendChild(t),e.model.sharedModel.source||t.classList.add("sage-ai-quick-generation-hidden"),t.addEventListener("click",()=>{if(e.node.querySelector(".sage-ai-quick-gen-prompt-container"))return;t.classList.add("sage-ai-quick-generation-hidden");const o=document.createElement("div");o.className="sage-ai-quick-gen-prompt-container";const n=document.createElement("div");n.className="sage-ai-blob-loader",n.style.display="none";const s=document.createElement("div");s.className="sage-ai-quick-gen-prompt-input-container";const a=document.createElement("input");a.className="sage-ai-prompt-input",a.placeholder="Edit selected lines or the whole cell";const r=document.createElement("span");r.className="sage-ai-quick-gen-prompt-error-message sage-ai-quick-gen-prompt-error-message-hidden",r.textContent="An unexpected error occurred, please try again.",s.append(a,r);const l=document.createElement("span");l.className="sage-ai-quick-gen-cancel",l.innerHTML='\n        <svg xmlns="http://www.w3.org/2000/svg" height="20px" width="20px" viewBox="0 0 24 24">\n          <path fill="var(--jp-ui-font-color3)" d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/>\n        </svg>\n      ',l.addEventListener("click",()=>{h.remove(),null==g||g.appendChild(u),i.classList.remove("sage-ai-buttons-hidden"),e.node.classList.remove("sage-ai-quick-gen-active"),e.model.sharedModel.source&&t.classList.remove("sage-ai-quick-generation-hidden")});const c=document.createElement("button");c.className="sage-ai-quick-gen-undo",c.disabled=!0,c.innerHTML=at,c.title="Undo AI changes",c.addEventListener("click",()=>{this.handleUndo(e)});const d=document.createElement("button");d.className="sage-ai-quick-gen-submit",d.style.cursor="pointer",d.innerHTML='<svg width="20px" height="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" stroke="var(--jp-ui-font-color3)"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g clip-path="url(#clip0_429_11126)"> <path d="M9 4.00018H19V18.0002C19 19.1048 18.1046 20.0002 17 20.0002H9" stroke="var(--jp-ui-font-color3)" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M12 15.0002L15 12.0002M15 12.0002L12 9.00018M15 12.0002H5" stroke="var(--jp-ui-font-color3)" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"></path> </g> <defs> <clipPath id="clip0_429_11126"> <rect width="24" height="24" fill="white"></rect> </clipPath> </defs> </g></svg>',d.addEventListener("click",()=>{this.handlePromptSubmit(e,a.value)}),o.innerHTML=it,o.append(s,n,c,d,l);const h=document.createElement("div");h.className="sage-ai-quick-gen-container";const u=e.node.querySelector(".jp-InputArea-editor");if(!u)throw"Unexpected error: Couldn't find the cell input area editor element";h.append(o,u);const g=e.node.querySelector(".jp-InputArea");if(!g)throw"Unexpected error: Couldn't find the cell input area element";g.appendChild(h),e.node.classList.add("sage-ai-quick-gen-active"),a.focus(),a.addEventListener("keydown",t=>{"Enter"!==t.key||t.shiftKey||(t.preventDefault(),this.handlePromptSubmit(e,a.value))})})}e.node.addEventListener("keydown",t=>{if(e.node.classList.contains("jp-mod-active")&&(t.metaKey||t.ctrlKey)&&"k"===t.key){t.preventDefault();const o=e.node.querySelector(".sage-ai-quick-generation");o&&!o.classList.contains("sage-ai-quick-generation-hidden")&&o.click()}});try{this.createCellPlaceholder(e),this.cellPlaceholderListener(e)}catch(e){console.error(`Couldn't setup placeholder: ${e}`)}e.node.appendChild(i)}cellPlaceholderListener(e){e.model.contentChanged.connect(t=>{const o=e.node.querySelector(".sage-ai-quick-generation"),n=t.sharedModel.source,s=e.node.querySelector(".sage-ai-placeholder-quick-gen"),i=null==s?void 0:s.classList.contains("sage-ai-placeholder-quick-gen-hidden");return!n&&i?(null==s||s.classList.remove("sage-ai-placeholder-quick-gen-hidden"),void(null==o||o.classList.add("sage-ai-quick-generation-hidden"))):n?(null==s||s.classList.add("sage-ai-placeholder-quick-gen-hidden"),void(null==o||o.classList.remove("sage-ai-quick-generation-hidden"))):void 0})}createCellPlaceholder(e){if(e.node.querySelector(".sage-ai-placeholder-quick-gen"))return;const t=document.createElement("span");t.className="sage-ai-placeholder-quick-gen",e.model.sharedModel.source&&t.classList.add("sage-ai-placeholder-quick-gen-hidden");const o=document.createElement("a");o.className="sage-ai-placeholder-quick-gen-button",o.textContent="Generate with Sage",o.innerHTML+=it,t.textContent="Start coding or ",t.append(o),o.addEventListener("click",t=>{t.stopPropagation();const o=e.node.querySelector(".sage-ai-quick-generation"),n=e.node.querySelector(".sage-ai-quick-gen-prompt-container");o&&!n&&o.click()}),t.addEventListener("click",()=>{const t=e.node.querySelector(".cm-content");null==t||t.focus()}),e.node.append(t)}highlightCell(e,t){e.node.classList.remove("sage-ai-in-context-cell");const o=e.node.querySelector(".sage-ai-context-indicator");o&&o.remove();const n=e.node.querySelector(".sage-ai-context-badge");if(n&&n.remove(),t){e.node.classList.add("sage-ai-in-context-cell");const t=document.createElement("div");t.className="sage-ai-context-indicator",e.node.appendChild(t);const o=document.createElement("div");o.className="sage-ai-context-badge",o.textContent="In Context",e.node.appendChild(o)}}}const it='\n      <svg fill="#1976d2" width="14px" height="14px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">\n      // <title></title><g data-name="Layer 2" id="Layer_2">\n      // <path d="M18,11a1,1,0,0,1-1,1,5,5,0,0,0-5,5,1,1,0,0,1-2,0,5,5,0,0,0-5-5,1,1,0,0,1,0-2,5,5,0,0,0,5-5,1,1,0,0,1,2,0,5,5,0,0,0,5,5A1,1,0,0,1,18,11Z"></path>\n      // <path d="M19,24a1,1,0,0,1-1,1,2,2,0,0,0-2,2,1,1,0,0,1-2,0,2,2,0,0,0-2-2,1,1,0,0,1,0-2,2,2,0,0,0,2-2,1,1,0,0,1,2,0,2,2,0,0,0,2,2A1,1,0,0,1,19,24Z"></path><path d="M28,17a1,1,0,0,1-1,1,4,4,0,0,0-4,4,1,1,0,0,1-2,0,4,4,0,0,0-4-4,1,1,0,0,1,0-2,4,4,0,0,0,4-4,1,1,0,0,1,2,0,4,4,0,0,0,4,4A1,1,0,0,1,28,17Z"></path></g></svg>\n    ',at='\n      <svg width="20px" height="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" stroke="var(--jp-ui-font-color3)">\n        <path d="M3 7v6h6" stroke="var(--jp-ui-font-color3)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>\n        <path d="M21 17a9 9 0 0 0-9-9 9 9 0 0 0-6 2.3L3 13" stroke="var(--jp-ui-font-color3)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>\n      </svg>\n    ';class rt extends z.Widget{constructor(e,t,o){super(),this.id="sage-ai-settings-container",this.title.label="Sage Settings",this.title.closable=!0,this.addClass("sage-ai-settings-container"),this.settingsWidget=new U(e);const n=new z.PanelLayout;n.addWidget(this.settingsWidget),this.layout=n}}function lt({isVisible:e,currentStep:t,nextStep:o,source:n,isLoading:s}){const[a,r]=x.useState(!1),[l,c]=x.useState("");if(x.useEffect(()=>{n&&n.trim()?(async()=>{try{i.marked.setOptions({gfm:!0,breaks:!1});const e=await i.marked.parse(n);c(e)}catch(e){console.error("Error rendering markdown:",e);const t=n.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;");c(t)}})():c("")},[n]),!e)return null;const d=n&&n.trim();return x.createElement("div",{className:"sage-ai-plan-state-display"},x.createElement("div",{className:"sage-ai-plan-state-header"},s&&x.createElement("div",{className:"sage-ai-plan-state-loader"}),x.createElement("div",{className:"sage-ai-plan-state-content"},x.createElement("div",{className:"sage-ai-plan-current-step"},x.createElement("span",{className:"sage-ai-plan-current-text"},t||"No current step")),(o||d)&&x.createElement("div",{className:"sage-ai-plan-bottom-row"},o&&x.createElement("div",{className:"sage-ai-plan-next-text"},"Next: ",o))),d&&x.createElement("button",{className:"sage-ai-plan-source-toggle",onClick:()=>r(!a),"aria-expanded":a,type:"button",title:"Toggle source details"},x.createElement("svg",{width:"17",height:"18",viewBox:"0 0 17 18",fill:"none",xmlns:"http://www.w3.org/2000/svg"},x.createElement("path",{d:"M3.54134 6.65503L13.458 6.65503L8.49967 11.3448L3.54134 6.65503Z",fill:"#949494"})))),d&&x.createElement("div",{className:"sage-ai-plan-source-content "+(a?"expanded":"collapsed")},x.createElement("div",{className:"sage-ai-plan-source-markdown",dangerouslySetInnerHTML:{__html:l}})))}class ct extends M.ReactWidget{constructor(){super(),this._stateChanged=new E.Signal(this),this._state={isVisible:!1,currentStep:void 0,nextStep:void 0,source:void 0,isLoading:!1},this.addClass("sage-ai-plan-state-widget")}get stateChanged(){return this._stateChanged}render(){return x.createElement(lt,{isVisible:this._state.isVisible,currentStep:this._state.currentStep,nextStep:this._state.nextStep,source:this._state.source,isLoading:this._state.isLoading})}async updatePlan(e,t,o,n){const s=!(!e&&!t);this._state={isVisible:s,currentStep:e,nextStep:t,source:o,isLoading:null!=n?n:!!e},this._stateChanged.emit(this._state),this.update()}show(){this._state={...this._state,isVisible:!0},this._stateChanged.emit(this._state),this.update()}hide(){this._state={...this._state,isVisible:!1},this._stateChanged.emit(this._state),this.update()}setLoading(e){this._state={...this._state,isLoading:e},this._stateChanged.emit(this._state),this.update()}updateCurrentStep(e){this._state={...this._state,currentStep:e,isVisible:!0},this._stateChanged.emit(this._state),this.update()}updateNextStep(e){this._state={...this._state,nextStep:e},this._stateChanged.emit(this._state),this.update()}updateSource(e){this._state={...this._state,source:e},this._stateChanged.emit(this._state),this.update()}getIsVisible(){return this._state.isVisible}getState(){return{...this._state}}getWidget(){return this}}class dt{constructor(){this.container=null,this.waitingReplyBox=null}initialize(e){if(this.waitingReplyBox)return;this.container=e,this.waitingReplyBox=document.createElement("div"),this.waitingReplyBox.className="sage-ai-waiting-reply-container";const t=document.createElement("div");t.className="sage-ai-waiting-reply-text",t.textContent="Sage will continue working after you reply",this.waitingReplyBox.appendChild(t),this.hide(),this.container.appendChild(this.waitingReplyBox)}hide(){this.waitingReplyBox&&(this.waitingReplyBox.style.display="none")}show(){this.waitingReplyBox&&(this.waitingReplyBox.style.display="block")}}var ht=o(8850),ut=o(4947);const gt={id:"sage-agent:plugin",description:"Sage AI - Your AI Data Partner",autoStart:!0,requires:[Re.INotebookTracker,We.ICommandPalette,We.IThemeManager,ut.IStateDB],optional:[ze.ISettingRegistry,We.IToolbarWidgetRegistry],activate:(e,t,o,n,s,i,a)=>{console.log("JupyterLab extension sage-agent is activated!"),T.initialize(i),te.initialize(s),(async()=>{console.log("MOVING ALL SETTINGS TO THE STATE DB");const e=await T.getSetting(D,{});e&&Object.keys(e).length>0&&(await te.setValue(D,e),console.log("SUCCESSFULLY MOVED ALL SETTINGS TO THE STATE DB"),await T.setSetting(D,{}))})(),v.setSettingsRegistry(i);const r=e.serviceManager,l=new ht.ListModel(r);v.setExtensions(l);const c=e.serviceManager.contents;(async()=>{await T.getBooleanSetting(I,!1)||(console.log("Setting theme to JupyterLab Dark (first time)"),n.setTheme("JupyterLab Dark"),await T.setBooleanSetting(I,!0))})(),(async()=>{try{let e=!1;try{e="directory"===(await c.get("templates")).type}catch(t){e=!1}if(!e){const e=await c.newUntitled({type:"directory",path:""});await c.rename(e.path,"templates"),console.log("Created 'templates' directory.")}let t=!1;try{await c.get("templates/rule.example.md"),t=!0}catch(e){t=!1}t||(await c.save("templates/rule.example.md",{type:"file",format:"text",content:"# EXAMPLE TEMPLATE FILE\n\n# Description: \nWhen called, look into the requested function or codeblock and see if you find any parallelizale code. You can use the following embarringly parallel code template to speed up those function computations\n\n# Code:\n```python\nfrom joblib import Parallel, delayed\n\ndef run_in_batches(fn_name):\n    tickers = get_sp500_tickers()\n    \n    # Process in smaller batches to control memory usage\n    results = Parallel(\n        n_jobs=-1, \n        batch_size=10,  # Process 10 items per batch\n        backend='multiprocessing'\n    )(delayed(test_ticket)(ticker) for ticker in tickers)\n    \n    return dict(zip(tickers, results))\n```"}),console.log("Created 'templates/rule.default.md' with placeholder content."))}catch(e){console.error("Error ensuring templates directory and rule.default.md:",e)}})(),i&&i.load(gt.id).then(e=>{console.log("Loaded settings for sage-agent");const t=e.get("defaultService").composite;t&&W.setActiveModelType(t),e.changed.connect(()=>{const t=e.get("defaultService").composite;W.setActiveModelType(t),console.log(`Default service changed to ${t}`)})}).catch(e=>{console.error("Failed to load settings for sage-agent",e)});const d=new Xe,h=new ct,u=new dt;d.setNotebookTracker(t,u),d.setContentManager(c);const g=new ot(d);d.setContextManager(g);const p=new _,m=new Qe(t,u);v.initializeCoreServices(d,t,m,g,c,i),v.initializeManagers(h,u),v.initializeAdditionalServices(p,new et(m,t),new Ke(t),new st(t,g,m));const f=v.getCellTrackingService(),C=v.getContextCellHighlighter(),y=new qe(m,p);v.setState({notebookDiffManager:y}),je.initializeThemeDetection(),je.onThemeChange(()=>{je.refreshAllDiffDisplays()}),t.currentChanged.connect((e,t)=>{if(t){let e=t.context.path;t.context.pathChanged.connect((t,o)=>{if(e!==o){y.setNotebookPath(o);const t=v.getChatContainerSafe();null==t||t.updateNotebookPath(e,o),e=o}});for(const e of t.content.widgets)je.removeDiffOverlay(e);y.setNotebookWidget(t),f.initializeExistingCells(),t.context.path&&g.getContext(t.context.path),v.switchChatContainerToNotebook(t.context.path)}});const b=v.getTrackingIDUtility(),k=new We.WidgetTracker({namespace:"sage-ai-widgets"});let w;const S=()=>{const o=v.getState().chatContainer;if(!o||o.isDisposed){const o=(()=>{const o=new tt(d,g);return k.add(o),e.shell.add(o,"right",{rank:1e3}),t.currentWidget&&o.switchToNotebook(t.currentWidget.context.path),v.setChatContainer(o),o})();return C.setChatContainer(o),o}return o},x=()=>(w&&!w.isDisposed||(w=(()=>{const t=new rt(d,y,g);return k.add(t),e.shell.add(t,"right",{rank:1001}),t})()),w);S(),w=x(),t.currentChanged.connect((e,t)=>{var o,n,s;if(t){t.model&&t.model.cells.length>0&&t.model.cells.get(0).setMetadata("deletable",!0),y.setNotebookWidget(t),y.setNotebookPath(t.context.path),f.initializeExistingCells(),t.context.path&&g.getContext(t.context.path);const e=v.getState().chatContainer;e&&!e.isDisposed&&e.switchToNotebook(t.context.path);const i=m.getPlanCell(t.context.path);if(i){const e=(null===(o=i.model.sharedModel.getMetadata().custom)||void 0===o?void 0:o.current_step_string)||"",t=(null===(n=i.model.sharedModel.getMetadata().custom)||void 0===n?void 0:n.next_step_string)||"",s=i.model.sharedModel.getSource()||"";console.log("Updating step floating box",e,t),v.getPlanStateDisplay().updatePlan(e,t,s,!1)}else i||v.getPlanStateDisplay().updatePlan(void 0,void 0,void 0);null===(s=null==t?void 0:t.model)||void 0===s||s.cells.changed.connect(()=>{var e,o,n;b.fixTrackingIDs(t.context.path),C.refreshHighlighting(t);const s=m.getPlanCell(t.context.path);if(s){const t=(null===(e=s.model.sharedModel.getMetadata().custom)||void 0===e?void 0:e.current_step_string)||"",n=(null===(o=s.model.sharedModel.getMetadata().custom)||void 0===o?void 0:o.next_step_string)||"",i=s.model.sharedModel.getSource()||"";console.log("Updating step floating box",t,n),v.getPlanStateDisplay().updatePlan(t,n,i,!1)}else s||v.getPlanStateDisplay().updatePlan(void 0,void 0,void 0);if(null===(n=t.model)||void 0===n?void 0:n.cells)for(const e of t.model.cells)e.metadataChanged.connect(()=>{C.refreshHighlighting(t)})})}}),function(e,t){!function(e,t){const o="sage-ai:test-notebook";e.commands.addCommand(o,{label:"Test Notebook",execute:async()=>{const e=v.getNotebookTools(),t=e.add_cell({cell_type:"code",source:'# This is a test cell created by NotebookTools\nprint("Hello from Sage AI!")\nimport time\ntime.sleep(1)\nprint("Cell with stable tracking ID!")',summary:"Test cell created with tracking ID",position:null}),o=e.add_cell({cell_type:"markdown",source:"# This is a test markdown cell\n\nWith stable tracking ID!\n\n* List item 1\n* List item 2",summary:"Test markdown cell created with tracking ID",position:null});console.log("Cell tracking ID 1:",t),console.log("Cell tracking ID 2:",o),setTimeout(()=>{const n=e.findCellByAnyId(t),s=e.findCellByAnyId(o);console.log("Found cell 1 by tracking ID:",n?"Yes":"No"),console.log("Found cell 2 by tracking ID:",s?"Yes":"No"),n&&e.edit_cell({cell_id:t,new_source:'# Updated cell content\nprint("This cell was found by tracking ID!")\nimport time\ntime.sleep(1)\nprint("Success!")',summary:"Updated test cell",is_tracking_id:!0})},2e3)}}),t.addItem({command:o,category:"AI Tools"})}(e,t),function(e,t){const o="sage-ai:test-add-with-diff";e.commands.addCommand(o,{label:"Test Add Cell With Diff",execute:async()=>{var e;const t=v.getNotebookTools(),o=v.getNotebookDiffManager(),n=v.getNotebookTracker(),s=t.add_cell({cell_type:"code",source:'# Test cell with diff view\nprint("This cell demonstrates diff view")\nfor i in range(5):\n    print(f"Count: {i}")',summary:"Test cell with diff view",position:null}),i=t.findCellByAnyId(s);if(!i)return void console.error("Could not find the newly added cell by tracking ID");const a=(null===(e=n.currentWidget)||void 0===e?void 0:e.context.path)||null;o.trackAddCell(s,i.cell.model.sharedModel.getSource(),"Test cell with diff view",a),console.log("Displaying diff view...");const r=t.display_diff(i.cell,"",i.cell.model.sharedModel.getSource(),"add").cellId;console.log(`Original tracking ID: ${s}, Updated cell ID: ${r}`),o.updateCellIdMapping(s,r,a);const l=n.currentWidget,c=await o.showApprovalDialog(l?l.node:document.body,!1,!1,l?l.context.path:null);console.log("Diff approval result:",c),setTimeout(()=>{const e=t.findCellByAnyId(s,a);console.log("Found cell after diff approval:",e?"Yes":"No")},1e3)}}),t.addItem({command:o,category:"AI Tools"})}(e,t),function(e,t){const o="sage-ai:test-edit-with-diff";e.commands.addCommand(o,{label:"Test Edit Cell With Diff",execute:async()=>{const e=v.getNotebookTools(),t=v.getNotebookDiffManager(),o=v.getNotebookTracker();console.log("Step 1: Adding new cell...");const n=e.add_cell({cell_type:"code",source:'# Original cell content\nprint("This is the original content")\nvalue = 42',summary:"Original test cell",position:null});setTimeout(()=>{var s;console.log("Step 2: Editing cell after 2 seconds...");const i='# Modified cell content\nprint("This content has been modified!")\nvalue = 42\nprint(f"The value is {value}")\n\n# Added a new comment';if(!e.edit_cell({cell_id:n,new_source:i,summary:"Modified test cell",is_tracking_id:!0}))return void console.error("Could not edit the cell with tracking ID");const a=(null===(s=o.currentWidget)||void 0===s?void 0:s.context.path)||null;t.trackEditCell(n,'# Original cell content\nprint("This is the original content")\nvalue = 42',i,"Modified test cell",a),setTimeout(async()=>{var s;console.log("Step 3: Showing diff after edit...");const i=await t.showApprovalDialog(document.body,!1,!1,(null===(s=o.currentWidget)||void 0===s?void 0:s.context.path)||null);console.log("Diff approval result:",i),await t.applyApprovedDiffs(),await t.handleRejectedDiffs(),setTimeout(()=>{const t=e.findCellByAnyId(n,a);console.log("Found cell after diff approval:",t?"Yes":"No")},2e3)},2e3)},2e3)}}),t.addItem({command:o,category:"AI Tools"})}(e,t),function(e,t){const o="sage-ai:test-multiple-diffs";e.commands.addCommand(o,{label:"Test Multiple Diffs",execute:async()=>{var e;const t=v.getNotebookTools(),o=v.getNotebookDiffManager(),n=v.getNotebookTracker();console.log("Running multiple diffs test with tracking IDs...");const s=[],i=t.add_cell({cell_type:"code",source:'# First cell\nx = 10\ny = 20\nprint(f"Sum: {x + y}")',summary:"First test cell",position:null});s.push(i),console.log(`Added cell 1 with tracking ID: ${i}`);const a=t.add_cell({cell_type:"markdown",source:"# Second Cell\nThis is a markdown cell for testing multiple diffs.",summary:"Second test cell",position:null});s.push(a),console.log(`Added cell 2 with tracking ID: ${a}`);const r=t.add_cell({cell_type:"code",source:'# Third cell\nimport matplotlib.pyplot as plt\nplt.figure(figsize=(8, 6))\nplt.plot([1, 2, 3, 4])\nplt.title("Test Plot")',summary:"Third test cell",position:null});s.push(r),console.log(`Added cell 3 with tracking ID: ${r}`),await new Promise(e=>setTimeout(e,1e3));const l=['# First cell - MODIFIED\nx = 10\ny = 20\nz = 30\nprint(f"Sum: {x + y + z}")',"# Second Cell - MODIFIED\nThis is a **modified** markdown cell for testing multiple diffs.\n\n- Item 1\n- Item 2",'# Third cell - MODIFIED\nimport matplotlib.pyplot as plt\nimport numpy as np\nx = np.linspace(0, 10, 100)\nplt.figure(figsize=(10, 8))\nplt.plot(x, np.sin(x))\nplt.title("Modified Plot")'];for(let i=0;i<s.length;i++){const a=s[i],r=t.findCellByAnyId(a);if(!r){console.error(`Could not find cell with tracking ID ${a}`);continue}const c=r.cell.model.sharedModel.getSource(),d=(null===(e=n.currentWidget)||void 0===e?void 0:e.context.path)||null;o.trackEditCell(a,c,l[i],`Modified test cell ${i+1}`,d),console.log(`Displaying diff for cell ${i+1} with tracking ID ${a}...`)}const c=n.currentWidget,d=await o.showApprovalDialog(c?c.node:document.body,!1,!1,c?c.context.path:null);console.log("Multiple diffs approval result:",d),setTimeout(()=>{for(let e=0;e<s.length;e++){const o=s[e],n=t.findCellByAnyId(o);console.log(`Found cell ${e+1} after diff approval: ${n?"Yes":"No"}`)}},1e3)}}),t.addItem({command:o,category:"AI Tools"})}(e,t),function(e,t){const o="sage-ai:test-tracking-persistence";e.commands.addCommand(o,{label:"Test Tracking ID Persistence",execute:async()=>{const e=v.getNotebookTools(),t=v.getCellTrackingService();console.log("Testing tracking ID persistence...");const o=t.getAllTrackingIds();console.log(`Found ${o.length} cells with tracking IDs`),console.log("Tracking IDs:",o),t.initializeExistingCells();const n=t.getAllTrackingIds();console.log(`Now have ${n.length} cells with tracking IDs`);const s=e.add_cell({cell_type:"markdown",source:"# Persistence Test\n\nThis cell tests tracking ID persistence across notebook operations.",summary:"Persistence test cell",position:null});console.log(`Added new cell with tracking ID: ${s}`);const i=e.findCellByAnyId(s);console.log("Found cell immediately:",i?"Yes":"No"),setTimeout(()=>{const t=e.findCellByAnyId(s);console.log("Found cell after delay:",t?"Yes":"No"),t&&(e.edit_cell({cell_id:s,new_source:"# Persistence Test - UPDATED\n\nThis cell was successfully found by its tracking ID after a delay!",summary:"Updated persistence test cell",is_tracking_id:!0}),console.log("Cell updated successfully through tracking ID"))},2e3)}}),t.addItem({command:o,category:"AI Tools"})}(e,t),function(e,t){const o="sage-ai:tracking-id-report";e.commands.addCommand(o,{label:"Show Cell Tracking ID Report",execute:()=>{const e=v.getTrackingIDUtility().getTrackingIDReport();console.log("Cell Tracking ID Report:"),console.table(e)}}),t.addItem({command:o,category:"AI Tools"})}(e,t),function(e,t){const o="sage-ai:fix-tracking-ids";e.commands.addCommand(o,{label:"Fix Cell Tracking IDs",execute:()=>{const e=v.getTrackingIDUtility().fixTrackingIDs();console.log(`Fixed tracking IDs for ${e} cells`)}}),t.addItem({command:o,category:"AI Tools"})}(e,t)}(e,o),function(e,t){!function(e,t){const o="sage-ai:run_eval";e.commands.addCommand(o,{label:"Run Eval",execute:async()=>{var t,o,n,s,i,a;v.getNotebookTools(),v.getNotebookDiffManager();const r=v.getNotebookTracker(),{commands:l,shell:c}=e,d=c.currentWidget,h="evals.ipynb";console.log("CURRENT NOTEBOOK ID:",null===(t=v.getNotebookTracker().currentWidget)||void 0===t?void 0:t.sessionContext.path),d&&(null===(o=v.getNotebookTracker().currentWidget)||void 0===o?void 0:o.sessionContext.path)!==h?l.execute("docmanager:open",{path:h,options:{mode:"tab-after",ref:d.id,activate:!0}}).then(()=>{d.close()}):l.execute("docmanager:open",{path:h}),await Oe(500),v.setCurrentNotebookPath(h);const u=null===(n=r.currentWidget)||void 0===n?void 0:n.content;u&&await Re.NotebookActions.runAll(u,null===(s=r.currentWidget)||void 0===s?void 0:s.sessionContext);const g=null===(i=v.getChatContainerSafe())||void 0===i?void 0:i.chatWidget;if(!g)return void console.error("Chat widget not found");const p=v.getContentManager(),m=await p.get("eval_prompt.txt");if(!m||!m.content)return void console.error("Prompt content not found");g.threadManager.createNewThread(),await Oe(200),g.conversationService.setAutoRun(!0),g.inputManager.setInputValue(m.content),await g.inputManager.sendMessage();const f=g.chatHistoryManager.getCurrentThread();if(!f)return void console.error("Chat history not found");const C=ne.getCleanMessageArrayWithTimestamps(f);return null===(a=r.currentWidget)||void 0===a||a.sessionContext.restartKernel(),await p.save("eval_output.json",{type:"file",format:"text",content:JSON.stringify(C,null,2)}),console.log("Cleaned Messages:",C),C}}),t.addItem({command:o,category:"AI Tools"})}(e,t)}(e,o),t.activeCellChanged.connect((e,o)=>{var n;if(o){const e=null===(n=t.currentWidget)||void 0===n?void 0:n.context.path;if(!e)return;const s=o.model.sharedModel.getMetadata()||{};let i="";s&&"object"==typeof s&&"cell_tracker"in s&&s.cell_tracker&&"object"==typeof s.cell_tracker&&"trackingId"in s.cell_tracker&&(i=String(s.cell_tracker.trackingId));const a=i?g.isCellInContext(e,i):g.isCellInContext(e,o.model.id),r=document.querySelector('.jp-ToolbarButtonComponent[data-command="sage-ai-add-to-context"]');if(r)if(a){r.classList.add("in-context");const e=r.querySelector(".jp-icon3");if(e){const t='<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24"><path fill="currentColor" d="M5 13v-2h14v2z"/></svg>';e.innerHTML=t}const t=r.querySelector(".button-text");t&&(t.textContent="Remove from Chat")}else{r.classList.remove("in-context");const e=r.querySelector(".jp-icon3");e&&(e.innerHTML=M.addIcon.svgstr);const t=r.querySelector(".button-text");t&&(t.textContent="Add to Context")}}});const{commands:E}=e,N="sage-agent:log-selected-code";o.addItem({command:N,category:"Sage AI"}),e.commands.addKeyBinding({command:N,keys:["Accel Shift K"],selector:".jp-Notebook.jp-mod-editMode"}),E.addCommand(N,{label:"Log Selected Code",execute:()=>{if(!k.currentWidget)return void console.warn("No active notebook");const e=t.activeCell;if(!e)return void console.warn("No active cell");const o=e.editor,n=null==o?void 0:o.getSelection();n?console.log("Selection:",n):console.log("No selection");const s=null==o?void 0:o.model.sharedModel.source.substring(o.getOffsetAt((null==n?void 0:n.start)||{line:0,column:0}),o.getOffsetAt((null==n?void 0:n.end)||{line:0,column:0}));s?console.log("Selected text:",s):console.log("No text selected")}}),S(),x()},deactivate:()=>{console.log("JupyterLab extension sage-agent is deactivated!"),je.cleanupThemeDetection()}},pt=gt},6316:e=>{"use strict";e.exports=JSON.parse('[{"name":"notebook-edit_plan","description":"Modifies the plan of the notebook. Returns True on success.\\n\\nArgs:\\n    updated_plan_string: Updated plan string in markdown format with detailed steps and sub-steps\\n        in a tree structure and this will be put on the first cell of the notebook.\\n        Each sub-step should be a check mark i.e. [ ] if not completed or [x] if completed.\\n        The first cell of the notebook will be the plan and the second cell will be the current step.\\n        The third cell will be the next step.\\n    current_step_string: Current step string i.e. the step that is currently being worked on.\\n        Should be a specific, step that is closest to the actual task being performed.\\n        It might be a step, sub-step, user-facing step, or a sub-step of a user-facing step.\\n    next_step_string: Next step string i.e. the step that will be worked on next.\\n        Should be the immediate next actionable step that follows logically from the current step.\\n        It might be a step, sub-step, user-facing step, or a sub-step of a user-facing step.\\n    notebook_path: Path to the notebook file. System-managed, should not be set by LLM.\\n\\nReturns:\\n    bool: True if the plan was found and updated, False otherwise.\\n","input_schema":{"type":"object","properties":{"updated_plan_string":{"title":"Updated Plan String","type":"string"},"current_step_string":{"default":"Current step","title":"Current Step String","type":"string"},"next_step_string":{"default":"Next step","title":"Next Step String","type":"string"},"notebook_path":{"anyOf":[{"type":"string"},{"type":"null"}],"default":null,"title":"Notebook Path"}},"required":["updated_plan_string"],"title":"edit_planArguments"}},{"name":"notebook-read_cells","description":"Reads the specified cells (max 5) and returns content as JSON.\\n\\nArgs:\\n    notebook_path: Path to the notebook file. System-managed, should not be set by LLM.\\n    start_index: int 0-based start index for cell slice. Default 0.\\n    end_index: int 0-based end index (inclusive) for cell slice. Default -1 (last cell).\\n\\nReturns:\\n    str: JSON string representing the notebook slice (cells, metadata).\\n","input_schema":{"type":"object","properties":{"notebook_path":{"anyOf":[{"type":"string"},{"type":"null"}],"default":null,"title":"Notebook Path"},"start_index":{"default":0,"title":"Start Index","type":"integer"},"end_index":{"default":-1,"title":"End Index","type":"integer"}},"title":"read_cellsArguments"}},{"name":"notebook-add_cell","description":"Adds a new cell (code, markdown, or raw) to the specified notebook at an optional position, returning its unique ID.\\n\\nArgs:\\n    cell_type: Type of cell (\\"code\\", \\"markdown\\", or \\"raw\\").\\n    source: Initial source content for the cell.\\n    summary: A summary of the cell\'s content.\\n    notebook_path: Path to the notebook file. System-managed, should not be set by LLM.\\n    position: 0-based index for insertion (appends if None).\\n\\nReturns:\\n    str: The unique ID of the newly created cell.\\n","input_schema":{"type":"object","properties":{"cell_type":{"title":"Cell Type","type":"string"},"source":{"title":"Source","type":"string"},"summary":{"title":"Summary","type":"string"},"notebook_path":{"anyOf":[{"type":"string"},{"type":"null"}],"default":null,"title":"Notebook Path"},"position":{"anyOf":[{"type":"integer"},{"type":"null"}],"default":null,"title":"Position"}},"required":["cell_type","source","summary"],"title":"add_cellArguments"}},{"name":"notebook-remove_cells","description":"Removes a list of cells from the specified notebook using their IDs. Returns True if at least one cell was removed.\\n\\nArgs:\\n    cell_ids: A list of unique identifiers of the cells to remove.\\n    notebook_path: Path to the notebook file. System-managed, should not be set by LLM.\\n\\nReturns:\\n    bool: True if at least one cell was found and removed, False otherwise.\\n","input_schema":{"type":"object","properties":{"cell_ids":{"items":{"type":"string"},"title":"Cell Ids","type":"array"},"notebook_path":{"anyOf":[{"type":"string"},{"type":"null"}],"default":null,"title":"Notebook Path"}},"required":["cell_ids"],"title":"remove_cellsArguments"}},{"name":"notebook-edit_cell","description":"Modifies the source content of an existing cell. Returns True on success.\\n\\nArgs:\\n    cell_id: Unique identifier of the cell to edit.\\n    new_source: New source content for the cell.\\n    summary: A summary of the cell\'s new content.\\n    notebook_path: Path to the notebook file. System-managed, should not be set by LLM.\\n\\nReturns:\\n    bool: True if the cell was found and updated, False otherwise.\\n","input_schema":{"type":"object","properties":{"cell_id":{"title":"Cell Id","type":"string"},"new_source":{"title":"New Source","type":"string"},"summary":{"title":"Summary","type":"string"},"notebook_path":{"anyOf":[{"type":"string"},{"type":"null"}],"default":null,"title":"Notebook Path"}},"required":["cell_id","new_source","summary"],"title":"edit_cellArguments"}},{"name":"notebook-run_cell","description":"Runs a code cell in the specified notebook and returns its formatted output.\\n\\nArgs:\\n    cell_id: Unique identifier of the code cell to execute.\\n    notebook_path: Path to the notebook file. System-managed, should not be set by LLM.\\n    kernel_id: Specific kernel ID to use (system-managed and should not be set by LLM).\\n\\nReturns:\\n    List[str]: Formatted output strings from the cell\'s execution.\\nRaises:\\n    ValueError: If cell_id is invalid or not a code cell.\\n    RuntimeError: If kernel or server communication fails.\\n","input_schema":{"type":"object","properties":{"cell_id":{"title":"Cell Id","type":"string"},"notebook_path":{"anyOf":[{"type":"string"},{"type":"null"}],"default":null,"title":"Notebook Path"},"kernel_id":{"anyOf":[{"type":"string"},{"type":"null"}],"default":null,"title":"Kernel Id"}},"required":["cell_id"],"title":"run_cellArguments"}},{"name":"notebook-wait_user_reply","description":"Displays a UI component to inform the user that the agent has completed its turn and is now waiting for a user reply.\\n\\nThis tool should be called as the final action in an assistant\'s turn after providing a complete response or asking a question. It signals that the agent is done processing and is awaiting the user\'s next instruction or answer.\\n\\nArgs:\\n    notebook_path: Path to the notebook file. System-managed, should not be set by LLM.\\n\\nReturns:\\n    bool: True if the waiting reply box was shown successfully, False otherwise.\\n","input_schema":{"type":"object","properties":{"notebook_path":{"anyOf":[{"type":"string"},{"type":"null"}],"default":null,"title":"Notebook Path"}},"title":"wait_user_replyArguments"}},{"name":"filesystem-read_dataset","description":"Read lines from a dataset in data dir (max 10 lines)\\n\\nArgs:\\n    filepath (str): Path to the file to read\\n    start (int): Starting line default 0\\n    end (int): Ending line default 10\\n\\nReturns:\\n    str: JSON object with file contents or error message\\n","input_schema":{"type":"object","properties":{"filepath":{"title":"Filepath","type":"string"},"start":{"default":0,"title":"Start","type":"integer"},"end":{"default":10,"title":"End","type":"integer"}},"required":["filepath"],"title":"read_datasetArguments"}},{"name":"web-search_dataset","description":"\\nSearch for tickers matching the provided query strings.\\nThe search is performed using a fuzzy matching algorithm, so precise queries will generally yield better results.\\n\\nArgs:\\n    queries: (List[str]) List of search strings to match against ticker symbols or names.\\n    limit: Maximum number of results to return (default: 5, max: 10)\\n\\nReturns:\\n    A list of matching ticker dictionaries, aggregated from all queries.\\n","input_schema":{"type":"object","properties":{"queries":{"items":{"type":"string"},"title":"Queries","type":"array"},"limit":{"default":10,"title":"Limit","type":"integer"}},"required":["queries"],"title":"search_datasetArguments"}}]')},8051:e=>{"use strict";e.exports="You are a world leading expert data scientist and quantitative analyst tasked with **answering questions and providing insights about data analysis within Jupyter Notebooks**. You excel in helping users understand **data exploration, analysis, visualization, hypothesis testing, and summarization** by reading and analyzing existing code and data. Your approach is analytical, insightful, and educational.\n\n## Important Rules:\n\n* **Read-only mode**: You can only read and analyze notebooks, never modify or execute code.\n* **Provide clear explanations** for any code or analysis you encounter.\n* **Answer questions comprehensively** based on the notebook content and context.\n* **Suggest improvements** and best practices without implementing them directly.\n* **Limit tool calls**: Bundle related dataset and code searches into minimal calls.\n* **Craft precise, descriptive queries** for dataset and code searches—avoid overly broad or vague single-word queries.\n\n---\n\n## Tool Calling\nFollow these instructions precisely:\n\n* **Explain clearly** before every tool call **why you're using it and what you expect**.\n* **Bundle searches efficiently** into one comprehensive query, not multiple single-word queries.\n* Tools are for your internal use only; **do not call tools from inside code cells**.\n* **Focus on reading and understanding** rather than execution.\n\n---\n\n## Workflow\n\n### Understand the Question:\n\n* Quickly read relevant notebook summary and recent context. Do **not** review the entire notebook unnecessarily.\n* Determine what specific information or insights the user is seeking.\n* Before any tool usage, explicitly ask the user if it's appropriate to perform searches or analyze specific parts.\n\n### Analyze and Explain:\n\n* Provide clear, structured explanations of code, data, and analysis you encounter.\n* Break down complex concepts into understandable components.\n* Highlight key insights, patterns, or potential issues in the analysis.\n\n### Answer Questions:\n\n* Respond to user questions based on the notebook content and your expertise.\n* Provide educational context and explanations for data science concepts.\n* Suggest improvements or alternative approaches when appropriate.\n\n### Dataset Understanding:\n\n* Analyze datasets mentioned in the notebook to provide insights.\n* Explain data structures, patterns, and characteristics you observe.\n* Help users understand the implications of their data.\n\n### Code Analysis:\n\n* Explain the purpose and functionality of code you encounter.\n* Identify potential improvements, optimizations, or best practices.\n* Help users understand the logic and reasoning behind analysis approaches.\n\n### Final Outputs:\n\n* Provide comprehensive answers to user questions.\n* Summarize key insights and findings from the analysis.\n* Offer suggestions for further exploration or improvement.\n\n### Error and Issue Analysis:\n\n* When encountering errors or issues in the notebook, explain what went wrong and why.\n* Suggest potential solutions or debugging approaches.\n* Help users understand the root causes of problems.\n\n---\n\n## Response Style\nWhen answering questions, clearly explain:\n- What the code or analysis is doing and why\n- Key insights and findings from the data\n- Potential improvements or alternative approaches\n- Educational context for data science concepts\n- Best practices and recommendations"},8883:e=>{"use strict";e.exports="You are an expert quantitative researcher and data scientist embedded inside a Jupyter notebook environment. You serve as a **cell-level editing assistant**—executing **precise, minimal code edits** on demand.\n\n## Primary Directive\n\n**Only return the fully edited Jupyter cells. No tool calls. No commentary or explanation. No output other than the edited cells.**\n\n---\n\n## Rules of Execution\n\n* **Follow User Commands Exactly**: Obey user instructions fully. Do **not** do more than asked. Do not infer or hallucinate missing context, libraries, variables, or data.\n* **Be Context-Aware**: Respect notebook context if available. Don't break dependencies or change variable semantics.\n* **Style and Performance**: Prioritize vectorization and correct use of libraries like NumPy, Pandas, Scikit-learn, PyTorch, etc. Make professional plots. \n* **Quantitative Style, Not Software Engineering**: Write code like a top-tier quant or data scientist. Favor clarity, elegance, and performance. Avoid overengineering.\n* **No Tool Calls, No Outputs, No Commentary**: Never invoke tools. Never provide any commentary or explanation besides the edited cells.\n* **Always Provide Executable Code**: Do not use Markdown formatting, including headers, bold, italic, bullet points, or code blocks.\n\n---\n\n## Output Format\n\n**Only the revised code cell. No text. No markdown. No notes. Just the final code, clean and executable.** "}}]);