"""Change description to description_fr

Revision ID: 6e28ca2ef0c7
Revises: 314114c0b886
Create Date: 2023-05-30 20:57:17.927987

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = "6e28ca2ef0c7"
down_revision = "314114c0b886"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("group", sa.Column("description_fr", sa.String(length=100), nullable=False))
    op.drop_index("description", table_name="group")
    op.create_unique_constraint(None, "group", ["description_fr"])
    op.drop_column("group", "description")
    op.add_column("phase", sa.Column("description_fr", sa.String(length=100), nullable=False))
    op.drop_column("phase", "description")
    op.add_column("team", sa.Column("description_fr", sa.String(length=100), nullable=False))
    op.drop_index("description", table_name="team")
    op.create_unique_constraint(None, "team", ["description_fr"])
    op.drop_column("team", "description")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("team", sa.Column("description", mysql.VARCHAR(length=100), nullable=False))
    op.drop_constraint(None, "team", type_="unique")
    op.create_index("description", "team", ["description"], unique=False)
    op.drop_column("team", "description_fr")
    op.add_column("phase", sa.Column("description", mysql.VARCHAR(length=100), nullable=False))
    op.drop_column("phase", "description_fr")
    op.add_column("group", sa.Column("description", mysql.VARCHAR(length=100), nullable=False))
    op.drop_constraint(None, "group", type_="unique")
    op.create_index("description", "group", ["description"], unique=False)
    op.drop_column("group", "description_fr")
    # ### end Alembic commands ###
