"""Introduce match reference table and allow nullable team_id foreign key in match table.

Revision ID: 9b91a1a350a0
Revises: e0f551c7766c
Create Date: 2023-04-07 23:06:16.326481

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = "9b91a1a350a0"
down_revision = "e0f551c7766c"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "match_reference",
        sa.Column("id", sa.String(length=100), nullable=False),
        sa.Column("group_id", sa.String(length=100), nullable=False),
        sa.Column("index", sa.Integer(), nullable=False),
        sa.Column("team1_id", sa.String(length=100), nullable=True),
        sa.Column("team2_id", sa.String(length=100), nullable=True),
        sa.Column(
            "bet_type_from_match",
            sa.Enum("SCORE_BET", "BINARY_BET", name="betmapping"),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["group_id"],
            ["group.id"],
        ),
        sa.ForeignKeyConstraint(
            ["team1_id"],
            ["team.id"],
        ),
        sa.ForeignKeyConstraint(
            ["team2_id"],
            ["team.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    with op.batch_alter_table("match", schema=None) as batch_op:
        batch_op.alter_column("team1_id", existing_type=mysql.VARCHAR(length=100), nullable=True)
        batch_op.alter_column("team2_id", existing_type=mysql.VARCHAR(length=100), nullable=True)
        batch_op.drop_column("bet_type_from_match")

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("match", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("bet_type_from_match", mysql.ENUM("SCORE_BET", "BINARY_BET"), nullable=True),
        )
        batch_op.alter_column("team2_id", existing_type=mysql.VARCHAR(length=100), nullable=False)
        batch_op.alter_column("team1_id", existing_type=mysql.VARCHAR(length=100), nullable=False)

    op.drop_table("match_reference")
    # ### end Alembic commands ###
