"""Add role column to User

Revision ID: d09424392322
Revises: ce42052974e9
Create Date: 2025-08-16 15:39:29.687453

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "d09424392322"
down_revision = "ce42052974e9"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # Create the ENUM type first
    role_enum = sa.Enum("USER", "ADMIN", name="role")
    role_enum.create(op.get_bind())

    # Add the column as nullable first
    op.add_column("user", sa.Column("role", role_enum, nullable=True))

    # Update existing rows to have a default role
    op.execute("UPDATE \"user\" SET role = 'USER' WHERE role IS NULL")

    # Now make the column NOT NULL
    op.alter_column("user", "role", nullable=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # Drop the column first
    op.drop_column("user", "role")

    # Then drop the ENUM type
    role_enum = sa.Enum("USER", "ADMIN", name="role")
    role_enum.drop(op.get_bind())
    # ### end Alembic commands ###
