"""Initial migration.

Revision ID: f33dc66104ad
Revises:
Create Date: 2023-02-27 15:42:06.550841

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "f33dc66104ad"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "phase",
        sa.Column("id", sa.String(length=100), nullable=False),
        sa.Column("code", sa.String(length=10), nullable=False),
        sa.Column("description", sa.String(length=100), nullable=False),
        sa.Column("index", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id", "code"),
        sa.UniqueConstraint("code"),
    )
    op.create_table(
        "team",
        sa.Column("id", sa.String(length=100), nullable=False),
        sa.Column("code", sa.String(length=10), nullable=False),
        sa.Column("description", sa.String(length=100), nullable=False),
        sa.Column("flag_url", sa.String(length=100), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("code"),
        sa.UniqueConstraint("description"),
    )
    op.create_table(
        "user",
        sa.Column("id", sa.String(length=100), nullable=False),
        sa.Column("name", sa.String(length=100), nullable=False),
        sa.Column("first_name", sa.String(length=100), nullable=False),
        sa.Column("last_name", sa.String(length=100), nullable=False),
        sa.Column("password", sa.String(length=100), nullable=False),
        sa.Column("number_match_guess", sa.Integer(), nullable=False),
        sa.Column("number_score_guess", sa.Integer(), nullable=False),
        sa.Column("number_qualified_teams_guess", sa.Integer(), nullable=False),
        sa.Column("number_first_qualified_guess", sa.Integer(), nullable=False),
        sa.Column("number_quarter_final_guess", sa.Integer(), nullable=False),
        sa.Column("number_semi_final_guess", sa.Integer(), nullable=False),
        sa.Column("number_final_guess", sa.Integer(), nullable=False),
        sa.Column("number_winner_guess", sa.Integer(), nullable=False),
        sa.Column("points", sa.Float(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
    )
    op.create_table(
        "group",
        sa.Column("id", sa.String(length=100), nullable=False),
        sa.Column("code", sa.String(length=1), nullable=False),
        sa.Column("description", sa.String(length=100), nullable=False),
        sa.Column("index", sa.Integer(), nullable=False),
        sa.Column("phase_id", sa.String(length=100), nullable=False),
        sa.ForeignKeyConstraint(
            ["phase_id"],
            ["phase.id"],
        ),
        sa.PrimaryKeyConstraint("id", "code"),
        sa.UniqueConstraint("code"),
        sa.UniqueConstraint("description"),
    )
    op.create_table(
        "match",
        sa.Column("id", sa.String(length=100), nullable=False),
        sa.Column("group_id", sa.String(length=100), nullable=False),
        sa.Column("index", sa.Integer(), nullable=False),
        sa.Column("team1_id", sa.String(length=100), nullable=False),
        sa.Column("team2_id", sa.String(length=100), nullable=False),
        sa.ForeignKeyConstraint(
            ["group_id"],
            ["group.id"],
        ),
        sa.ForeignKeyConstraint(
            ["team1_id"],
            ["team.id"],
        ),
        sa.ForeignKeyConstraint(
            ["team2_id"],
            ["team.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "binary_bet",
        sa.Column("id", sa.String(length=100), nullable=False),
        sa.Column("user_id", sa.String(length=100), nullable=False),
        sa.Column("match_id", sa.String(length=100), nullable=False),
        sa.Column("locked", sa.Boolean(), nullable=True),
        sa.Column("is_one_won", sa.Boolean(), nullable=True),
        sa.ForeignKeyConstraint(
            ["match_id"],
            ["match.id"],
        ),
        sa.ForeignKeyConstraint(["user_id"], ["user.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "score_bet",
        sa.Column("id", sa.String(length=100), nullable=False),
        sa.Column("user_id", sa.String(length=100), nullable=False),
        sa.Column("match_id", sa.String(length=100), nullable=False),
        sa.Column("score1", sa.Integer(), nullable=True),
        sa.Column("score2", sa.Integer(), nullable=True),
        sa.Column("locked", sa.Boolean(), nullable=True),
        sa.ForeignKeyConstraint(
            ["match_id"],
            ["match.id"],
        ),
        sa.ForeignKeyConstraint(["user_id"], ["user.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("score_bet")
    op.drop_table("binary_bet")
    op.drop_table("match")
    op.drop_table("group")
    op.drop_table("user")
    op.drop_table("team")
    op.drop_table("phase")
    # ### end Alembic commands ###
