from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="QuerySUTRA",
    version="0.2.3",
    author="Aditya Batta",
    author_email="",
    description="SUTRA: Structured-Unstructured-Text-Retrieval-Architecture - Creates multiple structured tables from ANY data",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/yourusername/querysutra",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "Topic :: Database",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
    ],
    python_requires=">=3.8",
    install_requires=[
        "pandas>=1.3.0",
        "numpy>=1.21.0",
        "openai>=1.0.0",
        "plotly>=5.0.0",
        "matplotlib>=3.3.0",
        "PyPDF2>=3.0.0",
        "python-docx>=0.8.11",
        "openpyxl>=3.0.0",
    ],
    extras_require={
        "mysql": ["sqlalchemy>=1.4.0", "mysql-connector-python>=8.0.0"],
        "postgres": ["sqlalchemy>=1.4.0", "psycopg2-binary>=2.9.0"],
        "all": [
            "sqlalchemy>=1.4.0",
            "mysql-connector-python>=8.0.0",
            "psycopg2-binary>=2.9.0",
        ],
    },
)
