"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("@aws-cdk/aws-events");
const targets = require("@aws-cdk/aws-events-targets");
const event_bridge_1 = require("./event-bridge");
/**
 * Use a Lambda function as a Lambda destination
 */
class LambdaDestination {
    constructor(fn, options = {}) {
        this.fn = fn;
        this.options = options;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_destinations_LambdaDestinationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaDestination);
            }
            throw error;
        }
    }
    /**
     * Returns a destination configuration
     */
    bind(scope, fn, options) {
        // Normal Lambda destination (full invocation record)
        if (!this.options.responseOnly) {
            // deduplicated automatically
            this.fn.grantInvoke(fn);
            return {
                destination: this.fn.functionArn,
            };
        }
        // Otherwise add rule to extract the response payload and use EventBridge
        // as destination
        if (!options) { // `options` added to bind() as optionnal to avoid breaking change
            throw new Error('Options must be defined when using `responseOnly`.');
        }
        // Match invocation result of the source function (`fn`) and use it
        // to trigger the destination function (`this.fn`).
        new events.Rule(scope, options.type, {
            eventPattern: {
                detailType: [`Lambda Function Invocation Result - ${options.type}`],
                resources: [`${fn.functionArn}:$LATEST`],
                source: ['lambda'],
            },
            targets: [
                new targets.LambdaFunction(this.fn, {
                    event: events.RuleTargetInput.fromEventPath('$.detail.responsePayload'),
                }),
            ],
        });
        const destination = new event_bridge_1.EventBridgeDestination(); // Use default event bus here
        return destination.bind(scope, fn);
    }
}
exports.LambdaDestination = LambdaDestination;
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "@aws-cdk/aws-lambda-destinations.LambdaDestination", version: "1.164.0" };
//# sourceMappingURL=data:application/json;base64,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