# AUTOGENERATED! DO NOT EDIT! File to edit: ../src/config.ipynb.

# %% auto 0
__all__ = ['hyperlane_relay_url', 'hyperlane_relayers', 'XCHAIN_GAS_LIMIT_UPPERBOUND', 'base_default_settings', 'GetEnv',
           'ChainSettings', 'validate_settings', 'get_env', 'make_settings', 'make_op_chain_settings',
           'make_base_chain_settings', 'make_lisk_chain_settings', 'make_uni_chain_settings']

# %% ../src/config.ipynb 3
import os
from dataclasses import dataclass, make_dataclass, fields
from .helpers import normalize_address
from typing import List, Callable, Any, Dict

# %% ../src/config.ipynb 4
hyperlane_relay_url = "https://offchain-lookup.services.hyperlane.xyz/callCommitments/calls"
hyperlane_relayers = ["0x74Cae0ECC47B02Ed9B9D32E000Fd70B9417970C5", "0x09B96417602Ed6AC76651F7A8c4860E60e3aA6d0"]
XCHAIN_GAS_LIMIT_UPPERBOUND = 600000

base_default_settings = {
  "price_batch_size": int(os.getenv("SUGAR_PRICE_BATCH_SIZE","40")),
  "price_threshold_filter": int(os.getenv("SUGAR_PRICE_THRESHOLD_FILTER","10")),
  "pagination_limit": int(os.getenv("SUGAR_PAGINATION_LIMIT","2000")),
  "pool_page_size": int(os.getenv("SUGAR_POOL_PAGE_SIZE","500")),
  # XX: dealing with Schrödinger's paginator this is likely to be ignored in the future with new sugar helpers
  "pools_count_upper_bound": 2500,
  "native_token_symbol": "ETH",
  "native_token_decimals": 18,
  "swap_slippage": 0.01,
  "pricing_cache_timeout_seconds": 5,
  "threading_max_workers": 5
}


@dataclass
class ChainSettings:
    # chain IDs come from: https://chainlist.org/
    chain_id: str
    chain_name: str
    wrapped_native_token_addr: str
    rpc_uri: str
    # interchain account address for superswaps
    interchain_router_contract_addr: str
    # bridge contract for superswaps
    bridge_contract_addr: str
    # bridge token address for superswaps
    bridge_token_addr: str
    # message module contract address for superswaps
    message_module_contract_addr: str
    sugar_contract_addr: str
    sugar_rewards_contract_addr: str
    # slipstream operates on concentrated liquidity (CL) pools
    slipstream_contract_addr: str
    # Non-Fungible Position Manager for CL pools
    nfpm_contract_addr: str
    price_oracle_contract_addr: str
    router_contract_addr: str
    quoter_contract_addr: str
    # aka Universal Router
    swapper_contract_addr: str
    token_addr: str
    stable_token_addr: str
    connector_tokens_addrs: List[str]
    # tokens to exclude from quote search graph
    excluded_tokens_addrs: List[str]
    # default swap slippage in % (0.0-1.0)
    swap_slippage: float
    price_batch_size: int
    price_threshold_filter: int
    pagination_limit: int
    pools_count_upper_bound: int
    pool_page_size: int
    native_token_symbol: str
    native_token_decimals: int
    # how often to check for new prices
    pricing_cache_timeout_seconds: int
    # how many max workers to use for threading in sync methods
    threading_max_workers: int

    def __str__(self):
        # go over all attributes of self
        lines = ["🍭 Chain settings:","----------------"]
        attributes = [attr for attr in dir(self) if not attr.startswith('_')]
        for attr in attributes:
            # Skip methods
            if callable(getattr(self, attr)): continue
            value = getattr(self, attr)
            if isinstance(value, list):
                value = "\n" + "\n".join([f"{' ' * 4 }- {v}" for v in value])
            lines.append(f"{attr}: {value}")
        return "\n".join(lines)
    
    def __repr__(self): return str(self)

def validate_settings(settings: ChainSettings) -> ChainSettings:
    # TODO: this should actually validate stuff, duh
    floats = ["swap_slippage"]
    ints = ["price_batch_size", "price_threshold_filter", "pagination_limit", "pool_page_size", "native_token_decimals",
            "pricing_cache_timeout_seconds", "pools_count_upper_bound", "threading_max_workers"]
    for k in floats: setattr(settings, k, float(getattr(settings, k)))
    for k in ints: setattr(settings, k, int(getattr(settings, k)))
    return settings

def get_env(key: str, default: Any) -> Any: return os.getenv(key, default)

GetEnv = Callable[[str, Any], Any]

def make_settings(chain_id: str, chain_name: str, chain_settings: Dict[str, Any], get_env: GetEnv, **kwargs) -> ChainSettings:
    d = { **base_default_settings, **chain_settings, **{ "chain_id": chain_id, "chain_name": chain_name } }

    for k,v in d.items():
        if k in ["chain_id", "chain_name"]: continue
        # look for env vars (i.e stable_token_addr for chain_id="10" should be SUGAR_STABLE_TOKEN_ADDR_10)
        d[k] = get_env(f"SUGAR_{k.upper()}_{chain_id}", v)

    # keywords override env vars
    d = d | kwargs

    for k,v in d.items():
        # anything that ends in "_addr", should be normalized
        if k.endswith("_addr"): d[k] = normalize_address(d[k]) if d[k] else None
        # anything that ends in "_addrs", should be a list of normalized addresses
        if k.endswith("_addrs"): d[k] = list(map(lambda a: normalize_address(a), d[k].split(","))) if d[k] else []

    # we only want fields that are in the ChainSettings dataclass
    d =  {k: v for k, v in d.items() if k in [field.name for field in fields(ChainSettings)]}

    return validate_settings(make_dataclass(ChainSettings.__name__, ((k, type(v)) for k, v in d.items()))(**d)) 

# %% ../src/config.ipynb 6
def make_op_chain_settings(get_env: GetEnv = get_env, **kwargs) -> ChainSettings:
    d = {
        "rpc_uri": "https://optimism-mainnet.wallet.coinbase.com",
        "wrapped_native_token_addr": "0x4200000000000000000000000000000000000006",
        "interchain_router_contract_addr": "0x3E343D07D024E657ECF1f8Ae8bb7a12f08652E75",
        "bridge_contract_addr": "0x7bd2676c85cca9fa2203eba324fb8792fbd520b8",
        "bridge_token_addr": "0x1217bfe6c773eec6cc4a38b5dc45b92292b6e189",
        "sugar_contract_addr": "0xA64db2D254f07977609def75c3A7db3eDc72EE1D",
        "sugar_rewards_contract_addr": "0x62CCFB2496f49A80B0184AD720379B529E9152fB",
        "slipstream_contract_addr": "0xD45624bf2CB9f65ecbdF3067d21992b099b56202",
        "nfpm_contract_addr": "0x416b433906b1B72FA758e166e239c43d68dC6F29",
        "price_oracle_contract_addr": "0x59114D308C6DE4A84F5F8cD80485a5481047b99f",
        "router_contract_addr": "0xa062aE8A9c5e11aaA026fc2670B0D65cCc8B2858",
        "quoter_contract_addr": "0xFF79ec912bA114FD7989b9A2b90C65f0c1b44722",
        "swapper_contract_addr": "0x01D40099fCD87C018969B0e8D4aB1633Fb34763C",
        "token_addr": "0x9560e827aF36c94D2Ac33a39bCE1Fe78631088Db",
        "stable_token_addr": "0x7f5c764cbc14f9669b88837ca1490cca17c31607",
        "connector_tokens_addrs": "0x9560e827aF36c94D2Ac33a39bCE1Fe78631088Db,0x4200000000000000000000000000000000000042,0x4200000000000000000000000000000000000006,0x9bcef72be871e61ed4fbbc7630889bee758eb81d,0x2e3d870790dc77a83dd1d18184acc7439a53f475,0x8c6f28f2f1a3c87f0f938b96d27520d9751ec8d9,0x1f32b1c2345538c0c6f582fcb022739c4a194ebb,0xbfd291da8a403daaf7e5e9dc1ec0aceacd4848b9,0xc3864f98f2a61a7caeb95b039d031b4e2f55e0e9,0x9485aca5bbbe1667ad97c7fe7c4531a624c8b1ed,0xDA10009cBd5D07dd0CeCc66161FC93D7c9000da1,0x73cb180bf0521828d8849bc8cf2b920918e23032,0x6806411765af15bddd26f8f544a34cc40cb9838b,0x6c2f7b6110a37b3b0fbdd811876be368df02e8b0,0xc5b001dc33727f8f26880b184090d3e252470d45,0x6c84a8f1c29108f47a79964b5fe888d4f4d0de40,0xc40f949f8a4e094d1b49a23ea9241d289b7b2819,0x94b008aa00579c1307b0ef2c499ad98a8ce58e58,0x0b2c639c533813f4aa9d7837caf62653d097ff85",
        "excluded_tokens_addrs": "0x74ccbe53f77b08632ce0cb91d3a545bf6b8e0979,0x139283255069ea5deef6170699aaef7139526f1f,0x88a89866439f4c2830986b79cbe6f69d1bd548bb,0x8901cb2e82cc95c01e42206f8d1f417fe53e7af0",
        "message_module_contract_addr": "0x2BbA7515F7cF114B45186274981888D8C2fBA15E"
    } 
    return make_settings("10", "OP", chain_settings=d, get_env=get_env, **kwargs)

# %% ../src/config.ipynb 8
def make_base_chain_settings(get_env: GetEnv = get_env, **kwargs) -> ChainSettings:
    d = {
        "rpc_uri": "https://mainnet.base.org",
        "pools_count_upper_bound": 9000,
        "wrapped_native_token_addr": "0x4200000000000000000000000000000000000006",
        "sugar_contract_addr": "0x27fc745390d1f4BaF8D184FBd97748340f786634",
        "sugar_rewards_contract_addr": "0xD4aD2EeeB3314d54212A92f4cBBE684195dEfe3E",
        "slipstream_contract_addr": "0x0AD09A66af0154a84e86F761313d02d0abB6edd5",
        "nfpm_contract_addr": "0x827922686190790b37229fd06084350E74485b72",
        "price_oracle_contract_addr": "0x3B06c787711ecb5624cE65AC8F26cde10831eb0C",
        "router_contract_addr": "0xcF77a3Ba9A5CA399B7c97c74d54e5b1Beb874E43",
        "quoter_contract_addr": "0x0A5aA5D3a4d28014f967Bf0f29EAA3FF9807D5c6",
        "swapper_contract_addr": "0x01D40099fCD87C018969B0e8D4aB1633Fb34763C",
        "token_addr": "0x9560e827aF36c94D2Ac33a39bCE1Fe78631088Db",
        "stable_token_addr": "0x833589fCD6eDb6E08f4c7C32D4f71b54bdA02913",
        "connector_tokens_addrs": "0x833589fcd6edb6e08f4c7c32d4f71b54bda02913,0x940181a94A35A4569E4529A3CDfB74e38FD98631,0x50c5725949A6F0c72E6C4a641F24049A917DB0Cb,0x4621b7a9c75199271f773ebd9a499dbd165c3191,0x4200000000000000000000000000000000000006,0xb79dd08ea68a908a97220c76d19a6aa9cbde4376,0xf7a0dd3317535ec4f4d29adf9d620b3d8d5d5069,0xcfa3ef56d303ae4faaba0592388f19d7c3399fb4,0xcb327b99ff831bf8223cced12b1338ff3aa322ff,0x2ae3f1ec7f1f5012cfeab0185bfc7aa3cf0dec22,0xc1cba3fcea344f92d9239c08c0568f6f2f0ee452,0x60a3e35cc302bfa44cb288bc5a4f316fdb1adb42,0xd9aaec86b65d86f6a7b5b1b0c42ffa531710b6ca,0xcbB7C0000aB88B473b1f5aFd9ef808440eed33Bf",
        "excluded_tokens_addrs": "0x74ccbe53f77b08632ce0cb91d3a545bf6b8e0979,0x8901cb2e82cc95c01e42206f8d1f417fe53e7af0,0x9cbd543f1b1166b2df36b68eb6bb1dce24e6abdf,0x025f99977db78317a4eba606998258b502bb256f,0xd260115030b9fb6849da169a01ed80b6496d1e99,0x608d5401d377228e465ba6113517dcf9bd1f95ca,0xd260115030b9fB6849da169a01ed80b6496d1e99,0x728cDA34D732a87fD6429129e23D4742d9Ff0064,0x728cda34d732a87fd6429129e23d4742d9ff0064,0xAC1Bd2486aAf3B5C0fc3Fd868558b082a531B2B4,0x0f929C29dcE303F96b1d4104505F2e60eE795caC,0x47E78d664E6c339693e8638B7A7D9543AbCc99D4,0xFF0C532FDB8Cd566Ae169C1CB157ff2Bdc83E105,0x373504da48418c67e6fcd071f33cb0b3b47613c7,0x0f929c29dce303f96b1d4104505f2e60ee795cac,0x628c5Ba9B775DACEcd14E237130c537f497d1CC7",
        "message_module_contract_addr": "0x2BbA7515F7cF114B45186274981888D8C2fBA15E"
    }
    return make_settings("8453", "Base", chain_settings=d, get_env=get_env, **kwargs)

# %% ../src/config.ipynb 10
def make_lisk_chain_settings(get_env: GetEnv = get_env, **kwargs) -> ChainSettings:
    d = {
        "rpc_uri": "https://lisk.drpc.org",
        "pools_count_upper_bound": 100,
        "wrapped_native_token_addr": "0x4200000000000000000000000000000000000006",
        "interchain_router_contract_addr": "0xE59592a179c4f436d5d2e4caA6e2750beA4E3166",
        "bridge_contract_addr": "0x910FF91a92c9141b8352Ad3e50cF13ef9F3169A1",
        "bridge_token_addr": "0x1217BfE6c773EEC6cc4A38b5Dc45B92292B6E189",
        "sugar_contract_addr": "0x1443c0757f77c04bd514427d2bE356A5834E4167",
        "sugar_rewards_contract_addr": "0xB1d0DFFe6260982164B53EdAcD3ccd58B081889d",
        "slipstream_contract_addr": "0xB98fB4C9C99dE155cCbF5A14af0dBBAd96033D6f",
        "nfpm_contract_addr": "0x991d5546C4B442B4c5fdc4c8B8b8d131DEB24702",
        "price_oracle_contract_addr": "0x024503003fFE9AF285f47c1DaAaA497D9f1166D0",
        "router_contract_addr": "0x3a63171DD9BebF4D07BC782FECC7eb0b890C2A45",
        "quoter_contract_addr": "0x2f7150B288ef1cc553207bD9fbd40D4e0e093B24",
        "swapper_contract_addr": "0x01D40099fCD87C018969B0e8D4aB1633Fb34763C",
        "token_addr": "",
        "stable_token_addr": "0xf242275d3a6527d877f2c927a82d9b057609cc71",
        "connector_tokens_addrs": "0x4200000000000000000000000000000000000006,0xac485391eb2d7d88253a7f1ef18c37f4242d1a24,0x05d032ac25d322df992303dca074ee7392c117b9,0x03c7054bcb39f7b2e5b2c7acb37583e32d70cfa3",
        "message_module_contract_addr": "0x2BbA7515F7cF114B45186274981888D8C2fBA15E",
        "excluded_tokens_addrs": ""
    }
    return make_settings("1135", "Lisk", chain_settings=d, get_env=get_env, **kwargs)

# %% ../src/config.ipynb 12
def make_uni_chain_settings(get_env: GetEnv = get_env, **kwargs) -> ChainSettings:
    d = {
        "rpc_uri": "https://unichain.drpc.org",
        "pools_count_upper_bound": 20,
        "wrapped_native_token_addr": "0x4200000000000000000000000000000000000006",
        "interchain_router_contract_addr": "0x43320f6B410322Bf5ca326a0DeAaa6a2FC5A021B",
        "bridge_contract_addr": "0x4A8149B1b9e0122941A69D01D23EaE6bD1441b4f",
        "bridge_token_addr": "0x1217BfE6c773EEC6cc4A38b5Dc45B92292B6E189",
        "sugar_contract_addr": "0x154c0F8331B0B4af1384A2dFa67AADCa5Fd92C20",
        "sugar_rewards_contract_addr": "0xbDD1d5A9d9566F575bC59cE33C8F77ACa5cF924b",
        "slipstream_contract_addr": "0x222ed297aF0560030136AE652d39fa40E1B72818",
        "nfpm_contract_addr": "0x991d5546C4B442B4c5fdc4c8B8b8d131DEB24702",
        "price_oracle_contract_addr": "0xe58920a8c684CD3d6dCaC2a41b12998e4CB17EfE",
        "router_contract_addr": "0x3a63171DD9BebF4D07BC782FECC7eb0b890C2A45",
        "quoter_contract_addr": "0x2f7150B288ef1cc553207bD9fbd40D4e0e093B24",
        "swapper_contract_addr": "0x01D40099fCD87C018969B0e8D4aB1633Fb34763C",
        "token_addr": "",
        "stable_token_addr": "0x078d782b760474a361dda0af3839290b0ef57ad6",
        "connector_tokens_addrs": "0x4200000000000000000000000000000000000006,0x078d782b760474a361dda0af3839290b0ef57ad6",
        "message_module_contract_addr": "0x2BbA7515F7cF114B45186274981888D8C2fBA15E",
        "excluded_tokens_addrs": ""
    }
    return make_settings("130", "Uni", chain_settings=d, get_env=get_env, **kwargs)
