# This file was auto-generated by Fern from our API Definition.

import typing

import httpx
from .http_client import AsyncHttpClient, HttpClient


class BaseClientWrapper:
    def __init__(
        self,
        *,
        framework_name: typing.Optional[str] = None,
        framework_version: typing.Optional[str] = None,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        base_url: str,
        timeout: typing.Optional[float] = None,
    ):
        self._framework_name = framework_name
        self._framework_version = framework_version
        self.api_key = api_key
        self._headers = headers
        self._base_url = base_url
        self._timeout = timeout

    def get_headers(self) -> typing.Dict[str, str]:
        headers: typing.Dict[str, str] = {
            "User-Agent": "airweave-sdk/v0.6.56",
            "X-Fern-Language": "Python",
            "X-Fern-SDK-Name": "airweave-sdk",
            "X-Fern-SDK-Version": "v0.6.56",
            **(self.get_custom_headers() or {}),
        }
        if self._framework_name is not None:
            headers["X-Framework-Name"] = self._framework_name
        if self._framework_version is not None:
            headers["X-Framework-Version"] = self._framework_version
        headers["x-api-key"] = self.api_key
        return headers

    def get_custom_headers(self) -> typing.Optional[typing.Dict[str, str]]:
        return self._headers

    def get_base_url(self) -> str:
        return self._base_url

    def get_timeout(self) -> typing.Optional[float]:
        return self._timeout


class SyncClientWrapper(BaseClientWrapper):
    def __init__(
        self,
        *,
        framework_name: typing.Optional[str] = None,
        framework_version: typing.Optional[str] = None,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        base_url: str,
        timeout: typing.Optional[float] = None,
        httpx_client: httpx.Client,
    ):
        super().__init__(
            framework_name=framework_name,
            framework_version=framework_version,
            api_key=api_key,
            headers=headers,
            base_url=base_url,
            timeout=timeout,
        )
        self.httpx_client = HttpClient(
            httpx_client=httpx_client,
            base_headers=self.get_headers,
            base_timeout=self.get_timeout,
            base_url=self.get_base_url,
        )


class AsyncClientWrapper(BaseClientWrapper):
    def __init__(
        self,
        *,
        framework_name: typing.Optional[str] = None,
        framework_version: typing.Optional[str] = None,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        base_url: str,
        timeout: typing.Optional[float] = None,
        httpx_client: httpx.AsyncClient,
    ):
        super().__init__(
            framework_name=framework_name,
            framework_version=framework_version,
            api_key=api_key,
            headers=headers,
            base_url=base_url,
            timeout=timeout,
        )
        self.httpx_client = AsyncHttpClient(
            httpx_client=httpx_client,
            base_headers=self.get_headers,
            base_timeout=self.get_timeout,
            base_url=self.get_base_url,
        )
