# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class AuthProviderConnection(UniversalBaseModel):
    """
    Schema for auth provider connection response.
    """

    id: str
    name: str
    readable_id: str = pydantic.Field()
    """
    URL-safe unique identifier that can be used to reference this connection when setting up source connections.
    """

    short_name: str
    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the connection
    """

    created_by_email: typing.Optional[str] = pydantic.Field(default=None)
    """
    Email of the user who created this connection
    """

    modified_by_email: typing.Optional[str] = pydantic.Field(default=None)
    """
    Email of the user who last modified this connection
    """

    created_at: dt.datetime
    modified_at: dt.datetime
    masked_client_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Masked client ID for OAuth providers (first 7 and last 4 characters visible)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
