# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs


class Filter(UniversalBaseModel):
    should: typing.Optional["Should"] = pydantic.Field(default=None)
    """
    At least one of those conditions should match
    """

    min_should: typing.Optional["MinShould"] = pydantic.Field(default=None)
    """
    At least minimum amount of given conditions should match
    """

    must: typing.Optional["Must"] = pydantic.Field(default=None)
    """
    All conditions must match
    """

    must_not: typing.Optional["FilterMustNot"] = pydantic.Field(default=None)
    """
    All conditions must NOT match
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .min_should import MinShould  # noqa: E402, F401, I001
from .nested import Nested  # noqa: E402, F401, I001
from .nested_condition import NestedCondition  # noqa: E402, F401, I001
from .min_should_conditions_item import MinShouldConditionsItem  # noqa: E402, F401, I001
from .should import Should  # noqa: E402, F401, I001
from .filter_must_not import FilterMustNot  # noqa: E402, F401, I001
from .must import Must  # noqa: E402, F401, I001
from .filter_should_item import FilterShouldItem  # noqa: E402, F401, I001
from .filter_must_not_item import FilterMustNotItem  # noqa: E402, F401, I001
from .filter_must_item import FilterMustItem  # noqa: E402, F401, I001

update_forward_refs(Filter)
