# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .billing_period import BillingPeriod
from .billing_plan import BillingPlan
from .billing_status import BillingStatus


class OrganizationBilling(UniversalBaseModel):
    """
    Organization billing schema with current period information.

    This schema is enriched with the current active billing period for
    efficient access to rate limits and billing status without additional queries.
    """

    billing_plan: typing.Optional[BillingPlan] = pydantic.Field(default=None)
    """
    Current billing plan
    """

    billing_status: typing.Optional[BillingStatus] = pydantic.Field(default=None)
    """
    Current billing status
    """

    billing_email: str = pydantic.Field()
    """
    Billing contact email
    """

    id: str
    organization_id: str
    stripe_customer_id: str
    stripe_subscription_id: typing.Optional[str] = None
    trial_ends_at: typing.Optional[dt.datetime] = None
    grace_period_ends_at: typing.Optional[dt.datetime] = None
    payment_method_added: typing.Optional[bool] = None
    current_period_start: typing.Optional[dt.datetime] = None
    current_period_end: typing.Optional[dt.datetime] = None
    cancel_at_period_end: typing.Optional[bool] = None
    pending_plan_change: typing.Optional[BillingPlan] = None
    pending_plan_change_at: typing.Optional[dt.datetime] = None
    payment_method_id: typing.Optional[str] = None
    last_payment_status: typing.Optional[str] = None
    last_payment_at: typing.Optional[dt.datetime] = None
    billing_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    has_yearly_prepay: typing.Optional[bool] = None
    yearly_prepay_started_at: typing.Optional[dt.datetime] = None
    yearly_prepay_expires_at: typing.Optional[dt.datetime] = None
    yearly_prepay_amount_cents: typing.Optional[int] = None
    yearly_prepay_coupon_id: typing.Optional[str] = None
    yearly_prepay_payment_intent_id: typing.Optional[str] = None
    created_at: dt.datetime
    modified_at: dt.datetime
    current_period: typing.Optional[BillingPeriod] = pydantic.Field(default=None)
    """
    Current active billing period
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
